/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.persistence;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDocumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmFolderDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmManifestDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.CdmFolderType;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.DocumentPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.ManifestPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.common.PersistenceType;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.ModelJsonType;
import com.microsoft.commondatamodel.objectmodel.storage.StorageAdapterBase;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.JMapper;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.OffsetDateTime;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class PersistenceLayer {
    private static final String TAG = PersistenceLayer.class.getSimpleName();
    final CdmCorpusDefinition corpus;
    final CdmCorpusContext ctx;
    public static final String folioExtension = ".folio.cdm.json";
    public static final String manifestExtension = ".manifest.cdm.json";
    public static final String cdmExtension = ".cdm.json";
    public static final String modelJsonExtension = "model.json";
    public static final String cdmFolder = "CdmFolder";
    public static final String modelJson = "ModelJson";
    private static final Map<String, PersistenceType> persistenceTypeMap = new LinkedHashMap<String, PersistenceType>();
    private ConcurrentHashMap<String, Class> registeredPersistenceFormats;
    private ConcurrentHashMap<Class, Boolean> isRegisteredPersistenceAsync;

    public PersistenceLayer(CdmCorpusDefinition corpus) {
        this.corpus = corpus;
        this.ctx = this.corpus.getCtx();
        this.registeredPersistenceFormats = new ConcurrentHashMap();
        this.isRegisteredPersistenceAsync = new ConcurrentHashMap();
    }

    public static <T extends CdmObject, U> CdmObject fromData(CdmCorpusContext ctx, U obj, String persistenceTypeName, Class<T> classInterface) {
        Class persistenceClass = PersistenceLayer.findPersistenceClass(persistenceTypeName, classInterface);
        try {
            Method method = persistenceClass.getMethod("fromData", CdmCorpusContext.class, obj.getClass());
            return (CdmObject)method.invoke(null, ctx, obj);
        }
        catch (NoSuchMethodException e) {
            String persistenceClassName = classInterface.getName();
            throw new RuntimeException("Persistence class " + persistenceClassName + " in type " + persistenceTypeName + " does not implement ToData.", e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            String persistenceClassName = classInterface.getName();
            throw new RuntimeException("Persistence class " + persistenceClassName + " in type " + persistenceTypeName + " fail to call toData.", e);
        }
    }

    public static <T extends CdmObject> Object toData(T instance, ResolveOptions resOpt, CopyOptions options, String persistenceTypeName, Class<T> classInterface) {
        Class persistenceClass = PersistenceLayer.findPersistenceClass(persistenceTypeName, classInterface);
        try {
            Method method = persistenceClass.getMethod("toData", classInterface, ResolveOptions.class, CopyOptions.class);
            return method.invoke(null, instance, resOpt, options);
        }
        catch (NoSuchMethodException e) {
            String persistenceClassName = classInterface.getName();
            throw new RuntimeException("Persistence class " + persistenceClassName + " in type " + persistenceTypeName + " does not implement toData.", e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            String persistenceClassName = classInterface.getName();
            throw new RuntimeException("Persistence class " + persistenceClassName + " in type " + persistenceTypeName + " fail to call toData.", e);
        }
    }

    public static <T extends CdmObject> Class findPersistenceClass(String persistenceTypeName, Class<T> classInterface) {
        if (persistenceTypeMap.containsKey(persistenceTypeName)) {
            Class persistenceClass = persistenceTypeMap.get(persistenceTypeName).getRegisteredClasses().getPersistenceClass(classInterface);
            if (persistenceClass == null) {
                throw new RuntimeException("Persistence class for " + classInterface.getName() + " is not implemented in type " + persistenceTypeName + ".");
            }
            return persistenceClass;
        }
        throw new RuntimeException("Persistence type " + persistenceTypeName + " not implemented.");
    }

    @Deprecated
    public CompletableFuture<CdmDocumentDefinition> loadDocumentFromPathAsync(CdmFolderDefinition folder, String docName, CdmDocumentDefinition docContainer) {
        return this.loadDocumentFromPathAsync(folder, docName, docContainer, null);
    }

    @Deprecated
    public CompletableFuture<CdmDocumentDefinition> loadDocumentFromPathAsync(CdmFolderDefinition folder, String docName, CdmDocumentDefinition docContainer, ResolveOptions resOpt) {
        return CompletableFuture.supplyAsync(() -> {
            CdmDocumentDefinition docContent;
            OffsetDateTime fsModifiedTime;
            block16: {
                String jsonData = null;
                fsModifiedTime = null;
                String docPath = folder.getFolderPath() + docName;
                StorageAdapterBase adapter = this.corpus.getStorage().fetchAdapter(folder.getNamespace());
                try {
                    if (!adapter.canRead()) {
                        throw new Exception("Storage Adapter is not enabled to read.");
                    }
                    Logger.debug(this.ctx, TAG, "loadDocumentFromPathAsync", docPath, Logger.format("request file: {0}", docPath));
                    jsonData = adapter.readAsync(docPath).get();
                    Logger.debug(this.ctx, TAG, "loadDocumentFromPathAsync", docPath, Logger.format("received file: {0}", docPath));
                }
                catch (Exception e) {
                    Logger.debug(this.ctx, TAG, "loadDocumentFromPathAsync", docPath, Logger.format("fail file: {0}", docPath));
                    if (resOpt != null && resOpt.getShallowValidation()) {
                        Logger.warning(this.ctx, TAG, "loadDocumentFromPathAsync", docPath, CdmLogCode.WarnPersistFileReadFailure, docPath, folder.getNamespace(), e.getLocalizedMessage());
                    } else {
                        Logger.error(this.ctx, TAG, "loadDocumentFromPathAsync", docPath, CdmLogCode.ErrPersistFileReadFailure, docPath, folder.getNamespace(), e.getLocalizedMessage());
                    }
                    return null;
                }
                try {
                    fsModifiedTime = adapter.computeLastModifiedTimeAsync(docPath).join();
                }
                catch (Exception e) {
                    Logger.error(this.ctx, TAG, "loadDocumentFromPathAsync", docPath, CdmLogCode.WarnPersistFileModTimeFailure, e.getMessage());
                }
                if (StringUtils.isEmpty((CharSequence)docName)) {
                    Logger.error(this.ctx, TAG, "loadDocumentFromPathAsync", docPath, CdmLogCode.ErrPersistNullDocName, new String[0]);
                    return null;
                }
                if (StringUtils.endsWithIgnoreCase((CharSequence)docName, (CharSequence)modelJsonExtension) && !StringUtils.equalsIgnoreCase((CharSequence)docName, (CharSequence)modelJsonExtension)) {
                    Logger.error(this.ctx, TAG, "loadDocumentFromPathAsync", docPath, CdmLogCode.ErrPersistDocNameLoadFailure, docName, modelJsonExtension);
                    return null;
                }
                try {
                    if (docName.toLowerCase().endsWith(manifestExtension) || docName.toLowerCase().endsWith(folioExtension)) {
                        docContent = ManifestPersistence.fromData(this.ctx, docName, jsonData, folder);
                        break block16;
                    }
                    if (docName.toLowerCase().endsWith(modelJsonExtension)) {
                        docContent = com.microsoft.commondatamodel.objectmodel.persistence.modeljson.ManifestPersistence.fromData(this.ctx, docName, jsonData, folder).join();
                        break block16;
                    }
                    if (docName.toLowerCase().endsWith(cdmExtension)) {
                        docContent = DocumentPersistence.fromData(this.ctx, docName, jsonData, folder);
                        break block16;
                    }
                    Logger.error(this.ctx, TAG, "loadDocumentFromPathAsync", docPath, CdmLogCode.ErrPersistClassMissing, docName);
                    return null;
                }
                catch (Exception e) {
                    Logger.error(this.ctx, TAG, "loadDocumentFromPathAsync", docPath, CdmLogCode.ErrPersistDocConversionFailure, docName, e.getLocalizedMessage());
                    return null;
                }
            }
            if (docContent != null) {
                if (docContainer != null) {
                    docContent = (CdmDocumentDefinition)docContent.copy(new ResolveOptions(docContainer, this.ctx.getCorpus().getDefaultResolutionDirectives()), docContainer);
                }
                folder.getDocuments().add(docContent, docName);
                docContent.setFileSystemModifiedTime(fsModifiedTime);
                docContent.setDirty(false);
            }
            return docContent;
        });
    }

    @Deprecated
    public CompletableFuture<Boolean> saveDocumentAsAsync(CdmDocumentDefinition doc, String newName) {
        return this.saveDocumentAsAsync(doc, newName, false);
    }

    @Deprecated
    public CompletableFuture<Boolean> saveDocumentAsAsync(CdmDocumentDefinition doc, String newName, boolean saveReferenced) {
        return this.saveDocumentAsAsync(doc, newName, saveReferenced, null);
    }

    @Deprecated
    public CompletableFuture<Boolean> saveDocumentAsAsync(CdmDocumentDefinition doc, String newName, boolean saveReferenced, CopyOptions options) {
        return CompletableFuture.supplyAsync(() -> {
            Object persistedDoc;
            String persistenceType;
            StorageAdapterBase adapter;
            String ns;
            block18: {
                ns = doc.getNamespace();
                if (StringUtils.isEmpty((CharSequence)ns)) {
                    ns = this.corpus.getStorage().getDefaultNamespace();
                }
                if ((adapter = this.corpus.getStorage().fetchAdapter(ns)) == null) {
                    Logger.error(this.ctx, TAG, "saveDocumentAsAsync", doc.getAtCorpusPath(), CdmLogCode.ErrPersistAdapterNotFoundForNamespace, ns);
                    return false;
                }
                if (!adapter.canWrite()) {
                    Logger.error(this.ctx, TAG, "saveDocumentAsAsync", doc.getAtCorpusPath(), CdmLogCode.ErrPersistAdapterWriteFailure, ns);
                    return false;
                }
                if (StringUtils.isEmpty((CharSequence)newName)) {
                    Logger.error(this.ctx, TAG, "saveDocumentAsAsync", doc.getAtCorpusPath(), CdmLogCode.ErrPersistNullDocName, new String[0]);
                    return false;
                }
                String string = persistenceType = StringUtils.endsWithIgnoreCase((CharSequence)newName, (CharSequence)modelJsonExtension) ? modelJson : cdmFolder;
                if (persistenceType == modelJson && !StringUtils.equalsIgnoreCase((CharSequence)newName, (CharSequence)modelJsonExtension)) {
                    Logger.error(this.ctx, TAG, "saveDocumentAsAsync", doc.getAtCorpusPath(), CdmLogCode.ErrPersistFailure, newName, modelJsonExtension);
                    return false;
                }
                ResolveOptions resOpt = new ResolveOptions(doc);
                try {
                    if (newName.toLowerCase().endsWith(modelJsonExtension) || newName.toLowerCase().endsWith(manifestExtension) || newName.toLowerCase().endsWith(folioExtension)) {
                        if (persistenceType.equals(cdmFolder)) {
                            persistedDoc = ManifestPersistence.toData((CdmManifestDefinition)doc, resOpt, options);
                        } else {
                            if (!newName.toLowerCase().equals(modelJsonExtension)) {
                                Logger.error(this.ctx, TAG, "saveDocumentAsAsync", doc.getAtCorpusPath(), CdmLogCode.ErrPersistFailure, newName, modelJsonExtension);
                                return false;
                            }
                            persistedDoc = com.microsoft.commondatamodel.objectmodel.persistence.modeljson.ManifestPersistence.toData((CdmManifestDefinition)doc, resOpt, options).join();
                        }
                        break block18;
                    }
                    if (newName.toLowerCase().endsWith(cdmExtension)) {
                        persistedDoc = DocumentPersistence.toData(doc, resOpt, options);
                        break block18;
                    }
                    Logger.error(this.ctx, TAG, "saveDocumentAsAsync", doc.getAtCorpusPath(), CdmLogCode.ErrPersistClassMissing, newName);
                    return false;
                }
                catch (Exception e) {
                    Logger.error(this.ctx, TAG, "saveDocumentAsAsync", doc.getAtCorpusPath(), CdmLogCode.ErrPersistFilePersistError, newName, e.getLocalizedMessage());
                    return false;
                }
            }
            if (persistedDoc == null) {
                Logger.error(this.ctx, TAG, "saveDocumentAsAsync", doc.getAtCorpusPath(), CdmLogCode.ErrPersistFilePersistFailed, newName);
                return false;
            }
            String newPath = doc.getFolderPath() + newName;
            newPath = this.corpus.getStorage().createAbsoluteCorpusPath(newPath, doc);
            if (newPath.startsWith(ns + ":")) {
                newPath = newPath.substring(ns.length() + 1);
            }
            try {
                adapter.writeAsync(newPath, JMapper.WRITER.writeValueAsString(persistedDoc)).join();
                doc.setFileSystemModifiedTime(adapter.computeLastModifiedTimeAsync(newPath).join());
                if (options.isTopLevelDocument()) {
                    this.corpus.getStorage().saveAdapterConfigAsync("/config.json", adapter).join();
                    options.setTopLevelDocument(false);
                }
            }
            catch (Exception e) {
                Logger.error(this.ctx, TAG, "saveDocumentAsAsync", doc.getAtCorpusPath(), CdmLogCode.ErrPersistFileWriteFailure, newName, e.getLocalizedMessage());
                return false;
            }
            if (saveReferenced && persistenceType.equals(cdmFolder) && !doc.saveLinkedDocumentsAsync(options).join().booleanValue()) {
                Logger.error(this.ctx, TAG, "saveDocumentAsAsync", doc.getAtCorpusPath(), CdmLogCode.ErrPersistSaveLinkedDocs, newName);
                return false;
            }
            return true;
        });
    }

    static {
        persistenceTypeMap.put(cdmFolder, new CdmFolderType());
        persistenceTypeMap.put(modelJson, new ModelJsonType());
    }
}

