/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.projections;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationRenameAttributes;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.projections.OperationBasePersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.projections.OperationRenameAttributes;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.JMapper;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class OperationRenameAttributesPersistence {
    private static final String TAG = OperationRenameAttributesPersistence.class.getSimpleName();

    public static CdmOperationRenameAttributes fromData(CdmCorpusContext ctx, JsonNode obj) {
        if (obj == null) {
            return null;
        }
        CdmOperationRenameAttributes renameAttributesOp = (CdmOperationRenameAttributes)OperationBasePersistence.fromData(ctx, CdmObjectType.OperationRenameAttributesDef, obj);
        if (obj.get("renameFormat") != null) {
            renameAttributesOp.setRenameFormat(obj.get("renameFormat").asText());
        }
        if (obj.get("applyTo") != null) {
            if (obj.get("applyTo").isValueNode()) {
                renameAttributesOp.setApplyTo(new ArrayList<String>(Arrays.asList(obj.get("applyTo").asText())));
            } else if (obj.get("applyTo").isArray()) {
                renameAttributesOp.setApplyTo((List)JMapper.MAP.convertValue((Object)obj.get("applyTo"), (TypeReference)new TypeReference<ArrayList<String>>(){}));
            } else {
                Logger.error(ctx, TAG, "fromData", renameAttributesOp.getAtCorpusPath(), CdmLogCode.ErrPersistProjUnsupportedProp, "applyTo", "string or list of strings");
            }
        }
        return renameAttributesOp;
    }

    public static OperationRenameAttributes toData(CdmOperationRenameAttributes instance, ResolveOptions resOpt, CopyOptions options) {
        if (instance == null) {
            return null;
        }
        OperationRenameAttributes obj = (OperationRenameAttributes)OperationBasePersistence.toData(instance, resOpt, options);
        obj.setRenameFormat(instance.getRenameFormat());
        obj.setApplyTo(instance.getApplyTo());
        return obj;
    }
}

