/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectDefinitionBase;
import com.microsoft.commondatamodel.objectmodel.enums.CdmAttributeContextType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttributeSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttributeSetBuilder;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSetBuilder;
import com.microsoft.commondatamodel.objectmodel.utilities.AttributeContextParameters;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class CdmConstantEntityDefinition
extends CdmObjectDefinitionBase {
    private static final String TAG = CdmConstantEntityDefinition.class.getSimpleName();
    private String constantEntityName;
    private CdmEntityReference entityShape;
    private List<List<String>> constantValues;

    @Override
    public String getName() {
        if (this.constantEntityName == null) {
            if (this.entityShape != null) {
                return "Constant" + this.entityShape.fetchObjectDefinitionName();
            }
            return "ConstantEntity";
        }
        return this.constantEntityName;
    }

    public CdmConstantEntityDefinition(CdmCorpusContext ctx, String constantEntityName) {
        super(ctx);
        this.setObjectType(CdmObjectType.ConstantEntityDef);
        this.setConstantEntityName(constantEntityName);
    }

    @Override
    public boolean visit(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        String path = this.fetchDeclaredPath(pathFrom);
        if (preChildren != null && preChildren.invoke(this, path)) {
            return false;
        }
        if (this.getEntityShape() != null) {
            this.getEntityShape().setOwner(this);
            if (this.getEntityShape().visit(path + "/entityShape/", preChildren, postChildren)) {
                return true;
            }
        }
        return postChildren != null && postChildren.invoke(this, path);
    }

    @Override
    @Deprecated
    public String fetchDeclaredPath(String pathFrom) {
        return pathFrom + (!StringUtils.isNullOrEmpty(this.getConstantEntityName()) ? this.getConstantEntityName() : "(unspecified)");
    }

    @Override
    void constructResolvedTraits(ResolvedTraitSetBuilder rtsb, ResolveOptions resOpt) {
    }

    @Override
    @Deprecated
    public ResolvedAttributeSetBuilder constructResolvedAttributes(ResolveOptions resOpt) {
        return this.constructResolvedAttributes(resOpt, null);
    }

    @Override
    @Deprecated
    public ResolvedAttributeSetBuilder constructResolvedAttributes(ResolveOptions resOpt, CdmAttributeContext under) {
        ResolvedAttributeSetBuilder rasb = new ResolvedAttributeSetBuilder();
        rasb.getResolvedAttributeSet().setAttributeContext(under);
        AttributeContextParameters acpEnt = null;
        if (under != null) {
            acpEnt = new AttributeContextParameters();
            acpEnt.setUnder(under);
            acpEnt.setType(CdmAttributeContextType.Entity);
            acpEnt.setName(this.getEntityShape().fetchObjectDefinitionName());
            acpEnt.setRegarding(this.getEntityShape());
            acpEnt.setIncludeTraits(true);
        }
        if (this.getEntityShape() != null) {
            rasb.mergeAttributes(this.getEntityShape().fetchResolvedAttributes(resOpt, acpEnt));
        }
        rasb.removeRequestedAtts();
        return rasb;
    }

    @Override
    public boolean validate() {
        if (null == this.constantValues) {
            String[] pathSplit = this.getDeclaredPath().split("/", -1);
            String entityName = pathSplit.length > 0 ? pathSplit[0] : new String();
            Logger.warning(this.getCtx(), TAG, "validate", this.getAtCorpusPath(), CdmLogCode.WarnValdnEntityNotDefined, entityName);
        }
        if (this.entityShape == null) {
            ArrayList<String> missingFields = new ArrayList<String>(Arrays.asList("entityShape"));
            Logger.error(this.getCtx(), TAG, "validate", this.getAtCorpusPath(), CdmLogCode.ErrValdnIntegrityCheckFailure, this.getAtCorpusPath(), String.join((CharSequence)", ", missingFields.parallelStream().map(s -> String.format("'%s'", s)).collect(Collectors.toList())));
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public Object copyData(ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectBase.copyData(this, resOpt, options, CdmConstantEntityDefinition.class);
    }

    @Override
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        CdmConstantEntityDefinition copy;
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        if (host == null) {
            copy = new CdmConstantEntityDefinition(this.getCtx(), this.getConstantEntityName());
        } else {
            copy = (CdmConstantEntityDefinition)host;
            copy.setConstantEntityName(this.getConstantEntityName());
        }
        copy.setConstantEntityName(this.getConstantEntityName());
        copy.setEntityShape((CdmEntityReference)this.getEntityShape().copy(resOpt));
        if (this.getConstantValues() != null) {
            copy.setConstantValues(new ArrayList<List<String>>());
            for (List<String> row : this.getConstantValues()) {
                copy.getConstantValues().add(new ArrayList<String>(row));
            }
        }
        this.copyDef(resOpt, copy);
        return copy;
    }

    @Override
    public boolean isDerivedFrom(String baseDef, ResolveOptions resOpt) {
        return false;
    }

    public String getConstantEntityName() {
        return this.constantEntityName;
    }

    public void setConstantEntityName(String value) {
        this.constantEntityName = value;
    }

    public List<List<String>> getConstantValues() {
        return this.constantValues;
    }

    public void setConstantValues(List<List<String>> value) {
        this.constantValues = value;
    }

    public CdmEntityReference getEntityShape() {
        return this.entityShape;
    }

    public void setEntityShape(CdmEntityReference value) {
        this.entityShape = value;
    }

    @Deprecated
    public String fetchConstantValue(ResolveOptions resOpt, Object attReturn, Object attSearch, String valueSearch, int order) {
        return this.findValue(resOpt, attReturn, attSearch, valueSearch, order);
    }

    @Deprecated
    public String updateConstantValue(ResolveOptions resOpt, Object attReturn, String newValue, Object attSearch, String valueSearch, int order) {
        return this.findValue(resOpt, attReturn, attSearch, valueSearch, order);
    }

    private String findValue(ResolveOptions resOpt, Object attReturn, Object attSearch, String valueSearch, int order) {
        ResolvedAttributeSet ras;
        int resultAtt = -1;
        int searchAtt = -1;
        if (attReturn instanceof Integer) {
            resultAtt = (Integer)attReturn;
        }
        if (attSearch instanceof Integer) {
            searchAtt = (Integer)attSearch;
        }
        if ((resultAtt == -1 || searchAtt == -1) && (ras = this.fetchResolvedAttributes(resOpt)) != null) {
            int l = ras.getSet().size();
            for (int i = 0; i < l; ++i) {
                String name = ras.getSet().get(i).getResolvedName();
                if (resultAtt == -1 && name == attReturn) {
                    resultAtt = i;
                }
                if (searchAtt == -1 && name == attSearch) {
                    searchAtt = i;
                }
                if (resultAtt >= 0 && searchAtt >= 0) break;
            }
        }
        if (resultAtt >= 0 && searchAtt >= 0 && this.getConstantValues() != null && this.getConstantValues().size() > 0) {
            int startAt = 0;
            int endBefore = this.getConstantValues().size();
            int increment = 1;
            if (order == -1) {
                increment = -1;
                startAt = this.getConstantValues().size() - 1;
                endBefore = -1;
            }
            for (int i = startAt; i != endBefore; i += increment) {
                if (!this.getConstantValues().get(i).get(searchAtt).equals(valueSearch)) continue;
                String result = this.getConstantValues().get(i).get(resultAtt);
                this.getConstantValues().get(i).set(resultAtt, result);
                return result;
            }
        }
        return null;
    }
}

