/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmArgumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttribute;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeContextReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeGroupDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeGroupReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeItem;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeResolutionGuidance;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmConstantEntityDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmContainerDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDataPartitionDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDataPartitionPatternDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDataTypeDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDataTypeReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDocumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmE2ERelationship;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityAttributeDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityDeclarationDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmFileStatus;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmFolderDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmImport;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmLocalEntityDeclarationDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmManifestDeclarationDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmManifestDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmParameterDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmPurposeDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmPurposeReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmReferencedEntityDeclarationDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitGroupDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitGroupReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReferenceBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTypeAttributeDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.DocumentLibrary;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationAddArtifactAttribute;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationAddAttributeGroup;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationAddCountAttribute;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationAddSupportingAttribute;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationAddTypeAttribute;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationAlterTraits;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationArrayExpansion;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationCombineAttributes;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationExcludeAttributes;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationIncludeAttributes;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationRenameAttributes;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationReplaceAsForeignKey;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmProjection;
import com.microsoft.commondatamodel.objectmodel.enums.CdmAttributeContextType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmStatusLevel;
import com.microsoft.commondatamodel.objectmodel.enums.CdmValidationStep;
import com.microsoft.commondatamodel.objectmodel.enums.ImportsLoadStrategy;
import com.microsoft.commondatamodel.objectmodel.persistence.PersistenceLayer;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolveContext;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTrait;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSet;
import com.microsoft.commondatamodel.objectmodel.storage.StorageAdapterBase;
import com.microsoft.commondatamodel.objectmodel.storage.StorageManager;
import com.microsoft.commondatamodel.objectmodel.utilities.AttributeResolutionDirectiveSet;
import com.microsoft.commondatamodel.objectmodel.utilities.DepthInfo;
import com.microsoft.commondatamodel.objectmodel.utilities.DocsResult;
import com.microsoft.commondatamodel.objectmodel.utilities.EventCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.ImportInfo;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StorageUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.SymbolSet;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.TelemetryClient;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class CdmCorpusDefinition {
    private static final String TAG = CdmCorpusDefinition.class.getSimpleName();
    private static AtomicInteger nextId = new AtomicInteger(0);
    private final StorageManager storage;
    private final PersistenceLayer persistence;
    private CdmCorpusContext ctx;
    private final Map<String, ArrayList<CdmE2ERelationship>> outgoingRelationships;
    private final Map<String, ArrayList<CdmE2ERelationship>> incomingRelationships;
    Map<String, String> resEntMap;
    private String appId;
    private TelemetryClient telemetryClient;
    private String rootPath;
    private Map<String, List<CdmDocumentDefinition>> symbolDefinitions = new LinkedHashMap<String, List<CdmDocumentDefinition>>();
    private Map<String, SymbolSet> definitionReferenceSymbols = new LinkedHashMap<String, SymbolSet>();
    private Map<String, ResolvedTraitSet> emptyRts = new LinkedHashMap<String, ResolvedTraitSet>();
    private Map<String, CdmTypeAttributeDefinition> knownArtifactAttributes;
    DocumentLibrary documentLibrary;
    boolean isCurrentlyResolving = false;
    private AttributeResolutionDirectiveSet defaultResolutionDirectives;

    public CdmCorpusDefinition() {
        this.setCtx(new ResolveContext(this));
        this.storage = new StorageManager(this);
        this.persistence = new PersistenceLayer(this);
        this.outgoingRelationships = new LinkedHashMap<String, ArrayList<CdmE2ERelationship>>();
        this.incomingRelationships = new LinkedHashMap<String, ArrayList<CdmE2ERelationship>>();
        this.resEntMap = new LinkedHashMap<String, String>();
        this.documentLibrary = new DocumentLibrary(this);
        LinkedHashSet<String> directives = new LinkedHashSet<String>();
        directives.add("normalized");
        directives.add("referenceOnly");
        this.defaultResolutionDirectives = new AttributeResolutionDirectiveSet(directives);
    }

    static CdmDocumentDefinition fetchPriorityDocument(List<CdmDocumentDefinition> docs, Map<CdmDocumentDefinition, ImportInfo> importPriority) {
        CdmDocumentDefinition docBest = null;
        int indexBest = Integer.MAX_VALUE;
        for (CdmDocumentDefinition docDefined : docs) {
            boolean worked = importPriority.containsKey(docDefined);
            ImportInfo importInfo = importPriority.getOrDefault(docDefined, null);
            if (!worked || importInfo.getPriority() >= indexBest) continue;
            indexBest = importInfo.getPriority();
            docBest = docDefined;
            if (indexBest != 0) continue;
            break;
        }
        return docBest;
    }

    static String createCacheKeyFromObject(CdmObject definition, String kind) {
        return definition.getId() + "-" + kind;
    }

    private static String pathToSymbol(String symbol, CdmDocumentDefinition docFrom, DocsResult docResultTo) {
        if (docResultTo.getDocBest() == null) {
            return null;
        }
        if (docFrom == docResultTo.getDocBest()) {
            return docResultTo.getNewSymbol();
        }
        Integer pri = docFrom.getImportPriorities().getImportPriority().get(docResultTo.getDocBest()).getPriority();
        if (pri != null) {
            if (docResultTo.getDocList() == null || docResultTo.getDocList().size() == 1) {
                return symbol;
            }
            Integer maxPri = 0;
            for (CdmDocumentDefinition docImpl : docResultTo.getDocList()) {
                Optional<Map.Entry> maxEntry = docImpl.getImportPriorities().getImportPriority().entrySet().parallelStream().max(Comparator.comparing(entry -> ((ImportInfo)entry.getValue()).getPriority()));
                maxPri = Math.max(maxPri, ((ImportInfo)maxEntry.get().getValue()).getPriority());
            }
            if (maxPri != null && maxPri.equals(pri)) {
                return symbol;
            }
        }
        if (null != docFrom.getImportPriorities().getMonikerPriorityMap()) {
            for (Map.Entry<String, CdmDocumentDefinition> kv : docFrom.getImportPriorities().getMonikerPriorityMap().entrySet()) {
                String tryMoniker = CdmCorpusDefinition.pathToSymbol(symbol, kv.getValue(), docResultTo);
                if (tryMoniker == null) continue;
                return String.format("%s/%s", kv.getKey(), tryMoniker);
            }
        }
        return null;
    }

    static CdmObjectType mapReferenceType(CdmObjectType ofType) {
        switch (ofType) {
            default: {
                return CdmObjectType.Error;
            }
            case AttributeGroupRef: 
            case AttributeGroupDef: {
                return CdmObjectType.AttributeGroupRef;
            }
            case ConstantEntityDef: 
            case EntityDef: 
            case EntityRef: {
                return CdmObjectType.EntityRef;
            }
            case DataTypeDef: 
            case DataTypeRef: {
                return CdmObjectType.DataTypeRef;
            }
            case PurposeDef: 
            case PurposeRef: {
                return CdmObjectType.PurposeRef;
            }
            case TraitDef: 
            case TraitRef: {
                return CdmObjectType.TraitRef;
            }
            case TraitGroupDef: 
            case TraitGroupRef: {
                return CdmObjectType.TraitGroupRef;
            }
            case EntityAttributeDef: 
            case TypeAttributeDef: 
            case AttributeRef: {
                return CdmObjectType.AttributeRef;
            }
            case AttributeContextDef: 
            case AttributeContextRef: 
        }
        return CdmObjectType.AttributeContextRef;
    }

    static int getNextId() {
        return nextId.incrementAndGet();
    }

    public boolean validate() {
        return false;
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public void setRootPath(String value) {
        this.rootPath = value;
    }

    public AttributeResolutionDirectiveSet getDefaultResolutionDirectives() {
        return this.defaultResolutionDirectives;
    }

    public void setDefaultResolutionDirectives(AttributeResolutionDirectiveSet defaultResolutionDirectives) {
        this.defaultResolutionDirectives = defaultResolutionDirectives;
    }

    public <T extends CdmObject> T makeObject(CdmObjectType ofType, String nameOrRef) {
        return this.makeObject(ofType, nameOrRef, false);
    }

    public <T extends CdmObject> T makeObject(CdmObjectType ofType) {
        return this.makeObject(ofType, null, false);
    }

    private void checkPrimaryKeyAttributes(CdmEntityDefinition resolvedEntity, ResolveOptions resOpt) {
        if (resolvedEntity.fetchResolvedTraits(resOpt).find(resOpt, "is.identifiedBy") == null) {
            Logger.warning(this.ctx, TAG, "checkPrimaryKeyAttributes", resolvedEntity.getAtCorpusPath(), CdmLogCode.WarnValdnPrimaryKeyMissing, resolvedEntity.getName());
        }
    }

    CdmDocumentDefinition addDocumentObjects(CdmFolderDefinition cdmFolderDefinition, CdmDocumentDefinition doc) {
        String path = this.storage.createAbsoluteCorpusPath(doc.getFolderPath() + doc.getName(), doc);
        this.documentLibrary.addDocumentPath(path, cdmFolderDefinition, doc);
        return doc;
    }

    String createDefinitionCacheTag(ResolveOptions resOpt, CdmObjectBase definition, String kind) {
        return this.createDefinitionCacheTag(resOpt, definition, kind, "", false);
    }

    String createDefinitionCacheTag(ResolveOptions resOpt, CdmObjectBase definition, String kind, String extraTags) {
        return this.createDefinitionCacheTag(resOpt, definition, kind, extraTags, false, null);
    }

    String createDefinitionCacheTag(ResolveOptions resOpt, CdmObjectBase definition, String kind, String extraTags, boolean notKnownToHaveParameters) {
        return this.createDefinitionCacheTag(resOpt, definition, kind, extraTags, notKnownToHaveParameters, null);
    }

    String createDefinitionCacheTag(ResolveOptions resOpt, CdmObjectBase definition, String kind, String extraTags, boolean notKnownToHaveParameters, String pathToDef) {
        String thisPath = definition.getObjectType() == CdmObjectType.ProjectionDef ? definition.getDeclaredPath().replace("/", "") : definition.getAtCorpusPath();
        String thisId = !StringUtils.isNullOrTrimEmpty(pathToDef) && notKnownToHaveParameters ? pathToDef : Integer.toString(definition.getId());
        StringBuilder tagSuffix = new StringBuilder();
        tagSuffix.append(String.format("-%s-%s", kind, thisId));
        boolean simpleCacheTag = false;
        switch (definition.getObjectType()) {
            case DataTypeDef: 
            case PurposeDef: 
            case TraitDef: 
            case TraitGroupDef: {
                simpleCacheTag = true;
            }
        }
        if (!simpleCacheTag) {
            tagSuffix.append(String.format("-(%s)", resOpt.getDirectives() != null ? resOpt.getDirectives().getTag() : ""));
        }
        if ("rasb".equals(kind)) {
            if (resOpt.depthInfo.getMaxDepth() == null) {
                resOpt.depthInfo.setMaxDepth(resOpt.getMaxDepth());
            }
            if (resOpt.depthInfo.getCurrentDepth() > resOpt.depthInfo.getMaxDepth()) {
                tagSuffix.append("-overMaxDepth");
            } else {
                DepthInfo currDepthInfo = resOpt.depthInfo;
                tagSuffix.append(String.format("-%stoMaxDepth", currDepthInfo.getMaxDepth() - currDepthInfo.getCurrentDepth()));
            }
        }
        if (resOpt.inCircularReference) {
            tagSuffix.append("-pk");
        }
        if (!StringUtils.isNullOrEmpty(extraTags)) {
            tagSuffix.append(String.format("-%s", extraTags));
        }
        Object objDef = definition.fetchObjectDefinition(resOpt);
        SymbolSet symbolsRef = null;
        if (objDef != null) {
            String key = CdmCorpusDefinition.createCacheKeyFromObject(objDef, kind);
            symbolsRef = this.definitionReferenceSymbols.get(key);
        }
        if (symbolsRef == null && thisPath != null) {
            SymbolSet symSetThis = new SymbolSet();
            symSetThis.add(thisPath);
            this.registerDefinitionReferenceSymbols(definition, kind, symSetThis);
            symbolsRef = symSetThis;
        }
        if (symbolsRef != null && symbolsRef.getSize() > 0) {
            CdmDocumentDefinition wrtDoc = resOpt.getWrtDoc();
            LinkedHashSet foundDocIds = new LinkedHashSet();
            if (wrtDoc.getImportPriorities() != null) {
                symbolsRef.forEach(symRef -> {
                    CdmDocumentDefinition docBest;
                    DocsResult docsRes = this.docsForSymbol(resOpt, wrtDoc, definition.getInDocument(), (String)symRef);
                    if (docsRes != null && docsRes.getDocList() != null && docsRes.getDocList().size() > 1 && (docBest = CdmCorpusDefinition.fetchPriorityDocument(docsRes.getDocList(), wrtDoc.getImportPriorities().getImportPriority())) != null) {
                        foundDocIds.add(docBest.getId());
                    }
                });
            }
            ArrayList sortedList = new ArrayList(foundDocIds);
            Collections.sort(sortedList);
            String tagPre = sortedList.stream().map(Object::toString).collect(Collectors.joining("-"));
            return tagPre + tagSuffix;
        }
        return null;
    }

    public <T extends CdmObjectReference> T makeRef(CdmObjectType ofType, Object refObj, boolean simpleNameRef) {
        CdmObjectReference oRef = null;
        if (refObj != null) {
            if (refObj instanceof CdmObject) {
                if (refObj == ofType) {
                    oRef = (CdmObjectReference)refObj;
                } else {
                    oRef = (CdmObjectReference)this.makeObject(ofType, null, false);
                    oRef.setExplicitReference((CdmObjectDefinition)refObj);
                }
            } else {
                oRef = (CdmObjectReference)this.makeObject(ofType, refObj.toString().replaceAll("^\"|\"$", ""), simpleNameRef);
            }
        }
        return (T)oRef;
    }

    public <T extends CdmObject> T makeObject(CdmObjectType ofType, String nameOrRef, boolean simpleNameRef) {
        CdmObjectBase newObj = null;
        switch (ofType) {
            case ArgumentDef: {
                newObj = new CdmArgumentDefinition(this.ctx, nameOrRef);
                break;
            }
            case AttributeContextDef: {
                newObj = new CdmAttributeContext(this.ctx, nameOrRef);
                break;
            }
            case AttributeContextRef: {
                newObj = new CdmAttributeContextReference(this.ctx, nameOrRef);
                break;
            }
            case AttributeGroupDef: {
                newObj = new CdmAttributeGroupDefinition(this.ctx, nameOrRef);
                break;
            }
            case AttributeGroupRef: {
                newObj = new CdmAttributeGroupReference(this.ctx, nameOrRef, simpleNameRef);
                break;
            }
            case AttributeRef: {
                newObj = new CdmAttributeReference(this.ctx, nameOrRef, simpleNameRef);
                break;
            }
            case AttributeResolutionGuidanceDef: {
                newObj = new CdmAttributeResolutionGuidance(this.ctx);
                break;
            }
            case ConstantEntityDef: {
                newObj = new CdmConstantEntityDefinition(this.ctx, nameOrRef);
                break;
            }
            case DataPartitionDef: {
                newObj = new CdmDataPartitionDefinition(this.ctx, nameOrRef);
                break;
            }
            case DataPartitionPatternDef: {
                newObj = new CdmDataPartitionPatternDefinition(this.ctx, nameOrRef);
                break;
            }
            case DataTypeDef: {
                newObj = new CdmDataTypeDefinition(this.ctx, nameOrRef, null);
                break;
            }
            case DataTypeRef: {
                newObj = new CdmDataTypeReference(this.ctx, nameOrRef, simpleNameRef);
                break;
            }
            case DocumentDef: {
                newObj = new CdmDocumentDefinition(this.ctx, nameOrRef);
                break;
            }
            case EntityAttributeDef: {
                newObj = new CdmEntityAttributeDefinition(this.ctx, nameOrRef);
                break;
            }
            case EntityDef: {
                newObj = new CdmEntityDefinition(this.ctx, nameOrRef, null);
                break;
            }
            case EntityRef: {
                newObj = new CdmEntityReference(this.ctx, nameOrRef, simpleNameRef);
                break;
            }
            case FolderDef: {
                newObj = new CdmFolderDefinition(this.ctx, nameOrRef);
                break;
            }
            case ManifestDef: {
                newObj = new CdmManifestDefinition(this.ctx, nameOrRef);
                Logger.debug(this.getCtx(), TAG, "makeObject<CdmManifestDefinition>", newObj.getAtCorpusPath(), "New Manifest created.", true);
                break;
            }
            case ManifestDeclarationDef: {
                newObj = new CdmManifestDeclarationDefinition(this.ctx, nameOrRef);
                break;
            }
            case Import: {
                newObj = new CdmImport(this.ctx, nameOrRef, null);
                break;
            }
            case LocalEntityDeclarationDef: {
                newObj = new CdmLocalEntityDeclarationDefinition(this.ctx, nameOrRef);
                break;
            }
            case ParameterDef: {
                newObj = new CdmParameterDefinition(this.ctx, nameOrRef);
                break;
            }
            case PurposeDef: {
                newObj = new CdmPurposeDefinition(this.ctx, nameOrRef, null);
                break;
            }
            case PurposeRef: {
                newObj = new CdmPurposeReference(this.ctx, nameOrRef, simpleNameRef);
                break;
            }
            case ReferencedEntityDeclarationDef: {
                newObj = new CdmReferencedEntityDeclarationDefinition(this.ctx, nameOrRef);
                break;
            }
            case TraitDef: {
                newObj = new CdmTraitDefinition(this.ctx, nameOrRef, null);
                break;
            }
            case TraitRef: {
                newObj = new CdmTraitReference(this.ctx, nameOrRef, simpleNameRef, false);
                break;
            }
            case TraitGroupDef: {
                newObj = new CdmTraitGroupDefinition(this.ctx, nameOrRef);
                break;
            }
            case TraitGroupRef: {
                newObj = new CdmTraitGroupReference(this.ctx, nameOrRef, simpleNameRef);
                break;
            }
            case TypeAttributeDef: {
                newObj = new CdmTypeAttributeDefinition(this.ctx, nameOrRef);
                break;
            }
            case E2ERelationshipDef: {
                newObj = new CdmE2ERelationship(this.ctx, nameOrRef);
                break;
            }
            case ProjectionDef: {
                newObj = new CdmProjection(this.ctx);
                break;
            }
            case OperationAddCountAttributeDef: {
                newObj = new CdmOperationAddCountAttribute(this.ctx);
                break;
            }
            case OperationAddSupportingAttributeDef: {
                newObj = new CdmOperationAddSupportingAttribute(this.ctx);
                break;
            }
            case OperationAddTypeAttributeDef: {
                newObj = new CdmOperationAddTypeAttribute(this.ctx);
                break;
            }
            case OperationExcludeAttributesDef: {
                newObj = new CdmOperationExcludeAttributes(this.ctx);
                break;
            }
            case OperationArrayExpansionDef: {
                newObj = new CdmOperationArrayExpansion(this.ctx);
                break;
            }
            case OperationCombineAttributesDef: {
                newObj = new CdmOperationCombineAttributes(this.ctx);
                break;
            }
            case OperationRenameAttributesDef: {
                newObj = new CdmOperationRenameAttributes(this.ctx);
                break;
            }
            case OperationReplaceAsForeignKeyDef: {
                newObj = new CdmOperationReplaceAsForeignKey(this.ctx);
                break;
            }
            case OperationIncludeAttributesDef: {
                newObj = new CdmOperationIncludeAttributes(this.ctx);
                break;
            }
            case OperationAddAttributeGroupDef: {
                newObj = new CdmOperationAddAttributeGroup(this.ctx);
                break;
            }
            case OperationAlterTraitsDef: {
                newObj = new CdmOperationAlterTraits(this.ctx);
                break;
            }
            case OperationAddArtifactAttributeDef: {
                newObj = new CdmOperationAddArtifactAttribute(this.ctx);
            }
        }
        return (T)newObj;
    }

    @Deprecated
    public void registerSymbol(String symbol, CdmDocumentDefinition inDoc) {
        List docs = this.symbolDefinitions.computeIfAbsent(symbol, k -> new ArrayList());
        docs.add(inDoc);
    }

    void removeDocumentObjects(CdmFolderDefinition cdmFolderDefinition, CdmDocumentDefinition doc) {
        this.removeObjectDefinitions(doc);
        String path = this.storage.createAbsoluteCorpusPath(doc.getFolderPath() + doc.getName(), doc);
        this.documentLibrary.removeDocumentPath(path, cdmFolderDefinition, doc);
    }

    private void removeObjectDefinitions(CdmDocumentDefinition doc) {
        ResolveContext ctx = (ResolveContext)this.ctx;
        doc.visit("", new removeObjectCallBack(this, ctx, doc), null);
    }

    private void unRegisterSymbol(String symbol, CdmDocumentDefinition inDoc) {
        int index;
        List<CdmDocumentDefinition> docs = this.symbolDefinitions.get(symbol);
        if (docs != null && (index = docs.indexOf(inDoc)) != -1) {
            docs.remove(index);
        }
    }

    void setImportDocuments(CdmDocumentDefinition doc) {
        if (doc.getImports() != null) {
            for (int i = 0; i < doc.getImports().size(); ++i) {
                String path;
                CdmDocumentDefinition impDoc;
                CdmImport anImport = (CdmImport)doc.getImports().get(i);
                if (anImport.getDocument() != null || (impDoc = this.documentLibrary.fetchDocument(path = this.getStorage().createAbsoluteCorpusPath(anImport.getCorpusPath(), doc))) == null) continue;
                anImport.setDocument(impDoc);
                this.setImportDocuments(anImport.getDocument());
            }
        }
    }

    CompletableFuture<Void> loadImportsAsync(CdmDocumentDefinition doc, Set<String> docsLoading, ResolveOptions resOpt) {
        if (doc == null) {
            return CompletableFuture.completedFuture(null);
        }
        Function<String, CompletableFuture> loadDocs = docPath -> this.documentLibrary.concurrentReadLock.acquire().thenRun(() -> {
            if (!this.documentLibrary.needToLoadDocument((String)docPath, docsLoading)) {
                this.documentLibrary.concurrentReadLock.release();
                return;
            }
            CdmDocumentDefinition loadedDoc = (CdmDocumentDefinition)this.documentLibrary.loadFolderOrDocumentAsync((String)docPath, false, resOpt).join();
            if (loadedDoc != null) {
                Logger.info(this.ctx, TAG, "loadImportsAsync", loadedDoc.getAtCorpusPath(), Logger.format("Resolved import for '{0}'.", loadedDoc.getName()));
            } else {
                Logger.warning(this.ctx, TAG, "loadImportsAsync", null, CdmLogCode.WarnResolveImportFailed, docPath);
            }
            this.documentLibrary.concurrentReadLock.release();
            this.loadImportsAsync(loadedDoc, docsLoading, resOpt).join();
        });
        ArrayList<CompletableFuture> taskList = new ArrayList<CompletableFuture>();
        for (CdmImport imp : doc.getImports()) {
            if (imp.getDocument() != null) continue;
            String docPath2 = this.getStorage().createAbsoluteCorpusPath(imp.getCorpusPath(), doc);
            CompletableFuture loadTask = loadDocs.apply(docPath2);
            taskList.add(loadTask);
        }
        return CompletableFuture.allOf(taskList.toArray(new CompletableFuture[0]));
    }

    CompletableFuture<Void> resolveImportsAsync(CdmDocumentDefinition doc, Set<String> docsLoading, ResolveOptions resOpt) {
        return this.loadImportsAsync(doc, docsLoading, resOpt).thenRun(() -> this.setImportDocuments(doc));
    }

    private DocsResult docsForSymbol(ResolveOptions resOpt, CdmDocumentDefinition wrtDoc, CdmDocumentDefinition fromDoc, String symbol) {
        ResolveContext ctx = (ResolveContext)this.ctx;
        DocsResult result = new DocsResult();
        result.setNewSymbol(symbol);
        List<CdmDocumentDefinition> docList = this.symbolDefinitions.get(symbol);
        result.setDocList(docList);
        if (result.getDocList() == null || result.getDocList().size() == 0) {
            int preEnd = 0;
            if (symbol != null) {
                preEnd = symbol.indexOf("/");
            }
            if (preEnd == 0) {
                Logger.error(ctx, TAG, "docsForSymbol", wrtDoc.getAtCorpusPath(), CdmLogCode.ErrUnsupportedRef, symbol, ctx.getRelativePath());
                return null;
            }
            if (preEnd > 0) {
                String prefix = StringUtils.slice(symbol, 0, preEnd);
                result.setNewSymbol(StringUtils.slice(symbol, preEnd + 1));
                List<CdmDocumentDefinition> tempDocList = this.symbolDefinitions.get(result.getNewSymbol());
                result.setDocList(tempDocList);
                CdmDocumentDefinition tempMoniker = null;
                boolean usingWrtDoc = false;
                if (fromDoc != null && fromDoc.getImportPriorities() != null && fromDoc.getImportPriorities().getMonikerPriorityMap() != null && fromDoc.getImportPriorities().getMonikerPriorityMap().containsKey(prefix)) {
                    tempMoniker = fromDoc.getImportPriorities().getMonikerPriorityMap().get(prefix);
                } else if (wrtDoc != null && wrtDoc.getImportPriorities() != null && wrtDoc.getImportPriorities().getMonikerPriorityMap() != null && wrtDoc.getImportPriorities().getMonikerPriorityMap().containsKey(prefix)) {
                    tempMoniker = wrtDoc.getImportPriorities().getMonikerPriorityMap().get(prefix);
                    usingWrtDoc = true;
                }
                if (tempMoniker != null) {
                    if (result.getNewSymbol().contains("/") && (usingWrtDoc || !this.symbolDefinitions.containsKey(result.getNewSymbol()))) {
                        DocsResult currDocsResult = this.docsForSymbol(resOpt, wrtDoc, tempMoniker, result.getNewSymbol());
                        if (currDocsResult.getDocList() == null && fromDoc == wrtDoc) {
                            return this.docsForSymbol(resOpt, tempMoniker, tempMoniker, result.getNewSymbol());
                        }
                        return currDocsResult;
                    }
                    result.setDocBest(tempMoniker);
                } else {
                    result.setNewSymbol(symbol);
                    result.setDocList(null);
                }
            }
        }
        return result;
    }

    @Deprecated
    public CdmObjectBase resolveSymbolReference(ResolveOptions resOpt, CdmDocumentDefinition fromDoc, String symbolDef, CdmObjectType expectedType, boolean retry) {
        List<CdmDocumentDefinition> docs;
        boolean isReference;
        ResolveContext ctx = (ResolveContext)this.ctx;
        if (resOpt == null || resOpt.getWrtDoc() == null || symbolDef == null) {
            return null;
        }
        CdmDocumentDefinition wrtDoc = resOpt.getWrtDoc();
        if (wrtDoc.getNeedsIndexing() && !wrtDoc.isCurrentlyIndexing() && !wrtDoc.indexIfNeededAsync(resOpt, true).join().booleanValue()) {
            Logger.error(ctx, TAG, "resolveSymbolReference", wrtDoc.getAtCorpusPath(), CdmLogCode.ErrIndexFailed, new String[0]);
            return null;
        }
        if (wrtDoc.getNeedsIndexing() && resOpt.getImportsLoadStrategy() == ImportsLoadStrategy.DoNotLoad) {
            Logger.error(ctx, TAG, "resolveSymbolReference", wrtDoc.getAtCorpusPath(), CdmLogCode.ErrSymbolNotFound, symbolDef, "because the ImportsLoadStrategy is set to DoNotLoad");
            return null;
        }
        String initialSymbol = symbolDef;
        boolean bl = isReference = symbolDef != null && symbolDef.endsWith("(ref)");
        if (isReference) {
            int defIndex = symbolDef.indexOf("/");
            symbolDef = symbolDef.substring(0, defIndex);
        }
        DocsResult symbolDocsResult = this.docsForSymbol(resOpt, wrtDoc, fromDoc, symbolDef);
        CdmDocumentDefinition docBest = symbolDocsResult.getDocBest();
        symbolDef = symbolDocsResult.getNewSymbol();
        if (!isReference) {
            initialSymbol = symbolDef;
        }
        if (null != (docs = symbolDocsResult.getDocList())) {
            if (null == resOpt.getSymbolRefSet()) {
                resOpt.setSymbolRefSet(new SymbolSet());
            }
            resOpt.getSymbolRefSet().add(symbolDef);
            if (null == wrtDoc.getImportPriorities()) {
                return null;
            }
            Map<CdmDocumentDefinition, ImportInfo> importPriority = wrtDoc.getImportPriorities().getImportPriority();
            if (importPriority.size() == 0) {
                return null;
            }
            if (null == docBest) {
                docBest = CdmCorpusDefinition.fetchPriorityDocument(docs, importPriority);
            }
        }
        if (null == docBest) {
            return null;
        }
        CdmObjectBase found = docBest.internalDeclarations.get(symbolDef);
        if (found != null && isReference) {
            AtomicReference foundRef = new AtomicReference();
            String symbol = initialSymbol;
            found.visit("", (obj, objPath) -> {
                if (symbol.equals(objPath)) {
                    foundRef.set((CdmObjectBase)obj);
                    return true;
                }
                return false;
            }, null);
            found = (CdmObjectBase)foundRef.get();
        }
        if (found == null && retry) {
            found = this.resolveSymbolReference(resOpt, docBest, initialSymbol, expectedType, false);
        }
        if (found != null && expectedType != CdmObjectType.Error) {
            switch (expectedType) {
                case TraitRef: {
                    if (found.getObjectType() == CdmObjectType.TraitDef) break;
                    Logger.error(ctx, TAG, "resolveSymbolReference", wrtDoc.getAtCorpusPath(), CdmLogCode.ErrUnexpectedType, "trait", symbolDef);
                    found = null;
                    break;
                }
                case DataTypeRef: {
                    if (found.getObjectType() == CdmObjectType.DataTypeDef) break;
                    Logger.error(ctx, TAG, "resolveSymbolReference", wrtDoc.getAtCorpusPath(), CdmLogCode.ErrUnexpectedType, "dataType", symbolDef);
                    found = null;
                    break;
                }
                case EntityRef: {
                    if (found.getObjectType() == CdmObjectType.EntityDef || found.getObjectType() == CdmObjectType.ProjectionDef || found.getObjectType() == CdmObjectType.ConstantEntityDef) break;
                    Logger.error(ctx, TAG, "resolveSymbolReference", wrtDoc.getAtCorpusPath(), CdmLogCode.ErrUnexpectedType, "entity or type projection or type constant entity", symbolDef);
                    found = null;
                    break;
                }
                case ParameterDef: {
                    if (found.getObjectType() == CdmObjectType.ParameterDef) break;
                    Logger.error(ctx, TAG, "resolveSymbolReference", wrtDoc.getAtCorpusPath(), CdmLogCode.ErrUnexpectedType, "parameter", symbolDef);
                    found = null;
                    break;
                }
                case PurposeRef: {
                    if (found.getObjectType() == CdmObjectType.PurposeDef) break;
                    Logger.error(ctx, TAG, "resolveSymbolReference", wrtDoc.getAtCorpusPath(), CdmLogCode.ErrUnexpectedType, "purpose", symbolDef);
                    found = null;
                    break;
                }
                case TraitGroupRef: {
                    if (found.getObjectType() == CdmObjectType.TraitGroupDef) break;
                    Logger.error(ctx, TAG, "resolveSymbolReference", wrtDoc.getAtCorpusPath(), CdmLogCode.ErrUnexpectedType, "traitGroup", symbolDef);
                    found = null;
                    break;
                }
                case AttributeGroupRef: {
                    if (found.getObjectType() == CdmObjectType.AttributeGroupDef) break;
                    Logger.error(ctx, TAG, "resolveSymbolReference", wrtDoc.getAtCorpusPath(), CdmLogCode.ErrUnexpectedType, "attributeGroup", symbolDef);
                    found = null;
                    break;
                }
                case ProjectionDef: {
                    if (found.getObjectType() == CdmObjectType.ProjectionDef) break;
                    Logger.error(ctx, TAG, "resolveSymbolReference", wrtDoc.getAtCorpusPath(), CdmLogCode.ErrUnexpectedType, "add count attribute operation", symbolDef);
                    found = null;
                    break;
                }
                case OperationAddCountAttributeDef: {
                    if (found.getObjectType() == CdmObjectType.OperationAddCountAttributeDef) break;
                    Logger.error(ctx, TAG, "resolveSymbolReference", wrtDoc.getAtCorpusPath(), CdmLogCode.ErrUnexpectedType, "add supporting attribute operation", symbolDef);
                    found = null;
                    break;
                }
                case OperationAddSupportingAttributeDef: {
                    if (found.getObjectType() == CdmObjectType.OperationAddSupportingAttributeDef) break;
                    Logger.error(ctx, TAG, "resolveSymbolReference", wrtDoc.getAtCorpusPath(), CdmLogCode.ErrUnexpectedType, "type attribute operation", symbolDef);
                    found = null;
                    break;
                }
                case OperationAddTypeAttributeDef: {
                    if (found.getObjectType() == CdmObjectType.OperationAddTypeAttributeDef) break;
                    Logger.error(ctx, TAG, "resolveSymbolReference", wrtDoc.getAtCorpusPath(), CdmLogCode.ErrUnexpectedType, "attribute operation", symbolDef);
                    found = null;
                    break;
                }
                case OperationExcludeAttributesDef: {
                    if (found.getObjectType() == CdmObjectType.OperationExcludeAttributesDef) break;
                    Logger.error(ctx, TAG, "resolveSymbolReference", wrtDoc.getAtCorpusPath(), CdmLogCode.ErrUnexpectedType, "exclude attributes operation", symbolDef);
                    found = null;
                    break;
                }
                case OperationArrayExpansionDef: {
                    if (found.getObjectType() == CdmObjectType.OperationArrayExpansionDef) break;
                    Logger.error(ctx, TAG, "resolveSymbolReference", wrtDoc.getAtCorpusPath(), CdmLogCode.ErrUnexpectedType, "array expansion operation", symbolDef);
                    found = null;
                    break;
                }
                case OperationCombineAttributesDef: {
                    if (found.getObjectType() == CdmObjectType.OperationCombineAttributesDef) break;
                    Logger.error(ctx, TAG, "resolveSymbolReference", wrtDoc.getAtCorpusPath(), CdmLogCode.ErrUnexpectedType, "combine attributes operation", symbolDef);
                    found = null;
                    break;
                }
                case OperationRenameAttributesDef: {
                    if (found.getObjectType() == CdmObjectType.OperationRenameAttributesDef) break;
                    Logger.error(ctx, TAG, "resolveSymbolReference", wrtDoc.getAtCorpusPath(), CdmLogCode.ErrUnexpectedType, "rename attributes operation", symbolDef);
                    found = null;
                    break;
                }
                case OperationReplaceAsForeignKeyDef: {
                    if (found.getObjectType() == CdmObjectType.OperationReplaceAsForeignKeyDef) break;
                    Logger.error(ctx, TAG, "resolveSymbolReference", wrtDoc.getAtCorpusPath(), CdmLogCode.ErrUnexpectedType, "replace as foreign key operation", symbolDef);
                    found = null;
                    break;
                }
                case OperationIncludeAttributesDef: {
                    if (found.getObjectType() == CdmObjectType.OperationIncludeAttributesDef) break;
                    Logger.error(ctx, TAG, "resolveSymbolReference", wrtDoc.getAtCorpusPath(), CdmLogCode.ErrUnexpectedType, "include attributes operation", symbolDef);
                    found = null;
                    break;
                }
                case OperationAddAttributeGroupDef: {
                    if (found.getObjectType() == CdmObjectType.OperationAddAttributeGroupDef) break;
                    Logger.error(ctx, TAG, "resolveSymbolReference", wrtDoc.getAtCorpusPath(), CdmLogCode.ErrUnexpectedType, "add attribute group operation", symbolDef);
                    found = null;
                    break;
                }
                case OperationAlterTraitsDef: {
                    if (found.getObjectType() == CdmObjectType.OperationAlterTraitsDef) break;
                    Logger.error(ctx, TAG, "resolveSymbolReference", wrtDoc.getAtCorpusPath(), CdmLogCode.ErrUnexpectedType, "alter traits operation", symbolDef);
                    found = null;
                    break;
                }
                case OperationAddArtifactAttributeDef: {
                    if (found.getObjectType() == CdmObjectType.OperationAddArtifactAttributeDef) break;
                    Logger.error(ctx, TAG, "resolveSymbolReference", wrtDoc.getAtCorpusPath(), CdmLogCode.ErrUnexpectedType, "add artifact attribute operation", symbolDef);
                    found = null;
                    break;
                }
            }
        }
        return found;
    }

    private void unRegisterDefinitionReferenceSymbols(CdmObject definition, String kind) {
        String key = CdmCorpusDefinition.createCacheKeyFromObject(definition, kind);
        this.definitionReferenceSymbols.remove(key);
    }

    void registerDefinitionReferenceSymbols(CdmObject definition, String kind, SymbolSet symbolRefSet) {
        String key = CdmCorpusDefinition.createCacheKeyFromObject(definition, kind);
        SymbolSet existingSymbols = this.definitionReferenceSymbols.get(key);
        if (existingSymbols == null) {
            this.definitionReferenceSymbols.put(key, symbolRefSet);
        } else {
            existingSymbols.merge(symbolRefSet);
        }
    }

    boolean indexDocuments(ResolveOptions resOpt, boolean loadImports, CdmDocumentDefinition rootDoc, Set<String> docsLoaded) {
        List<CdmDocumentDefinition> docsNotIndexed = this.documentLibrary.listDocsNotIndexed(rootDoc, docsLoaded);
        for (CdmDocumentDefinition doc : docsNotIndexed) {
            if (doc.declarationsIndexed && !loadImports) continue;
            Logger.debug(this.ctx, TAG, "indexDocuments", doc.getAtCorpusPath(), Logger.format("index start: {0}", new Object[0]));
            doc.clearCaches();
        }
        for (CdmDocumentDefinition doc : docsNotIndexed) {
            if (doc.declarationsIndexed && !loadImports) continue;
            doc.checkIntegrity();
        }
        for (CdmDocumentDefinition doc : docsNotIndexed) {
            if (doc.declarationsIndexed && !loadImports || !doc.isValid) continue;
            doc.declareObjectDefinitions();
        }
        if (loadImports) {
            ResolveOptions resOptLocal;
            for (CdmDocumentDefinition doc : docsNotIndexed) {
                if (!doc.isValid) continue;
                doc.getImportPriorities();
            }
            for (CdmDocumentDefinition doc : docsNotIndexed) {
                if (!doc.isValid) continue;
                resOptLocal = resOpt.copy();
                resOptLocal.setWrtDoc(doc);
                doc.resolveObjectDefinitions(resOptLocal);
            }
            for (CdmDocumentDefinition doc : docsNotIndexed) {
                if (!doc.isValid) continue;
                resOptLocal = resOpt.copy();
                resOptLocal.setWrtDoc(doc);
                doc.resolveTraitArguments(resOptLocal);
            }
        }
        for (CdmDocumentDefinition doc : docsNotIndexed) {
            doc.finishIndexing(loadImports);
        }
        return true;
    }

    public <T extends CdmObject> CompletableFuture<T> fetchObjectAsync(String objectPath) {
        return this.fetchObjectAsync(objectPath, null);
    }

    public <T extends CdmObject> CompletableFuture<T> fetchObjectAsync(String objectPath, CdmObject cdmObject) {
        return this.fetchObjectAsync(objectPath, cdmObject, null, false);
    }

    public <T extends CdmObject> CompletableFuture<T> fetchObjectAsync(String objectPath, CdmObject cdmObject, boolean shallowValidation) {
        ResolveOptions resOpt = new ResolveOptions();
        resOpt.setShallowValidation(shallowValidation);
        return this.fetchObjectAsync(objectPath, cdmObject, resOpt, false);
    }

    public <T extends CdmObject> CompletableFuture<T> fetchObjectAsync(String objectPath, CdmObject cdmObject, ResolveOptions resOpt) {
        return this.fetchObjectAsync(objectPath, cdmObject, resOpt, false);
    }

    public <T extends CdmObject> CompletableFuture<T> fetchObjectAsync(String objectPath, CdmObject cdmObject, ResolveOptions resOpt, boolean forceReload) {
        try (Logger.LoggerScope logScope = Logger.enterScope(CdmCorpusDefinition.class.getSimpleName(), this.ctx, "fetchObjectAsync");){
            String absolutePath;
            ResolveOptions finalResOpt = resOpt != null ? resOpt : new ResolveOptions();
            String documentPath = absolutePath = this.storage.createAbsoluteCorpusPath(objectPath, cdmObject);
            int documentNameIndex = absolutePath.lastIndexOf(".cdm.json");
            if (documentNameIndex != -1) {
                documentPath = absolutePath.substring(0, documentNameIndex += ".cdm.json".length());
            }
            Logger.debug(this.ctx, TAG, "fetchObjectAsync", documentPath, Logger.format("request object: {0}", objectPath));
            CdmContainerDefinition newObj = this.documentLibrary.loadFolderOrDocumentAsync(documentPath, forceReload).join();
            if (newObj != null) {
                if (newObj instanceof CdmDocumentDefinition) {
                    if (!((CdmDocumentDefinition)newObj).indexIfNeededAsync(finalResOpt, false).join().booleanValue()) {
                        CompletableFuture<T> completableFuture = null;
                        return completableFuture;
                    }
                    if (!((CdmDocumentDefinition)newObj).isValid) {
                        Logger.error(this.ctx, TAG, "fetchObjectAsync", newObj.getAtCorpusPath(), CdmLogCode.ErrValdnInvalidDoc, objectPath);
                        CompletableFuture<T> completableFuture = null;
                        return completableFuture;
                    }
                }
                if (Objects.equals(documentPath, absolutePath)) {
                    if (newObj instanceof CdmManifestDefinition) {
                        Logger.ingestManifestTelemetry((CdmManifestDefinition)newObj, this.getCtx(), TAG, Logger.format("fetchObjectAsync<{0}>", CdmManifestDefinition.class.getSimpleName()), newObj.getAtCorpusPath());
                    }
                    CompletableFuture<CdmContainerDefinition> completableFuture = CompletableFuture.completedFuture(newObj);
                    return completableFuture;
                }
                if (documentNameIndex == -1) {
                    CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
                    return completableFuture;
                }
                String remainingObjectPath = absolutePath.substring(documentNameIndex + 1);
                CdmObject result = ((CdmDocumentDefinition)newObj).fetchObjectFromDocumentPath(remainingObjectPath, resOpt);
                if (null == result) {
                    Logger.error(this.ctx, TAG, "fetchObjectAsync", newObj.getAtCorpusPath(), CdmLogCode.ErrDocSymbolNotFound, objectPath, newObj.getAtCorpusPath());
                } else if (result instanceof CdmManifestDefinition) {
                    Logger.ingestManifestTelemetry((CdmManifestDefinition)newObj, this.getCtx(), TAG, Logger.format("fetchObjectAsync<{0}}>", CdmManifestDefinition.class.getSimpleName()), newObj.getAtCorpusPath());
                } else if (result instanceof CdmEntityDefinition) {
                    Logger.ingestEntityTelemetry((CdmEntityDefinition)result, this.getCtx(), TAG, Logger.format("fetchObjectAsync<{0}>", CdmEntityDefinition.class.getSimpleName()), newObj.getAtCorpusPath());
                }
                CompletableFuture<CdmObject> completableFuture = CompletableFuture.completedFuture(result);
                return completableFuture;
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    public void setEventCallback(EventCallback status) {
        this.setEventCallback(status, CdmStatusLevel.Info, null);
    }

    public void setEventCallback(EventCallback status, CdmStatusLevel reportAtLevel) {
        this.setEventCallback(status, reportAtLevel, null);
    }

    public void setEventCallback(EventCallback status, CdmStatusLevel reportAtLevel, String correlationId) {
        ResolveContext ctx = (ResolveContext)this.ctx;
        ctx.setStatusEvent(status);
        ctx.setReportAtLevel(reportAtLevel);
        ctx.setCorrelationId(correlationId);
    }

    private CompletableFuture<Void> visitManifestTreeAsync(CdmManifestDefinition manifest, List<CdmEntityDefinition> entitiesInManifestTree) {
        return CompletableFuture.runAsync(() -> {
            CdmCollection<CdmManifestDeclarationDefinition> subManifests;
            CdmEntityCollection entities = manifest.getEntities();
            if (entities != null) {
                for (CdmEntityDeclarationDefinition entity : entities) {
                    CdmFileStatus currentFile = manifest;
                    CdmEntityDeclarationDefinition currentEnt = entity;
                    while (currentEnt instanceof CdmReferencedEntityDeclarationDefinition) {
                        currentEnt = (CdmEntityDeclarationDefinition)this.fetchObjectAsync(currentEnt.getEntityPath(), currentFile).join();
                        currentFile = currentEnt;
                    }
                    CdmEntityDefinition entityDef = (CdmEntityDefinition)this.fetchObjectAsync(currentEnt.getEntityPath(), currentFile).join();
                    entitiesInManifestTree.add(entityDef);
                }
            }
            if ((subManifests = manifest.getSubManifests()) == null) {
                return;
            }
            subManifests.forEach(subFolder -> {
                CdmManifestDefinition childManifest = (CdmManifestDefinition)this.fetchObjectAsync(subFolder.getDefinition(), manifest).join();
                this.visitManifestTreeAsync(childManifest, entitiesInManifestTree).join();
            });
        });
    }

    private CompletableFuture<Void> generateWarningsForSingleDoc(Pair<CdmFolderDefinition, CdmDocumentDefinition> fd, ResolveOptions resOpt) {
        CdmDocumentDefinition doc = (CdmDocumentDefinition)fd.getRight();
        if (doc.getDefinitions() == null) {
            return CompletableFuture.completedFuture(null);
        }
        resOpt.setWrtDoc(doc);
        return CompletableFuture.runAsync(() -> doc.getDefinitions().getAllItems().parallelStream().map(element -> {
            if (element instanceof CdmEntityDefinition) {
                CdmEntityDefinition entity = (CdmEntityDefinition)element;
                if (entity.getAttributes().getCount() > 0) {
                    CdmEntityDefinition resolvedEntity = entity.createResolvedEntityAsync(entity.getName() + "_", resOpt).join();
                    this.checkPrimaryKeyAttributes(resolvedEntity, resOpt);
                }
                return entity;
            }
            return null;
        }));
    }

    public ArrayList<CdmE2ERelationship> fetchIncomingRelationships(CdmEntityDefinition entity) {
        if (this.incomingRelationships != null && this.incomingRelationships.containsKey(entity.getAtCorpusPath())) {
            return this.incomingRelationships.get(entity.getAtCorpusPath());
        }
        return new ArrayList<CdmE2ERelationship>();
    }

    public ArrayList<CdmE2ERelationship> fetchOutgoingRelationships(CdmEntityDefinition entity) {
        if (this.outgoingRelationships != null && this.outgoingRelationships.containsKey(entity.getAtCorpusPath())) {
            return this.outgoingRelationships.get(entity.getAtCorpusPath());
        }
        return new ArrayList<CdmE2ERelationship>();
    }

    public CompletableFuture<Void> calculateEntityGraphAsync(CdmManifestDefinition currManifest) {
        return CompletableFuture.runAsync(() -> {
            try (Logger.LoggerScope logScope = Logger.enterScope(CdmCorpusDefinition.class.getSimpleName(), this.ctx, "calculateEntityGraphAsync");){
                if (currManifest.getEntities() != null) {
                    for (CdmEntityDeclarationDefinition entityDec : currManifest.getEntities()) {
                        try (Logger.LoggerScope logScopePerEntity = Logger.enterScope(TAG, this.ctx, "calculateEntityGraphAsync(perEntity)");){
                            String entityPath = currManifest.createEntityPathFromDeclarationAsync(entityDec, currManifest).join();
                            CdmEntityDefinition entity = (CdmEntityDefinition)this.fetchObjectAsync(entityPath).join();
                            if (entity == null) continue;
                            LinkedHashSet<String> directives = new LinkedHashSet<String>();
                            directives.add("normalized");
                            directives.add("referenceOnly");
                            ResolveOptions resOpt = new ResolveOptions(entity.getInDocument(), new AttributeResolutionDirectiveSet(directives));
                            boolean isResolvedEntity = entity.getIsResolved();
                            CdmEntityDefinition resEntity = !isResolvedEntity ? entity.createResolvedEntityAsync("wrtSelf_" + entity.getEntityName(), resOpt).join() : entity;
                            ArrayList<CdmE2ERelationship> newOutgoingRelationships = this.findOutgoingRelationships(resOpt, resEntity, resEntity.getAttributeContext(), isResolvedEntity);
                            ArrayList<CdmE2ERelationship> oldOutgoingRelationships = this.outgoingRelationships.get(entity.getAtCorpusPath());
                            if (oldOutgoingRelationships != null) {
                                oldOutgoingRelationships.forEach(rel -> {
                                    String relString = rel.createCacheKey();
                                    Boolean hasRel = newOutgoingRelationships.parallelStream().anyMatch(x -> x.createCacheKey().equals(relString));
                                    if (!hasRel.booleanValue()) {
                                        CdmEntityDefinition targetEnt = (CdmEntityDefinition)this.fetchObjectAsync(rel.getToEntity(), currManifest).join();
                                        if (targetEnt != null) {
                                            ArrayList<CdmE2ERelationship> currIncoming = this.incomingRelationships.get(targetEnt.getAtCorpusPath());
                                            if (currIncoming != null) {
                                                currIncoming.remove(rel);
                                            }
                                        } else {
                                            String absolutePath = this.getStorage().createAbsoluteCorpusPath(rel.getToEntity(), rel.getInDocument());
                                            this.incomingRelationships.remove(absolutePath);
                                        }
                                    }
                                });
                            }
                            this.outgoingRelationships.put(entity.getAtCorpusPath(), newOutgoingRelationships);
                            if (newOutgoingRelationships != null) {
                                for (CdmE2ERelationship outgoingRelationship : newOutgoingRelationships) {
                                    CdmEntityDefinition targetEnt = (CdmEntityDefinition)this.fetchObjectAsync(outgoingRelationship.getToEntity(), currManifest).join();
                                    if (targetEnt == null) continue;
                                    if (!this.incomingRelationships.containsKey(targetEnt.getAtCorpusPath())) {
                                        this.incomingRelationships.put(targetEnt.getAtCorpusPath(), new ArrayList());
                                    }
                                    this.incomingRelationships.get(targetEnt.getAtCorpusPath()).add(outgoingRelationship);
                                }
                            }
                            if (isResolvedEntity) continue;
                            ((CdmFolderDefinition)resEntity.getInDocument().getOwner()).getDocuments().remove(resEntity.getInDocument().getName());
                        }
                    }
                }
                if (currManifest.getSubManifests() != null) {
                    for (CdmManifestDeclarationDefinition subManifestDef : currManifest.getSubManifests()) {
                        CdmManifestDefinition subManifest = (CdmManifestDefinition)this.fetchObjectAsync(subManifestDef.getDefinition(), currManifest).join();
                        if (subManifest == null) continue;
                        this.calculateEntityGraphAsync(subManifest).join();
                    }
                }
            }
        });
    }

    private ArrayList<CdmE2ERelationship> findOutgoingRelationships(ResolveOptions resOpt, CdmEntityDefinition resEntity, CdmAttributeContext attCtx) {
        return this.findOutgoingRelationships(resOpt, resEntity, attCtx, false, null);
    }

    private ArrayList<CdmE2ERelationship> findOutgoingRelationships(ResolveOptions resOpt, CdmEntityDefinition resEntity, CdmAttributeContext attCtx, boolean isResolvedEntity) {
        return this.findOutgoingRelationships(resOpt, resEntity, attCtx, isResolvedEntity, null);
    }

    private ArrayList<CdmE2ERelationship> findOutgoingRelationships(ResolveOptions resOpt, CdmEntityDefinition resEntity, CdmAttributeContext attCtx, boolean isResolvedEntity, CdmAttributeContext generatedAttSetContext) {
        return this.findOutgoingRelationships(resOpt, resEntity, attCtx, isResolvedEntity, generatedAttSetContext, false);
    }

    private ArrayList<CdmE2ERelationship> findOutgoingRelationships(ResolveOptions resOpt, CdmEntityDefinition resEntity, CdmAttributeContext attCtx, boolean isResolvedEntity, CdmAttributeContext generatedAttSetContext, boolean wasProjectionPolymorphic) {
        return this.findOutgoingRelationships(resOpt, resEntity, attCtx, isResolvedEntity, generatedAttSetContext, wasProjectionPolymorphic, null, null);
    }

    private ArrayList<CdmE2ERelationship> findOutgoingRelationships(ResolveOptions resOpt, CdmEntityDefinition resEntity, CdmAttributeContext attCtx, boolean isResolvedEntity, CdmAttributeContext generatedAttSetContext, boolean wasProjectionPolymorphic, List<CdmAttributeReference> fromAtts, CdmAttributeContext entityAttAttContext) {
        ArrayList<CdmE2ERelationship> outRels = new ArrayList<CdmE2ERelationship>();
        if (attCtx != null && attCtx.getContents() != null) {
            CdmAttributeContext newGenSet = (CdmAttributeContext)attCtx.getContents().item("_generatedAttributeSet");
            if (newGenSet == null) {
                newGenSet = generatedAttSetContext;
            }
            boolean isEntityRef = false;
            boolean isPolymorphicSource = false;
            for (CdmObject subAttCtx : attCtx.getContents()) {
                CdmAttributeContext child;
                if (subAttCtx.getObjectType() != CdmObjectType.AttributeContextDef) continue;
                if (entityAttAttContext == null && attCtx.getType() == CdmAttributeContextType.AttributeDefinition && attCtx.getDefinition() != null && attCtx.getDefinition().fetchObjectDefinition(resOpt) != null && attCtx.getDefinition().fetchObjectDefinition(resOpt).getObjectType() == CdmObjectType.EntityAttributeDef) {
                    entityAttAttContext = attCtx;
                }
                CdmAttributeContext cdmAttributeContext = child = subAttCtx instanceof CdmAttributeContext ? (CdmAttributeContext)subAttCtx : null;
                if (child != null && child.getDefinition() != null && child.getDefinition().getObjectType() == CdmObjectType.EntityRef) {
                    Object toEntity = child.getDefinition().fetchObjectDefinition(resOpt);
                    if (toEntity != null && toEntity.getObjectType() == CdmObjectType.ProjectionDef) {
                        ResolvedTraitSet resolvedTraitSet;
                        CdmObject owner;
                        isEntityRef = false;
                        CdmObject cdmObject = owner = toEntity.getOwner() != null ? toEntity.getOwner().getOwner() : null;
                        if (owner != null) {
                            isPolymorphicSource = owner.getObjectType() == CdmObjectType.EntityAttributeDef && ((CdmEntityAttributeDefinition)owner).getIsPolymorphicSource() != null && ((CdmEntityAttributeDefinition)owner).getIsPolymorphicSource() != false;
                        } else {
                            Logger.error(this.ctx, TAG, "findOutgoingRelationships", null, CdmLogCode.ErrObjectWithoutOwnerFound, new String[0]);
                        }
                        if (newGenSet != null && fromAtts == null) {
                            fromAtts = this.getFromAttributes(newGenSet, fromAtts);
                        }
                        List<Pair<CdmTraitReference, String>> traitRefsAndCorpusPaths = null;
                        CdmObjectBase ownerDefinition = (CdmObjectBase)owner.fetchObjectDefinition(resOpt);
                        CdmAttribute entityAtt = null;
                        if (ownerDefinition.getObjectType() == CdmObjectType.EntityAttributeDef) {
                            entityAtt = (CdmEntityAttributeDefinition)owner.fetchObjectDefinition(resOpt);
                        }
                        if (entityAtt != null && entityAtt.getPurpose() != null && (resolvedTraitSet = entityAtt.getPurpose().fetchResolvedTraits(resOpt)) != null) {
                            traitRefsAndCorpusPaths = this.findElevatedTraitRefsAndCorpusPaths(resOpt, resolvedTraitSet);
                        }
                        outRels = this.findOutgoingRelationshipsForProjection(outRels, child, resOpt, resEntity, fromAtts, traitRefsAndCorpusPaths);
                        wasProjectionPolymorphic = isPolymorphicSource;
                    } else {
                        isEntityRef = true;
                        List<String> toAtt = child.getExhibitsTraits().getAllItems().parallelStream().filter(x -> "is.identifiedBy".equals(x.fetchObjectDefinitionName()) && ((CdmTraitReference)x).getArguments().getCount() > 0).map(y -> {
                            String namedRef = ((CdmAttributeReference)((CdmArgumentDefinition)((CdmTraitReference)y).getArguments().getAllItems().get(0)).getValue()).getNamedReference();
                            return namedRef.substring(namedRef.lastIndexOf("/") + 1);
                        }).collect(Collectors.toList());
                        outRels = this.findOutgoingRelationshipsForEntityRef((CdmObjectDefinition)toEntity, toAtt, (List<CdmE2ERelationship>)outRels, newGenSet, child, resOpt, resEntity, isResolvedEntity, wasProjectionPolymorphic, isEntityRef, entityAttAttContext);
                    }
                }
                boolean skipAdd = wasProjectionPolymorphic && isEntityRef;
                ArrayList<CdmE2ERelationship> subOutRels = this.findOutgoingRelationships(resOpt, resEntity, child, isResolvedEntity, newGenSet, wasProjectionPolymorphic, fromAtts, entityAttAttContext);
                outRels.addAll(subOutRels);
                if (!skipAdd) continue;
                wasProjectionPolymorphic = false;
            }
        }
        return outRels;
    }

    @Deprecated
    public List<CdmE2ERelationship> findOutgoingRelationshipsForProjection(List<CdmE2ERelationship> outRels, CdmAttributeContext child, ResolveOptions resOpt, CdmEntityDefinition resEntity) {
        return this.findOutgoingRelationshipsForProjection(outRels, child, resOpt, resEntity, null, null);
    }

    @Deprecated
    public ArrayList<CdmE2ERelationship> findOutgoingRelationshipsForProjection(List<CdmE2ERelationship> outRels, CdmAttributeContext child, ResolveOptions resOpt, CdmEntityDefinition resEntity, List<CdmAttributeReference> fromAtts, List<Pair<CdmTraitReference, String>> traitRefsAndCorpusPaths) {
        if (fromAtts != null) {
            ResolveOptions resOptCopy = resOpt.copy();
            resOptCopy.setWrtDoc(resEntity.getInDocument());
            CdmObjectReference refToLogicalEntity = resEntity.getAttributeContext().getDefinition();
            CdmEntityDefinition unResolvedEntity = refToLogicalEntity != null ? (CdmEntityDefinition)refToLogicalEntity.fetchObjectDefinition(resOptCopy) : null;
            String fromEntity = unResolvedEntity != null ? unResolvedEntity.getCtx().getCorpus().getStorage().createRelativeCorpusPath(unResolvedEntity.getAtCorpusPath(), unResolvedEntity.getInDocument()) : null;
            for (int i = 0; i < fromAtts.size(); ++i) {
                CdmTypeAttributeDefinition fromAttrDef = (CdmTypeAttributeDefinition)fromAtts.get(i).fetchObjectDefinition(resOptCopy);
                List<List<String>> tupleList = this.getToAttributes(fromAttrDef, resOptCopy);
                for (List<String> tuple : tupleList) {
                    CdmE2ERelationship newE2ERel = new CdmE2ERelationship(this.ctx, tuple.get(2));
                    newE2ERel.setFromEntity(this.getStorage().createAbsoluteCorpusPath(fromEntity, unResolvedEntity));
                    newE2ERel.setFromEntityAttribute(fromAtts.get(i).fetchObjectDefinitionName());
                    newE2ERel.setToEntity(this.getStorage().createAbsoluteCorpusPath(tuple.get(0), unResolvedEntity));
                    newE2ERel.setToEntityAttribute(tuple.get(1));
                    this.addTraitRefsAndCorpusPathsToRelationship(traitRefsAndCorpusPaths, newE2ERel);
                    outRels.add(newE2ERel);
                }
            }
        }
        return (ArrayList)outRels;
    }

    private void addTraitRefsAndCorpusPathsToRelationship(List<Pair<CdmTraitReference, String>> traitRefsAndCorpusPaths, CdmE2ERelationship cdmE2ERel) {
        if (traitRefsAndCorpusPaths != null) {
            for (Pair<CdmTraitReference, String> pair : traitRefsAndCorpusPaths) {
                cdmE2ERel.getExhibitsTraits().add((CdmTraitReferenceBase)pair.getLeft());
                cdmE2ERel.getElevatedTraitCorpusPath().put((CdmTraitReference)pair.getLeft(), (String)pair.getRight());
            }
        }
    }

    private List<Pair<CdmTraitReference, String>> fetchPurposeTraitRefsFromAttCtx(ResolveOptions resOpt, CdmAttributeContext attributeCtx) {
        ResolvedTraitSet resolvedTraitSet;
        CdmEntityAttributeDefinition ettAttDef;
        Object def;
        if (attributeCtx.getDefinition() != null && (def = attributeCtx.getDefinition().fetchObjectDefinition(resOpt)) != null && def.getObjectType() == CdmObjectType.EntityAttributeDef && (ettAttDef = (CdmEntityAttributeDefinition)def).getPurpose() != null && (resolvedTraitSet = ettAttDef.getPurpose().fetchResolvedTraits(resOpt)) != null) {
            return this.findElevatedTraitRefsAndCorpusPaths(resOpt, resolvedTraitSet);
        }
        return null;
    }

    private List<Pair<CdmTraitReference, String>> findElevatedTraitRefsAndCorpusPaths(ResolveOptions resOpt, ResolvedTraitSet resolvedTraitSet) {
        LinkedList<Pair<CdmTraitReference, String>> traitRefsAndCorpusPaths = new LinkedList<Pair<CdmTraitReference, String>>();
        for (ResolvedTrait resolvedTrait : resolvedTraitSet.getSet()) {
            CdmTraitReference traitRef = CdmObjectBase.resolvedTraitToTraitRef(resOpt, resolvedTrait);
            if (traitRef == null || resolvedTrait.getTrait().getInDocument() == null || StringUtils.isNullOrEmpty(resolvedTrait.getTrait().getInDocument().getAtCorpusPath())) continue;
            traitRefsAndCorpusPaths.add((Pair<CdmTraitReference, String>)new ImmutablePair((Object)traitRef, (Object)resolvedTrait.getTrait().getInDocument().getAtCorpusPath()));
        }
        return traitRefsAndCorpusPaths;
    }

    @Deprecated
    public List<CdmE2ERelationship> findOutgoingRelationshipsForEntityRef(CdmObjectDefinition toEntity, List<String> toAtt, List<CdmE2ERelationship> outRels, CdmAttributeContext newGenSet, CdmAttributeContext child, ResolveOptions resOpt, CdmEntityDefinition resEntity, boolean isResolvedEntity) {
        return this.findOutgoingRelationshipsForEntityRef(toEntity, toAtt, outRels, newGenSet, child, resOpt, resEntity, isResolvedEntity, false);
    }

    @Deprecated
    public List<CdmE2ERelationship> findOutgoingRelationshipsForEntityRef(CdmObjectDefinition toEntity, List<String> toAtt, List<CdmE2ERelationship> outRels, CdmAttributeContext newGenSet, CdmAttributeContext child, ResolveOptions resOpt, CdmEntityDefinition resEntity, boolean isResolvedEntity, boolean wasProjectionPolymorphic) {
        return this.findOutgoingRelationshipsForEntityRef(toEntity, toAtt, outRels, newGenSet, child, resOpt, resEntity, isResolvedEntity, wasProjectionPolymorphic, false, null);
    }

    @Deprecated
    public ArrayList<CdmE2ERelationship> findOutgoingRelationshipsForEntityRef(CdmObjectDefinition toEntity, List<String> toAtt, List<CdmE2ERelationship> outRels, CdmAttributeContext newGenSet, CdmAttributeContext child, ResolveOptions resOpt, CdmEntityDefinition resEntity, boolean isResolvedEntity, boolean wasProjectionPolymorphic, boolean wasEntityRef, CdmAttributeContext attributeCtx) {
        String foreignKey;
        if (toAtt.size() == 1 && toEntity != null && !(foreignKey = this.findAddedAttributeIdentity(newGenSet)).isEmpty()) {
            ArrayList<ImmutablePair> toAttList = new ArrayList<ImmutablePair>();
            ResolveOptions resolvedResOpt = new ResolveOptions(resEntity.getInDocument());
            CdmTypeAttributeDefinition attFromFk = (CdmTypeAttributeDefinition)this.resolveSymbolReference(resolvedResOpt, resEntity.getInDocument(), foreignKey, CdmObjectType.TypeAttributeDef, false);
            if (attFromFk != null) {
                List<List<String>> fkArgValues = this.getToAttributes(attFromFk, resolvedResOpt);
                for (List<String> list : fkArgValues) {
                    String absolutePath = this.getStorage().createAbsoluteCorpusPath(list.get(0), attFromFk);
                    toAttList.add(new ImmutablePair((Object)absolutePath, (Object)list.get(1)));
                }
            }
            List<Pair<CdmTraitReference, String>> traitRefsAndCorpusPaths = this.fetchPurposeTraitRefsFromAttCtx(resOpt, attributeCtx);
            for (Pair pair : toAttList) {
                String fromAtt = foreignKey.substring(foreignKey.lastIndexOf("/") + 1).replace(child.getName() + "_", "");
                CdmE2ERelationship newE2ERel = new CdmE2ERelationship(this.ctx, "");
                newE2ERel.setFromEntityAttribute(fromAtt);
                newE2ERel.setToEntityAttribute((String)pair.getValue());
                this.addTraitRefsAndCorpusPathsToRelationship(traitRefsAndCorpusPaths, newE2ERel);
                if (isResolvedEntity) {
                    newE2ERel.setFromEntity(resEntity.getAtCorpusPath());
                    if (this.resEntMap.containsKey(pair.getKey())) {
                        newE2ERel.setToEntity(this.resEntMap.get(pair.getKey()));
                    } else {
                        newE2ERel.setToEntity((String)pair.getKey());
                    }
                } else {
                    CdmObjectReference refToLogicalEntity = resEntity.getAttributeContext().getDefinition();
                    CdmEntityDefinition unResolvedEntity = null;
                    if (refToLogicalEntity != null) {
                        unResolvedEntity = (CdmEntityDefinition)refToLogicalEntity.fetchObjectDefinition(resOpt);
                    }
                    CdmEntityDefinition selectedEntity = unResolvedEntity != null ? unResolvedEntity : resEntity;
                    String selectedEntCorpusPath = unResolvedEntity != null ? unResolvedEntity.getAtCorpusPath() : resEntity.getAtCorpusPath().replace("wrtSelf_", "");
                    newE2ERel.setFromEntity(this.getStorage().createAbsoluteCorpusPath(selectedEntCorpusPath, selectedEntity));
                    newE2ERel.setToEntity((String)pair.getKey());
                }
                if (wasProjectionPolymorphic && wasEntityRef) continue;
                outRels.add(newE2ERel);
            }
        }
        return (ArrayList)outRels;
    }

    private String findAddedAttributeIdentity(CdmAttributeContext context) {
        if (context != null && context.getContents() != null) {
            for (CdmObject sub : context.getContents()) {
                CdmAttributeContext subCtx;
                if (!(sub instanceof CdmAttributeContext) || (subCtx = (CdmAttributeContext)sub).getType() == CdmAttributeContextType.Entity) continue;
                String fk = this.findAddedAttributeIdentity(subCtx);
                if (!fk.isEmpty()) {
                    return fk;
                }
                if (subCtx.getType() != CdmAttributeContextType.AddedAttributeIdentity || subCtx.getContents().size() <= 0) continue;
                return ((CdmObjectReference)subCtx.getContents().get(0)).getNamedReference();
            }
        }
        return "";
    }

    @Deprecated
    public CompletableFuture<CdmValidationStep> resolveReferencesAndValidateAsync(CdmValidationStep stage, CdmValidationStep stageThrough) {
        return this.resolveReferencesAndValidateAsync(stage, stageThrough, null);
    }

    private CompletableFuture<CdmValidationStep> resolveReferencesAndValidateAsync(CdmValidationStep stage, CdmValidationStep stageThrough, ResolveOptions resOpt) {
        return CompletableFuture.supplyAsync(() -> {
            AttributeResolutionDirectiveSet directives = null != resOpt ? resOpt.getDirectives() : this.defaultResolutionDirectives;
            ResolveOptions finalResolveOptions = new ResolveOptions();
            finalResolveOptions.setWrtDoc(null);
            finalResolveOptions.setDirectives(directives);
            finalResolveOptions.depthInfo.reset();
            for (CdmDocumentDefinition doc : this.documentLibrary.listAllDocuments()) {
                doc.indexIfNeededAsync(resOpt, false).join();
            }
            boolean finishResolve = stageThrough == stage;
            switch (stage) {
                case Start: 
                case TraitAppliers: {
                    return this.resolveReferencesStep("Defining traits...", (currentDoc, resOptions, entityNesting) -> {}, finalResolveOptions, true, finishResolve || stageThrough == CdmValidationStep.MinimumForResolving, CdmValidationStep.Traits);
                }
                case Traits: {
                    this.resolveReferencesStep("Resolving traits...", this::resolveTraits, finalResolveOptions, false, finishResolve, CdmValidationStep.Traits);
                    return this.resolveReferencesStep("Checking required arguments...", this::resolveReferencesTraitsArguments, finalResolveOptions, true, finishResolve, CdmValidationStep.Attributes);
                }
                case Attributes: {
                    return this.resolveReferencesStep("Resolving attributes...", this::resolveAttributes, finalResolveOptions, true, finishResolve, CdmValidationStep.EntityReferences);
                }
                case EntityReferences: {
                    return this.resolveReferencesStep("Resolving foreign key references...", this::resolveForeignKeyReferences, finalResolveOptions, true, true, CdmValidationStep.Finished);
                }
            }
            return CdmValidationStep.Error;
        });
    }

    private CdmValidationStep resolveReferencesStep(String statusMessage, ResolveAction resolveAction, ResolveOptions resolveOpt, boolean stageFinished, boolean finishResolve, CdmValidationStep nextStage) {
        ResolveContext ctx = (ResolveContext)this.ctx;
        Logger.debug(ctx, TAG, "resolveReferencesStep", null, statusMessage);
        MutableInt entityNesting = new MutableInt(0);
        Iterator<CdmDocumentDefinition> iterator = this.documentLibrary.listAllDocuments().iterator();
        while (iterator.hasNext()) {
            CdmDocumentDefinition doc;
            CdmDocumentDefinition currentDoc = doc = iterator.next();
            resolveOpt.setWrtDoc(currentDoc);
            resolveAction.invoke(currentDoc, resolveOpt, entityNesting);
        }
        if (stageFinished) {
            if (finishResolve) {
                this.finishResolve();
                return CdmValidationStep.Finished;
            }
            return nextStage;
        }
        return nextStage;
    }

    private void resolveTraits(CdmDocumentDefinition currentDoc, ResolveOptions resOpt, MutableInt entityNesting) {
        MutableInt nesting = entityNesting;
        currentDoc.visit("", (iObject, path) -> {
            switch (iObject.getObjectType()) {
                case AttributeGroupDef: 
                case EntityDef: 
                case DataTypeDef: 
                case PurposeDef: 
                case TraitDef: 
                case TraitGroupDef: {
                    if (iObject.getObjectType() == CdmObjectType.EntityDef || iObject.getObjectType() == CdmObjectType.AttributeGroupDef) {
                        nesting.increment();
                        if (nesting.getValue() > 1) break;
                    }
                    ((ResolveContext)this.ctx).setRelativePath(path);
                    iObject.fetchResolvedTraits(resOpt);
                    break;
                }
                case EntityAttributeDef: 
                case TypeAttributeDef: {
                    ((ResolveContext)this.ctx).setRelativePath(path);
                    iObject.fetchResolvedTraits(resOpt);
                }
            }
            return false;
        }, (iObject, path) -> {
            if (iObject.getObjectType() == CdmObjectType.EntityDef || iObject.getObjectType() == CdmObjectType.AttributeGroupDef) {
                nesting.decrement();
            }
            return false;
        });
        entityNesting.setValue((Number)nesting.getValue());
    }

    private void resolveForeignKeyReferences(CdmDocumentDefinition currentDoc, ResolveOptions resOpt, MutableInt entityNesting) {
        MutableInt nesting = entityNesting;
        currentDoc.visit("", (iObject, path) -> {
            CdmObjectType ot = iObject.getObjectType();
            if (ot == CdmObjectType.AttributeGroupDef) {
                nesting.increment();
            }
            if (ot == CdmObjectType.EntityDef) {
                nesting.increment();
                if (nesting.getValue() == 1) {
                    ((ResolveContext)this.ctx).setRelativePath(path);
                    ((CdmEntityDefinition)iObject).fetchResolvedEntityReferences(resOpt);
                }
            }
            return false;
        }, (iObject, path) -> {
            if (iObject.getObjectType() == CdmObjectType.EntityDef || iObject.getObjectType() == CdmObjectType.AttributeGroupDef) {
                nesting.decrement();
            }
            return false;
        });
        entityNesting.setValue((Number)nesting);
    }

    private void resolveAttributes(CdmDocumentDefinition currentDoc, ResolveOptions resOpt, MutableInt entityNesting) {
        ResolveContext ctx = (ResolveContext)this.ctx;
        MutableInt nesting = entityNesting;
        currentDoc.visit("", (iObject, path) -> {
            CdmObjectType ot = iObject.getObjectType();
            if (ot == CdmObjectType.EntityDef) {
                nesting.increment();
                if (nesting.getValue() == 1) {
                    ctx.setRelativePath(path);
                    iObject.fetchResolvedAttributes(resOpt);
                }
            }
            if (ot == CdmObjectType.AttributeGroupDef) {
                nesting.increment();
                if (nesting.getValue() == 1) {
                    ctx.setRelativePath(path);
                    iObject.fetchResolvedAttributes(resOpt);
                }
            }
            return false;
        }, (iObject, path) -> {
            if (iObject.getObjectType() == CdmObjectType.EntityDef || iObject.getObjectType() == CdmObjectType.AttributeGroupDef) {
                nesting.decrement();
            }
            return false;
        });
        entityNesting.setValue((Number)nesting);
    }

    private void resolveReferencesTraitsArguments(CdmDocumentDefinition currentDoc, ResolveOptions resOpt, MutableInt entityNesting) {
        ResolveContext ctx = (ResolveContext)this.ctx;
        Consumer<CdmObject> checkRequiredParamsOnResolvedTraits = obj -> {
            ResolvedTraitSet rts = obj.fetchResolvedTraits(resOpt);
            if (rts != null) {
                for (int i = 0; i < rts.getSize(); ++i) {
                    ResolvedTrait rt = rts.getSet().get(i);
                    int found = 0;
                    int resolved = 0;
                    if (rt != null && rt.getParameterValues() != null) {
                        for (int iParam = 0; iParam < rt.getParameterValues().length(); ++iParam) {
                            if (!rt.getParameterValues().fetchParameter(iParam).isRequired().booleanValue()) continue;
                            ++found;
                            if (rt.getParameterValues().fetchValue(iParam) == null) {
                                String message = Logger.format("no argument supplied for required parameter '{0}' of trait '{1}' on '{2}'", rt.getParameterValues().fetchParameter(iParam).getName(), rt.getTraitName(), obj.fetchObjectDefinition(resOpt).getName());
                                Logger.error(ctx, TAG, "resolveReferencesTraitsArguments", currentDoc.getAtCorpusPath(), CdmLogCode.ErrTraitArgumentMissing, rt.getParameterValues().fetchParameter(iParam).getName(), rt.getTraitName(), obj.fetchObjectDefinition(resOpt).getName());
                                continue;
                            }
                            ++resolved;
                        }
                    }
                    if (found <= 0 || found != resolved) continue;
                    String message = Logger.format("found and resolved '{0}' required parameters of trait '{1}' on '{2}'", found, rt.getTraitName(), obj.fetchObjectDefinition(resOpt).getName());
                    Logger.info(ctx, TAG, "resolveReferencesTraitsArguments", currentDoc.getAtCorpusPath(), message);
                }
            }
        };
        currentDoc.visit("", null, (iObject, path) -> {
            CdmObjectType ot = iObject.getObjectType();
            if (ot == CdmObjectType.EntityDef) {
                ctx.setRelativePath(path);
                checkRequiredParamsOnResolvedTraits.accept(iObject);
                CdmCollection<CdmAttributeItem> hasAttributeDefs = ((CdmEntityDefinition)iObject).getAttributes();
                if (hasAttributeDefs != null) {
                    for (CdmAttributeItem attDef : hasAttributeDefs) {
                        checkRequiredParamsOnResolvedTraits.accept(attDef);
                    }
                }
            }
            if (ot == CdmObjectType.AttributeGroupDef) {
                ctx.setRelativePath(path);
                checkRequiredParamsOnResolvedTraits.accept(iObject);
                CdmCollection<CdmAttributeItem> memberAttributeDefs = ((CdmAttributeGroupDefinition)iObject).getMembers();
                if (memberAttributeDefs != null) {
                    for (CdmAttributeItem attDef : memberAttributeDefs) {
                        checkRequiredParamsOnResolvedTraits.accept(attDef);
                    }
                }
            }
            return false;
        });
    }

    private void finishResolve() {
        ResolveContext ctx = (ResolveContext)this.ctx;
        Logger.debug(ctx, TAG, "finishResolve", null, "Finishing...");
        List<CdmDocumentDefinition> allDocuments = this.documentLibrary.listAllDocuments();
        for (CdmDocumentDefinition doc : allDocuments) {
            doc.finishIndexing(false);
        }
    }

    public StorageManager getStorage() {
        return this.storage;
    }

    public PersistenceLayer getPersistence() {
        return this.persistence;
    }

    public CdmCorpusContext getCtx() {
        return this.ctx;
    }

    public void setCtx(CdmCorpusContext ctx) {
        this.ctx = ctx;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public TelemetryClient getTelemetryClient() {
        return this.telemetryClient;
    }

    public void setTelemetryClient(TelemetryClient telemetryClient) {
        this.telemetryClient = telemetryClient;
    }

    @Deprecated
    public DocumentLibrary getDocumentLibrary() {
        return this.documentLibrary;
    }

    Map<String, SymbolSet> getDefinitionReferenceSymbols() {
        return this.definitionReferenceSymbols;
    }

    CompletableFuture<OffsetDateTime> getLastModifiedTimeFromObjectAsync(CdmObject currObject) {
        if (currObject instanceof CdmContainerDefinition) {
            StorageAdapterBase adapter = this.storage.fetchAdapter(((CdmContainerDefinition)currObject).getNamespace());
            if (adapter == null) {
                Logger.error(this.ctx, TAG, "getLastModifiedTimeAsyncFromObjectAsync", currObject.getAtCorpusPath(), CdmLogCode.ErrAdapterNotFound, ((CdmContainerDefinition)currObject).getNamespace());
                return CompletableFuture.completedFuture(null);
            }
            ImmutablePair<String, String> pathTuple = StorageUtils.splitNamespacePath(currObject.getAtCorpusPath());
            if (pathTuple == null) {
                Logger.error(this.ctx, TAG, "getLastModifiedTimeAsyncFromObjectAsync", currObject.getAtCorpusPath(), CdmLogCode.ErrStorageNullCorpusPath, new String[0]);
                return CompletableFuture.completedFuture(null);
            }
            try {
                return adapter.computeLastModifiedTimeAsync((String)pathTuple.getRight());
            }
            catch (Exception e) {
                Logger.error(this.ctx, TAG, "getLastModifiedTimeAsyncFromObjectAsync", currObject.getAtCorpusPath(), CdmLogCode.ErrPartitionFileModTimeFailure, (String)pathTuple.getRight(), e.getMessage());
                return null;
            }
        }
        return this.getLastModifiedTimeFromObjectAsync(currObject.getInDocument());
    }

    Map<String, ResolvedTraitSet> getEmptyRts() {
        return this.emptyRts;
    }

    void setEmptyRts(Map<String, ResolvedTraitSet> emptyRts) {
        this.emptyRts = emptyRts;
    }

    CompletableFuture<OffsetDateTime> getLastModifiedTimeFromPartitionPathAsync(String corpusPath) {
        ImmutablePair<String, String> pathTuple = StorageUtils.splitNamespacePath(corpusPath);
        if (pathTuple == null) {
            Logger.error(this.ctx, TAG, "getLastModifiedTimeFromPartitionPathAsync", corpusPath, CdmLogCode.ErrPathNullObjectPath, new String[0]);
            return CompletableFuture.completedFuture(null);
        }
        String nameSpace = (String)pathTuple.getLeft();
        if (!StringUtils.isNullOrTrimEmpty(nameSpace)) {
            StorageAdapterBase adapter = this.storage.fetchAdapter(nameSpace);
            if (adapter == null) {
                Logger.error(this.ctx, TAG, "getLastModifiedTimeFromPartitionPathAsync", corpusPath, CdmLogCode.ErrStorageAdapterNotFound, nameSpace);
                return CompletableFuture.completedFuture(null);
            }
            try {
                return adapter.computeLastModifiedTimeAsync((String)pathTuple.getRight());
            }
            catch (Exception e) {
                Logger.error(this.ctx, TAG, "getLastModifiedTimeFromPartitionPathAsync", corpusPath, CdmLogCode.ErrPartitionFileModTimeFailure, (String)pathTuple.getRight(), e.getMessage());
            }
        }
        return CompletableFuture.completedFuture(null);
    }

    CompletableFuture<OffsetDateTime> computeLastModifiedTimeAsync(String corpusPath) {
        return this.computeLastModifiedTimeAsync(corpusPath, null);
    }

    CompletableFuture<OffsetDateTime> computeLastModifiedTimeAsync(String corpusPath, CdmObject obj) {
        return this.fetchObjectAsync(corpusPath, obj, true).thenCompose(currObject -> {
            if (currObject != null) {
                return this.getLastModifiedTimeFromObjectAsync((CdmObject)currObject);
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    private List<CdmAttributeReference> getFromAttributes(CdmAttributeContext newGenSet, List<CdmAttributeReference> fromAttrs) {
        if (newGenSet != null && newGenSet.getContents() != null) {
            if (fromAttrs == null) {
                fromAttrs = new ArrayList<CdmAttributeReference>();
            }
            for (CdmObject sub : newGenSet.getContents()) {
                if (sub.getObjectType() == CdmObjectType.AttributeContextDef) {
                    CdmAttributeContext subCtx = (CdmAttributeContext)sub;
                    fromAttrs = this.getFromAttributes(subCtx, fromAttrs);
                    continue;
                }
                if (sub.getObjectType() != CdmObjectType.AttributeRef) continue;
                fromAttrs.add((CdmAttributeReference)sub);
            }
        }
        return fromAttrs;
    }

    private List<List<String>> getToAttributes(CdmTypeAttributeDefinition fromAttrDef, ResolveOptions resOpt) {
        if (fromAttrDef != null && fromAttrDef.getAppliedTraits() != null) {
            ArrayList<List<String>> tupleList = new ArrayList<List<String>>();
            for (CdmTraitReferenceBase trait : fromAttrDef.getAppliedTraits()) {
                CdmConstantEntityDefinition constEnt;
                if (!trait.getNamedReference().equals("is.linkedEntity.identifier") || ((CdmTraitReference)trait).getArguments().size() <= 0 || (constEnt = (CdmConstantEntityDefinition)((CdmEntityReference)((CdmArgumentDefinition)((CdmTraitReference)trait).getArguments().get(0)).getValue()).fetchObjectDefinition(resOpt)) == null || constEnt.getConstantValues().size() <= 0) continue;
                for (List<String> constantValues : constEnt.getConstantValues()) {
                    tupleList.add(constantValues);
                }
            }
            return tupleList;
        }
        return null;
    }

    @Deprecated
    public CompletableFuture<Boolean> prepareArtifactAttributesAsync() {
        return CompletableFuture.supplyAsync(() -> {
            if (this.knownArtifactAttributes == null) {
                this.knownArtifactAttributes = new LinkedHashMap<String, CdmTypeAttributeDefinition>();
                EventCallback oldStatus = this.getCtx().getStatusEvent();
                CdmStatusLevel oldLevel = this.getCtx().getReportAtLevel();
                this.setEventCallback((level, message) -> {}, CdmStatusLevel.Error);
                CdmEntityDefinition entArt = null;
                try {
                    entArt = (CdmEntityDefinition)this.fetchObjectAsync("cdm:/primitives.cdm.json/defaultArtifacts").join();
                }
                finally {
                    this.setEventCallback(oldStatus, oldLevel);
                }
                if (entArt == null) {
                    CdmTypeAttributeDefinition artAtt = (CdmTypeAttributeDefinition)this.makeObject(CdmObjectType.TypeAttributeDef, "count");
                    artAtt.setDataType((CdmDataTypeReference)this.makeObject(CdmObjectType.DataTypeRef, "integer", true));
                    this.knownArtifactAttributes.put("count", artAtt);
                    artAtt = (CdmTypeAttributeDefinition)this.makeObject(CdmObjectType.TypeAttributeDef, "id");
                    artAtt.setDataType((CdmDataTypeReference)this.makeObject(CdmObjectType.DataTypeRef, "entityId", true));
                    this.knownArtifactAttributes.put("id", artAtt);
                    artAtt = (CdmTypeAttributeDefinition)this.makeObject(CdmObjectType.TypeAttributeDef, "type");
                    artAtt.setDataType((CdmDataTypeReference)this.makeObject(CdmObjectType.DataTypeRef, "entityName", true));
                    this.knownArtifactAttributes.put("type", artAtt);
                } else {
                    entArt.getAttributes().forEach(att -> this.knownArtifactAttributes.put(((CdmAttribute)att).getName(), (CdmTypeAttributeDefinition)att));
                }
            }
            return true;
        });
    }

    @Deprecated
    public CdmTypeAttributeDefinition fetchArtifactAttribute(String name) {
        if (this.knownArtifactAttributes == null) {
            return null;
        }
        return (CdmTypeAttributeDefinition)this.knownArtifactAttributes.get(name).copy();
    }

    private class removeObjectCallBack
    implements VisitCallback {
        private final CdmCorpusDefinition thiz;
        private final ResolveContext ctx;
        private final CdmDocumentDefinition doc;

        public removeObjectCallBack(CdmCorpusDefinition thiz, ResolveContext ctx, CdmDocumentDefinition doc) {
            this.thiz = thiz;
            this.ctx = ctx;
            this.doc = doc;
        }

        @Override
        public boolean invoke(CdmObject iObject, String path) {
            if (path.contains("(unspecified)")) {
                return true;
            }
            switch (iObject.getObjectType()) {
                case ParameterDef: 
                case AttributeGroupDef: 
                case ConstantEntityDef: 
                case EntityDef: 
                case DataTypeDef: 
                case PurposeDef: 
                case TraitDef: 
                case TraitGroupDef: 
                case EntityAttributeDef: 
                case TypeAttributeDef: 
                case AttributeContextDef: 
                case LocalEntityDeclarationDef: 
                case ReferencedEntityDeclarationDef: 
                case ProjectionDef: 
                case OperationAddCountAttributeDef: 
                case OperationAddSupportingAttributeDef: 
                case OperationAddTypeAttributeDef: 
                case OperationExcludeAttributesDef: 
                case OperationArrayExpansionDef: 
                case OperationCombineAttributesDef: 
                case OperationRenameAttributesDef: 
                case OperationReplaceAsForeignKeyDef: 
                case OperationIncludeAttributesDef: 
                case OperationAddAttributeGroupDef: 
                case OperationAlterTraitsDef: 
                case OperationAddArtifactAttributeDef: {
                    this.thiz.unRegisterSymbol(path, this.doc);
                    this.thiz.unRegisterDefinitionReferenceSymbols(iObject, "rasb");
                }
            }
            return false;
        }
    }

    @FunctionalInterface
    private static interface ResolveAction {
        public void invoke(CdmDocumentDefinition var1, ResolveOptions var2, MutableInt var3);
    }
}

