/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder;

import com.fasterxml.jackson.databind.JsonNode;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityAttributeDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitGroupReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReference;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmPropertyName;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.AttributeResolutionGuidancePersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.EntityReferencePersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.PurposeReferencePersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.Utils;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.projections.ProjectionPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.EntityAttribute;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.JMapper;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.stream.Collectors;

public class EntityAttributePersistence {
    private static final String TAG = EntityAttributePersistence.class.getSimpleName();

    public static CdmEntityAttributeDefinition fromData(CdmCorpusContext ctx, JsonNode obj) {
        boolean isProjection;
        CdmEntityAttributeDefinition entityAttribute = (CdmEntityAttributeDefinition)ctx.getCorpus().makeObject(CdmObjectType.EntityAttributeDef, obj.get("name").asText());
        entityAttribute.setExplanation(Utils.propertyFromDataToString(obj.get("explanation")));
        entityAttribute.updateDescription(Utils.propertyFromDataToString(obj.get("description")));
        entityAttribute.updateDisplayName(Utils.propertyFromDataToString(obj.get("displayName")));
        entityAttribute.setCardinality(Utils.cardinalitySettingsFromData(obj.get("cardinality"), entityAttribute));
        if (obj.has("isPolymorphicSource")) {
            entityAttribute.setIsPolymorphicSource(obj.get("isPolymorphicSource").asBoolean());
        }
        boolean bl = isProjection = obj.get("entity") != null && !obj.get("entity").isValueNode() && obj.get("entity").get("source") != null;
        if (isProjection) {
            CdmEntityReference inlineEntityRef = (CdmEntityReference)ctx.getCorpus().makeObject(CdmObjectType.EntityRef, null);
            inlineEntityRef.setExplicitReference(ProjectionPersistence.fromData(ctx, obj.get("entity")));
            entityAttribute.setEntity(inlineEntityRef);
        } else {
            entityAttribute.setEntity(EntityReferencePersistence.fromData(ctx, obj.get("entity")));
        }
        entityAttribute.setPurpose(PurposeReferencePersistence.fromData(ctx, obj.get("purpose")));
        Utils.addListToCdmCollection(entityAttribute.getAppliedTraits(), Utils.createTraitReferenceList(ctx, obj.get("appliedTraits")));
        if (obj.get("resolutionGuidance") != null && isProjection) {
            Logger.error(ctx, TAG, "fromData", null, CdmLogCode.ErrPersistEntityAttrUnsupported, entityAttribute.getName());
        } else {
            entityAttribute.setResolutionGuidance(AttributeResolutionGuidancePersistence.fromData(ctx, obj.get("resolutionGuidance")));
        }
        return entityAttribute;
    }

    public static EntityAttribute toData(CdmEntityAttributeDefinition instance, ResolveOptions resOpt, CopyOptions options) {
        EntityAttribute result = new EntityAttribute();
        result.setExplanation(instance.getExplanation());
        result.setDescription((String)instance.fetchProperty(CdmPropertyName.DESCRIPTION));
        result.setDisplayName((String)instance.fetchProperty(CdmPropertyName.DISPLAY_NAME));
        result.setName(instance.getName());
        result.setIsPolymorphicSource(instance.getIsPolymorphicSource());
        result.setEntity(Utils.jsonForm(instance.getEntity(), resOpt, options));
        result.setPurpose(Utils.jsonForm(instance.getPurpose(), resOpt, options));
        result.setAppliedTraits(Utils.listCopyDataAsArrayNode(instance.getAppliedTraits().getAllItems().stream().filter(trait -> trait instanceof CdmTraitGroupReference || !((CdmTraitReference)trait).isFromProperty()).collect(Collectors.toList()), resOpt, options));
        result.setResolutionGuidance(Utils.jsonForm(instance.getResolutionGuidance(), resOpt, options));
        result.setCardinalitySettings(instance.getCardinality() != null ? JMapper.MAP.valueToTree((Object)instance.getCardinality()) : null);
        return result;
    }
}

