/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitDefinition;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.ParameterPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.TraitReferencePersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.Utils;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.Trait;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.JMapper;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import java.util.List;

public class TraitPersistence {
    public static CdmTraitDefinition fromData(CdmCorpusContext ctx, JsonNode obj) {
        CdmTraitDefinition trait = (CdmTraitDefinition)ctx.getCorpus().makeObject(CdmObjectType.TraitDef, obj.get("traitName").asText());
        trait.setExtendsTrait(TraitReferencePersistence.fromData(ctx, obj.get("extendsTrait")));
        if (obj.get("explanation") != null) {
            trait.setExplanation(obj.get("explanation").asText());
        }
        if (obj.get("hasParameters") != null) {
            obj.get("hasParameters").forEach(ap -> trait.getParameters().add(ParameterPersistence.fromData(ctx, ap)));
        }
        if (obj.get("elevated") != null) {
            trait.setElevated(obj.get("elevated").asBoolean());
        }
        if (obj.get("ugly") != null) {
            trait.setUgly(obj.get("ugly").asBoolean());
        }
        if (obj.get("associatedProperties") != null) {
            trait.setAssociatedProperties((List)JMapper.MAP.convertValue((Object)obj.get("associatedProperties"), (TypeReference)new TypeReference<List<String>>(){}));
        }
        return trait;
    }

    public static Trait toData(CdmTraitDefinition instance, ResolveOptions resOpt, CopyOptions options) {
        Trait trait = new Trait();
        trait.setExplanation(instance.getExplanation());
        trait.setTraitName(instance.getTraitName());
        trait.setExtendsTrait(Utils.jsonForm(instance.getExtendsTrait(), resOpt, options));
        trait.setParameters(Utils.listCopyDataAsArrayNode(instance.getParameters(), resOpt, options));
        trait.setElevated(instance.getElevated() != null && instance.getElevated() != false ? Boolean.valueOf(true) : null);
        trait.setUgly(instance.getUgly() != null && instance.getUgly() != false ? Boolean.valueOf(true) : null);
        trait.setAssociatedProperties(instance.getAssociatedProperties());
        return trait;
    }
}

