/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDataPartitionDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDataPartitionPatternDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDocumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmE2ERelationship;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityDeclarationDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmFileStatus;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmFolderDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmImport;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmLocalEntityDeclarationDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmManifestDeclarationDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmReferencedEntityDeclarationDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReferenceBase;
import com.microsoft.commondatamodel.objectmodel.enums.CdmIncrementalPartitionType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmRelationshipDiscoveryStyle;
import com.microsoft.commondatamodel.objectmodel.enums.ImportsLoadStrategy;
import com.microsoft.commondatamodel.objectmodel.enums.PartitionFileStatusCheckType;
import com.microsoft.commondatamodel.objectmodel.storage.StorageAdapterBase;
import com.microsoft.commondatamodel.objectmodel.utilities.AttributeResolutionDirectiveSet;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.TimeUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.ObjectUtils;

public class CdmManifestDefinition
extends CdmDocumentDefinition
implements CdmObjectDefinition,
CdmFileStatus {
    private static final String TAG = CdmManifestDefinition.class.getSimpleName();
    private String manifestName;
    private CdmCollection<CdmManifestDeclarationDefinition> subManifests;
    private CdmEntityCollection entities;
    private CdmCollection<CdmE2ERelationship> relationships;
    private String explanation;
    private CdmTraitCollection exhibitsTraits;
    private OffsetDateTime lastFileStatusCheckTime;
    private OffsetDateTime lastFileModifiedTime;
    private OffsetDateTime lastChildFileModifiedTime;

    public CdmManifestDefinition(CdmCorpusContext ctx, String name) {
        super(ctx, name + ".manifest.cdm.json");
        this.setObjectType(CdmObjectType.ManifestDef);
        this.manifestName = name;
        this.entities = new CdmEntityCollection(this.getCtx(), this);
        this.exhibitsTraits = new CdmTraitCollection(this.getCtx(), this);
    }

    public String getManifestName() {
        return this.manifestName;
    }

    public void setManifestName(String manifestName) {
        if (manifestName.endsWith(".folio.cdm.json")) {
            this.manifestName = manifestName.replace(".folio.cdm.json", ".manifest.cdm.json");
        }
        this.manifestName = manifestName;
    }

    @Override
    public OffsetDateTime getLastFileStatusCheckTime() {
        return this.lastFileStatusCheckTime;
    }

    @Override
    public void setLastFileStatusCheckTime(OffsetDateTime lastFileStatusCheckTime) {
        this.lastFileStatusCheckTime = lastFileStatusCheckTime;
    }

    @Override
    public OffsetDateTime getLastFileModifiedTime() {
        return this.lastFileModifiedTime;
    }

    @Override
    public void setLastFileModifiedTime(OffsetDateTime lastFileModifiedTime) {
        this.lastFileModifiedTime = lastFileModifiedTime;
    }

    @Override
    public OffsetDateTime getLastChildFileModifiedTime() {
        return this.lastChildFileModifiedTime;
    }

    @Override
    public void setLastChildFileModifiedTime(OffsetDateTime lastChildFileModifiedTime) {
        this.lastChildFileModifiedTime = lastChildFileModifiedTime;
    }

    @Override
    public String getExplanation() {
        return this.explanation;
    }

    @Override
    public void setExplanation(String explanation) {
        this.explanation = explanation;
    }

    public CdmEntityCollection getEntities() {
        return this.entities;
    }

    @Override
    public CdmObjectType getObjectType() {
        return CdmObjectType.ManifestDef;
    }

    public CdmCollection<CdmManifestDeclarationDefinition> getSubManifests() {
        if (this.subManifests == null) {
            this.subManifests = new CdmCollection(this.getCtx(), this, CdmObjectType.ManifestDeclarationDef);
        }
        return this.subManifests;
    }

    public CdmCollection<CdmE2ERelationship> getRelationships() {
        if (this.relationships == null) {
            this.relationships = new CdmCollection(this.getCtx(), this, CdmObjectType.E2ERelationshipDef);
        }
        return this.relationships;
    }

    @Override
    public CdmTraitCollection getExhibitsTraits() {
        return this.exhibitsTraits;
    }

    public void setExhibitsTraits(CdmTraitCollection exhibitsTraits) {
        this.exhibitsTraits = exhibitsTraits;
    }

    @Override
    @Deprecated
    public CompletableFuture<Boolean> saveLinkedDocumentsAsync(CopyOptions options) {
        return CompletableFuture.supplyAsync(() -> {
            HashSet<String> links = new HashSet<String>();
            if (this.getImports() != null) {
                for (CdmImport imp : this.getImports()) {
                    links.add(imp.getCorpusPath());
                }
            }
            if (this.getEntities() != null) {
                for (CdmEntityDeclarationDefinition def : this.getEntities()) {
                    if (def.getObjectType() != CdmObjectType.LocalEntityDeclarationDef) continue;
                    links.add(def.getEntityPath());
                    if (def.getDataPartitions() != null) {
                        for (CdmDataPartitionDefinition cdmDataPartitionDefinition : def.getDataPartitions()) {
                            if (cdmDataPartitionDefinition.getSpecializedSchema() == null) continue;
                            links.add(cdmDataPartitionDefinition.getSpecializedSchema());
                        }
                    }
                    if (def.getDataPartitionPatterns() == null) continue;
                    for (CdmDataPartitionPatternDefinition cdmDataPartitionPatternDefinition : def.getDataPartitionPatterns()) {
                        if (cdmDataPartitionPatternDefinition.getSpecializedSchema() == null) continue;
                        links.add(cdmDataPartitionPatternDefinition.getSpecializedSchema());
                    }
                }
            }
            for (String link : links) {
                CdmDocumentDefinition doc = this.fetchDocumentDefinition(link).join();
                if (doc == null) {
                    return false;
                }
                this.saveDocumentIfDirty(doc, options).join();
            }
            if (this.getSubManifests() != null) {
                for (CdmManifestDeclarationDefinition sub : this.getSubManifests()) {
                    CdmManifestDefinition subManifest = (CdmManifestDefinition)this.fetchDocumentDefinition(sub.getDefinition()).join();
                    if (subManifest != null && this.saveDocumentIfDirty(subManifest, options).join().booleanValue()) continue;
                    return false;
                }
            }
            return true;
        });
    }

    private CompletableFuture<Boolean> saveDirtyLinkAsync(String relative, CopyOptions options) {
        return CompletableFuture.supplyAsync(() -> {
            String docPath = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(relative, this);
            if (docPath == null) {
                Logger.error(this.getCtx(), TAG, "saveDirtyLinkAsync", this.getAtCorpusPath(), CdmLogCode.ErrValdnInvalidCorpusPath, relative);
                return false;
            }
            CdmObject objAt = (CdmObject)this.getCtx().getCorpus().fetchObjectAsync(docPath).join();
            if (objAt == null) {
                Logger.error(this.getCtx(), TAG, "saveDirtyLinkAsync", this.getAtCorpusPath(), CdmLogCode.ErrPersistObjectNotFound, docPath);
                return false;
            }
            CdmDocumentDefinition docImp = objAt.getInDocument();
            if (docImp != null && docImp.isDirty() && !docImp.saveAsAsync(docImp.getName(), true, options).join().booleanValue()) {
                Logger.error(this.getCtx(), TAG, "saveDirtyLinkAsync", this.getAtCorpusPath(), CdmLogCode.ErrDocEntityDocSavingFailure, docImp.getName());
                return false;
            }
            return true;
        });
    }

    private CompletableFuture<CdmDocumentDefinition> fetchDocumentDefinition(String relativePath) {
        return CompletableFuture.supplyAsync(() -> {
            String docPath = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(relativePath, this);
            if (docPath == null) {
                Logger.error(this.getCtx(), TAG, "fetchDocumentDefinition", this.getAtCorpusPath(), CdmLogCode.ErrValdnInvalidCorpusPath, relativePath);
                return null;
            }
            ResolveOptions resOpt = new ResolveOptions();
            resOpt.setImportsLoadStrategy(ImportsLoadStrategy.Load);
            CdmObject objAt = (CdmObject)this.getCtx().getCorpus().fetchObjectAsync(docPath, null, resOpt).join();
            if (objAt == null) {
                Logger.error(this.getCtx(), TAG, "fetchDocumentDefinition", this.getAtCorpusPath(), CdmLogCode.ErrPersistObjectNotFound, docPath);
                return null;
            }
            return objAt.getInDocument();
        });
    }

    private CompletableFuture<Boolean> saveDocumentIfDirty(CdmDocumentDefinition docImp, CopyOptions options) {
        return CompletableFuture.supplyAsync(() -> {
            if (docImp != null && docImp.isDirty() && !docImp.saveAsAsync(docImp.getName(), true, options).join().booleanValue()) {
                Logger.error(this.getCtx(), TAG, "saveDocumentIfDirty", this.getAtCorpusPath(), CdmLogCode.ErrDocEntityDocSavingFailure, docImp.getName());
                return false;
            }
            return true;
        });
    }

    public CompletableFuture<Void> populateManifestRelationshipsAsync() {
        return this.populateManifestRelationshipsAsync(CdmRelationshipDiscoveryStyle.All);
    }

    public CompletableFuture<Void> populateManifestRelationshipsAsync(CdmRelationshipDiscoveryStyle option) {
        return CompletableFuture.runAsync(() -> {
            try (Logger.LoggerScope logScope = Logger.enterScope(CdmManifestDefinition.class.getSimpleName(), this.getCtx(), "populateManifestRelationshipsAsync");){
                this.getRelationships().clear();
                ConcurrentHashMap.KeySetView relCache = ConcurrentHashMap.newKeySet();
                if (this.getEntities() != null) {
                    ResolveOptions outerResOpt = new ResolveOptions(this);
                    this.indexIfNeededAsync(outerResOpt, true).join();
                    for (CdmEntityDeclarationDefinition entDec : this.getEntities()) {
                        ArrayList<CdmE2ERelationship> incomingRels;
                        String entPath = this.createEntityPathFromDeclarationAsync(entDec, this).join();
                        CdmEntityDefinition currEntity = (CdmEntityDefinition)this.getCtx().getCorpus().fetchObjectAsync(entPath).join();
                        if (currEntity == null) continue;
                        ArrayList<CdmE2ERelationship> outgoingRels = this.getCtx().getCorpus().fetchOutgoingRelationships(currEntity);
                        if (outgoingRels != null) {
                            for (CdmE2ERelationship outgoingRel : outgoingRels) {
                                String cacheKey = outgoingRel.createCacheKey();
                                if (relCache.contains(cacheKey) || !this.isRelAllowed(outgoingRel, option)) continue;
                                this.addElevatedTraitsAndRelationships(outgoingRel).join();
                                relCache.add(cacheKey);
                            }
                        }
                        if ((incomingRels = this.getCtx().getCorpus().fetchIncomingRelationships(currEntity)) == null) continue;
                        for (CdmE2ERelationship inRel : incomingRels) {
                            CdmEntityDefinition currentInBase = (CdmEntityDefinition)this.getCtx().getCorpus().fetchObjectAsync(inRel.getToEntity(), this).join();
                            if (currentInBase == null) continue;
                            ArrayList<CdmEntityDefinition> toInheritanceGraph = new ArrayList<CdmEntityDefinition>();
                            while (currentInBase != null) {
                                ResolveOptions resOpt = new ResolveOptions();
                                resOpt.setWrtDoc(currentInBase.getInDocument());
                                if ((currentInBase = currentInBase.getExtendsEntity() != null ? (CdmEntityDefinition)currentInBase.getExtendsEntity().fetchObjectDefinition(resOpt) : null) == null) continue;
                                toInheritanceGraph.add(currentInBase);
                            }
                            String cacheKey = inRel.createCacheKey();
                            if (!relCache.contains(cacheKey) && this.isRelAllowed(inRel, option)) {
                                this.addElevatedTraitsAndRelationships(inRel).join();
                                relCache.add(cacheKey);
                            }
                            for (CdmEntityDefinition baseEntity : toInheritanceGraph) {
                                ArrayList<CdmE2ERelationship> incomingRelsForBase = this.getCtx().getCorpus().fetchIncomingRelationships(baseEntity);
                                if (incomingRelsForBase == null) continue;
                                for (CdmE2ERelationship inRelBase : incomingRelsForBase) {
                                    CdmE2ERelationship newRel = new CdmE2ERelationship(this.getCtx(), "");
                                    newRel.setFromEntity(inRelBase.getFromEntity());
                                    newRel.setFromEntityAttribute(inRelBase.getFromEntityAttribute());
                                    newRel.setToEntity(inRel.getToEntity());
                                    newRel.setToEntityAttribute(inRel.getToEntityAttribute());
                                    String baseRelCacheKey = newRel.createCacheKey();
                                    if (relCache.contains(baseRelCacheKey) || !this.isRelAllowed(newRel, option)) continue;
                                    this.addElevatedTraitsAndRelationships(newRel).join();
                                    relCache.add(baseRelCacheKey);
                                }
                            }
                        }
                    }
                    this.refreshAsync(outerResOpt).join();
                }
                if (this.getSubManifests() != null) {
                    for (CdmManifestDeclarationDefinition subManifestDef : this.getSubManifests()) {
                        String corpusPath = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(subManifestDef.getDefinition(), this);
                        CdmManifestDefinition subManifest = (CdmManifestDefinition)this.getCtx().getCorpus().fetchObjectAsync(corpusPath).join();
                        subManifest.populateManifestRelationshipsAsync(option).join();
                    }
                }
            }
        });
    }

    @Override
    public CompletableFuture<Void> fileStatusCheckAsync() {
        return this.fileStatusCheckAsync(PartitionFileStatusCheckType.Full);
    }

    public CompletableFuture<Void> fileStatusCheckAsync(PartitionFileStatusCheckType partitionFileStatusCheckType) {
        return this.fileStatusCheckAsync(partitionFileStatusCheckType, CdmIncrementalPartitionType.None);
    }

    public CompletableFuture<Void> fileStatusCheckAsync(PartitionFileStatusCheckType partitionFileStatusCheckType, CdmIncrementalPartitionType incrementalType) {
        return CompletableFuture.runAsync(() -> {
            try (Logger.LoggerScope logScope = Logger.enterScope(CdmManifestDefinition.class.getSimpleName(), this.getCtx(), "fileStatusCheckAsync");){
                StorageAdapterBase adapter = this.getCtx().getCorpus().getStorage().fetchAdapter(this.getInDocument().getNamespace());
                StorageAdapterBase.CacheContext cacheContext = null;
                if (adapter != null) {
                    cacheContext = adapter.createFileQueryCacheContext();
                }
                try {
                    OffsetDateTime modifiedTime = this.getCtx().getCorpus().getLastModifiedTimeFromObjectAsync(this).join();
                    this.setLastFileStatusCheckTime(OffsetDateTime.now(ZoneOffset.UTC));
                    if (this.getLastFileModifiedTime() == null) {
                        this.setLastFileModifiedTime(this.getFileSystemModifiedTime());
                    }
                    if (!Objects.equals(modifiedTime, this.getFileSystemModifiedTime())) {
                        this.reloadAsync().join();
                        this.setLastFileModifiedTime(TimeUtils.maxTime(modifiedTime, this.getLastFileModifiedTime()));
                        this.setFileSystemModifiedTime(this.getLastFileModifiedTime());
                    }
                    for (CdmEntityDeclarationDefinition entity : this.getEntities()) {
                        if (entity instanceof CdmReferencedEntityDeclarationDefinition) {
                            entity.fileStatusCheckAsync().join();
                            continue;
                        }
                        if (!(entity instanceof CdmLocalEntityDeclarationDefinition)) continue;
                        ((CdmLocalEntityDeclarationDefinition)entity).fileStatusCheckAsync(partitionFileStatusCheckType, incrementalType).join();
                    }
                    for (CdmManifestDeclarationDefinition subManifest : this.getSubManifests()) {
                        subManifest.fileStatusCheckAsync().join();
                    }
                }
                finally {
                    if (cacheContext != null) {
                        cacheContext.dispose();
                    }
                }
            }
        });
    }

    @Override
    public CompletableFuture<Void> reportMostRecentTimeAsync(OffsetDateTime childTime) {
        if (childTime != null) {
            this.setLastChildFileModifiedTime(TimeUtils.maxTime(childTime, this.getLastChildFileModifiedTime()));
        }
        return CompletableFuture.completedFuture(null);
    }

    private CompletableFuture<List<?>> queryOnTraitsAsync(Object querySpec) {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public boolean isDerivedFrom(String baseDef, ResolveOptions resOpt) {
        return false;
    }

    @Override
    public boolean visit(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        if (preChildren != null && preChildren.invoke(this, pathFrom)) {
            return false;
        }
        if (this.getImports() != null && this.getImports().visitList(pathFrom, preChildren, postChildren)) {
            return true;
        }
        if (this.getDefinitions() != null && this.getDefinitions().visitList(pathFrom, preChildren, postChildren)) {
            return true;
        }
        if (this.getEntities() != null && this.entities.visitList(pathFrom, preChildren, postChildren)) {
            return true;
        }
        if (this.getRelationships() != null && this.getRelationships().visitList(pathFrom + "/relationships/", preChildren, postChildren)) {
            return true;
        }
        if (this.getSubManifests() != null && this.getSubManifests().visitList(pathFrom + "/subManifests/", preChildren, postChildren)) {
            return true;
        }
        return postChildren != null && postChildren.invoke(this, pathFrom);
    }

    @Override
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        CdmManifestDefinition tempHost = (CdmManifestDefinition)host;
        if (tempHost == null) {
            tempHost = new CdmManifestDefinition(this.getCtx(), this.getManifestName());
        }
        CdmManifestDefinition copy = (CdmManifestDefinition)super.copy(resOpt, tempHost);
        copy.setManifestName(this.getManifestName());
        copy.setExplanation(this.getExplanation());
        copy.setLastFileStatusCheckTime(this.getLastFileStatusCheckTime());
        copy.setLastFileModifiedTime(this.getLastFileModifiedTime());
        copy.setLastChildFileModifiedTime(this.getLastChildFileModifiedTime());
        copy.getEntities().clear();
        this.getEntities().forEach(entityDec -> copy.getEntities().add((CdmEntityDeclarationDefinition)entityDec.copy(resOpt)));
        copy.getRelationships().clear();
        this.getRelationships().forEach(relationship -> copy.getRelationships().add((CdmE2ERelationship)relationship.copy(resOpt)));
        copy.getSubManifests().clear();
        this.getSubManifests().forEach(subManifest -> copy.getSubManifests().add((CdmManifestDeclarationDefinition)subManifest.copy(resOpt)));
        copy.getExhibitsTraits().clear();
        this.getExhibitsTraits().forEach(trait -> copy.getExhibitsTraits().add((CdmTraitReferenceBase)trait.copy(resOpt)));
        return copy;
    }

    public CompletableFuture<CdmManifestDefinition> createResolvedManifestAsync(String newManifestName, String newEntityDocumentNameFormat) {
        return this.createResolvedManifestAsync(newManifestName, newEntityDocumentNameFormat, null);
    }

    public CompletableFuture<CdmManifestDefinition> createResolvedManifestAsync(String newManifestName, String newEntityDocumentNameFormat, AttributeResolutionDirectiveSet directives) {
        return CompletableFuture.supplyAsync(() -> {
            try (Logger.LoggerScope logScope = Logger.enterScope(CdmManifestDefinition.class.getSimpleName(), this.getCtx(), "createResolvedManifestAsync");){
                Object object;
                CdmFolderDefinition resolvedManifestFolder;
                String resolvedManifestPath;
                String innerNewEntityDocumentNameFormat = newEntityDocumentNameFormat;
                String innerNewManifestName = newManifestName;
                if (null == this.getEntities()) {
                    CdmManifestDefinition cdmManifestDefinition = null;
                    return cdmManifestDefinition;
                }
                if (this.getOwner() == null) {
                    Logger.error(this.getCtx(), TAG, "createResolvedManifestAsync", this.getAtCorpusPath(), CdmLogCode.ErrResolveManifestFailed, this.manifestName);
                    CdmManifestDefinition cdmManifestDefinition = null;
                    return cdmManifestDefinition;
                }
                if (null == innerNewEntityDocumentNameFormat) {
                    innerNewEntityDocumentNameFormat = "{f}resolved/{n}.cdm.json";
                } else if (innerNewEntityDocumentNameFormat.isEmpty()) {
                    innerNewEntityDocumentNameFormat = "{n}.cdm.json";
                } else if (!innerNewEntityDocumentNameFormat.contains("{n}")) {
                    innerNewEntityDocumentNameFormat = innerNewEntityDocumentNameFormat + "/{n}.cdm.json";
                }
                String sourceManifestPath = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(this.getAtCorpusPath(), this);
                String sourceManifestFolderPath = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(this.getOwner().getAtCorpusPath(), this);
                int resolvedManifestPathSplit = innerNewManifestName.lastIndexOf("/") + 1;
                if (resolvedManifestPathSplit > 0) {
                    resolvedManifestPath = innerNewManifestName.substring(0, resolvedManifestPathSplit);
                    String newFolderPath = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(resolvedManifestPath, this);
                    resolvedManifestFolder = (CdmFolderDefinition)this.getCtx().getCorpus().fetchObjectAsync(newFolderPath).join();
                    if (resolvedManifestFolder == null) {
                        Logger.error(this.getCtx(), TAG, "createResolvedManifestAsync", this.getAtCorpusPath(), CdmLogCode.ErrResolveFolderNotFound, newFolderPath);
                        CdmManifestDefinition cdmManifestDefinition = null;
                        return cdmManifestDefinition;
                    }
                    innerNewManifestName = innerNewManifestName.substring(resolvedManifestPathSplit);
                } else {
                    resolvedManifestFolder = (CdmFolderDefinition)this.getOwner();
                }
                if (resolvedManifestFolder.getDocuments().item(newManifestName) != null) {
                    Logger.error(this.getCtx(), TAG, "createResolvedManifestAsync", this.getAtCorpusPath(), CdmLogCode.ErrResolveManifestExists, newManifestName, resolvedManifestFolder.getAtCorpusPath());
                    resolvedManifestPath = null;
                    return resolvedManifestPath;
                }
                Logger.debug(this.getCtx(), TAG, "createResolvedManifestAsync", this.getAtCorpusPath(), Logger.format("Resolving manifest '{0}'", sourceManifestPath));
                if (innerNewManifestName.toLowerCase().endsWith(".manifest.cdm.json")) {
                    innerNewManifestName = innerNewManifestName.substring(0, innerNewManifestName.length() - ".manifest.cdm.json".length());
                }
                CdmManifestDefinition resolvedManifest = new CdmManifestDefinition(this.getCtx(), innerNewManifestName);
                resolvedManifest.setSchema(this.getSchema());
                resolvedManifest.setExplanation(this.getExplanation());
                resolvedManifest.setDocumentVersion(this.getDocumentVersion());
                for (CdmImport imp : this.getImports()) {
                    resolvedManifest.getImports().add((CdmImport)imp.copy());
                }
                if (resolvedManifestFolder.getDocuments().add(resolvedManifest) == null) {
                    object = null;
                    return object;
                }
                for (CdmEntityDeclarationDefinition entity : this.getEntities()) {
                    CdmManifestDefinition cdmManifestDefinition;
                    String entityPath = this.createEntityPathFromDeclarationAsync(entity, this).join();
                    CdmEntityDefinition entDef = (CdmEntityDefinition)this.getCtx().getCorpus().fetchObjectAsync(entityPath).join();
                    if (null == entDef) {
                        Logger.error(this.getCtx(), TAG, "createResolvedManifestAsync", this.getAtCorpusPath(), CdmLogCode.ErrResolveEntityFailure, entityPath);
                        cdmManifestDefinition = null;
                        return cdmManifestDefinition;
                    }
                    if (entDef.getInDocument().getOwner() == null) {
                        Logger.error(this.getCtx(), TAG, "createResolvedManifestAsync", this.getAtCorpusPath(), CdmLogCode.ErrDocIsNotFolder, entDef.getEntityName());
                        cdmManifestDefinition = null;
                        return cdmManifestDefinition;
                    }
                    String sourceEntityFullPath = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(entDef.getInDocument().getOwner().getAtCorpusPath(), this);
                    String f = "";
                    if (sourceEntityFullPath.startsWith(sourceManifestFolderPath)) {
                        f = sourceEntityFullPath.substring(sourceManifestFolderPath.length());
                    }
                    String newDocumentFullPath = innerNewEntityDocumentNameFormat.replace("{n}", entDef.getEntityName());
                    newDocumentFullPath = newDocumentFullPath.replace("{f}", f);
                    newDocumentFullPath = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(newDocumentFullPath, this);
                    int newDocumentPathSplit = newDocumentFullPath.lastIndexOf("/") + 1;
                    String newDocumentPath = newDocumentFullPath.substring(0, newDocumentPathSplit);
                    String newDocumentName = newDocumentFullPath.substring(newDocumentPathSplit);
                    CdmFolderDefinition folder = (CdmFolderDefinition)this.getCtx().getCorpus().fetchObjectAsync(newDocumentPath).join();
                    if (null == folder) {
                        Logger.error(this.getCtx(), TAG, "createResolvedManifestAsync", this.getAtCorpusPath(), CdmLogCode.ErrResolveFolderNotFound, newDocumentPath);
                        CdmManifestDefinition cdmManifestDefinition2 = null;
                        return cdmManifestDefinition2;
                    }
                    AttributeResolutionDirectiveSet withDirectives = directives != null ? directives : this.getCtx().getCorpus().getDefaultResolutionDirectives();
                    ResolveOptions resOpt = new ResolveOptions(entDef.getInDocument(), withDirectives != null ? withDirectives.copy() : null);
                    Logger.debug(this.getCtx(), TAG, "createResolvedManifestAsync", this.getAtCorpusPath(), Logger.format("resolving entity {0} to document {1}", sourceEntityFullPath, newDocumentFullPath));
                    CdmEntityDefinition resolvedEntity = entDef.createResolvedEntityAsync(entDef.getEntityName(), resOpt, folder, newDocumentName).join();
                    if (null == resolvedEntity) {
                        CdmManifestDefinition cdmManifestDefinition3 = null;
                        return cdmManifestDefinition3;
                    }
                    CdmEntityDeclarationDefinition result = (CdmEntityDeclarationDefinition)entity.copy(resOpt);
                    if (result.getObjectType() == CdmObjectType.LocalEntityDeclarationDef) {
                        result.setEntityPath((String)ObjectUtils.firstNonNull((Object[])new String[]{this.getCtx().getCorpus().getStorage().createRelativeCorpusPath(resolvedEntity.getAtCorpusPath(), resolvedManifest), result.getAtCorpusPath()}));
                    }
                    resolvedManifest.getEntities().add(result);
                }
                Logger.debug(this.getCtx(), TAG, "createResolvedManifestAsync", this.getAtCorpusPath(), "calculating relationships");
                this.getCtx().getCorpus().calculateEntityGraphAsync(resolvedManifest).join();
                resolvedManifest.populateManifestRelationshipsAsync(CdmRelationshipDiscoveryStyle.Exclusive).join();
                resolvedManifest.setDirty(true);
                object = resolvedManifest;
                return object;
            }
        });
    }

    @Deprecated
    public CompletableFuture<String> createEntityPathFromDeclarationAsync(CdmEntityDeclarationDefinition entityDec) {
        return this.createEntityPathFromDeclarationAsync(entityDec, null);
    }

    CompletableFuture<String> createEntityPathFromDeclarationAsync(CdmEntityDeclarationDefinition entityDec, CdmObject obj) {
        while (entityDec instanceof CdmReferencedEntityDeclarationDefinition) {
            String currCorpusPath = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(entityDec.getEntityPath(), obj);
            entityDec = (CdmEntityDeclarationDefinition)this.getCtx().getCorpus().fetchObjectAsync(currCorpusPath).join();
            if (entityDec == null) {
                return null;
            }
            obj = entityDec.getInDocument();
        }
        return CompletableFuture.completedFuture(entityDec != null ? this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(entityDec.getEntityPath(), obj) : null);
    }

    boolean isRelAllowed(CdmE2ERelationship rel, CdmRelationshipDiscoveryStyle option) {
        if (option == CdmRelationshipDiscoveryStyle.None) {
            return false;
        }
        if (option == CdmRelationshipDiscoveryStyle.Exclusive) {
            String absoluteFromEntString = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(rel.getFromEntity(), this);
            boolean fromEntInManifest = this.getEntities().getAllItems().stream().anyMatch(x -> Objects.equals(this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(x.getEntityPath(), this), absoluteFromEntString));
            String absoluteToEntString = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(rel.getToEntity(), this);
            boolean toEntInManifest = this.getEntities().getAllItems().parallelStream().anyMatch(x -> Objects.equals(this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(x.getEntityPath(), this), absoluteToEntString));
            return fromEntInManifest && toEntInManifest;
        }
        return true;
    }

    private CompletableFuture<Void> addElevatedTraitsAndRelationships(CdmE2ERelationship rel) {
        return CompletableFuture.runAsync(() -> {
            ResolveOptions resOpt = new ResolveOptions(this);
            for (CdmTraitReferenceBase traitRef : rel.getExhibitsTraits()) {
                CdmTraitDefinition traitDef = (CdmTraitDefinition)this.getCtx().getCorpus().resolveSymbolReference(resOpt, this, traitRef.fetchObjectDefinitionName(), CdmObjectType.TraitDef, true);
                if (traitDef != null) continue;
                String absPath = rel.getElevatedTraitCorpusPath().get((CdmTraitReference)traitRef);
                String relativePath = this.getCtx().getCorpus().getStorage().createRelativeCorpusPath(absPath, this);
                this.getImports().add(0, new CdmImport(this.getCtx(), relativePath, null));
                CdmDocumentDefinition importDocument = (CdmDocumentDefinition)this.getCtx().getCorpus().fetchObjectAsync(absPath).join();
                importDocument.indexIfNeededAsync(resOpt, false).join();
                this.getCtx().getCorpus().resolveImportsAsync(this, new HashSet<String>(Collections.singletonList(this.getAtCorpusPath())), resOpt);
                this.setImportPriorities(null);
                this.getImportPriorities();
                this.setNeedsIndexing(false);
            }
            this.getRelationships().add(this.localizeRelToManifest(rel));
        });
    }

    CdmE2ERelationship localizeRelToManifest(CdmE2ERelationship rel) {
        CdmE2ERelationship relCopy = (CdmE2ERelationship)this.getCtx().getCorpus().makeObject(CdmObjectType.E2ERelationshipDef, rel.getName());
        relCopy.setToEntity(this.getCtx().getCorpus().getStorage().createRelativeCorpusPath(rel.getToEntity(), this));
        relCopy.setFromEntity(this.getCtx().getCorpus().getStorage().createRelativeCorpusPath(rel.getFromEntity(), this));
        relCopy.setToEntityAttribute(rel.getToEntityAttribute());
        relCopy.setFromEntityAttribute(rel.getFromEntityAttribute());
        relCopy.getExhibitsTraits().addAll(rel.getExhibitsTraits());
        return relCopy;
    }
}

