/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttribute;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeItem;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeResolutionGuidance;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmConstantEntityDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReference;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CardinalitySettings;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmProjection;
import com.microsoft.commondatamodel.objectmodel.enums.CdmAttributeContextType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmPropertyName;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.AttributeResolutionContext;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.RelationshipInfo;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolveContext;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttribute;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttributeSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttributeSetBuilder;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedEntityReference;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedEntityReferenceSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedEntityReferenceSide;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTrait;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSetBuilder;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionContext;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionDirective;
import com.microsoft.commondatamodel.objectmodel.utilities.AttributeContextParameters;
import com.microsoft.commondatamodel.objectmodel.utilities.AttributeResolutionDirectiveSet;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.TraitToPropertyMap;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;

public class CdmEntityAttributeDefinition
extends CdmAttribute {
    private static final String TAG = CdmEntityAttributeDefinition.class.getSimpleName();
    private CdmEntityReference entity;
    private TraitToPropertyMap t2pm;
    private Boolean isPolymorphicSource;

    public CdmEntityAttributeDefinition(CdmCorpusContext ctx, String name) {
        super(ctx, name);
        this.setObjectType(CdmObjectType.EntityAttributeDef);
    }

    @Override
    public boolean isDerivedFrom(String baseDef, ResolveOptions resOpt) {
        return false;
    }

    public String fetchDescription() {
        Object description = this.getTraitToPropertyMap().fetchPropertyValue(CdmPropertyName.DESCRIPTION);
        return description != null ? (String)description : null;
    }

    public void updateDescription(String value) {
        this.getTraitToPropertyMap().updatePropertyValue(CdmPropertyName.DESCRIPTION, value);
    }

    public String fetchDisplayName() {
        return (String)this.getTraitToPropertyMap().fetchPropertyValue(CdmPropertyName.DISPLAY_NAME);
    }

    public void updateDisplayName(String value) {
        this.getTraitToPropertyMap().updatePropertyValue(CdmPropertyName.DISPLAY_NAME, value);
    }

    @Deprecated
    public Object fetchProperty(CdmPropertyName propertyName) {
        return this.getTraitToPropertyMap().fetchPropertyValue(propertyName, true);
    }

    private TraitToPropertyMap getTraitToPropertyMap() {
        if (this.t2pm == null) {
            this.t2pm = new TraitToPropertyMap(this);
        }
        return this.t2pm;
    }

    @Override
    public boolean visit(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        if (this.entity == null) {
            return false;
        }
        String path = this.fetchDeclaredPath(pathFrom);
        if (preChildren != null && preChildren.invoke(this, path)) {
            return false;
        }
        if (this.getEntity() != null && this.getEntity().visit(path + "/entity/", preChildren, postChildren)) {
            return true;
        }
        if (this.visitAtt(path, preChildren, postChildren)) {
            return true;
        }
        return postChildren != null && postChildren.invoke(this, path);
    }

    public CdmEntityReference getEntity() {
        return this.entity;
    }

    public void setEntity(CdmEntityReference entity) {
        if (entity != null) {
            entity.setOwner(this);
        }
        this.entity = entity;
    }

    public Boolean getIsPolymorphicSource() {
        return this.isPolymorphicSource;
    }

    public void setIsPolymorphicSource(Boolean polymorphicSource) {
        this.isPolymorphicSource = polymorphicSource;
    }

    @Override
    public ResolvedEntityReferenceSet fetchResolvedEntityReferences(ResolveOptions resOpt) {
        if (resOpt == null) {
            LinkedHashSet<String> directives = new LinkedHashSet<String>();
            directives.add("normalized");
            directives.add("referenceOnly");
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        } else {
            resOpt = resOpt.copy();
        }
        ResolvedTraitSet rtsThisAtt = this.fetchResolvedTraits(resOpt);
        CdmAttributeResolutionGuidance resGuide = this.getResolutionGuidance();
        AttributeResolutionContext arc = new AttributeResolutionContext(resOpt, resGuide, rtsThisAtt);
        RelationshipInfo relInfo = arc.getRelationshipInfo();
        if (relInfo.isByRef() && !relInfo.isArray()) {
            ResolvedEntityReferenceSet rers = new ResolvedEntityReferenceSet(resOpt);
            ResolvedEntityReference rer = new ResolvedEntityReference();
            rer.getReferencing().getResolvedAttributeSetBuilder().mergeAttributes(this.fetchResolvedAttributes(resOpt, null));
            if (this.getEntity().getExplicitReference() != null) {
                CdmEntityDefinition entPickFrom = (CdmEntityDefinition)this.getEntity().fetchObjectDefinition(resOpt);
                CdmCollection<CdmAttributeItem> attsPick = entPickFrom.getAttributes();
                if (attsPick != null) {
                    for (int i = 0; i < attsPick.getCount(); ++i) {
                        if (attsPick.getAllItems().get(i).getObjectType() != CdmObjectType.EntityAttributeDef) continue;
                        CdmEntityReference er = ((CdmEntityAttributeDefinition)attsPick.getAllItems().get(i)).getEntity();
                        rer.getReferenced().add(this.resolveSide(er, resOpt));
                    }
                }
            } else {
                rer.getReferenced().add(this.resolveSide(this.getEntity(), resOpt));
            }
            rers.getSet().add(rer);
            return rers;
        }
        return null;
    }

    @Override
    public boolean validate() {
        ArrayList<String> missingFields = new ArrayList<String>();
        if (StringUtils.isNullOrTrimEmpty(this.getName())) {
            missingFields.add("name");
        }
        if (this.entity == null) {
            missingFields.add("entity");
        }
        if (this.getCardinality() != null) {
            if (StringUtils.isNullOrTrimEmpty(this.getCardinality().getMinimum())) {
                missingFields.add("cardinality.minimum");
            }
            if (StringUtils.isNullOrTrimEmpty(this.getCardinality().getMaximum())) {
                missingFields.add("cardinality.maximum");
            }
        }
        if (missingFields.size() > 0) {
            Logger.error(this.getCtx(), TAG, "validate", this.getAtCorpusPath(), CdmLogCode.ErrValdnIntegrityCheckFailure, this.getAtCorpusPath(), String.join((CharSequence)", ", missingFields.parallelStream().map(s -> String.format("'%s'", s)).collect(Collectors.toList())));
            return false;
        }
        if (this.getCardinality() != null) {
            if (!CardinalitySettings.isMinimumValid(this.getCardinality().getMinimum())) {
                Logger.error(this.getCtx(), TAG, "validate", this.getAtCorpusPath(), CdmLogCode.ErrValdnInvalidMinCardinality, this.getCardinality().getMinimum());
                return false;
            }
            if (!CardinalitySettings.isMaximumValid(this.getCardinality().getMaximum())) {
                Logger.error(this.getCtx(), TAG, "validate", this.getAtCorpusPath(), CdmLogCode.ErrValdnInvalidMaxCardinality, this.getCardinality().getMaximum());
                return false;
            }
        }
        return true;
    }

    @Override
    @Deprecated
    public Object copyData(ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectBase.copyData(this, resOpt, options, CdmEntityAttributeDefinition.class);
    }

    @Override
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        CdmEntityAttributeDefinition copy;
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        if (host == null) {
            copy = new CdmEntityAttributeDefinition(this.getCtx(), this.getName());
        } else {
            copy = (CdmEntityAttributeDefinition)host;
            copy.setName(this.getName());
        }
        copy.setEntity((CdmEntityReference)this.entity.copy(resOpt));
        this.copyAtt(resOpt, copy);
        return copy;
    }

    @Override
    void constructResolvedTraits(ResolvedTraitSetBuilder rtsb, ResolveOptions resOpt) {
        if (this.getPurpose() != null) {
            rtsb.takeReference(this.getPurpose().fetchResolvedTraits(resOpt));
        }
        this.addResolvedTraitsApplied(rtsb, resOpt);
    }

    private AttributeResolutionContext fetchAttResContext(ResolveOptions resOpt) {
        ResolvedTraitSet rtsThisAtt = this.fetchResolvedTraits(resOpt);
        CdmAttributeResolutionGuidance resGuideWithDefault = this.getResolutionGuidance() == null ? new CdmAttributeResolutionGuidance(this.getCtx()) : (CdmAttributeResolutionGuidance)this.getResolutionGuidance().copy(resOpt);
        resGuideWithDefault.updateAttributeDefaults(this.getName(), this);
        return new AttributeResolutionContext(resOpt, resGuideWithDefault, rtsThisAtt);
    }

    @Override
    @Deprecated
    public ResolvedAttributeSetBuilder fetchObjectFromCache(ResolveOptions resOpt, AttributeContextParameters acpInContext) {
        String kind = "rasb";
        ResolveContext ctx = (ResolveContext)this.getCtx();
        AttributeResolutionContext arc = !this.entity.getIsProjection() ? this.fetchAttResContext(resOpt) : null;
        resOpt.depthInfo.updateToNextLevel(resOpt, this.isPolymorphicSource, arc);
        String cacheTag = ctx.getCorpus().createDefinitionCacheTag(resOpt, this, "rasb", acpInContext != null ? "ctx" : "");
        ResolvedAttributeSetBuilder rasbCache = null;
        if (cacheTag != null) {
            rasbCache = ctx.getAttributeCache().get(cacheTag);
        }
        return rasbCache;
    }

    @Override
    @Deprecated
    public ResolvedAttributeSetBuilder constructResolvedAttributes(ResolveOptions resOpt) {
        return this.constructResolvedAttributes(resOpt, null);
    }

    @Override
    @Deprecated
    public ResolvedAttributeSetBuilder constructResolvedAttributes(ResolveOptions resOpt, CdmAttributeContext under) {
        ResolvedAttributeSetBuilder rasb = new ResolvedAttributeSetBuilder();
        CdmAttributeContext underAtt = under;
        AttributeContextParameters acpEnt = null;
        if (!resOpt.inCircularReference) {
            if (this.entity != null && this.entity.getIsProjection()) {
                if (!resOpt.depthInfo.getMaxDepthExceeded()) {
                    CdmProjection projDef = (CdmProjection)this.getEntity().fetchObjectDefinition(resOpt);
                    ProjectionDirective projDirective = new ProjectionDirective(resOpt, this, this.getEntity());
                    ProjectionContext projCtx = projDef.constructProjectionContext(projDirective, under);
                    rasb.setResolvedAttributeSet(projDef.extractResolvedAttributes(projCtx, under));
                    rasb.getResolvedAttributeSet().applyTraits(this.fetchResolvedTraits(resOpt));
                }
            } else {
                resOpt.usedResolutionGuidance = true;
                AttributeResolutionContext arc = this.fetchAttResContext(resOpt);
                RelationshipInfo relInfo = arc.getRelationshipInfo();
                if (underAtt != null) {
                    acpEnt = new AttributeContextParameters();
                    acpEnt.setUnder(underAtt);
                    acpEnt.setType(CdmAttributeContextType.Entity);
                    acpEnt.setName(this.getEntity().fetchObjectDefinitionName());
                    acpEnt.setRegarding(this.getEntity());
                    acpEnt.setIncludeTraits(true);
                }
                if (relInfo.isByRef()) {
                    if (under != null) {
                        under = rasb.getResolvedAttributeSet().createAttributeContext(resOpt, acpEnt);
                    }
                    if (under != null && relInfo.doSelectsOne()) {
                        CdmEntityDefinition entPickFrom = (CdmEntityDefinition)this.getEntity().fetchObjectDefinition(resOpt);
                        CdmCollection<CdmAttributeItem> attsPick = null;
                        if (entPickFrom != null) {
                            attsPick = entPickFrom.getAttributes();
                        }
                        if (entPickFrom != null && attsPick != null) {
                            for (int i = 0; i < attsPick.getCount(); ++i) {
                                if (attsPick.getAllItems().get(i).getObjectType() != CdmObjectType.EntityAttributeDef) continue;
                                AttributeContextParameters acpEntAtt = new AttributeContextParameters();
                                acpEntAtt.setUnder(under);
                                acpEntAtt.setType(CdmAttributeContextType.AttributeDefinition);
                                acpEntAtt.setName(attsPick.getAllItems().get(i).fetchObjectDefinitionName());
                                acpEntAtt.setRegarding(attsPick.getAllItems().get(i));
                                acpEntAtt.setIncludeTraits(true);
                                CdmAttributeContext pickUnder = rasb.getResolvedAttributeSet().createAttributeContext(resOpt, acpEntAtt);
                                CdmEntityReference pickEnt = ((CdmEntityAttributeDefinition)attsPick.getAllItems().get(i)).getEntity();
                                CdmAttributeContextType pickEntType = pickEnt.fetchObjectDefinition(resOpt).getObjectType() == CdmObjectType.ProjectionDef ? CdmAttributeContextType.Projection : CdmAttributeContextType.Entity;
                                AttributeContextParameters acpEntAttEnt = new AttributeContextParameters();
                                acpEntAttEnt.setUnder(pickUnder);
                                acpEntAttEnt.setType(pickEntType);
                                acpEntAttEnt.setName(pickEnt.fetchObjectDefinitionName());
                                acpEntAttEnt.setRegarding(pickEnt);
                                acpEntAttEnt.setIncludeTraits(true);
                                rasb.getResolvedAttributeSet().createAttributeContext(resOpt, acpEntAttEnt);
                            }
                        }
                    }
                    if (resOpt.depthInfo.getMaxDepthExceeded()) {
                        if (arc.getResOpt().getDirectives() == null) {
                            arc.getResOpt().setDirectives(new AttributeResolutionDirectiveSet());
                        }
                        arc.getResOpt().getDirectives().add("referenceOnly");
                    }
                } else {
                    ResolveOptions resLink = resOpt.copy();
                    resLink.setSymbolRefSet(resOpt.getSymbolRefSet());
                    rasb.mergeAttributes(this.getEntity().fetchResolvedAttributes(resLink, acpEnt));
                    if (resLink.depthInfo.getMaxDepthExceeded()) {
                        resOpt.depthInfo = resLink.depthInfo.copy();
                    }
                }
                rasb.getResolvedAttributeSet().setAttributeContext(underAtt);
                rasb.applyTraits(arc);
                rasb.generateApplierAttributes(arc, true);
                resOpt.getSymbolRefSet().merge(arc.getResOpt().getSymbolRefSet());
                if (rasb.getResolvedAttributeSet() != null && rasb.getResolvedAttributeSet().getSet() != null && relInfo.isByRef()) {
                    for (ResolvedAttribute att : rasb.getResolvedAttributeSet().getSet()) {
                        ResolvedTrait reqdTrait;
                        if (att.getResolvedTraits() == null || (reqdTrait = att.getResolvedTraits().find(resOpt, "is.linkedEntity.identifier")) == null) continue;
                        if (reqdTrait.getParameterValues() == null || reqdTrait.getParameterValues().length() == 0) {
                            Logger.warning(this.getCtx(), TAG, "constructResolvedAttributes", this.getAtCorpusPath(), CdmLogCode.WarnLinkEntIdentArgsNotSupported, att.displayName(), this.getEntity().getNamedReference());
                            continue;
                        }
                        ArrayList<String> entReferences = new ArrayList<String>();
                        ArrayList<String> attReferences = new ArrayList<String>();
                        if (relInfo.doSelectsOne()) {
                            CdmEntityDefinition entPickFrom = (CdmEntityDefinition)this.getEntity().fetchObjectDefinition(resOpt);
                            List attsPick = null;
                            if (entPickFrom != null && entPickFrom.getAttributes() != null) {
                                attsPick = entPickFrom.getAttributes().getAllItems().stream().map(attribute -> attribute).collect(Collectors.toList());
                            }
                            if (entPickFrom != null && attsPick != null) {
                                for (int i = 0; i < attsPick.size(); ++i) {
                                    if (((CdmObject)attsPick.get(i)).getObjectType() != CdmObjectType.EntityAttributeDef) continue;
                                    CdmEntityAttributeDefinition entAtt = (CdmEntityAttributeDefinition)attsPick.get(i);
                                    this.addEntityReference(entAtt.getEntity(), resOpt, entReferences, attReferences, this.getInDocument().getNamespace());
                                }
                            }
                        } else {
                            this.addEntityReference(this.getEntity(), resOpt, entReferences, attReferences, this.getInDocument() == null ? null : this.getInDocument().getNamespace());
                        }
                        CdmConstantEntityDefinition constantEntity = (CdmConstantEntityDefinition)this.getCtx().getCorpus().makeObject(CdmObjectType.ConstantEntityDef);
                        constantEntity.setEntityShape((CdmEntityReference)this.getCtx().getCorpus().makeRef(CdmObjectType.EntityRef, "entityGroupSet", true));
                        ArrayList<List<String>> listOfStringLists = new ArrayList<List<String>>();
                        for (int i = 0; i < entReferences.size(); ++i) {
                            ArrayList<String> stringList = new ArrayList<String>();
                            stringList.add((String)entReferences.get(i));
                            stringList.add((String)attReferences.get(i));
                            listOfStringLists.add(stringList);
                        }
                        constantEntity.setConstantValues(listOfStringLists);
                        CdmEntityReference traitParam = (CdmEntityReference)this.getCtx().getCorpus().makeRef(CdmObjectType.EntityRef, constantEntity, false);
                        reqdTrait.getParameterValues().setParameterValue(resOpt, "entityReferences", traitParam);
                    }
                }
                if (arc.getResOpt().getDirectives() != null && arc.getResOpt().getDirectives().has("structured")) {
                    ResolvedAttribute raSub = new ResolvedAttribute(arc.getTraitsToApply().getResOpt(), rasb.getResolvedAttributeSet(), this.getName(), rasb.getResolvedAttributeSet().getAttributeContext());
                    if (relInfo.isArray()) {
                        CdmTraitReference tr = (CdmTraitReference)this.getCtx().getCorpus().makeObject(CdmObjectType.TraitRef, "is.linkedEntity.array", true);
                        CdmTraitDefinition t = (CdmTraitDefinition)tr.fetchObjectDefinition(resOpt);
                        ResolvedTrait rt = new ResolvedTrait(t, null, new ArrayList<Object>(), new ArrayList<Boolean>());
                        raSub.setResolvedTraits(raSub.getResolvedTraits().merge(rt, true));
                    }
                    int depth = rasb.getResolvedAttributeSet().getDepthTraveled();
                    rasb = new ResolvedAttributeSetBuilder();
                    rasb.getResolvedAttributeSet().setAttributeContext(raSub.getAttCtx());
                    rasb.ownOne(raSub);
                    rasb.getResolvedAttributeSet().setDepthTraveled(depth);
                }
            }
        }
        rasb.getResolvedAttributeSet().setAttributeOwnership(this.getName());
        rasb.getResolvedAttributeSet().setDepthTraveled(rasb.getResolvedAttributeSet().getDepthTraveled() + 1);
        return rasb;
    }

    private void addEntityReference(CdmEntityReference entRef, ResolveOptions resOpt, List<String> entReferences, List<String> attReferences, String nameSpace) {
        ResolvedTrait identifyingTrait;
        ResolvedTraitSet otherResTraits;
        CdmEntityDefinition entDef = (CdmEntityDefinition)entRef.fetchObjectDefinition(resOpt);
        if (entDef != null && (otherResTraits = entRef.fetchResolvedTraits(resOpt)) != null && (identifyingTrait = otherResTraits.find(resOpt, "is.identifiedBy")) != null) {
            Object attRef = identifyingTrait.getParameterValues().fetchParameterValue("attribute").getValue();
            String[] bits = attRef instanceof String ? ((String)attRef).split("/") : ((CdmObjectReference)attRef).getNamedReference().split("/");
            String attName = bits[bits.length - 1];
            String absoluteEntPath = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(entDef.getAtCorpusPath(), entDef.getInDocument());
            entReferences.add(absoluteEntPath);
            attReferences.add(attName);
        }
    }

    private ResolvedEntityReferenceSide resolveSide(CdmEntityReference entRef, ResolveOptions resOpt) {
        ResolvedEntityReferenceSide sideOther = new ResolvedEntityReferenceSide(null, null);
        if (entRef != null) {
            sideOther.setEntity((CdmEntityDefinition)entRef.fetchObjectDefinition(resOpt));
            if (sideOther.getEntity() != null) {
                ResolvedAttributeSet resolvedAttributeSet;
                CdmAttribute otherAttribute;
                Object otherRef;
                ResolveOptions otherOpts = new ResolveOptions();
                otherOpts.setWrtDoc(resOpt.getWrtDoc());
                otherOpts.setDirectives(resOpt.getDirectives());
                ResolvedTrait t = entRef.fetchResolvedTraits(otherOpts).find(otherOpts, "is.identifiedBy");
                if (t != null && t.getParameterValues() != null && t.getParameterValues().length() > 0 && CdmObject.class.isAssignableFrom((otherRef = t.getParameterValues().fetchParameterValue("attribute").getValue()).getClass()) && (otherAttribute = (CdmAttribute)((CdmObject)otherRef).fetchObjectDefinition(otherOpts)) != null && (resolvedAttributeSet = sideOther.getEntity().fetchResolvedAttributes(otherOpts)) != null) {
                    sideOther.getResolvedAttributeSetBuilder().ownOne(resolvedAttributeSet.get(otherAttribute.getName()).copy());
                }
            }
        }
        return sideOther;
    }
}

