/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDataTypeDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDataTypeReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDocumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectDefinitionBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectReferenceBase;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolveContext;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;

public class CdmParameterDefinition
extends CdmObjectDefinitionBase {
    private static final String TAG = CdmParameterDefinition.class.getSimpleName();
    private String name;
    private Boolean isRequired;
    private CdmDataTypeReference dataTypeRef;
    private Object defaultValue;

    public CdmParameterDefinition(CdmCorpusContext ctx, String name) {
        super(ctx);
        this.setName(name);
        this.setObjectType(CdmObjectType.ParameterDef);
    }

    @Override
    public boolean isDerivedFrom(String baseDef, ResolveOptions resOpt) {
        return false;
    }

    @Override
    public boolean visit(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        String path = this.fetchDeclaredPath(pathFrom);
        if (preChildren != null && preChildren.invoke(this, path)) {
            return false;
        }
        if (this.getDefaultValue() != null && this.getDefaultValue() instanceof CdmObject && ((CdmObject)this.getDefaultValue()).visit(path + "/defaultValue/", preChildren, postChildren)) {
            return true;
        }
        if (this.getDataTypeRef() != null && this.getDataTypeRef().visit(path + "/dataType/", preChildren, postChildren)) {
            return true;
        }
        return postChildren != null && postChildren.invoke(this, path);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object value) {
        this.defaultValue = value;
    }

    public Boolean isRequired() {
        return this.isRequired;
    }

    public void setRequired(boolean value) {
        this.isRequired = value;
    }

    public CdmDataTypeReference getDataTypeRef() {
        return this.dataTypeRef;
    }

    public void setDataTypeRef(CdmDataTypeReference value) {
        this.dataTypeRef = value;
    }

    @Override
    public boolean validate() {
        if (StringUtils.isNullOrTrimEmpty(this.name)) {
            ArrayList<String> missingFields = new ArrayList<String>(Arrays.asList("Name"));
            Logger.error(this.getCtx(), TAG, "validate", this.getAtCorpusPath(), CdmLogCode.ErrValdnIntegrityCheckFailure, this.getAtCorpusPath(), String.join((CharSequence)", ", missingFields.parallelStream().map(s -> String.format("'%s'", s)).collect(Collectors.toList())));
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public Object copyData(ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectBase.copyData(this, resOpt, options, CdmParameterDefinition.class);
    }

    @Override
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        CdmParameterDefinition copy;
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        if (host == null) {
            copy = new CdmParameterDefinition(this.getCtx(), this.getName());
        } else {
            copy = (CdmParameterDefinition)host;
            copy.setCtx(this.getCtx());
            copy.setName(this.getName());
        }
        Object defVal = null;
        if (this.getDefaultValue() != null) {
            defVal = this.getDefaultValue() instanceof String ? this.getDefaultValue() : ((CdmObject)this.getDefaultValue()).copy(resOpt);
        }
        copy.setExplanation(this.getExplanation());
        copy.setDefaultValue(defVal);
        copy.setRequired(this.isRequired());
        copy.setDataTypeRef((CdmDataTypeReference)(this.getDataTypeRef() != null ? this.getDataTypeRef().copy(resOpt) : null));
        return copy;
    }

    Object constTypeCheck(ResolveOptions resOpt, CdmDocumentDefinition wrtDoc, Object argumentValue) {
        ResolveContext ctx = (ResolveContext)this.getCtx();
        Object replacement = argumentValue;
        if (this.getDataTypeRef() == null) {
            return replacement;
        }
        CdmDataTypeDefinition dt = (CdmDataTypeDefinition)this.getDataTypeRef().fetchObjectDefinition(resOpt);
        if (null == dt) {
            Logger.error(ctx, TAG, "constTypeCheck", wrtDoc.getFolderPath() + wrtDoc.getName(), CdmLogCode.ErrUnrecognizedDataType, this.getName());
            return null;
        }
        Object pValue = argumentValue;
        if (null == pValue) {
            replacement = pValue = this.getDefaultValue();
        }
        if (null != pValue && dt.isDerivedFrom("cdmObject", resOpt)) {
            ArrayList<CdmObjectType> expectedTypes = new ArrayList<CdmObjectType>();
            String expected = null;
            if (dt.isDerivedFrom("entity", resOpt)) {
                expectedTypes.add(CdmObjectType.ConstantEntityDef);
                expectedTypes.add(CdmObjectType.EntityRef);
                expectedTypes.add(CdmObjectType.EntityDef);
                expectedTypes.add(CdmObjectType.ProjectionDef);
                expected = "entity";
            } else if (dt.isDerivedFrom("attribute", resOpt)) {
                expectedTypes.add(CdmObjectType.AttributeRef);
                expectedTypes.add(CdmObjectType.TypeAttributeDef);
                expectedTypes.add(CdmObjectType.EntityAttributeDef);
                expected = "attribute";
            } else if (dt.isDerivedFrom("dataType", resOpt)) {
                expectedTypes.add(CdmObjectType.DataTypeRef);
                expectedTypes.add(CdmObjectType.DataTypeDef);
                expected = "dataType";
            } else if (dt.isDerivedFrom("purpose", resOpt)) {
                expectedTypes.add(CdmObjectType.PurposeRef);
                expectedTypes.add(CdmObjectType.PurposeDef);
                expected = "purpose";
            } else if (dt.isDerivedFrom("traitGroup", resOpt)) {
                expectedTypes.add(CdmObjectType.TraitGroupRef);
                expectedTypes.add(CdmObjectType.TraitGroupDef);
                expected = "traitGroup";
            } else if (dt.isDerivedFrom("trait", resOpt)) {
                expectedTypes.add(CdmObjectType.TraitRef);
                expectedTypes.add(CdmObjectType.TraitDef);
                expected = "trait";
            } else if (dt.isDerivedFrom("attributeGroup", resOpt)) {
                expectedTypes.add(CdmObjectType.AttributeGroupRef);
                expectedTypes.add(CdmObjectType.AttributeGroupDef);
                expected = "attributeGroup";
            }
            if (expectedTypes.size() == 0) {
                Logger.error(ctx, TAG, "constTypeCheck", wrtDoc.getFolderPath() + wrtDoc.getName(), CdmLogCode.ErrUnexpectedDataType, this.getName());
            }
            CdmObjectType foundType = CdmObjectType.Error;
            Class<?> pValueType = pValue.getClass();
            if (CdmObject.class.isAssignableFrom(pValueType)) {
                foundType = ((CdmObject)pValue).getObjectType();
            }
            String foundDesc = ctx.getRelativePath();
            String pValueAsString = "";
            if (!(pValue instanceof CdmObject)) {
                pValueAsString = (String)pValue;
            }
            if (!pValueAsString.isEmpty()) {
                if (pValueAsString.equalsIgnoreCase("this.attribute") && expected.equalsIgnoreCase("attribute")) {
                    foundType = CdmObjectType.AttributeRef;
                } else {
                    foundDesc = pValueAsString;
                    int seekResAtt = CdmObjectReferenceBase.offsetAttributePromise(pValueAsString);
                    if (seekResAtt >= 0) {
                        replacement = new CdmAttributeReference(ctx, pValueAsString, true);
                        ((CdmAttributeReference)replacement).setCtx(ctx);
                        ((CdmAttributeReference)replacement).setInDocument(wrtDoc);
                        foundType = CdmObjectType.AttributeRef;
                    } else {
                        CdmObjectBase lu = ctx.getCorpus().resolveSymbolReference(resOpt, wrtDoc, pValueAsString, CdmObjectType.Error, true);
                        if (null != lu) {
                            if (expected.equalsIgnoreCase("attribute")) {
                                replacement = new CdmAttributeReference(ctx, pValueAsString, true);
                                ((CdmAttributeReference)replacement).setCtx(ctx);
                                ((CdmAttributeReference)replacement).setInDocument(wrtDoc);
                                foundType = CdmObjectType.AttributeRef;
                            } else {
                                replacement = lu;
                                foundType = ((CdmObject)replacement).getObjectType();
                            }
                        }
                    }
                }
            }
            if (expectedTypes.indexOf((Object)foundType) == -1) {
                Logger.error(ctx, TAG, "constTypeCheck", wrtDoc.getAtCorpusPath(), CdmLogCode.ErrResolutionFailure, this.getName(), expected, foundDesc, expected);
            } else {
                Logger.info(ctx, TAG, "constTypeCheck", wrtDoc.getAtCorpusPath(), Logger.format("Resolved '{0}'", foundDesc));
            }
        }
        return replacement;
    }
}

