/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm.projections;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttribute;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeGroupReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeItem;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityAttributeDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTypeAttributeDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationBase;
import com.microsoft.commondatamodel.objectmodel.enums.CdmAttributeContextType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmOperationType;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttribute;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionAttributeState;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionAttributeStateSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionContext;
import com.microsoft.commondatamodel.objectmodel.utilities.AttributeContextParameters;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.ArrayList;
import java.util.stream.Collectors;

public class CdmOperationAddArtifactAttribute
extends CdmOperationBase {
    private static final String TAG = CdmOperationAddArtifactAttribute.class.getSimpleName();
    private CdmAttributeItem newAttribute;
    private Boolean insertAtTop;

    public CdmOperationAddArtifactAttribute(CdmCorpusContext ctx) {
        super(ctx);
        this.setObjectType(CdmObjectType.OperationAddArtifactAttributeDef);
        this.setType(CdmOperationType.AddArtifactAttribute);
    }

    public CdmAttributeItem getNewAttribute() {
        return this.newAttribute;
    }

    public void setNewAttribute(CdmAttributeItem newAttribute) {
        this.newAttribute = newAttribute;
    }

    public Boolean getInsertAtTop() {
        return this.insertAtTop;
    }

    public void setInsertAtTop(Boolean insertAtTop) {
        this.insertAtTop = insertAtTop;
    }

    @Override
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        CdmOperationAddArtifactAttribute copy = host == null ? new CdmOperationAddArtifactAttribute(this.getCtx()) : (CdmOperationAddArtifactAttribute)host;
        copy.setNewAttribute(this.getNewAttribute() != null ? (CdmAttributeItem)this.getNewAttribute().copy(resOpt) : null);
        copy.setInsertAtTop(this.getInsertAtTop());
        this.copyProj(resOpt, copy);
        return copy;
    }

    @Override
    @Deprecated
    public Object copyData(ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectBase.copyData(this, resOpt, options, CdmOperationAddArtifactAttribute.class);
    }

    @Override
    public String getName() {
        return "operationAddArtifactAttribute";
    }

    @Override
    @Deprecated
    public CdmObjectType getObjectType() {
        return CdmObjectType.OperationAddArtifactAttributeDef;
    }

    @Override
    public boolean validate() {
        ArrayList<String> missingFields = new ArrayList<String>();
        if (this.newAttribute == null) {
            missingFields.add("newAttribute");
        }
        if (missingFields.size() > 0) {
            Logger.error(this.getCtx(), TAG, "validate", this.getAtCorpusPath(), CdmLogCode.ErrValdnIntegrityCheckFailure, this.getAtCorpusPath(), String.join((CharSequence)", ", missingFields.parallelStream().map(s -> String.format("'%s'", s)).collect(Collectors.toList())));
            return false;
        }
        return true;
    }

    @Override
    public boolean visit(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        String path = this.fetchDeclaredPath(pathFrom);
        if (preChildren != null && preChildren.invoke(this, path)) {
            return false;
        }
        if (this.getNewAttribute() != null && this.getNewAttribute().visit(path + "/newAttribute/", preChildren, postChildren)) {
            return true;
        }
        return postChildren != null && postChildren.invoke(this, path);
    }

    @Override
    @Deprecated
    public ProjectionAttributeStateSet appendProjectionAttributeState(ProjectionContext projCtx, ProjectionAttributeStateSet projOutputSet, CdmAttributeContext attrCtx) {
        if (this.insertAtTop == null || !this.insertAtTop.booleanValue()) {
            this.addAllPreviousAttributeStates(projCtx, projOutputSet);
            this.addNewArtifactAttributeState(projCtx, projOutputSet, attrCtx);
        } else {
            this.addNewArtifactAttributeState(projCtx, projOutputSet, attrCtx);
            this.addAllPreviousAttributeStates(projCtx, projOutputSet);
        }
        return projOutputSet;
    }

    private void addNewArtifactAttributeState(ProjectionContext projCtx, ProjectionAttributeStateSet projOutputSet, CdmAttributeContext attrCtx) {
        AttributeContextParameters attrCtxOpAddArtifactAttrParam = new AttributeContextParameters();
        attrCtxOpAddArtifactAttrParam.setUnder(attrCtx);
        attrCtxOpAddArtifactAttrParam.setType(CdmAttributeContextType.OperationAddArtifactAttribute);
        attrCtxOpAddArtifactAttrParam.setName("operation/index" + this.getIndex() + "/" + this.getName());
        CdmAttributeContext attrCtxOpAddArtifactAttr = CdmAttributeContext.createChildUnder(projCtx.getProjectionDirective().getResOpt(), attrCtxOpAddArtifactAttrParam);
        if (this.newAttribute instanceof CdmTypeAttributeDefinition) {
            AttributeContextParameters attrCtxNewAttrParam = new AttributeContextParameters();
            attrCtxNewAttrParam.setUnder(attrCtxOpAddArtifactAttr);
            attrCtxNewAttrParam.setType(CdmAttributeContextType.AddedAttributeNewArtifact);
            attrCtxNewAttrParam.setName(this.newAttribute.fetchObjectDefinitionName());
            CdmAttributeContext attrCtxNewAttr = CdmAttributeContext.createChildUnder(projCtx.getProjectionDirective().getResOpt(), attrCtxNewAttrParam);
            ResolvedAttribute newResAttr = CdmOperationAddArtifactAttribute.createNewResolvedAttribute(projCtx, attrCtxNewAttr, (CdmAttribute)this.newAttribute);
            ProjectionAttributeState newPAS = new ProjectionAttributeState(projOutputSet.getCtx());
            newPAS.setCurrentResolvedAttribute(newResAttr);
            projOutputSet.add(newPAS);
        } else if (this.newAttribute instanceof CdmEntityAttributeDefinition || this.newAttribute instanceof CdmAttributeGroupReference) {
            String typeStr = this.newAttribute instanceof CdmEntityAttributeDefinition ? "an entity attribute" : "an attribute group";
            Logger.warning(this.getCtx(), TAG, "appendProjectionAttributeState", this.getAtCorpusPath(), CdmLogCode.WarnProjAddArtifactAttrNotSupported, typeStr);
        } else {
            Logger.error(this.getCtx(), TAG, "appendProjectionAttributeState", this.getAtCorpusPath(), CdmLogCode.ErrProjUnsupportedSource, this.newAttribute.getObjectType().toString(), this.getName());
        }
    }

    private void addAllPreviousAttributeStates(ProjectionContext projCtx, ProjectionAttributeStateSet projOutputSet) {
        for (ProjectionAttributeState currentPAS : projCtx.getCurrentAttributeStateSet().getStates()) {
            projOutputSet.add(currentPAS);
        }
    }
}

