/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder;

import com.fasterxml.jackson.databind.node.ArrayNode;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReference;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.Utils;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.AttributeGroupReferenceDefinition;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.DataTypeReferenceDefinition;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.EntityReferenceDefinition;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.PurposeReferenceDefinition;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.TraitGroupReferenceDefinition;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.TraitReferenceDefinition;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.JMapper;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class CdmObjectRefPersistence {
    private static final String TAG = CdmObjectRefPersistence.class.getSimpleName();

    public static Object toData(CdmObjectReference instance, ResolveOptions resOpt, CopyOptions options) {
        Object erCopy;
        Object replace;
        Object copy = null;
        if (!StringUtils.isBlankByCdmStandard(instance.getNamedReference())) {
            Object identifier = Utils.copyIdentifierRef(instance, resOpt, options);
            if (instance.isSimpleNamedReference()) {
                if (identifier instanceof String) {
                    return identifier;
                }
                return JMapper.MAP.valueToTree(identifier);
            }
            Object replace2 = CdmObjectRefPersistence.copyRefData(instance, copy, identifier, resOpt, options);
            if (replace2 != null) {
                copy = replace2;
            }
        } else if (instance.getExplicitReference() != null && (replace = CdmObjectRefPersistence.copyRefData(instance, copy, erCopy = instance.getExplicitReference().copyData(resOpt, options), resOpt, options)) != null) {
            copy = replace;
        }
        if (instance.isOptional() != null) {
            ((CdmObjectReference)copy).setOptional(instance.isOptional());
        }
        if (null != copy && instance.getAppliedTraits().getCount() > 0) {
            try {
                Method setAppliedTraitsMethod = copy.getClass().getMethod("setAppliedTraits", ArrayNode.class);
                setAppliedTraitsMethod.invoke(copy, Utils.listCopyDataAsArrayNode(instance.getAppliedTraits(), resOpt, options));
            }
            catch (NoSuchMethodException setAppliedTraitsMethod) {
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                Logger.error(instance.getCtx(), TAG, "toData", null, CdmLogCode.ErrPersistJsonObjectRefConversionError, ex.getLocalizedMessage());
            }
        }
        return copy;
    }

    private static Object copyRefData(CdmObjectReference instance, Object copy, Object refTo, ResolveOptions resOpt, CopyOptions options) {
        switch (instance.getObjectType()) {
            case AttributeGroupRef: {
                AttributeGroupReferenceDefinition agrd = new AttributeGroupReferenceDefinition();
                agrd.setAttributeGroupReference(JMapper.MAP.valueToTree(refTo));
                return agrd;
            }
            case AttributeRef: {
                return refTo;
            }
            case DataTypeRef: {
                DataTypeReferenceDefinition dtrd = new DataTypeReferenceDefinition();
                dtrd.setDataTypeReference(JMapper.MAP.valueToTree(refTo));
                return dtrd;
            }
            case EntityRef: {
                EntityReferenceDefinition erd = new EntityReferenceDefinition();
                erd.setEntityReference(JMapper.MAP.valueToTree(refTo));
                return erd;
            }
            case PurposeRef: {
                PurposeReferenceDefinition prd = new PurposeReferenceDefinition();
                prd.setPurposeReference(refTo);
                return prd;
            }
            case TraitRef: {
                copy = new TraitReferenceDefinition();
                ((TraitReferenceDefinition)copy).setTraitReference(refTo);
                ((TraitReferenceDefinition)copy).setArguments(Utils.listCopyDataAsArrayNode(((CdmTraitReference)instance).getArguments(), resOpt, options));
                return copy;
            }
            case TraitGroupRef: {
                TraitGroupReferenceDefinition tgrd = new TraitGroupReferenceDefinition();
                tgrd.setTraitGroupReference(refTo);
            }
        }
        return null;
    }
}

