/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmArgumentCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmArgumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttribute;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeContextReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeGroupDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeGroupReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeItem;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeResolutionGuidance;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmConstantEntityDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDocumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityAttributeDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmFolderDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectDefinitionBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmReferencesEntities;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReferenceBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTypeAttributeDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmProjection;
import com.microsoft.commondatamodel.objectmodel.enums.CdmAttributeContextType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmDataFormat;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmPropertyName;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.AttributeResolutionContext;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolveContext;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttribute;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttributeSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttributeSetBuilder;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedEntity;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedEntityReference;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedEntityReferenceSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTrait;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSetBuilder;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionContext;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionDirective;
import com.microsoft.commondatamodel.objectmodel.utilities.AttributeContextParameters;
import com.microsoft.commondatamodel.objectmodel.utilities.AttributeResolutionDirectiveSet;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.TraitToPropertyMap;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class CdmEntityDefinition
extends CdmObjectDefinitionBase
implements CdmReferencesEntities {
    private static final String TAG = CdmEntityDefinition.class.getSimpleName();
    private String entityName;
    private CdmEntityReference extendsEntity;
    private CdmAttributeResolutionGuidance extendsEntityResolutionGuidance;
    private CdmCollection<CdmAttributeItem> attributes;
    private CdmAttributeContext attributeContext;
    private ResolveContext ctxDefault;
    private boolean resolvingEntityReferences = false;
    private TraitToPropertyMap t2pm;
    private ResolvedAttributeSetBuilder rasb;

    public CdmEntityDefinition(CdmCorpusContext ctx, String entityName) {
        this(ctx, entityName, null);
    }

    public CdmEntityDefinition(CdmCorpusContext ctx, String entityName, CdmEntityReference extendsEntity) {
        this(ctx, entityName, extendsEntity, false, false);
    }

    public CdmEntityDefinition(CdmCorpusContext ctx, String entityName, CdmEntityReference extendsEntity, boolean exhibitsTraits, boolean attributes) {
        super(ctx);
        this.setObjectType(CdmObjectType.EntityDef);
        this.setEntityName(entityName);
        this.setExtendsEntity(extendsEntity);
        this.attributes = new CdmCollection(this.getCtx(), this, CdmObjectType.TypeAttributeDef);
        this.t2pm = new TraitToPropertyMap(this);
    }

    public String getEntityName() {
        return this.entityName;
    }

    public void setEntityName(String entityName) {
        this.entityName = entityName;
    }

    public CdmEntityReference getExtendsEntity() {
        return this.extendsEntity;
    }

    public void setExtendsEntity(CdmEntityReference extendsEntity) {
        if (extendsEntity != null) {
            extendsEntity.setOwner(this);
        }
        this.extendsEntity = extendsEntity;
    }

    public CdmAttributeResolutionGuidance getExtendsEntityResolutionGuidance() {
        return this.extendsEntityResolutionGuidance;
    }

    public void setExtendsEntityResolutionGuidance(CdmAttributeResolutionGuidance extendsEntityResolutionGuidance) {
        this.extendsEntityResolutionGuidance = extendsEntityResolutionGuidance;
    }

    public CdmAttributeContext getAttributeContext() {
        return this.attributeContext;
    }

    public void setAttributeContext(CdmAttributeContext attributeContext) {
        this.attributeContext = attributeContext;
    }

    public void setExtendsEntityRef(CdmEntityReference extendsEntityRef) {
        this.extendsEntity = extendsEntityRef;
    }

    @Override
    public String getName() {
        return this.entityName;
    }

    @Override
    public boolean isDerivedFrom(String baseDef, ResolveOptions resOpt) {
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        return this.isDerivedFromDef(resOpt, this.getExtendsEntity(), this.getName(), baseDef);
    }

    public List<String> getCdmSchemas() {
        return (List)this.t2pm.fetchPropertyValue(CdmPropertyName.CDM_SCHEMAS);
    }

    public void setCdmSchemas(List<String> value) {
        this.t2pm.updatePropertyValue(CdmPropertyName.CDM_SCHEMAS, value);
    }

    public String getDescription() {
        return (String)this.t2pm.fetchPropertyValue(CdmPropertyName.DESCRIPTION);
    }

    public void setDescription(String value) {
        this.t2pm.updatePropertyValue(CdmPropertyName.DESCRIPTION, value);
    }

    public String getDisplayName() {
        return (String)this.t2pm.fetchPropertyValue(CdmPropertyName.DISPLAY_NAME);
    }

    public void setDisplayName(String value) {
        this.t2pm.updatePropertyValue(CdmPropertyName.DISPLAY_NAME, value);
    }

    public CdmCollection<CdmAttributeItem> getAttributes() {
        return this.attributes;
    }

    public String getSourceName() {
        return (String)this.t2pm.fetchPropertyValue(CdmPropertyName.SOURCE_NAME);
    }

    public void setSourceName(String value) {
        this.t2pm.updatePropertyValue(CdmPropertyName.SOURCE_NAME, value);
    }

    public String getVersion() {
        return (String)this.t2pm.fetchPropertyValue(CdmPropertyName.VERSION);
    }

    public void setVersion(String value) {
        this.t2pm.updatePropertyValue(CdmPropertyName.VERSION, value);
    }

    int countInheritedAttributes(ResolveOptions resOpt) {
        this.fetchResolvedAttributes(resOpt);
        return this.rasb.getInheritedMark();
    }

    @Override
    void constructResolvedTraits(ResolvedTraitSetBuilder rtsb, ResolveOptions resOpt) {
        CdmEntityReference baseClass = this.getExtendsEntity();
        if (baseClass != null) {
            rtsb.mergeTraits(baseClass.fetchResolvedTraits(resOpt));
        }
        if (this.getAttributes() != null) {
            ResolvedTraitSet rtsElevated = new ResolvedTraitSet(resOpt);
            for (int i = 0; i < this.getAttributes().getCount(); ++i) {
                CdmAttributeItem att = this.attributes.getAllItems().get(i);
                ResolvedTraitSet rtsAtt = att.fetchResolvedTraits(resOpt);
                if (rtsAtt != null && rtsAtt.getHasElevated() != null && rtsAtt.getHasElevated().booleanValue()) {
                    rtsElevated = rtsElevated.mergeSet(rtsAtt, true);
                }
                rtsb.mergeTraits(rtsElevated);
            }
            this.constructResolvedTraitsDef(null, rtsb, resOpt);
        }
    }

    @Override
    @Deprecated
    public ResolvedAttributeSetBuilder constructResolvedAttributes(ResolveOptions resOpt) {
        return this.constructResolvedAttributes(resOpt, null);
    }

    @Override
    @Deprecated
    public ResolvedAttributeSetBuilder constructResolvedAttributes(ResolveOptions resOpt, CdmAttributeContext under) {
        ResolvedAttributeSetBuilder rasb = this.rasb = new ResolvedAttributeSetBuilder();
        rasb.getResolvedAttributeSet().setAttributeContext(under);
        if (this.getExtendsEntity() != null) {
            CdmEntityReference extRef = this.extendsEntity;
            CdmAttributeContext extendsRefUnder = null;
            AttributeContextParameters acpExtEnt = null;
            if (under != null) {
                AttributeContextParameters acpExt = new AttributeContextParameters();
                acpExt.setUnder(under);
                acpExt.setType(CdmAttributeContextType.EntityReferenceExtends);
                acpExt.setName("extends");
                acpExt.setRegarding(null);
                acpExt.setIncludeTraits(false);
                extendsRefUnder = rasb.getResolvedAttributeSet().createAttributeContext(resOpt, acpExt);
            }
            if (extRef.getExplicitReference() != null && extRef.fetchObjectDefinition(resOpt).getObjectType() == CdmObjectType.ProjectionDef) {
                Object extRefObjDef = extRef.fetchObjectDefinition(resOpt);
                if (extendsRefUnder != null) {
                    acpExtEnt = new AttributeContextParameters();
                    acpExtEnt.setUnder(extendsRefUnder);
                    acpExtEnt.setType(CdmAttributeContextType.Projection);
                    acpExtEnt.setName(extRefObjDef.getName());
                    acpExtEnt.setRegarding(extRef);
                    acpExtEnt.setIncludeTraits(false);
                }
                ProjectionDirective projDirective = new ProjectionDirective(resOpt, this, extRef);
                CdmProjection projDef = (CdmProjection)extRefObjDef;
                ProjectionContext projCtx = projDef.constructProjectionContext(projDirective, extendsRefUnder);
                rasb.setResolvedAttributeSet(projDef.extractResolvedAttributes(projCtx, under));
            } else {
                if (extendsRefUnder != null) {
                    acpExtEnt = new AttributeContextParameters();
                    acpExtEnt.setUnder(extendsRefUnder);
                    acpExtEnt.setType(CdmAttributeContextType.Entity);
                    acpExtEnt.setName(extRef.getNamedReference() != null ? extRef.getNamedReference() : extRef.getExplicitReference().getName());
                    acpExtEnt.setRegarding(extRef);
                    acpExtEnt.setIncludeTraits(true);
                }
                rasb.mergeAttributes(this.getExtendsEntity().fetchResolvedAttributes(resOpt, acpExtEnt));
                if (!resOpt.checkAttributeCount(rasb.getResolvedAttributeSet().getResolvedAttributeCount())) {
                    Logger.error(this.getCtx(), TAG, "constructResolvedAttributes", this.getAtCorpusPath(), CdmLogCode.ErrRelMaxResolvedAttrReached, this.entityName);
                    return null;
                }
                if (this.getExtendsEntityResolutionGuidance() != null) {
                    resOpt.usedResolutionGuidance = true;
                    ResolvedTraitSet rtsBase = this.fetchResolvedTraits(resOpt);
                    CdmAttributeResolutionGuidance resGuide = (CdmAttributeResolutionGuidance)this.getExtendsEntityResolutionGuidance().copy(resOpt);
                    resGuide.updateAttributeDefaults(resGuide.fetchObjectDefinitionName(), this);
                    AttributeResolutionContext arc = new AttributeResolutionContext(resOpt, resGuide, rtsBase);
                    rasb.generateApplierAttributes(arc, false);
                }
            }
        }
        rasb.markInherited();
        rasb.getResolvedAttributeSet().setAttributeContext(under);
        if (this.getAttributes() != null) {
            int furthestChildDepth = 0;
            int l = this.getAttributes().getCount();
            for (int i = 0; i < l; ++i) {
                CdmAttributeItem att = this.attributes.getAllItems().get(i);
                AttributeContextParameters acpAtt = null;
                if (under != null) {
                    acpAtt = new AttributeContextParameters();
                    acpAtt.setUnder(under);
                    acpAtt.setType(CdmAttributeContextType.AttributeDefinition);
                    acpAtt.setName(att.fetchObjectDefinitionName());
                    acpAtt.setRegarding(att);
                    acpAtt.setIncludeTraits(false);
                }
                ResolvedAttributeSet rasFromAtt = att.fetchResolvedAttributes(resOpt, acpAtt);
                if (att instanceof CdmEntityAttributeDefinition) {
                    furthestChildDepth = rasFromAtt.getDepthTraveled() > furthestChildDepth ? rasFromAtt.getDepthTraveled() : furthestChildDepth;
                }
                rasb.getResolvedAttributeSet().markOrphansForRemoval(att.fetchObjectDefinitionName(), rasFromAtt);
                rasb.mergeAttributes(rasFromAtt);
                if (resOpt.checkAttributeCount(rasb.getResolvedAttributeSet().getResolvedAttributeCount())) continue;
                Logger.error(this.getCtx(), TAG, "constructResolvedAttributes", this.getAtCorpusPath(), CdmLogCode.ErrRelMaxResolvedAttrReached, this.entityName);
                return null;
            }
            rasb.getResolvedAttributeSet().setDepthTraveled(furthestChildDepth);
        }
        rasb.markOrder();
        rasb.getResolvedAttributeSet().setAttributeContext(under);
        rasb.removeRequestedAtts();
        rasb.getResolvedAttributeSet().setTargetOwner(this);
        return rasb;
    }

    public CompletableFuture<CdmEntityDefinition> createResolvedEntityAsync(String newEntName) {
        return this.createResolvedEntityAsync(newEntName, null);
    }

    public CompletableFuture<CdmEntityDefinition> createResolvedEntityAsync(String newEntName, ResolveOptions resOpt) {
        return this.createResolvedEntityAsync(newEntName, resOpt, null, null);
    }

    public CompletableFuture<CdmEntityDefinition> createResolvedEntityAsync(String newEntName, ResolveOptions resOpt, CdmFolderDefinition folder) {
        return this.createResolvedEntityAsync(newEntName, resOpt, folder, null);
    }

    public CompletableFuture<CdmEntityDefinition> createResolvedEntityAsync(String newEntName, ResolveOptions resOpt, CdmFolderDefinition folderDef, String newDocName) {
        return CompletableFuture.supplyAsync(() -> {
            try (Logger.LoggerScope logScope = Logger.enterScope(TAG, this.getCtx(), "createResolvedEntityAsync");){
                CdmFolderDefinition folder;
                ResolveOptions tmpResOpt = resOpt;
                if (tmpResOpt == null) {
                    tmpResOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
                }
                if (tmpResOpt.getWrtDoc() == null) {
                    Logger.error(this.getCtx(), TAG, "createResolvedEntityAsync", this.getAtCorpusPath(), CdmLogCode.ErrDocWrtDocNotfound, new String[0]);
                    CdmEntityDefinition cdmEntityDefinition = null;
                    return cdmEntityDefinition;
                }
                if (StringUtils.isNullOrEmpty(newEntName)) {
                    Logger.error(this.getCtx(), TAG, "createResolvedEntityAsync", this.getAtCorpusPath(), CdmLogCode.ErrResolveNewEntityNameNotSet, new String[0]);
                    CdmEntityDefinition cdmEntityDefinition = null;
                    return cdmEntityDefinition;
                }
                ResolveOptions finalResOpt = tmpResOpt;
                CdmFolderDefinition cdmFolderDefinition = folder = folderDef != null ? folderDef : (CdmFolderDefinition)this.getInDocument().getOwner();
                if (!finalResOpt.getWrtDoc().indexIfNeededAsync(finalResOpt, true).join().booleanValue()) {
                    Logger.error(this.getCtx(), TAG, "createResolvedEntityAsync", this.getAtCorpusPath(), CdmLogCode.ErrIndexFailed, new String[0]);
                    CdmEntityDefinition cdmEntityDefinition = null;
                    return cdmEntityDefinition;
                }
                String fileName = StringUtils.isNullOrEmpty(newDocName) ? String.format("%s.cdm.json", newEntName) : newDocName;
                String origDoc = this.getInDocument().getAtCorpusPath();
                String targetAtCorpusPath = String.format("%s%s", this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(folder.getAtCorpusPath(), folder), fileName);
                if (StringUtils.equalsWithIgnoreCase(targetAtCorpusPath, origDoc)) {
                    Logger.error(this.getCtx(), TAG, "createResolvedEntityAsync", this.getAtCorpusPath(), CdmLogCode.ErrDocEntityReplacementFailure, targetAtCorpusPath);
                    CdmEntityDefinition cdmEntityDefinition = null;
                    return cdmEntityDefinition;
                }
                this.getCtx().getCorpus().prepareArtifactAttributesAsync().join();
                boolean wasResolving = this.getCtx().getCorpus().isCurrentlyResolving;
                this.getCtx().getCorpus().isCurrentlyResolving = true;
                String entName = newEntName;
                ResolveContext ctx = (ResolveContext)this.getCtx();
                CdmAttributeContext attCtxEnt = (CdmAttributeContext)ctx.getCorpus().makeObject(CdmObjectType.AttributeContextDef, entName, true);
                attCtxEnt.setCtx(ctx);
                attCtxEnt.setInDocument(this.getInDocument());
                AttributeContextParameters acp = new AttributeContextParameters();
                acp.setUnder(attCtxEnt);
                acp.setType(CdmAttributeContextType.AttributeGroup);
                acp.setName("attributeContext");
                CdmAttributeContext attCtxAC = CdmAttributeContext.createChildUnder(finalResOpt, acp);
                CdmEntityReference entRefThis = (CdmEntityReference)ctx.getCorpus().makeObject(CdmObjectType.EntityRef, this.getName(), true);
                entRefThis.setOwner(this);
                entRefThis.setInDocument(this.getInDocument());
                CdmObject prevOwner = this.getOwner();
                entRefThis.setExplicitReference(this);
                this.setOwner(prevOwner);
                AttributeContextParameters acpEnt = new AttributeContextParameters();
                acpEnt.setUnder(attCtxAC);
                acpEnt.setType(CdmAttributeContextType.Entity);
                acpEnt.setName(entName);
                acpEnt.setRegarding(entRefThis);
                finalResOpt.depthInfo.reset();
                ResolveOptions resOptCopy = CdmAttributeContext.prepareOptionsForResolveAttributes(finalResOpt);
                ResolvedAttributeSet ras = this.fetchResolvedAttributes(resOptCopy, acpEnt);
                if (resOptCopy.usedResolutionGuidance) {
                    Logger.warning(this.getCtx(), TAG, "createResolvedEntityAsync", this.getAtCorpusPath(), CdmLogCode.WarnDeprecatedResolutionGuidance, new String[0]);
                }
                if (ras == null) {
                    CdmEntityDefinition cdmEntityDefinition = null;
                    return cdmEntityDefinition;
                }
                this.getCtx().getCorpus().isCurrentlyResolving = wasResolving;
                folder.getDocuments().remove(fileName);
                CdmDocumentDefinition docRes = folder.getDocuments().add(fileName);
                origDoc = this.getCtx().getCorpus().getStorage().createRelativeCorpusPath(origDoc, docRes);
                docRes.getImports().add(origDoc, "resolvedFrom");
                if (this.getInDocument().getImports().item("cdm:/foundations.cdm.json") != null) {
                    docRes.getImports().add("cdm:/foundations.cdm.json");
                }
                docRes.setDocumentVersion(this.getInDocument().getDocumentVersion());
                CdmEntityDefinition entResolved = docRes.getDefinitions().add(entName);
                CdmAttributeContext attCtx = null;
                if (attCtxAC != null && attCtxAC.getContents() != null && attCtxAC.getContents().size() == 1) {
                    attCtx = (CdmAttributeContext)attCtxAC.getContents().get(0);
                }
                entResolved.setAttributeContext(attCtx);
                if (attCtx != null) {
                    attCtx.finalizeAttributeContext(resOptCopy, String.format("%s/attributeContext/", entName), docRes, this.getInDocument(), "resolvedFrom", true);
                }
                ResolvedTraitSet rtsEnt = this.fetchResolvedTraits(finalResOpt);
                for (ResolvedTrait rt : rtsEnt.getSet()) {
                    CdmTraitReference traitRef = CdmObjectBase.resolvedTraitToTraitRef(resOptCopy, rt);
                    entResolved.getExhibitsTraits().add(traitRef);
                    traitRef = CdmObjectBase.resolvedTraitToTraitRef(resOptCopy, rt);
                    if (entResolved.getAttributeContext() == null) continue;
                    entResolved.getAttributeContext().getExhibitsTraits().add(traitRef);
                }
                entResolved.indicateAbstractionLevel("resolved", finalResOpt);
                if (entResolved.getAttributeContext() != null) {
                    LinkedHashMap<String, Integer> attPath2Order = new LinkedHashMap<String, Integer>();
                    LinkedHashSet<String> finishedGroups = new LinkedHashSet<String>();
                    LinkedHashSet<CdmAttributeContext> allPrimaryCtx = new LinkedHashSet<CdmAttributeContext>();
                    this.pointContextAtResolvedAtts(ras, entName + "/hasAttributes/", allPrimaryCtx, attPath2Order, finishedGroups);
                    if (!attCtx.pruneToScope(allPrimaryCtx)) {
                        CdmEntityDefinition cdmEntityDefinition = null;
                        return cdmEntityDefinition;
                    }
                    this.orderContents(attCtx, attPath2Order);
                    LinkedHashMap<CdmAttributeContext, HashSet<String>> ctx2traitNames = new LinkedHashMap<CdmAttributeContext, HashSet<String>>();
                    this.collectContextTraits(attCtx, new LinkedHashSet<String>(), ctx2traitNames);
                    LinkedHashMap<ResolvedAttribute, String> resAtt2RefPath = new LinkedHashMap<ResolvedAttribute, String>();
                    this.addAttributes(ras, entResolved, entName + "/hasAttributes/", docRes, ctx2traitNames, resOptCopy, resAtt2RefPath);
                    if (entResolved.getExhibitsTraits() != null) {
                        for (CdmTraitReferenceBase et : entResolved.getExhibitsTraits()) {
                            if (!(et instanceof CdmTraitReference)) continue;
                            this.replaceTraitAttRef((CdmTraitReference)et, newEntName, false);
                        }
                    }
                    this.fixContextTraits(attCtx, newEntName);
                    CdmCollection<CdmAttributeItem> entAttributes = entResolved.getAttributes();
                    if (entAttributes != null) {
                        entAttributes.forEach(entAtt -> {
                            CdmTraitCollection attTraits = entAtt.getAppliedTraits();
                            if (attTraits != null) {
                                attTraits.forEach(tr -> {
                                    if (tr instanceof CdmTraitReference) {
                                        this.replaceTraitAttRef((CdmTraitReference)tr, newEntName, false);
                                    }
                                });
                            }
                        });
                    }
                }
                if (attCtx != null) {
                    attCtx.setParent(null);
                }
                ResolveOptions resOptNew = finalResOpt.copy();
                resOptNew.setLocalizeReferencesFor(docRes);
                resOptNew.setWrtDoc(docRes);
                docRes.refreshAsync(resOptNew).join();
                entResolved = (CdmEntityDefinition)docRes.fetchObjectFromDocumentPath(newEntName, resOptNew);
                this.getCtx().getCorpus().resEntMap.put(this.getAtCorpusPath(), entResolved.getAtCorpusPath());
                CdmEntityDefinition cdmEntityDefinition = entResolved;
                return cdmEntityDefinition;
            }
        });
    }

    private void pointContextAtResolvedAtts(ResolvedAttributeSet rasSub, String path, Set<CdmAttributeContext> allPrimaryCtx, Map<String, Integer> attPath2Order, Set<String> finishedGroups) {
        rasSub.getSet().forEach(ra -> {
            CdmAttributeContext raCtx = ra.getAttCtx();
            CdmCollection<CdmObject> refs = raCtx.getContents();
            allPrimaryCtx.add(raCtx);
            String attRefPath = path + ra.getResolvedName();
            if (ra.getTarget() instanceof CdmAttribute) {
                if (!attPath2Order.containsKey(attRefPath)) {
                    CdmObjectReference attRef = (CdmObjectReference)this.getCtx().getCorpus().makeObject(CdmObjectType.AttributeRef, attRefPath, true);
                    attPath2Order.put(attRef.getNamedReference(), ra.getInsertOrder());
                    raCtx.getContents().add(attRef);
                }
            } else if (!finishedGroups.contains(attRefPath = attRefPath + "/members/")) {
                this.pointContextAtResolvedAtts((ResolvedAttributeSet)ra.getTarget(), attRefPath, allPrimaryCtx, attPath2Order, finishedGroups);
                finishedGroups.add(attRefPath);
            }
        });
    }

    private boolean cleanSubGroup(CdmObject subItem, HashSet<CdmAttributeContext> nodesToSave) {
        if (subItem.getObjectType() == CdmObjectType.AttributeRef) {
            return true;
        }
        CdmAttributeContext ac = (CdmAttributeContext)subItem;
        if (!nodesToSave.contains(ac)) {
            return false;
        }
        if (ac.getContents() != null && ac.getContents().size() > 0) {
            ArrayList<CdmObject> newContent = new ArrayList<CdmObject>();
            for (CdmObject sub : ac.getContents()) {
                if (!this.cleanSubGroup(sub, nodesToSave)) continue;
                newContent.add(sub);
            }
            ac.getContents().allItems.clear();
            ac.getContents().allItems.addAll(newContent);
        }
        return true;
    }

    private Integer orderContents(CdmAttributeContext under, Map<String, Integer> attPath2Order) {
        if (under.getLowestOrder() == null) {
            under.setLowestOrder(-1);
            if (under.getContents().size() == 1) {
                under.setLowestOrder(this.getOrderNum(under.getContents().get(0), attPath2Order));
            } else {
                under.getContents().sort((l, r) -> {
                    Integer rNum;
                    Integer lNum = this.getOrderNum((CdmObject)l, attPath2Order);
                    if (lNum == null) {
                        lNum = -1;
                    }
                    if ((rNum = this.getOrderNum((CdmObject)r, attPath2Order)) == null) {
                        rNum = -1;
                    }
                    if (lNum != -1 && (under.getLowestOrder() == -1 || lNum < under.getLowestOrder())) {
                        under.setLowestOrder(lNum);
                    }
                    if (rNum != -1 && (under.getLowestOrder() == -1 || rNum < under.getLowestOrder())) {
                        under.setLowestOrder(rNum);
                    }
                    return lNum - rNum;
                });
            }
        }
        return under.getLowestOrder();
    }

    private Integer getOrderNum(CdmObject item, Map<String, Integer> attPath2Order) {
        if (item.getObjectType() == CdmObjectType.AttributeContextDef) {
            return this.orderContents((CdmAttributeContext)item, attPath2Order);
        }
        if (item.getObjectType() == CdmObjectType.AttributeRef) {
            String attName = ((CdmAttributeReference)item).getNamedReference();
            int o = attPath2Order.get(attName);
            return o;
        }
        return -1;
    }

    private void collectContextTraits(CdmAttributeContext subAttCtx, HashSet<String> inheritedTraitNames, Map<CdmAttributeContext, HashSet<String>> ctx2traitNames) {
        LinkedHashSet<String> traitNamesHere = new LinkedHashSet<String>(inheritedTraitNames);
        CdmTraitCollection traitsHere = subAttCtx.getExhibitsTraits();
        if (traitsHere != null) {
            traitsHere.forEach(tat -> traitNamesHere.add(tat.getNamedReference()));
        }
        ctx2traitNames.put(subAttCtx, traitNamesHere);
        for (CdmObject cr : subAttCtx.getContents().getAllItems()) {
            if (cr.getObjectType() != CdmObjectType.AttributeContextDef) continue;
            this.collectContextTraits((CdmAttributeContext)cr, traitNamesHere, ctx2traitNames);
        }
    }

    private void addAttributes(ResolvedAttributeSet rasSub, Object container, String path, CdmDocumentDefinition docRes, Map<CdmAttributeContext, HashSet<String>> ctx2traitNames, ResolveOptions resOptCopy, Map<ResolvedAttribute, String> resAtt2RefPath) {
        rasSub.getSet().forEach(ra -> {
            String attPath = path + ra.getResolvedName();
            CdmAttributeContext raCtx = ra.getAttCtx();
            Object target = ra.getTarget();
            if (target instanceof ResolvedAttributeSet) {
                CdmAttributeGroupDefinition attGrp = (CdmAttributeGroupDefinition)this.getCtx().getCorpus().makeObject(CdmObjectType.AttributeGroupDef, ra.getResolvedName(), false);
                attGrp.setAttributeContext((CdmAttributeContextReference)this.getCtx().getCorpus().makeObject(CdmObjectType.AttributeContextRef, raCtx.getAtCorpusPath(), true));
                HashSet avoidSet = (HashSet)ctx2traitNames.get(raCtx);
                avoidSet.clear();
                ResolvedTraitSet rtsAtt = ra.getResolvedTraits();
                rtsAtt.getSet().forEach(rt -> {
                    if (!(rt.getTrait().getUgly() != null && (rt.getTrait().getUgly() == null || rt.getTrait().getUgly().booleanValue()) || avoidSet != null && avoidSet.contains(rt.getTraitName()))) {
                        CdmTraitReference traitRef = CdmObjectBase.resolvedTraitToTraitRef(resOptCopy, rt);
                        attGrp.getExhibitsTraits().add(traitRef);
                    }
                });
                CdmAttributeGroupReference attGrpRef = (CdmAttributeGroupReference)this.getCtx().getCorpus().makeObject(CdmObjectType.AttributeGroupRef, null, false);
                attGrpRef.setExplicitReference(attGrp);
                if (container instanceof CdmEntityDefinition) {
                    ((CdmEntityDefinition)container).addAttributeDef(attGrpRef);
                } else if (container instanceof CdmAttributeGroupDefinition) {
                    ((CdmAttributeGroupDefinition)container).addAttributeDef(attGrpRef);
                }
                this.addAttributes((ResolvedAttributeSet)ra.getTarget(), attGrp, attPath + "/members/", docRes, ctx2traitNames, resOptCopy, resAtt2RefPath);
            } else {
                CdmTypeAttributeDefinition att = (CdmTypeAttributeDefinition)this.getCtx().getCorpus().makeObject(CdmObjectType.TypeAttributeDef, ra.getResolvedName(), false);
                att.setAttributeContext((CdmAttributeContextReference)this.getCtx().getCorpus().makeObject(CdmObjectType.AttributeContextRef, raCtx.getAtCorpusPath(), true));
                HashSet avoidSet = (HashSet)ctx2traitNames.get(raCtx);
                avoidSet.clear();
                ResolvedTraitSet rtsAtt = ra.getResolvedTraits();
                rtsAtt.getSet().forEach(rt -> {
                    if (!(rt.getTrait().getUgly() != null && rt.getTrait().getUgly().booleanValue() || avoidSet != null && avoidSet.contains(rt.getTraitName()))) {
                        CdmTraitReference traitRef = CdmObjectBase.resolvedTraitToTraitRef(resOptCopy, rt);
                        att.getAppliedTraits().add(traitRef);
                        if (rt.getTraitName().equals("is.linkedEntity.identifier")) {
                            List<List<String>> linkTable = null;
                            if (traitRef.getArguments() != null && traitRef.getArguments().size() > 0) {
                                CdmArgumentCollection args = traitRef.getArguments();
                                CdmEntityReference cdmEntityReference = args != null ? (CdmEntityReference)((CdmArgumentDefinition)args.get(0)).getValue() : null;
                                CdmConstantEntityDefinition constantEntDef = cdmEntityReference != null ? (CdmConstantEntityDefinition)cdmEntityReference.getExplicitReference() : null;
                                List<List<String>> list = linkTable = constantEntDef != null ? constantEntDef.getConstantValues() : null;
                            }
                            if (linkTable != null && linkTable.size() > 0) {
                                for (List list : linkTable) {
                                    if (list.size() != 2 && list.size() != 3) continue;
                                    String fixedPath = (String)list.get(0);
                                    fixedPath = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(fixedPath, this.getInDocument());
                                    fixedPath = this.getCtx().getCorpus().getStorage().createRelativeCorpusPath(fixedPath, docRes);
                                    list.set(0, fixedPath);
                                }
                            }
                        }
                    }
                });
                CdmDataFormat impliedDataFormat = att.fetchDataFormat();
                if (impliedDataFormat != CdmDataFormat.Unknown) {
                    att.updateDataFormat(impliedDataFormat);
                }
                if (container instanceof CdmEntityDefinition) {
                    ((CdmEntityDefinition)container).addAttributeDef(att);
                } else if (container instanceof CdmAttributeGroupDefinition) {
                    ((CdmAttributeGroupDefinition)container).addAttributeDef(att);
                }
                resAtt2RefPath.put((ResolvedAttribute)ra, attPath);
            }
        });
    }

    private void replaceTraitAttRef(CdmTraitReference tr, String entityHint, boolean isAttributeContext) {
        if (tr.getArguments() != null) {
            for (CdmArgumentDefinition argumentDef : tr.getArguments().getAllItems()) {
                CdmAttributeReference attRef;
                CdmArgumentDefinition arg = argumentDef;
                Object v = arg.getUnResolvedValue() != null ? arg.getUnResolvedValue() : arg.getValue();
                if (!(v instanceof CdmObject) || ((CdmObject)v).getObjectType() != CdmObjectType.AttributeRef || StringUtils.isNullOrEmpty((attRef = (CdmAttributeReference)v).getNamedReference()) || attRef.getNamedReference().indexOf(47) != -1) continue;
                if (arg.getUnResolvedValue() == null) {
                    arg.setUnResolvedValue(arg.getValue());
                }
                CdmAttributeReference newAttRef = (CdmAttributeReference)this.getCtx().getCorpus().makeRef(CdmObjectType.AttributeRef, entityHint + "/(resolvedAttributes)/" + attRef.getNamedReference(), true);
                newAttRef.setInDocument(arg.getInDocument());
                arg.setValue(newAttRef);
            }
        }
    }

    private void fixContextTraits(CdmAttributeContext subAttCtx, String entityHint) {
        CdmTraitCollection traitsHere = subAttCtx.getExhibitsTraits();
        if (traitsHere != null) {
            traitsHere.forEach(tr -> {
                if (tr instanceof CdmTraitReference) {
                    this.replaceTraitAttRef((CdmTraitReference)tr, entityHint, true);
                }
            });
        }
        subAttCtx.getContents().getAllItems().forEach(cr -> {
            if (cr.getObjectType() == CdmObjectType.AttributeContextDef) {
                CdmAttributeContext subSubAttCtx = (CdmAttributeContext)cr;
                String subEntityHint = entityHint;
                if (subSubAttCtx.getType() == CdmAttributeContextType.Entity && subSubAttCtx.getDefinition() != null) {
                    subEntityHint = subSubAttCtx.getDefinition().getNamedReference();
                }
                this.fixContextTraits(subSubAttCtx, subEntityHint);
            }
        });
    }

    ResolvedAttributeSet getAttributesWithTraits(ResolveOptions resOpt, Object queryFor) {
        try {
            ResolvedAttributeSet resolvedAttributeSet = this.fetchResolvedAttributes(resOpt);
            if (resolvedAttributeSet != null) {
                return resolvedAttributeSet.fetchAttributesWithTraits(resOpt, queryFor);
            }
        }
        catch (IOException ex) {
            Logger.error(this.getCtx(), TAG, "getAttributesWithTraits", this.getAtCorpusPath(), CdmLogCode.ErrTraitAttrFetchError, ex.getLocalizedMessage());
        }
        return null;
    }

    public String getPrimaryKey() {
        return (String)this.t2pm.fetchPropertyValue(CdmPropertyName.PRIMARY_KEY);
    }

    boolean getIsResolved() {
        return (Boolean)this.t2pm.fetchPropertyValue(CdmPropertyName.IS_RESOLVED);
    }

    @Deprecated
    public Object getProperty(CdmPropertyName propertyName) {
        return this.t2pm.fetchPropertyValue(propertyName, true);
    }

    TraitToPropertyMap getTraitToPropertyMap() {
        return this.t2pm;
    }

    private CompletableFuture<List<?>> queryOnTraitsAsync(Object querySpec) {
        return null;
    }

    @Deprecated
    public ResolvedEntity getResolvedEntity(ResolveOptions resOpt) {
        return new ResolvedEntity(this, resOpt);
    }

    @Override
    public boolean visit(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        String path = this.fetchDeclaredPath(pathFrom);
        if (preChildren != null && preChildren.invoke(this, path)) {
            return false;
        }
        if (this.getExtendsEntity() != null && this.getExtendsEntity().visit(path + "/extendsEntity/", preChildren, postChildren)) {
            return true;
        }
        if (this.getExtendsEntityResolutionGuidance() != null) {
            this.getExtendsEntityResolutionGuidance().setOwner(this);
            if (this.getExtendsEntityResolutionGuidance().visit(pathFrom + "/extendsEntityResolutionGuidance/", preChildren, postChildren)) {
                return true;
            }
        }
        if (this.visitDef(path, preChildren, postChildren)) {
            return true;
        }
        if (this.getAttributeContext() != null) {
            this.getAttributeContext().setOwner(this);
            if (this.getAttributeContext().visit(path + "/attributeContext/", preChildren, postChildren)) {
                return true;
            }
        }
        if (this.getAttributes() != null && this.attributes.visitList(path + "/hasAttributes/", preChildren, postChildren)) {
            return true;
        }
        return postChildren != null && postChildren.invoke(this, path);
    }

    @Override
    public boolean validate() {
        if (StringUtils.isNullOrTrimEmpty(this.entityName)) {
            ArrayList<String> missingFields = new ArrayList<String>(Arrays.asList("entityName"));
            Logger.error(this.getCtx(), TAG, "validate", this.getAtCorpusPath(), CdmLogCode.ErrValdnIntegrityCheckFailure, this.getAtCorpusPath(), String.join((CharSequence)", ", missingFields.parallelStream().map(s -> String.format("'%s'", s)).collect(Collectors.toList())));
            return false;
        }
        return true;
    }

    @Override
    public Object copyData(ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectBase.copyData(this, resOpt, options, CdmEntityDefinition.class);
    }

    @Override
    @Deprecated
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        CdmEntityDefinition copy;
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        if (host == null) {
            copy = new CdmEntityDefinition(this.getCtx(), this.getEntityName(), null);
        } else {
            copy = (CdmEntityDefinition)host;
            copy.setEntityName(this.getEntityName());
            copy.getAttributes().clear();
        }
        copy.setExtendsEntity(this.getExtendsEntity() != null ? (CdmEntityReference)this.getExtendsEntity().copy(resOpt) : null);
        copy.setExtendsEntityResolutionGuidance(this.getExtendsEntityResolutionGuidance() != null ? (CdmAttributeResolutionGuidance)this.getExtendsEntityResolutionGuidance().copy(resOpt) : null);
        copy.setAttributeContext(this.getAttributeContext() != null ? (CdmAttributeContext)this.getAttributeContext().copy(resOpt) : null);
        for (CdmAttributeItem hasAttribute : this.getAttributes()) {
            copy.getAttributes().add((CdmAttributeItem)hasAttribute.copy(resOpt));
        }
        this.copyDef(resOpt, copy);
        return copy;
    }

    @Override
    public ResolvedEntityReferenceSet fetchResolvedEntityReferences(ResolveOptions resOpt) {
        boolean wasPreviouslyResolving = this.getCtx().getCorpus().isCurrentlyResolving;
        this.getCtx().getCorpus().isCurrentlyResolving = true;
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        resOpt = resOpt.copy();
        LinkedHashSet<String> LinkedHashSet2 = new LinkedHashSet<String>();
        LinkedHashSet2.add("normalized");
        LinkedHashSet2.add("referenceOnly");
        resOpt = resOpt.copy();
        resOpt.setDirectives(new AttributeResolutionDirectiveSet(LinkedHashSet2));
        ResolvedEntityReferenceSet entRefSet = new ResolvedEntityReferenceSet(resOpt);
        if (!this.resolvingEntityReferences) {
            ResolvedEntityReferenceSet inherited;
            CdmEntityDefinition extDef;
            this.resolvingEntityReferences = true;
            CdmEntityReference extRef = this.extendsEntity;
            if (extRef != null && (extDef = (CdmEntityDefinition)extRef.fetchObjectDefinition(resOpt)) != null && (inherited = extDef.fetchResolvedEntityReferences(resOpt)) != null) {
                for (ResolvedEntityReference res : inherited.getSet()) {
                    ResolvedEntityReference resolvedEntityReference = res.copy();
                    resolvedEntityReference.getReferencing().setEntity(this);
                    entRefSet.getSet().add(resolvedEntityReference);
                }
            }
            if (this.getAttributes() != null) {
                for (int i = 0; i < this.getAttributes().getCount(); ++i) {
                    ResolvedEntityReferenceSet sub = this.getAttributes().getAllItems().get(i).fetchResolvedEntityReferences(resOpt);
                    if (sub == null) continue;
                    for (ResolvedEntityReference res : sub.getSet()) {
                        res.getReferencing().setEntity(this);
                    }
                    entRefSet.add(sub);
                }
            }
            this.resolvingEntityReferences = false;
        }
        this.getCtx().getCorpus().isCurrentlyResolving = wasPreviouslyResolving;
        return entRefSet;
    }

    CdmAttributeItem addAttributeDef(CdmAttributeItem attributeDef) {
        this.getAttributes().add(attributeDef);
        return attributeDef;
    }

    @Deprecated
    public void indicateAbstractionLevel(String level, ResolveOptions resOpt) {
        CdmArgumentDefinition argDef;
        if (resOpt != null && this.getCtx().getCorpus().resolveSymbolReference(resOpt, this.getInDocument(), "has.entitySchemaAbstractionLevel", CdmObjectType.TraitDef, false) == null) {
            return;
        }
        CdmTraitReference traitRef = (CdmTraitReference)this.getExhibitsTraits().item("has.entitySchemaAbstractionLevel");
        if (traitRef == null) {
            traitRef = new CdmTraitReference(this.getCtx(), "has.entitySchemaAbstractionLevel", false, true);
            this.getExhibitsTraits().add(traitRef);
        }
        if (traitRef.getArguments() != null && traitRef.getArguments().size() == 1) {
            argDef = (CdmArgumentDefinition)traitRef.getArguments().get(0);
        } else {
            argDef = new CdmArgumentDefinition(this.getCtx(), "level");
            traitRef.getArguments().add(argDef);
        }
        argDef.setValue(level);
    }
}

