/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder;

import com.fasterxml.jackson.databind.JsonNode;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmArgumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDefinitionCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDocumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmFolderDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReference;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.AttributeGroupPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.ConstantEntityPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.DataTypePersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.EntityPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.ImportPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.PurposePersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.TraitGroupPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.TraitPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.Utils;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.DataType;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.DocumentContent;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.Import;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.JMapper;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;

public class DocumentPersistence {
    private static final String TAG = DocumentPersistence.class.getSimpleName();
    public static final boolean isPersistenceAsync = false;
    public static final String[] formats = new String[]{".cdm.json"};
    public static final String jsonSemanticVersion = CdmDocumentDefinition.getCurrentJsonSchemaSemanticVersion();

    public static CdmDocumentDefinition fromObject(CdmCorpusContext ctx, String name, String nameSpace, String path, DocumentContent obj) {
        CdmDocumentDefinition doc = (CdmDocumentDefinition)ctx.getCorpus().makeObject(CdmObjectType.DocumentDef);
        doc.setFolderPath(path);
        doc.setNamespace(nameSpace);
        if (!StringUtils.isBlankByCdmStandard(obj.getSchema())) {
            doc.setSchema(obj.getSchema());
        }
        if (!StringUtils.isBlankByCdmStandard(obj.getDocumentVersion())) {
            doc.setDocumentVersion(obj.getDocumentVersion());
        }
        if (obj.getImports() != null) {
            for (Import imp : obj.getImports()) {
                doc.getImports().add(ImportPersistence.fromData(ctx, imp));
            }
        }
        if (obj.getDefinitions() != null) {
            for (int i = 0; i < obj.getDefinitions().size(); ++i) {
                CdmDefinitionCollection definitions = doc.getDefinitions();
                JsonNode d = obj.getDefinitions().get(i);
                if (d.has("dataTypeName")) {
                    definitions.add(DataTypePersistence.fromData(ctx, (DataType)JMapper.MAP.convertValue((Object)d, DataType.class)));
                    continue;
                }
                if (d.has("purposeName")) {
                    definitions.add(PurposePersistence.fromData(ctx, d));
                    continue;
                }
                if (d.has("attributeGroupName")) {
                    definitions.add(AttributeGroupPersistence.fromData(ctx, d));
                    continue;
                }
                if (d.has("traitName")) {
                    definitions.add(TraitPersistence.fromData(ctx, d));
                    continue;
                }
                if (d.has("traitGroupName")) {
                    definitions.add(TraitGroupPersistence.fromData(ctx, d));
                    continue;
                }
                if (d.has("entityShape")) {
                    definitions.add(ConstantEntityPersistence.fromData(ctx, d));
                    continue;
                }
                if (!d.has("entityName")) continue;
                definitions.add(EntityPersistence.fromData(ctx, d));
            }
        }
        boolean isResolvedDoc = false;
        if (doc.getDefinitions().getCount() == 1 && ((CdmObjectDefinition)doc.getDefinitions().get(0)).getObjectType() == CdmObjectType.EntityDef) {
            CdmEntityDefinition entity = (CdmEntityDefinition)doc.getDefinitions().get(0);
            CdmTraitReference resolvedTrait = (CdmTraitReference)entity.getExhibitsTraits().item("has.entitySchemaAbstractionLevel");
            isResolvedDoc = resolvedTrait != null && "resolved".equals(((CdmArgumentDefinition)resolvedTrait.getArguments().get(0)).getValue());
            boolean bl = isResolvedDoc = isResolvedDoc || entity.getAttributeContext() != null;
        }
        if (!StringUtils.isBlankByCdmStandard(obj.getJsonSchemaSemanticVersion())) {
            doc.setJsonSchemaSemanticVersion(obj.getJsonSchemaSemanticVersion());
            if (DocumentPersistence.compareJsonSemanticVersion(ctx, doc.getJsonSchemaSemanticVersion()) > 0) {
                String message = "This ObjectModel version supports json semantic version " + jsonSemanticVersion + " at maximum.";
                message = message + " Trying to load a document with version " + doc.getJsonSchemaSemanticVersion() + ".";
                if (isResolvedDoc) {
                    Logger.warning(ctx, TAG, "fromObject", doc.getAtCorpusPath(), CdmLogCode.WarnPersistUnsupportedJsonSemVer, jsonSemanticVersion, doc.getJsonSchemaSemanticVersion());
                } else {
                    Logger.error(ctx, TAG, "fromObject", doc.getAtCorpusPath(), CdmLogCode.ErrPersistUnsupportedJsonSemVer, jsonSemanticVersion, doc.getJsonSchemaSemanticVersion());
                }
            }
        } else {
            Logger.warning(ctx, TAG, "fromObject", doc.getAtCorpusPath(), CdmLogCode.WarnPersistJsonSemVerMandatory, new String[0]);
        }
        return doc;
    }

    public static CdmDocumentDefinition fromData(CdmCorpusContext ctx, String docName, String jsonData, CdmFolderDefinition folder) {
        try {
            DocumentContent obj = (DocumentContent)JMapper.MAP.readValue(jsonData, DocumentContent.class);
            return DocumentPersistence.fromObject(ctx, docName, folder.getNamespace(), folder.getFolderPath(), obj);
        }
        catch (Exception e) {
            Logger.error(ctx, TAG, "fromData", null, CdmLogCode.ErrPersistDocConversionFailure, docName, e.getLocalizedMessage());
            return null;
        }
    }

    public static DocumentContent toData(CdmDocumentDefinition instance, ResolveOptions resOpt, CopyOptions options) {
        DocumentContent documentContent = new DocumentContent();
        documentContent.setSchema(instance.getSchema());
        documentContent.setJsonSchemaSemanticVersion(instance.getJsonSchemaSemanticVersion());
        documentContent.setImports(Utils.listCopyDataAsCdmObject(instance.getImports(), resOpt, options));
        documentContent.setDefinitions(Utils.listCopyDataAsCdmObject(instance.getDefinitions(), resOpt, options));
        documentContent.setDocumentVersion(instance.getDocumentVersion());
        return documentContent;
    }

    private static int compareJsonSemanticVersion(CdmCorpusContext ctx, String documentSemanticVersion) {
        String[] docSemanticVersionSplit = documentSemanticVersion.split("\\.");
        String[] currSemanticVersionSplit = jsonSemanticVersion.split("\\.");
        if (docSemanticVersionSplit.length != 3) {
            Logger.warning(ctx, TAG, "compareJsonSemanticVersion", null, CdmLogCode.WarnPersistJsonSemVerInvalidFormat, new String[0]);
            return 0;
        }
        for (int i = 0; i < 3; ++i) {
            if (docSemanticVersionSplit[i].equals(currSemanticVersionSplit[i])) continue;
            try {
                int version = Integer.parseInt(docSemanticVersionSplit[i]);
                return version < Integer.parseInt(currSemanticVersionSplit[i]) ? -1 : 1;
            }
            catch (NumberFormatException e) {
                Logger.warning(ctx, TAG, "compareJsonSemanticVersion", null, CdmLogCode.WarnPersistJsonSemVerInvalidFormat, new String[0]);
                return 0;
            }
        }
        return 0;
    }
}

