/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder;

import com.fasterxml.jackson.databind.JsonNode;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmPurposeReference;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.CdmObjectRefPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.PurposePersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.Utils;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;

public class PurposeReferencePersistence {
    public static CdmPurposeReference fromData(CdmCorpusContext ctx, JsonNode obj) {
        Object purpose;
        if (obj == null) {
            return null;
        }
        boolean simpleReference = true;
        Boolean optional = null;
        Object appliedTraits = null;
        if (obj.isValueNode()) {
            purpose = obj;
        } else {
            simpleReference = false;
            optional = Utils.propertyFromDataToBoolean(obj.get("optional"));
            purpose = obj.get("purposeReference").isValueNode() ? obj.get("purposeReference").asText() : PurposePersistence.fromData(ctx, obj.get("purposeReference"));
        }
        CdmPurposeReference purposeReference = (CdmPurposeReference)ctx.getCorpus().makeRef(CdmObjectType.PurposeRef, purpose, simpleReference);
        if (optional != null) {
            purposeReference.setOptional(optional);
        }
        if (!obj.isValueNode()) {
            Utils.addListToCdmCollection(purposeReference.getAppliedTraits(), Utils.createTraitReferenceList(ctx, obj.get("appliedTraits")));
        }
        return purposeReference;
    }

    public static Object toData(CdmPurposeReference instance, ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectRefPersistence.toData(instance, resOpt, options);
    }
}

