/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.persistence.modeljson;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDataPartitionDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDocumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityDeclarationDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmFolderDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmImport;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmLocalEntityDeclarationDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmManifestDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReference;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmPropertyName;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.DataPartitionPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.DocumentPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.ExtensionHelper;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.types.LocalEntity;
import com.microsoft.commondatamodel.objectmodel.persistence.modeljson.types.Partition;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.TraitToPropertyMap;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class LocalEntityDeclarationPersistence {
    private static final String TAG = LocalEntityDeclarationPersistence.class.getSimpleName();

    public static CompletableFuture<CdmEntityDeclarationDefinition> fromData(CdmCorpusContext ctx, CdmFolderDefinition documentFolder, LocalEntity obj, List<CdmTraitDefinition> extensionTraitDefList, CdmManifestDefinition manifest) {
        CdmLocalEntityDeclarationDefinition localEntity = (CdmLocalEntityDeclarationDefinition)ctx.getCorpus().makeObject(CdmObjectType.LocalEntityDeclarationDef, obj.getName());
        ArrayList<CdmTraitDefinition> localExtensionTraitDefList = new ArrayList<CdmTraitDefinition>();
        return DocumentPersistence.fromData(ctx, obj, extensionTraitDefList, localExtensionTraitDefList).thenCompose(entityDoc -> {
            List<Partition> partitions;
            documentFolder.getDocuments().add((CdmDocumentDefinition)entityDoc);
            localEntity.setEntityPath(ctx.getCorpus().getStorage().createRelativeCorpusPath(entityDoc.getAtCorpusPath() + "/" + obj.getName(), manifest));
            localEntity.setVirtualLocation(documentFolder.getFolderPath() + "model.json");
            localEntity.setExplanation(obj.getDescription());
            localEntity.setLastChildFileModifiedTime(obj.getLastChildFileModifiedTime());
            localEntity.setLastFileModifiedTime(obj.getLastFileModifiedTime());
            localEntity.setLastFileStatusCheckTime(obj.getLastFileStatusCheckTime());
            if (obj.isHidden() != null && obj.isHidden().booleanValue()) {
                CdmTraitReference isHiddenTrait = (CdmTraitReference)ctx.getCorpus().makeRef(CdmObjectType.TraitRef, "is.hidden", true);
                isHiddenTrait.setFromProperty(true);
                localEntity.getExhibitsTraits().add(isHiddenTrait);
            }
            if (obj.getSchemas() != null) {
                TraitToPropertyMap t2pm = new TraitToPropertyMap(localEntity);
                t2pm.updatePropertyValue(CdmPropertyName.CDM_SCHEMAS, obj.getSchemas());
            }
            if ((partitions = obj.getPartitions()) != null) {
                for (Partition element : partitions) {
                    CdmDataPartitionDefinition cdmPartition = DataPartitionPersistence.fromData(ctx, element, extensionTraitDefList, localExtensionTraitDefList, documentFolder).join();
                    if (cdmPartition != null) {
                        localEntity.getDataPartitions().add(cdmPartition);
                        continue;
                    }
                    Logger.error(ctx, TAG, "fromData", null, CdmLogCode.ErrPersistModelJsonDocConversionError, new String[0]);
                    return CompletableFuture.completedFuture(null);
                }
            }
            List<CdmImport> importDocs = ExtensionHelper.standardImportDetection(ctx, extensionTraitDefList, localExtensionTraitDefList).join();
            ExtensionHelper.addImportDocsToManifest(ctx, importDocs, entityDoc);
            return CompletableFuture.completedFuture(localEntity);
        });
    }

    public static CompletableFuture<LocalEntity> toData(CdmEntityDeclarationDefinition instance, CdmManifestDefinition manifest, ResolveOptions resOpt, CopyOptions options) {
        return DocumentPersistence.toData(instance.getEntityPath(), manifest, instance.getCtx(), resOpt, options).thenCompose(localEntity -> {
            if (localEntity != null) {
                Object propertyValues;
                TraitToPropertyMap t2pm = new TraitToPropertyMap(instance);
                CdmTraitReference isHiddenTrait = t2pm.fetchTraitReference("is.hidden");
                if (localEntity.getDescription() == null) {
                    localEntity.setDescription(instance.getExplanation());
                }
                localEntity.setLastChildFileModifiedTime(instance.getLastChildFileModifiedTime());
                localEntity.setLastFileModifiedTime(instance.getLastFileModifiedTime());
                localEntity.setLastFileStatusCheckTime(instance.getLastFileStatusCheckTime());
                if (isHiddenTrait != null) {
                    localEntity.setHidden(true);
                }
                if ((propertyValues = t2pm.fetchPropertyValue(CdmPropertyName.CDM_SCHEMAS)) instanceof ArrayList) {
                    ArrayList schemas = (ArrayList)propertyValues;
                    localEntity.setSchemas(schemas);
                }
                if (localEntity.getTraits() != null) {
                    localEntity.setTraits(localEntity.getTraits());
                }
                if (instance.getDataPartitions() != null && instance.getDataPartitions().getCount() > 0) {
                    localEntity.setPartitions(new ArrayList<Partition>());
                    for (CdmDataPartitionDefinition element : instance.getDataPartitions()) {
                        Partition partition = DataPartitionPersistence.toData(element, resOpt, options).join();
                        if (partition == null) continue;
                        localEntity.getPartitions().add(partition);
                    }
                }
                return CompletableFuture.completedFuture(localEntity);
            }
            return CompletableFuture.completedFuture(null);
        });
    }
}

