/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.storage;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.microsoft.commondatamodel.objectmodel.enums.AzureCloudEndpoint;
import com.microsoft.commondatamodel.objectmodel.storage.AdlsAdapterAuthenticator;
import com.microsoft.commondatamodel.objectmodel.storage.NetworkAdapter;
import com.microsoft.commondatamodel.objectmodel.storage.StorageAdapterException;
import com.microsoft.commondatamodel.objectmodel.utilities.CdmFileMetadata;
import com.microsoft.commondatamodel.objectmodel.utilities.JMapper;
import com.microsoft.commondatamodel.objectmodel.utilities.StorageUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.network.CdmHttpClient;
import com.microsoft.commondatamodel.objectmodel.utilities.network.CdmHttpRequest;
import com.microsoft.commondatamodel.objectmodel.utilities.network.CdmHttpResponse;
import com.microsoft.commondatamodel.objectmodel.utilities.network.TokenProvider;
import com.nimbusds.oauth2.sdk.util.MapUtils;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.http.client.utils.DateUtils;
import org.apache.http.entity.StringEntity;

public class AdlsAdapter
extends NetworkAdapter {
    protected static final Duration ADLS_DEFAULT_TIMEOUT = Duration.ofMillis(5000L);
    static final String TYPE = "adls";
    private static final String HTTP_XMS_CONTINUATION = "x-ms-continuation";
    private String root;
    private String hostname;
    private Map<String, String> adapterPaths = new LinkedHashMap<String, String>();
    private String formattedHostname = "";
    private String formattedHostnameNoProtocol = "";
    private String rootBlobContainer = "";
    private String unescapedRootSubPath = "";
    private String escapedRootSubPath = "";
    private int httpMaxResults = 5000;
    private Map<String, OffsetDateTime> fileModifiedTimeCache = new LinkedHashMap<String, OffsetDateTime>();
    private AdlsAdapterAuthenticator adlsAdapterAuthenticator;

    public AdlsAdapter(String hostname, String root, String tenant, String clientId, String secret) {
        this(hostname, root, tenant, clientId, secret, AzureCloudEndpoint.AzurePublic);
    }

    public AdlsAdapter(String hostname, String root, String tenant, String clientId, String secret, AzureCloudEndpoint endpoint) {
        this();
        this.updateRoot(root);
        this.updateHostname(hostname);
        this.adlsAdapterAuthenticator.setTenant(tenant);
        this.adlsAdapterAuthenticator.setClientId(clientId);
        this.adlsAdapterAuthenticator.setSecret(secret);
        this.adlsAdapterAuthenticator.setEndpoint(endpoint);
    }

    public AdlsAdapter(String hostname, String root, String sharedKey) {
        this();
        this.updateRoot(root);
        this.updateHostname(hostname);
        this.adlsAdapterAuthenticator.setSharedKey(sharedKey);
    }

    public AdlsAdapter(String hostname, String root, TokenProvider tokenProvider) {
        this();
        this.updateRoot(root);
        this.updateHostname(hostname);
        this.adlsAdapterAuthenticator.setTokenProvider(tokenProvider);
    }

    public AdlsAdapter(String hostname, String root) {
        this();
        this.updateRoot(root);
        this.updateHostname(hostname);
    }

    public AdlsAdapter() {
        this.httpClient = new CdmHttpClient();
        this.setTimeout(ADLS_DEFAULT_TIMEOUT);
        this.adlsAdapterAuthenticator = new AdlsAdapterAuthenticator();
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public CompletableFuture<String> readAsync(String corpusPath) {
        return CompletableFuture.supplyAsync(() -> {
            String url = this.createFormattedAdapterPath(corpusPath);
            CdmHttpRequest cdmHttpRequest = this.buildRequest(url, "GET");
            try {
                CdmHttpResponse res = this.executeRequest(cdmHttpRequest).get();
                return res != null ? res.getContent() : null;
            }
            catch (Exception e) {
                throw new StorageAdapterException("Could not read ADLS content at path: " + corpusPath + ". Reason: " + e.getMessage(), e);
            }
        });
    }

    @Override
    public boolean canWrite() {
        return true;
    }

    @Override
    public CompletableFuture<Void> writeAsync(String corpusPath, String data) {
        if (!this.ensurePath(this.root + corpusPath)) {
            throw new IllegalArgumentException("Could not create folder for document '" + corpusPath + "'");
        }
        return CompletableFuture.runAsync(() -> {
            block5: {
                String url = this.createFormattedAdapterPath(corpusPath);
                CdmHttpResponse response = this.createFileAtPath(corpusPath, url);
                try {
                    CdmHttpRequest request = this.buildRequest(url + "?action=append&position=0", "PATCH", data, "application/json; charset=utf-8");
                    response = this.executeRequest(request).get();
                    if (response.getStatusCode() == 202) {
                        request = this.buildRequest(url + "?action=flush&position=" + new StringEntity(data, StandardCharsets.UTF_8).getContentLength(), "PATCH");
                        response = this.executeRequest(request).get();
                        if (response.getStatusCode() != 200) {
                            this.deleteContentAtPath(corpusPath, url, null);
                            throw new StorageAdapterException("Could not write ADLS content at path, there was an issue at: " + corpusPath);
                        }
                        break block5;
                    }
                    this.deleteContentAtPath(corpusPath, url, null);
                    throw new StorageAdapterException("Could not write ADLS content at path, there was an issue at: " + corpusPath);
                }
                catch (StorageAdapterException ex) {
                    throw ex;
                }
                catch (Exception e) {
                    this.deleteContentAtPath(corpusPath, url, e);
                    throw new StorageAdapterException("Could not write ADLS content at path, there was an issue at: " + corpusPath, e);
                }
            }
        });
    }

    @Override
    public String createAdapterPath(String corpusPath) {
        if (corpusPath == null) {
            return null;
        }
        String formattedCorpusPath = this.formatCorpusPath(corpusPath);
        if (formattedCorpusPath == null) {
            return null;
        }
        if (this.adapterPaths.containsKey(formattedCorpusPath)) {
            return this.adapterPaths.get(formattedCorpusPath);
        }
        try {
            return "https://" + this.removeProtocolFromHostname(this.hostname) + this.getEscapedRoot() + this.escapePath(formattedCorpusPath);
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("Could not encode corpusPath: " + corpusPath + "." + e.getMessage());
            return null;
        }
    }

    @Override
    public String createCorpusPath(String adapterPath) {
        if (!StringUtils.isNullOrEmpty(adapterPath)) {
            int startIndex = "https://".length();
            int endIndex = adapterPath.indexOf(47, startIndex + 1);
            String hostname = "";
            try {
                hostname = this.formatHostname(adapterPath.substring(startIndex, endIndex));
            }
            catch (Exception ex) {
                throw new StorageAdapterException("Unexpected adapter path: " + adapterPath);
            }
            if (hostname.equals(this.formattedHostnameNoProtocol) && adapterPath.substring(endIndex).startsWith(this.getEscapedRoot())) {
                String escapedCorpusPath = adapterPath.substring(endIndex + this.getEscapedRoot().length());
                String corpusPath = "";
                try {
                    corpusPath = URLDecoder.decode(escapedCorpusPath, "UTF8");
                }
                catch (UnsupportedEncodingException e) {
                    System.err.println("Could not decode corpus path: " + escapedCorpusPath + "." + e.getMessage());
                    return null;
                }
                this.adapterPaths.putIfAbsent(corpusPath, adapterPath);
                return corpusPath;
            }
        }
        return null;
    }

    @Override
    public void clearCache() {
        this.fileModifiedTimeCache.clear();
    }

    @Override
    public CompletableFuture<OffsetDateTime> computeLastModifiedTimeAsync(String corpusPath) {
        return CompletableFuture.supplyAsync(() -> {
            OffsetDateTime cachedValue;
            OffsetDateTime offsetDateTime = cachedValue = this.getIsCacheEnabled() ? this.fileModifiedTimeCache.get(corpusPath) : null;
            if (cachedValue != null) {
                return cachedValue;
            }
            String url = this.createFormattedAdapterPath(corpusPath);
            CdmHttpRequest request = this.buildRequest(url, "HEAD");
            CdmHttpResponse cdmResponse = this.executeRequest(request).join();
            if (cdmResponse.getStatusCode() == 200) {
                OffsetDateTime lastTime = DateUtils.parseDate((String)cdmResponse.getResponseHeaders().get("Last-Modified")).toInstant().atOffset(ZoneOffset.UTC);
                if (this.getIsCacheEnabled()) {
                    this.fileModifiedTimeCache.put(corpusPath, lastTime);
                }
                return lastTime;
            }
            return null;
        });
    }

    @Override
    public CompletableFuture<List<String>> fetchAllFilesAsync(String folderCorpusPath) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap<String, CdmFileMetadata> filesMetadatas = this.fetchAllFilesMetadataAsync(folderCorpusPath).join();
            return new ArrayList<String>(filesMetadatas.keySet());
        });
    }

    @Override
    public CompletableFuture<HashMap<String, CdmFileMetadata>> fetchAllFilesMetadataAsync(String folderCorpusPath) {
        return CompletableFuture.supplyAsync(() -> {
            if (folderCorpusPath == null) {
                return null;
            }
            String url = "https://" + this.formattedHostnameNoProtocol + "/" + this.rootBlobContainer;
            String escapedFolderCorpusPath = null;
            try {
                escapedFolderCorpusPath = this.escapePath(folderCorpusPath);
            }
            catch (UnsupportedEncodingException e) {
                System.err.println("Could not encode corpus path: " + folderCorpusPath + "." + e.getMessage());
                return null;
            }
            String directory = this.escapedRootSubPath + this.formatCorpusPath(escapedFolderCorpusPath);
            if (directory.startsWith("/")) {
                directory = directory.substring(1);
            }
            HashMap<String, CdmFileMetadata> result = new HashMap<String, CdmFileMetadata>();
            String continuationToken = null;
            do {
                CdmHttpRequest request;
                if (continuationToken == null) {
                    request = this.buildRequest(url + "?directory=" + directory + "&maxResults=" + this.httpMaxResults + "&recursive=True&resource=filesystem", "GET");
                } else {
                    String escapedContinuationToken;
                    try {
                        escapedContinuationToken = URLEncoder.encode(continuationToken, "UTF8");
                    }
                    catch (UnsupportedEncodingException e) {
                        System.err.println("Could not encode continuationToken" + continuationToken + "' for the request.");
                        return result;
                    }
                    request = this.buildRequest(url + "?continuation=" + escapedContinuationToken + "&directory=" + directory + "&maxResults=" + this.httpMaxResults + "&recursive=True&resource=filesystem", "GET");
                }
                CdmHttpResponse cdmResponse = this.executeRequest(request).join();
                if (cdmResponse.getStatusCode() != 200) continue;
                continuationToken = cdmResponse.getResponseHeaders().containsKey(HTTP_XMS_CONTINUATION) ? cdmResponse.getResponseHeaders().get(HTTP_XMS_CONTINUATION) : null;
                String json = cdmResponse.getContent();
                try {
                    JsonNode jObject1 = JMapper.MAP.readTree(json);
                    JsonNode paths = jObject1.get("paths");
                    for (JsonNode path : paths) {
                        JsonNode isDirectory = path.get("isDirectory");
                        if (isDirectory != null && isDirectory.asBoolean() || !path.has("name")) continue;
                        String name = path.get("name").asText();
                        String nameWithoutSubPath = this.unescapedRootSubPath.length() > 0 && name.startsWith(this.unescapedRootSubPath) ? name.substring(this.unescapedRootSubPath.length() + 1) : name;
                        String filepath = this.formatCorpusPath(nameWithoutSubPath);
                        JsonNode contentLength = path.get("contentLength");
                        result.put(filepath, new CdmFileMetadata(contentLength.asLong()));
                        OffsetDateTime lastTime = DateUtils.parseDate((String)path.get("lastModified").asText()).toInstant().atOffset(ZoneOffset.UTC);
                        if (!this.getIsCacheEnabled()) continue;
                        this.fileModifiedTimeCache.put(filepath, lastTime);
                    }
                }
                catch (JsonProcessingException e) {
                    System.err.println("Unable to parse response content from request.");
                    return null;
                }
            } while (!StringUtils.isNullOrTrimEmpty(continuationToken));
            return result;
        });
    }

    private String createFormattedAdapterPath(String corpusPath) {
        String adapterPath = this.createAdapterPath(corpusPath);
        return adapterPath != null ? adapterPath.replace(this.hostname, this.formattedHostname) : null;
    }

    private String extractRootBlobContainerAndSubPath(String root) {
        if (StringUtils.isNullOrEmpty(root)) {
            this.rootBlobContainer = "";
            this.updateRootSubPath("");
            return "";
        }
        String prepRoot = root.charAt(0) == '/' ? root.substring(1) : root;
        String string = prepRoot = prepRoot.charAt(prepRoot.length() - 1) == '/' ? prepRoot.substring(0, prepRoot.length() - 1) : prepRoot;
        if (prepRoot.indexOf(47) == -1) {
            this.rootBlobContainer = prepRoot;
            this.updateRootSubPath("");
            return "/" + this.rootBlobContainer;
        }
        String[] prepRootArray = prepRoot.split("/");
        this.rootBlobContainer = prepRootArray[0];
        this.updateRootSubPath(Arrays.stream(prepRootArray).skip(1L).collect(Collectors.joining("/")));
        return "/" + this.rootBlobContainer + "/" + this.unescapedRootSubPath;
    }

    private String formatCorpusPath(String corpusPath) {
        ImmutablePair<String, String> pathTuple = StorageUtils.splitNamespacePath(corpusPath);
        if (pathTuple == null) {
            return null;
        }
        corpusPath = (String)pathTuple.getRight();
        if (corpusPath.length() > 0 && !corpusPath.startsWith("/")) {
            corpusPath = "/" + corpusPath;
        }
        return corpusPath;
    }

    private String formatHostname(String hostname) {
        String port;
        if ((hostname = hostname.replace(".blob.", ".dfs.")).contains(port = ":443")) {
            hostname = hostname.substring(0, hostname.length() - port.length());
        }
        return hostname;
    }

    private CdmHttpRequest buildRequest(String url, String method, String content, String contentType) {
        CdmHttpRequest request;
        try {
            if (this.adlsAdapterAuthenticator.getSasToken() == null) {
                Map<String, String> authenticationHeader = this.adlsAdapterAuthenticator.buildAuthenticationHeader(url, method, content, contentType);
                request = this.setUpCdmRequest(url, authenticationHeader, method);
            } else {
                request = this.setUpCdmRequest(this.adlsAdapterAuthenticator.buildSasAuthenticatedUrl(url), method);
            }
        }
        catch (UnsupportedEncodingException | URISyntaxException | InvalidKeyException | NoSuchAlgorithmException e) {
            throw new StorageAdapterException("Failed to build request", e);
        }
        if (content != null) {
            request.setContent(content);
            request.setContentType(contentType);
        }
        return request;
    }

    private CdmHttpRequest buildRequest(String url, String method, String content) {
        return this.buildRequest(url, method, content, null);
    }

    private CdmHttpRequest buildRequest(String url, String method) {
        return this.buildRequest(url, method, null);
    }

    private boolean ensurePath(String pathFor) {
        return pathFor.lastIndexOf("/") != -1;
    }

    private String escapePath(String unescapedPath) throws UnsupportedEncodingException {
        return URLEncoder.encode(unescapedPath, "UTF8").replace("%2F", "/").replace("+", "%20");
    }

    @Override
    public String fetchConfig() {
        ObjectNode resultConfig = JsonNodeFactory.instance.objectNode();
        resultConfig.put("type", TYPE);
        ObjectNode configObject = JsonNodeFactory.instance.objectNode();
        configObject.put("hostname", this.hostname);
        configObject.put("root", this.root);
        if (this.adlsAdapterAuthenticator.getClientId() != null && this.adlsAdapterAuthenticator.getTenant() != null) {
            configObject.put("tenant", this.adlsAdapterAuthenticator.getTenant());
            configObject.put("clientId", this.adlsAdapterAuthenticator.getClientId());
        }
        for (Map.Entry<String, JsonNode> stringJsonNodeEntry : this.fetchNetworkConfig().entrySet()) {
            configObject.set(stringJsonNodeEntry.getKey(), stringJsonNodeEntry.getValue());
        }
        String locationHint = this.getLocationHint();
        if (locationHint != null) {
            configObject.put("locationHint", locationHint);
        }
        if (this.adlsAdapterAuthenticator.getEndpoint() != null) {
            configObject.put("endpoint", this.adlsAdapterAuthenticator.getEndpoint().toString());
        }
        resultConfig.set("config", (JsonNode)configObject);
        try {
            return JMapper.WRITER.writeValueAsString((Object)resultConfig);
        }
        catch (JsonProcessingException e) {
            throw new StorageAdapterException("Failed to construct config string", (Exception)((Object)e));
        }
    }

    @Override
    public void updateConfig(String config) throws IOException {
        if (config == null) {
            throw new StorageAdapterException("ADLS adapter needs a config.");
        }
        this.updateNetworkConfig(config);
        JsonNode configsJson = JMapper.MAP.readTree(config);
        if (!configsJson.has("root")) {
            throw new StorageAdapterException("Root has to be set for ADLS adapter.");
        }
        this.updateRoot(configsJson.get("root").asText());
        if (!configsJson.has("hostname")) {
            throw new StorageAdapterException("Hostname has to be set for ADLS adapter.");
        }
        this.updateHostname(configsJson.get("hostname").asText());
        if (configsJson.has("tenant") && configsJson.has("clientId")) {
            this.adlsAdapterAuthenticator.setTenant(configsJson.get("tenant").asText());
            this.adlsAdapterAuthenticator.setClientId(configsJson.get("clientId").asText());
            if (this.getEndpoint() == null) {
                this.adlsAdapterAuthenticator.setEndpoint(AzureCloudEndpoint.AzurePublic);
            }
        }
        this.setLocationHint(configsJson.has("locationHint") ? configsJson.get("locationHint").asText() : null);
        if (configsJson.has("endpoint")) {
            String endpointStr = configsJson.get("endpoint").asText();
            try {
                AzureCloudEndpoint endpoint = AzureCloudEndpoint.valueOf(endpointStr);
                this.adlsAdapterAuthenticator.setEndpoint(endpoint);
            }
            catch (IllegalArgumentException ex) {
                throw new StorageAdapterException("Endpoint value should be a string of an enumeration value from the class AzureCloudEndpoint in Pascal case.");
            }
        }
    }

    private String getEscapedRoot() {
        return StringUtils.isNullOrEmpty(this.escapedRootSubPath) ? "/" + this.rootBlobContainer : "/" + this.rootBlobContainer + "/" + this.escapedRootSubPath;
    }

    private String removeProtocolFromHostname(String hostname) {
        if (!hostname.contains("://")) {
            return hostname;
        }
        try {
            URL outUri = new URL(hostname);
            if (outUri.getProtocol().equals("https")) {
                return hostname.substring("https://".length());
            }
            throw new IllegalArgumentException("ADLS Adapter only supports HTTPS, please provide a leading \"https://\" hostname or a non-protocol-relative hostname.");
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Please provide a valid hostname.");
        }
    }

    private void updateRoot(String value) {
        this.root = this.extractRootBlobContainerAndSubPath(value);
    }

    private void updateRootSubPath(String value) {
        this.unescapedRootSubPath = value;
        try {
            this.escapedRootSubPath = this.escapePath(this.unescapedRootSubPath);
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("Exception thrown when encoding path: " + this.unescapedRootSubPath + "." + e.getMessage());
            this.escapedRootSubPath = this.unescapedRootSubPath;
        }
    }

    public String getRoot() {
        return this.root;
    }

    private void updateHostname(String value) {
        if (StringUtils.isNullOrTrimEmpty(value)) {
            throw new IllegalArgumentException("Hostname cannot be null or whitespace.");
        }
        this.hostname = value;
        this.formattedHostname = this.formatHostname(this.hostname);
        this.formattedHostnameNoProtocol = this.formatHostname(this.removeProtocolFromHostname(this.hostname));
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getTenant() {
        return this.adlsAdapterAuthenticator.getTenant();
    }

    public String getClientId() {
        return this.adlsAdapterAuthenticator.getClientId();
    }

    public void setClientId(String clientId) {
        this.adlsAdapterAuthenticator.setClientId(clientId);
    }

    public String getSecret() {
        return this.adlsAdapterAuthenticator.getSecret();
    }

    public void setSecret(String secret) {
        this.adlsAdapterAuthenticator.setSecret(secret);
    }

    public String getSharedKey() {
        return this.adlsAdapterAuthenticator.getSharedKey();
    }

    public void setSharedKey(String sharedKey) {
        this.adlsAdapterAuthenticator.setSharedKey(sharedKey);
    }

    public String getSasToken() {
        return this.adlsAdapterAuthenticator.getSasToken();
    }

    public void setSasToken(String sasToken) {
        this.adlsAdapterAuthenticator.setSasToken(sasToken);
    }

    public TokenProvider getTokenProvider() {
        return this.adlsAdapterAuthenticator.getTokenProvider();
    }

    public void setTokenProvider(TokenProvider tokenProvider) {
        this.adlsAdapterAuthenticator.setTokenProvider(tokenProvider);
    }

    public int getHttpMaxResults() {
        return this.httpMaxResults;
    }

    public void setHttpMaxResults(int value) {
        this.httpMaxResults = value;
    }

    public AzureCloudEndpoint getEndpoint() {
        return this.adlsAdapterAuthenticator.getEndpoint();
    }

    public void setEndpoint(AzureCloudEndpoint endpoint) {
        this.adlsAdapterAuthenticator.setEndpoint(endpoint);
    }

    private void deleteContentAtPath(String corpusPath, String url, Exception innerException) {
        if (this.getCtx() == null || MapUtils.isEmpty(this.getCtx().getFeatureFlags()) || this.getCtx().getFeatureFlags().getOrDefault("ADLSAdapter_deleteEmptyFile", true).equals(true)) {
            try {
                this.executeRequest(this.buildRequest(url, "DELETE")).get();
                return;
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
        }
        throw new StorageAdapterException("Empty file was created but could not write ADLS content at path: " + corpusPath, innerException);
    }

    private CdmHttpResponse createFileAtPath(String corpusPath, String url) {
        try {
            CdmHttpRequest request = this.buildRequest(url + "?resource=file", "PUT");
            CdmHttpResponse response = this.executeRequest(request).get();
            if (response.getStatusCode() != 201) {
                throw new StorageAdapterException(String.format("Could not write ADLS content at path, response code: %s. Reason: %s.", response.getStatusCode(), response.getReason()));
            }
            return response;
        }
        catch (InterruptedException | ExecutionException e) {
            throw new StorageAdapterException("Could not write ADLS content at path, there was an issue at: " + corpusPath, e);
        }
    }
}

