/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.utilities;

import com.microsoft.commondatamodel.objectmodel.cdm.EntityByReference;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.AttributeResolutionContext;
import com.microsoft.commondatamodel.objectmodel.utilities.AttributeResolutionDirectiveSet;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;

public class DepthInfo {
    public static int maxDepthLimit = 32;
    private Integer maxDepth;
    private int currentDepth;
    private boolean maxDepthExceeded;

    public Integer getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(Integer maxDepth) {
        this.maxDepth = maxDepth;
    }

    public int getCurrentDepth() {
        return this.currentDepth;
    }

    public void setCurrentDepth(int currentDepth) {
        this.currentDepth = currentDepth;
    }

    public boolean getMaxDepthExceeded() {
        return this.maxDepthExceeded;
    }

    public void setMaxDepthExceeded(boolean maxDepthExceeded) {
        this.maxDepthExceeded = maxDepthExceeded;
    }

    public DepthInfo() {
        this.reset();
    }

    public void reset() {
        this.currentDepth = 0;
        this.maxDepth = null;
        this.maxDepthExceeded = false;
    }

    public DepthInfo copy() {
        DepthInfo copy = new DepthInfo();
        copy.currentDepth = this.currentDepth;
        copy.maxDepth = this.maxDepth;
        copy.maxDepthExceeded = this.maxDepthExceeded;
        return copy;
    }

    public void updateToNextLevel(ResolveOptions resOpt, Boolean isPolymorphic, AttributeResolutionContext arc) {
        AttributeResolutionDirectiveSet directives = resOpt.getDirectives();
        boolean isByRef = false;
        this.maxDepth = resOpt.getMaxDepth();
        if (arc != null) {
            if (arc.getResOpt() != null) {
                directives = arc.getResOpt().getDirectives();
                if (isPolymorphic == null && directives != null) {
                    isPolymorphic = directives.has("selectOne");
                }
            }
            if (arc.getResGuide().getEntityByReference() != null) {
                EntityByReference entityByReference = arc.getResGuide().getEntityByReference();
                if (entityByReference.getReferenceOnlyAfterDepth() != null) {
                    this.maxDepth = entityByReference.getReferenceOnlyAfterDepth();
                }
                if (entityByReference.doesAllowReference().booleanValue() && directives != null) {
                    isByRef = directives.has("referenceOnly");
                }
            }
        }
        if (directives != null && directives.has("noMaxDepth")) {
            this.maxDepth = maxDepthLimit;
        }
        if (!(isPolymorphic != null && isPolymorphic.booleanValue() || isByRef)) {
            ++this.currentDepth;
            if (this.currentDepth > this.maxDepth) {
                this.maxDepthExceeded = true;
            }
        }
    }
}

