/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDataPartitionDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmFileStatus;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmLocalEntityDeclarationDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectDefinitionBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReferenceBase;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmPropertyName;
import com.microsoft.commondatamodel.objectmodel.storage.StorageAdapterBase;
import com.microsoft.commondatamodel.objectmodel.utilities.CdmFileMetadata;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.FileStatusCheckOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StorageUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.TraitToPropertyMap;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class CdmDataPartitionPatternDefinition
extends CdmObjectDefinitionBase
implements CdmFileStatus {
    private static final String TAG = CdmDataPartitionPatternDefinition.class.getSimpleName();
    private String name;
    private String rootLocation;
    private String globPattern;
    private String regularExpression;
    private List<String> parameters;
    private String specializedSchema;
    private OffsetDateTime lastFileStatusCheckTime;
    private OffsetDateTime lastFileModifiedTime;
    private TraitToPropertyMap t2pm;
    private OffsetDateTime lastChildFileModifiedTime;

    public CdmDataPartitionPatternDefinition(CdmCorpusContext ctx, String name) {
        super(ctx);
        this.setObjectType(CdmObjectType.DataPartitionPatternDef);
        this.setName(name);
    }

    @Override
    public boolean validate() {
        if (StringUtils.isNullOrEmpty(this.getRootLocation())) {
            ArrayList<String> missingFields = new ArrayList<String>(Arrays.asList("rootLocation"));
            Logger.error(this.getCtx(), TAG, "validate", this.getAtCorpusPath(), CdmLogCode.ErrValdnIntegrityCheckFailure, this.getAtCorpusPath(), String.join((CharSequence)", ", missingFields.parallelStream().map(s -> String.format("'%s'", s)).collect(Collectors.toList())));
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public Object copyData(ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectBase.copyData(this, resOpt, options, CdmDataPartitionPatternDefinition.class);
    }

    @Override
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        CdmDataPartitionPatternDefinition copy;
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        if (host == null) {
            copy = new CdmDataPartitionPatternDefinition(this.getCtx(), this.getName());
        } else {
            copy = (CdmDataPartitionPatternDefinition)host;
            copy.setName(this.getName());
        }
        copy.setRootLocation(this.getRootLocation());
        copy.setGlobPattern(this.getGlobPattern());
        copy.setRegularExpression(this.getRegularExpression());
        copy.setParameters((List<String>)(this.getParameters() != null ? new ArrayList<String>(this.getParameters()) : null));
        copy.setLastFileStatusCheckTime(this.getLastFileStatusCheckTime());
        copy.setLastFileModifiedTime(this.getLastFileModifiedTime());
        if (this.getSpecializedSchema() != null) {
            copy.setSpecializedSchema(this.getSpecializedSchema());
        }
        this.copyDef(resOpt, copy);
        return copy;
    }

    private TraitToPropertyMap getTraitToPropertyMap() {
        if (this.t2pm == null) {
            this.t2pm = new TraitToPropertyMap(this);
        }
        return this.t2pm;
    }

    @Override
    public boolean isDerivedFrom(String baseDef, ResolveOptions resOpt) {
        return false;
    }

    @Override
    public boolean visit(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        String path = this.fetchDeclaredPath(pathFrom);
        if (preChildren != null && preChildren.invoke(this, path)) {
            return false;
        }
        if (this.visitDef(path, preChildren, postChildren)) {
            return true;
        }
        return postChildren != null && postChildren.invoke(this, path);
    }

    @Override
    @Deprecated
    public String fetchDeclaredPath(String pathFrom) {
        return pathFrom + (this.getName() == null ? "UNNAMED" : this.getName());
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getRootLocation() {
        return this.rootLocation;
    }

    public void setRootLocation(String value) {
        this.rootLocation = value;
    }

    public String getGlobPattern() {
        return this.globPattern;
    }

    public void setGlobPattern(String value) {
        this.globPattern = value;
    }

    public String getRegularExpression() {
        return this.regularExpression;
    }

    public void setRegularExpression(String value) {
        this.regularExpression = value;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<String> value) {
        this.parameters = value;
    }

    public String getSpecializedSchema() {
        return this.specializedSchema;
    }

    public void setSpecializedSchema(String value) {
        this.specializedSchema = value;
    }

    public boolean isIncremental() {
        return (Boolean)this.getTraitToPropertyMap().fetchPropertyValue(CdmPropertyName.IS_INCREMENTAL);
    }

    @Override
    public OffsetDateTime getLastFileStatusCheckTime() {
        return this.lastFileStatusCheckTime;
    }

    @Override
    public void setLastFileStatusCheckTime(OffsetDateTime value) {
        this.lastFileStatusCheckTime = value;
    }

    @Override
    public OffsetDateTime getLastFileModifiedTime() {
        return this.lastFileModifiedTime;
    }

    @Override
    public void setLastFileModifiedTime(OffsetDateTime value) {
        this.lastFileModifiedTime = value;
    }

    @Override
    public OffsetDateTime getLastChildFileModifiedTime() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLastChildFileModifiedTime(OffsetDateTime time) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Void> fileStatusCheckAsync(FileStatusCheckOptions fileStatusCheckOptions) {
        return CompletableFuture.runAsync(() -> {
            ImmutablePair<String, String> pathTuple;
            HashMap<String, CdmFileMetadata> fileInfoList;
            String rootCorpus;
            String rootCleaned;
            StorageAdapterBase adapter;
            String nameSpace;
            Logger.LoggerScope logScope;
            block30: {
                logScope = Logger.enterScope(CdmDataPartitionPatternDefinition.class.getSimpleName(), this.getCtx(), "fileStatusCheckAsync");
                nameSpace = null;
                adapter = null;
                String string = rootCleaned = this.getRootLocation() != null && this.getRootLocation().endsWith("/") ? this.getRootLocation().substring(0, this.getRootLocation().length() - 1) : this.getRootLocation();
                if (rootCleaned == null) {
                    rootCleaned = "";
                }
                rootCorpus = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(rootCleaned, this.getInDocument());
                fileInfoList = null;
                pathTuple = StorageUtils.splitNamespacePath(rootCorpus);
                if (pathTuple != null) break block30;
                Logger.error(this.getCtx(), TAG, "fileStatusCheckAsync", this.getAtCorpusPath(), CdmLogCode.ErrStorageNullCorpusPath, new String[0]);
                if (logScope == null) return;
                logScope.close();
                return;
            }
            nameSpace = (String)pathTuple.getLeft();
            adapter = this.getCtx().getCorpus().getStorage().fetchAdapter(nameSpace);
            if (adapter == null) {
                Logger.error(this.getCtx(), TAG, "fileStatusCheckAsync", this.getAtCorpusPath(), CdmLogCode.ErrDocAdapterNotFound, this.getInDocument().getName());
                if (logScope == null) return;
                logScope.close();
                return;
            }
            try {
                fileInfoList = adapter.fetchAllFilesMetadataAsync((String)pathTuple.getRight()).join();
            }
            catch (Exception e) {
                Logger.warning(this.getCtx(), TAG, "fileStatusCheckAsync", rootCorpus, CdmLogCode.WarnPartitionFileFetchFailed, rootCorpus, e.getMessage());
            }
            this.setLastFileStatusCheckTime(OffsetDateTime.now(ZoneOffset.UTC));
            if (fileInfoList == null) {
                Logger.error(this.getCtx(), TAG, "fileStatusCheckAsync", rootCorpus, CdmLogCode.ErrFetchingFileMetadataNull, nameSpace);
                return;
            }
            if (nameSpace == null) return;
            HashMap<String, CdmFileMetadata> cleanedFileList = new HashMap<String, CdmFileMetadata>();
            for (Map.Entry<String, CdmFileMetadata> entry : fileInfoList.entrySet()) {
                cleanedFileList.put(StringUtils.slice(nameSpace + ":" + entry.getKey(), rootCorpus.length()), entry.getValue());
            }
            if (!(this.getOwner() instanceof CdmLocalEntityDeclarationDefinition)) return;
            CdmLocalEntityDeclarationDefinition localEntDecDefOwner = (CdmLocalEntityDeclarationDefinition)this.getOwner();
            if (!StringUtils.isNullOrTrimEmpty(this.getGlobPattern()) && !StringUtils.isNullOrTrimEmpty(this.getRegularExpression())) {
                Logger.warning(this.getCtx(), TAG, "fileStatusCheckAsync", rootCorpus, CdmLogCode.WarnPartitionGlobAndRegexPresent, this.getGlobPattern(), this.getRegularExpression());
            }
            String regularExpression = !StringUtils.isNullOrTrimEmpty(this.globPattern) ? this.globPatternToRegex(this.globPattern) : this.regularExpression;
            Pattern regexPattern = null;
            try {
                regexPattern = Pattern.compile(regularExpression);
            }
            catch (PatternSyntaxException e) {
                Logger.error(this.getCtx(), TAG, "fileStatusCheckAsync", rootCorpus, CdmLogCode.ErrValdnInvalidExpression, !StringUtils.isNullOrTrimEmpty(this.globPattern) ? "glob pattern" : "regular expression", !StringUtils.isNullOrTrimEmpty(this.globPattern) ? this.globPattern : this.regularExpression, e.getMessage());
            }
            if (regexPattern == null) return;
            HashSet<Object> dataPartitionPathHashSet = new HashSet<Object>();
            if (localEntDecDefOwner.getDataPartitions() != null) {
                for (CdmDataPartitionDefinition dataPartition : localEntDecDefOwner.getDataPartitions()) {
                    String string = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(dataPartition.getLocation(), this.getInDocument());
                    dataPartitionPathHashSet.add(string);
                }
            }
            HashSet<Object> incrementalPartitionPathHashSet = new HashSet<Object>();
            if (localEntDecDefOwner.getIncrementalPartitions() != null) {
                for (CdmDataPartitionDefinition cdmDataPartitionDefinition : localEntDecDefOwner.getIncrementalPartitions()) {
                    String fullPath = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(cdmDataPartitionDefinition.getLocation(), this.getInDocument());
                    incrementalPartitionPathHashSet.add(fullPath);
                }
            }
            Iterator<Object> iterator = cleanedFileList.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                String fileName = (String)entry.getKey();
                CdmFileMetadata partitionMetadata = (CdmFileMetadata)entry.getValue();
                Matcher m = regexPattern.matcher(fileName);
                if (!m.matches() || !m.group().equals(fileName)) continue;
                LinkedHashMap<String, List<String>> args = new LinkedHashMap<String, List<String>>();
                for (int i = 0; i < m.groupCount(); ++i) {
                    if (this.getParameters() == null || i >= this.getParameters().size()) continue;
                    String currentParam = this.getParameters().get(i);
                    if (!args.containsKey(currentParam)) {
                        args.put(currentParam, new ArrayList());
                    }
                    ((List)args.get(currentParam)).add(m.group(i + 1));
                }
                String locationCorpusPath = rootCleaned + fileName;
                String fullPath = rootCorpus + fileName;
                ImmutablePair<String, String> pathTuple2 = StorageUtils.splitNamespacePath(fullPath);
                if (pathTuple2 == null) {
                    Logger.error(this.getCtx(), TAG, "fileStatusCheckAsync", rootCorpus, CdmLogCode.ErrStorageNullCorpusPath, this.getAtCorpusPath());
                    return;
                }
                CdmTraitCollection exhibitsTraits = this.getExhibitsTraits();
                if (fileStatusCheckOptions != null && fileStatusCheckOptions.getIncludeDataPartitionSize() && partitionMetadata != null) {
                    exhibitsTraits = new CdmTraitCollection(this.getCtx(), this);
                    for (CdmTraitReferenceBase trait : this.getExhibitsTraits()) {
                        exhibitsTraits.add(trait);
                    }
                    exhibitsTraits.add("is.partition.size", new ArrayList<ImmutablePair>(Collections.singletonList(new ImmutablePair((Object)"value", (Object)partitionMetadata.getSize()))));
                }
                OffsetDateTime lastModifiedTime = adapter.computeLastModifiedTimeAsync((String)pathTuple2.getRight()).join();
                if (this.isIncremental() && !incrementalPartitionPathHashSet.contains(fullPath)) {
                    localEntDecDefOwner.createDataPartitionFromPattern(locationCorpusPath, exhibitsTraits, args, this.getSpecializedSchema(), lastModifiedTime, true, this.getName());
                    incrementalPartitionPathHashSet.add(fullPath);
                    continue;
                }
                if (this.isIncremental() || dataPartitionPathHashSet.contains(fullPath)) continue;
                localEntDecDefOwner.createDataPartitionFromPattern(locationCorpusPath, exhibitsTraits, args, this.getSpecializedSchema(), lastModifiedTime);
                dataPartitionPathHashSet.add(fullPath);
            }
            return;
        });
    }

    @Override
    public CompletableFuture<Void> fileStatusCheckAsync() {
        return this.fileStatusCheckAsync(null);
    }

    @Override
    public CompletableFuture<Void> reportMostRecentTimeAsync(OffsetDateTime childTime) {
        if (this.getOwner() instanceof CdmFileStatus && childTime != null) {
            return ((CdmFileStatus)this.getOwner()).reportMostRecentTimeAsync(childTime);
        }
        return CompletableFuture.completedFuture(null);
    }

    private String globPatternToRegex(String pattern) {
        int i;
        ArrayList<String> newPattern = new ArrayList<String>();
        newPattern.add("[/\\\\]");
        int n = i = pattern.charAt(0) == '/' || pattern.charAt(0) == '\\' ? 1 : 0;
        while (i < pattern.length()) {
            char currChar = pattern.charAt(i);
            switch (currChar) {
                case '.': {
                    newPattern.add("\\.");
                    break;
                }
                case '\\': {
                    newPattern.add("[/\\\\]");
                    break;
                }
                case '?': {
                    newPattern.add(".");
                    break;
                }
                case '*': {
                    Character nextChar;
                    Character c = nextChar = i + 1 < pattern.length() ? Character.valueOf(pattern.charAt(i + 1)) : null;
                    if (nextChar != null && nextChar.equals(Character.valueOf('*'))) {
                        Character postChar;
                        Character prevChar = i - 1 >= 0 ? Character.valueOf(pattern.charAt(i - 1)) : null;
                        Character c2 = postChar = i + 2 < pattern.length() ? Character.valueOf(pattern.charAt(i + 2)) : null;
                        if (!(prevChar != null && prevChar.charValue() != '/' && prevChar.charValue() != '\\' || postChar != null && postChar.charValue() != '/' && postChar.charValue() != '\\')) {
                            newPattern.add(".*");
                            if (!(prevChar == null || postChar == null || prevChar.charValue() != '/' && prevChar.charValue() != '\\' || postChar.charValue() != '/' && postChar.charValue() != '\\')) {
                                newPattern.add("/?");
                                ++i;
                            }
                        } else {
                            newPattern.add("[^/\\\\]*");
                        }
                        ++i;
                        break;
                    }
                    newPattern.add("[^/\\\\]*");
                    break;
                }
                default: {
                    newPattern.add(Character.toString(currChar));
                }
            }
            ++i;
        }
        return String.join((CharSequence)"", newPattern);
    }
}

