/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmArgumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmContainerDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDataPartitionDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDataPartitionPatternDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDefinitionCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmE2ERelationship;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityDeclarationDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmFolderDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmImport;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmImportCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmLocalEntityDeclarationDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmManifestDeclarationDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmManifestDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectDefinitionBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectReferenceBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectSimple;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmParameterDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReference;
import com.microsoft.commondatamodel.objectmodel.cdm.ImportPriorities;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.enums.ImportsLoadStrategy;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ParameterCollection;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolveContext;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttributeSetBuilder;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSetBuilder;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ImportInfo;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class CdmDocumentDefinition
extends CdmObjectSimple
implements CdmContainerDefinition {
    private static final String TAG = CdmDocumentDefinition.class.getSimpleName();
    protected Map<String, CdmObjectBase> internalDeclarations;
    protected boolean isDirty = true;
    protected boolean isValid;
    protected boolean declarationsIndexed;
    protected ImportPriorities importPriorities;
    private boolean needsIndexing;
    private CdmDefinitionCollection definitions;
    private CdmImportCollection imports;
    private String folderPath;
    private String namespace;
    private boolean importsIndexed;
    private boolean currentlyIndexing;
    private String name;
    private String schema;
    private String jsonSchemaSemanticVersion;
    private String documentVersion;
    private OffsetDateTime _fileSystemModifiedTime;
    private List<CdmObjectBase> internalObjects;

    public CdmDocumentDefinition() {
    }

    public CdmDocumentDefinition(CdmCorpusContext ctx, String name) {
        super(ctx);
        this.setInDocument(this);
        this.setObjectType(CdmObjectType.DocumentDef);
        this.name = name;
        this.jsonSchemaSemanticVersion = CdmDocumentDefinition.getJsonSchemaSemanticVersionMinimumSave();
        this.documentVersion = null;
        this.needsIndexing = true;
        this.isDirty = true;
        this.importsIndexed = false;
        this.currentlyIndexing = false;
        this.isValid = true;
        this.imports = new CdmImportCollection(this.getCtx(), this);
        this.definitions = new CdmDefinitionCollection(this.getCtx(), this);
    }

    @Deprecated
    public boolean getNeedsIndexing() {
        return this.needsIndexing;
    }

    @Deprecated
    public void setNeedsIndexing(boolean value) {
        this.needsIndexing = value;
    }

    @Override
    @Deprecated
    public String getFolderPath() {
        return this.folderPath;
    }

    @Override
    @Deprecated
    public void setFolderPath(String folderPath) {
        this.folderPath = folderPath;
    }

    @Override
    @Deprecated
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    @Deprecated
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Deprecated
    boolean isImportsIndexed() {
        return this.importsIndexed;
    }

    @Deprecated
    void setImportsIndexed(boolean importsIndexed) {
        this.importsIndexed = importsIndexed;
    }

    @Deprecated
    boolean isCurrentlyIndexing() {
        return this.currentlyIndexing;
    }

    @Deprecated
    void setCurrentlyIndexing(boolean currentlyIndexing) {
        this.currentlyIndexing = currentlyIndexing;
    }

    public CdmDefinitionCollection getDefinitions() {
        return this.definitions;
    }

    @Deprecated
    public CdmFolderDefinition getFolder() {
        return (CdmFolderDefinition)this.getOwner();
    }

    @Deprecated
    public void setFolder(CdmFolderDefinition folder) {
        this.setOwner(folder);
    }

    public CdmImportCollection getImports() {
        return this.imports;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public String getJsonSchemaSemanticVersion() {
        return this.jsonSchemaSemanticVersion;
    }

    public void setJsonSchemaSemanticVersion(String jsonSchemaSemanticVersion) {
        this.jsonSchemaSemanticVersion = jsonSchemaSemanticVersion;
    }

    public String getDocumentVersion() {
        return this.documentVersion;
    }

    public void setDocumentVersion(String documentVersion) {
        this.documentVersion = documentVersion;
    }

    @Deprecated
    public void discoverMinimumRequiredJsonSemanticVersion() {
        long[] maxVersion = new long[]{CdmObjectBase.semanticVersionStringToNumber(this.getJsonSchemaSemanticVersion())};
        this.visit("", null, (obj, objPath) -> {
            CdmObjectBase objectBase = (CdmObjectBase)obj;
            long objVersion = objectBase.getMinimumSemanticVersion();
            if (objVersion > maxVersion[0]) {
                maxVersion[0] = objVersion;
            }
            return false;
        });
        this.setJsonSchemaSemanticVersion(CdmObjectBase.semanticVersionNumberToString(maxVersion[0]));
    }

    void clearCaches() {
        this.internalDeclarations = new LinkedHashMap<String, CdmObjectBase>();
        this.internalObjects = new ArrayList<CdmObjectBase>();
        this.declarationsIndexed = false;
        this.importsIndexed = false;
        this.setImportPriorities(null);
        this.visit("", null, (obj, objPath) -> {
            CdmObjectBase objectBase = (CdmObjectBase)obj;
            ((CdmObjectBase)obj).setDeclaredPath(objPath);
            this.internalObjects.add(objectBase);
            return false;
        });
    }

    boolean localizeCorpusPaths(CdmFolderDefinition newFolder) {
        AtomicBoolean allWentWell = new AtomicBoolean(true);
        Logger.info(this.getCtx(), TAG, "localizeCorpusPaths", newFolder.getAtCorpusPath(), Logger.format("Localizing corpus paths in document '{0}'.", this.getName()));
        this.visit("", (iObject, path) -> {
            switch (iObject.getObjectType()) {
                case Import: {
                    CdmImport typeObj = (CdmImport)iObject;
                    String localizeCorpusPath = this.localizeCorpusPath(typeObj.getCorpusPath(), newFolder, allWentWell);
                    typeObj.setCorpusPath(localizeCorpusPath == null ? typeObj.getCorpusPath() : localizeCorpusPath);
                    break;
                }
                case LocalEntityDeclarationDef: 
                case ReferencedEntityDeclarationDef: {
                    CdmEntityDeclarationDefinition typeObj = (CdmEntityDeclarationDefinition)iObject;
                    String localizeCorpusPath = this.localizeCorpusPath(typeObj.getEntityPath(), newFolder, allWentWell);
                    typeObj.setEntityPath(localizeCorpusPath == null ? typeObj.getEntityPath() : localizeCorpusPath);
                    break;
                }
                case DataPartitionDef: {
                    CdmDataPartitionDefinition typeObj = (CdmDataPartitionDefinition)iObject;
                    String localizeCorpusPath = this.localizeCorpusPath(typeObj.getLocation(), newFolder, allWentWell);
                    typeObj.setLocation(localizeCorpusPath == null ? typeObj.getLocation() : localizeCorpusPath);
                    localizeCorpusPath = this.localizeCorpusPath(typeObj.getSpecializedSchema(), newFolder, allWentWell);
                    typeObj.setSpecializedSchema(localizeCorpusPath == null ? typeObj.getSpecializedSchema() : localizeCorpusPath);
                    break;
                }
                case DataPartitionPatternDef: {
                    CdmDataPartitionPatternDefinition typeObj = (CdmDataPartitionPatternDefinition)iObject;
                    String localizeCorpusPath = this.localizeCorpusPath(typeObj.getRootLocation(), newFolder, allWentWell);
                    typeObj.setRootLocation(localizeCorpusPath == null ? typeObj.getRootLocation() : localizeCorpusPath);
                    localizeCorpusPath = this.localizeCorpusPath(typeObj.getSpecializedSchema(), newFolder, allWentWell);
                    typeObj.setSpecializedSchema(localizeCorpusPath == null ? typeObj.getSpecializedSchema() : localizeCorpusPath);
                    break;
                }
                case E2ERelationshipDef: {
                    CdmE2ERelationship typeObj = (CdmE2ERelationship)iObject;
                    String localizeCorpusPath = this.localizeCorpusPath(typeObj.getToEntity(), newFolder, allWentWell);
                    typeObj.setToEntity(localizeCorpusPath == null ? typeObj.getToEntity() : localizeCorpusPath);
                    localizeCorpusPath = this.localizeCorpusPath(typeObj.getFromEntity(), newFolder, allWentWell);
                    typeObj.setFromEntity(localizeCorpusPath == null ? typeObj.getFromEntity() : localizeCorpusPath);
                    break;
                }
                case ManifestDeclarationDef: {
                    CdmManifestDeclarationDefinition typeObj = (CdmManifestDeclarationDefinition)iObject;
                    String localizeCorpusPath = this.localizeCorpusPath(typeObj.getDefinition(), newFolder, allWentWell);
                    typeObj.setDefinition(localizeCorpusPath == null ? typeObj.getDefinition() : localizeCorpusPath);
                    break;
                }
            }
            return false;
        }, null);
        return allWentWell.get();
    }

    private String localizeCorpusPath(String corpusPath, CdmFolderDefinition newFolder, AtomicBoolean allWentWell) {
        String absPath;
        if (StringUtils.isNullOrTrimEmpty(corpusPath)) {
            return corpusPath;
        }
        CdmFolderDefinition oldFolder = (CdmFolderDefinition)this.getOwner();
        String newPath = oldFolder == null ? this.getCtx().getCorpus().getStorage().createRelativeCorpusPath(corpusPath, newFolder) : (Objects.equals(absPath = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(corpusPath, oldFolder), corpusPath) ? absPath : this.getCtx().getCorpus().getStorage().createRelativeCorpusPath(absPath, newFolder));
        if (newPath == null) {
            allWentWell.set(false);
        }
        return newPath;
    }

    public CompletableFuture<Boolean> refreshAsync() {
        return this.refreshAsync(new ResolveOptions(this));
    }

    public CompletableFuture<Boolean> refreshAsync(ResolveOptions resOpt) {
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        this.needsIndexing = true;
        this.declarationsIndexed = false;
        this.importPriorities = null;
        this.importsIndexed = false;
        this.isValid = true;
        return this.indexIfNeededAsync(resOpt, true);
    }

    @Deprecated
    public CompletableFuture<Boolean> indexIfNeededAsync(ResolveOptions resOpt, boolean finalLoadImports) {
        if (this.getOwner() == null) {
            Logger.error(this.getCtx(), TAG, "indexIfNeededAsync", this.getAtCorpusPath(), CdmLogCode.ErrValdnMissingDoc, this.name);
            return CompletableFuture.completedFuture(false);
        }
        CdmCorpusDefinition corpus = ((CdmFolderDefinition)this.getOwner()).getCorpus();
        boolean needsIndexing = corpus.documentLibrary.markDocumentForIndexing(this);
        if (!needsIndexing) {
            return CompletableFuture.completedFuture(true);
        }
        return CompletableFuture.supplyAsync(() -> {
            boolean loadImports = finalLoadImports;
            if (resOpt.getImportsLoadStrategy() == ImportsLoadStrategy.DoNotLoad) {
                loadImports = false;
            } else if (resOpt.getImportsLoadStrategy() == ImportsLoadStrategy.Load) {
                loadImports = true;
            }
            HashSet<String> docsLoading = new HashSet<String>();
            docsLoading.add(this.getAtCorpusPath());
            if (loadImports) {
                corpus.resolveImportsAsync(this, docsLoading, resOpt).join();
            }
            return corpus.indexDocuments(resOpt, loadImports, this, docsLoading);
        });
    }

    public CompletableFuture<Boolean> saveAsAsync(String newName) {
        return this.saveAsAsync(newName, false);
    }

    public CompletableFuture<Boolean> saveAsAsync(String newName, boolean saveReferenced) {
        return this.saveAsAsync(newName, saveReferenced, new CopyOptions());
    }

    public CompletableFuture<Boolean> saveAsAsync(String newName, boolean saveReferenced, CopyOptions options) {
        if (options == null) {
            options = new CopyOptions();
        }
        CopyOptions finalOptions = options;
        return CompletableFuture.supplyAsync(() -> {
            try (Logger.LoggerScope logScope = Logger.enterScope(CdmDocumentDefinition.class.getSimpleName(), this.getCtx(), "saveAsAsync");){
                ResolveOptions resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
                if (!this.indexIfNeededAsync(resOpt, false).join().booleanValue()) {
                    Logger.error(this.getCtx(), TAG, "saveAsAsync", this.getAtCorpusPath(), CdmLogCode.ErrIndexFailed, new String[0]);
                    Boolean bl = false;
                    return bl;
                }
                if (newName.equals(this.getName())) {
                    this.isDirty = false;
                }
                if (!this.getCtx().getCorpus().getPersistence().saveDocumentAsAsync(this, newName, saveReferenced, finalOptions).join().booleanValue()) {
                    Boolean bl = false;
                    return bl;
                }
                if (this instanceof CdmManifestDefinition) {
                    for (CdmEntityDeclarationDefinition entity : ((CdmManifestDefinition)this).getEntities()) {
                        if (entity instanceof CdmLocalEntityDeclarationDefinition) {
                            ((CdmLocalEntityDeclarationDefinition)entity).resetLastFileModifiedOldTime();
                        }
                        for (CdmE2ERelationship relationship : ((CdmManifestDefinition)this).getRelationships()) {
                            relationship.resetLastFileModifiedOldTime();
                        }
                    }
                    Logger.ingestManifestTelemetry((CdmManifestDefinition)this, this.getCtx(), TAG, "saveAsAsync", this.getAtCorpusPath());
                } else {
                    for (CdmObjectDefinition obj : this.getDefinitions()) {
                        if (!(obj instanceof CdmEntityDefinition)) continue;
                        Logger.ingestEntityTelemetry((CdmEntityDefinition)obj, this.getCtx(), TAG, "saveAsAsync", this.getAtCorpusPath());
                    }
                }
            }
            return true;
        });
    }

    CdmObject fetchObjectFromDocumentPath(String objectPath, ResolveOptions resOpt) {
        if (this.internalDeclarations.containsKey(objectPath)) {
            return this.internalDeclarations.get(objectPath);
        }
        int lastObj = objectPath.lastIndexOf("/(object)");
        while (lastObj > 0) {
            String thisDocPart = objectPath.substring(0, lastObj);
            if (this.internalDeclarations.containsKey(thisDocPart)) {
                CdmObjectReferenceBase thisDocObjRef = (CdmObjectReferenceBase)this.internalDeclarations.get(thisDocPart);
                CdmObjectDefinitionBase thatDocObjDef = (CdmObjectDefinitionBase)thisDocObjRef.fetchObjectDefinition(resOpt);
                if (thatDocObjDef != null) {
                    Object thatDocPart = objectPath.substring(lastObj + "/(object)".length());
                    thatDocPart = thatDocObjDef.getDeclaredPath() + (String)thatDocPart;
                    if (thatDocPart == objectPath) {
                        return null;
                    }
                    return thatDocObjDef.getInDocument().fetchObjectFromDocumentPath((String)thatDocPart, resOpt);
                }
                return null;
            }
            lastObj = thisDocPart.lastIndexOf("/(object)");
        }
        return null;
    }

    @Override
    public String fetchObjectDefinitionName() {
        return this.name;
    }

    @Override
    public String getAtCorpusPath() {
        if (this.getOwner() == null) {
            return "NULL:/" + this.name;
        }
        return this.getOwner().getAtCorpusPath() + this.name;
    }

    @Override
    public boolean visit(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        if (preChildren != null && preChildren.invoke(this, pathFrom)) {
            return false;
        }
        if (this.getImports() != null && this.getImports().visitList(pathFrom, preChildren, postChildren)) {
            return true;
        }
        if (this.getDefinitions() != null && this.getDefinitions().visitList(pathFrom, preChildren, postChildren)) {
            return true;
        }
        return postChildren != null && postChildren.invoke(this, pathFrom);
    }

    @Override
    public <T extends CdmObjectDefinition> T fetchObjectDefinition(ResolveOptions resOpt) {
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        return null;
    }

    @Override
    public boolean validate() {
        if (StringUtils.isNullOrTrimEmpty(this.getName())) {
            ArrayList<String> missingFields = new ArrayList<String>(Arrays.asList("name"));
            Logger.error(this.getCtx(), TAG, "validate", this.getAtCorpusPath(), CdmLogCode.ErrValdnIntegrityCheckFailure, this.getAtCorpusPath(), String.join((CharSequence)", ", missingFields.parallelStream().map(s -> String.format("'%s'", s)).collect(Collectors.toList())));
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public Object copyData(ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectBase.copyData(this, resOpt, options, CdmDocumentDefinition.class);
    }

    @Override
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        CdmDocumentDefinition copy;
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        if (host == null) {
            copy = new CdmDocumentDefinition(this.getCtx(), this.getName());
        } else {
            copy = (CdmDocumentDefinition)host;
            copy.setCtx(this.getCtx());
            copy.setName(this.getName());
            copy.getDefinitions().clear();
            copy.declarationsIndexed = false;
            copy.internalDeclarations = new LinkedHashMap<String, CdmObjectBase>();
            copy.needsIndexing = true;
            copy.getImports().clear();
            copy.importsIndexed = false;
            copy.importPriorities = null;
        }
        copy.setInDocument(copy);
        copy.setDirty(true);
        copy.setFolderPath(this.getFolderPath());
        copy.setSchema(this.getSchema());
        copy.setJsonSchemaSemanticVersion(this.getJsonSchemaSemanticVersion());
        copy.setDocumentVersion(this.getDocumentVersion());
        for (CdmObjectDefinition definition : this.getDefinitions()) {
            copy.getDefinitions().add(definition);
        }
        for (CdmImport anImport : this.getImports()) {
            copy.getImports().add(anImport);
        }
        return copy;
    }

    @Override
    @Deprecated
    public ResolvedAttributeSetBuilder constructResolvedAttributes(ResolveOptions resOpt) {
        return this.constructResolvedAttributes(resOpt, null);
    }

    @Override
    @Deprecated
    public ResolvedAttributeSetBuilder constructResolvedAttributes(ResolveOptions resOpt, CdmAttributeContext under) {
        return null;
    }

    @Override
    void constructResolvedTraits(ResolvedTraitSetBuilder rtsb, ResolveOptions resOpt) {
    }

    @Deprecated
    public OffsetDateTime getFileSystemModifiedTime() {
        return this._fileSystemModifiedTime;
    }

    @Deprecated
    public void setFileSystemModifiedTime(OffsetDateTime _fileSystemModifiedTime) {
        this._fileSystemModifiedTime = _fileSystemModifiedTime;
    }

    void checkIntegrity() {
        int errorCount = 0;
        for (CdmObjectBase obj : this.internalObjects) {
            if (!obj.validate()) {
                ++errorCount;
            } else {
                obj.setCtx(this.getCtx());
            }
            Logger.info(this.getCtx(), TAG, "checkObjectIntegrity", null, Logger.format("Checked, folderPath: '{0}', path: '{1}'", this.getFolderPath(), obj.getDeclaredPath()));
        }
        this.isValid = Objects.equals(errorCount, 0);
    }

    void declareObjectDefinitions() {
        String corpusPathRoot = this.getFolderPath() + this.getName();
        block4: for (CdmObjectBase obj : this.internalObjects) {
            obj.setInDocument(this);
            String objPath = obj.getDeclaredPath();
            if (objPath.contains("(unspecified)")) continue;
            boolean skipDuplicates = false;
            switch (obj.getObjectType()) {
                case ConstantEntityDef: {
                    skipDuplicates = true;
                }
                case AttributeGroupDef: 
                case EntityDef: 
                case ParameterDef: 
                case TraitDef: 
                case PurposeDef: 
                case TraitGroupDef: 
                case AttributeContextDef: 
                case DataTypeDef: 
                case TypeAttributeDef: 
                case EntityAttributeDef: 
                case LocalEntityDeclarationDef: 
                case ReferencedEntityDeclarationDef: 
                case ProjectionDef: 
                case OperationAddCountAttributeDef: 
                case OperationAddSupportingAttributeDef: 
                case OperationAddTypeAttributeDef: 
                case OperationExcludeAttributesDef: 
                case OperationArrayExpansionDef: 
                case OperationCombineAttributesDef: 
                case OperationRenameAttributesDef: 
                case OperationReplaceAsForeignKeyDef: 
                case OperationIncludeAttributesDef: 
                case OperationAddAttributeGroupDef: 
                case OperationAlterTraitsDef: 
                case OperationAddArtifactAttributeDef: {
                    String corpusPath = corpusPathRoot.endsWith("/") || objPath.startsWith("/") ? corpusPathRoot + objPath : corpusPathRoot + "/" + objPath;
                    if (this.internalDeclarations.containsKey(objPath) && !skipDuplicates) {
                        Logger.error(this.getCtx(), TAG, "declareObjectDefinitions", corpusPath, CdmLogCode.ErrPathIsDuplicate, objPath);
                        continue block4;
                    }
                    this.internalDeclarations.putIfAbsent(objPath, obj);
                    this.getCtx().getCorpus().registerSymbol(objPath, this);
                    Logger.info(this.getCtx(), TAG, "declareObjectDefinitions", corpusPath, Logger.format("Declared: '{0}'", corpusPath));
                    continue block4;
                }
            }
            Logger.debug(this.getCtx(), TAG, "declareObjectDefinitions", this.getAtCorpusPath(), Logger.format("ObjectType not recognized: '{0}'", obj.getObjectType().name()));
        }
    }

    void resolveObjectDefinitions(ResolveOptions resOpt) {
        ResolveContext ctx = (ResolveContext)this.getCtx();
        resOpt.setIndexingDoc(this);
        block4: for (CdmObjectBase obj : this.internalObjects) {
            switch (obj.getObjectType()) {
                case AttributeRef: 
                case AttributeGroupRef: 
                case AttributeContextRef: 
                case DataTypeRef: 
                case EntityRef: 
                case PurposeRef: 
                case TraitRef: {
                    ctx.setRelativePath(obj.getDeclaredPath());
                    CdmObjectReferenceBase objectRef = (CdmObjectReferenceBase)obj;
                    if (CdmObjectReferenceBase.offsetAttributePromise(objectRef.getNamedReference()) >= 0) continue block4;
                    Object resNew = objectRef.fetchObjectDefinition(resOpt);
                    if (null == resNew) {
                        String message = Logger.format("Unable to resolve the reference '{0}' to a known object", this.getAtCorpusPath(), this.getFolderPath(), objectRef.getNamedReference());
                        String messagePath = obj.getAtCorpusPath();
                        if (resOpt.getShallowValidation()) {
                            Logger.warning(ctx, TAG, "resolveObjectDefinitions", this.getAtCorpusPath(), CdmLogCode.WarnResolveReferenceFailure, objectRef.getNamedReference());
                            break;
                        }
                        Logger.error(ctx, TAG, "resolveObjectDefinitions", this.getAtCorpusPath(), CdmLogCode.ErrResolveReferenceFailure, objectRef.getNamedReference());
                        break;
                    }
                    Logger.info(ctx, TAG, "resolveObjectDefinitions", resNew.getAtCorpusPath(), Logger.format("Resolved folderPath: '{0}', path: '{1}'", this.getFolderPath(), obj.getDeclaredPath()));
                    break;
                }
                case ParameterDef: {
                    CdmParameterDefinition parameterDef = (CdmParameterDefinition)obj;
                    parameterDef.constTypeCheck(resOpt, this, null);
                    break;
                }
                default: {
                    Logger.debug(ctx, TAG, "resolveObjectDefinitions", null, Logger.format("ObjectType not recognized: '{0}'", obj.getObjectType().name()));
                }
            }
        }
        resOpt.setIndexingDoc(null);
    }

    void resolveTraitArguments(ResolveOptions resOpt) {
        ResolveContext ctx = (ResolveContext)this.getCtx();
        for (CdmObjectBase obj : this.internalObjects) {
            CdmTraitDefinition traitDef;
            if (obj.getObjectType() != CdmObjectType.TraitRef || (traitDef = (CdmTraitDefinition)obj.fetchObjectDefinition(resOpt)) == null) continue;
            CdmTraitReference traitRef = (CdmTraitReference)obj;
            for (int argumentIndex = 0; argumentIndex < traitRef.getArguments().getCount(); ++argumentIndex) {
                CdmArgumentDefinition argument = (CdmArgumentDefinition)traitRef.getArguments().get(argumentIndex);
                try {
                    ctx.setRelativePath(argument.getDeclaredPath());
                    ParameterCollection parameterCollection = traitDef.fetchAllParameters(resOpt);
                    CdmParameterDefinition paramFound = parameterCollection.resolveParameter(argumentIndex, argument.getName());
                    argument.setResolvedParameter(paramFound);
                    Object argumentValue = paramFound.constTypeCheck(resOpt, this, argument.getValue());
                    if (argumentValue == null) continue;
                    argument.setValue(argumentValue);
                    continue;
                }
                catch (Exception e) {
                    Logger.error(ctx, TAG, "resolveTraitArguments", this.getAtCorpusPath(), CdmLogCode.ErrTraitResolutionFailure, traitDef.getName());
                }
            }
            traitRef.resolvedArguments = true;
        }
    }

    void finishIndexing(boolean importsLoaded) {
        Logger.debug(this.getCtx(), TAG, "indexDocuments", this.getAtCorpusPath(), Logger.format("index finish: {0}", new Object[0]));
        boolean wasIndexedPreviously = this.declarationsIndexed;
        this.getCtx().getCorpus().documentLibrary.markDocumentAsIndexed(this);
        this.setImportsIndexed(this.isImportsIndexed() || importsLoaded);
        this.declarationsIndexed = true;
        this.setNeedsIndexing(!importsLoaded);
        this.internalObjects = null;
        if (!wasIndexedPreviously && this.isValid) {
            this.getDefinitions().forEach(def -> {
                if (def.getObjectType() == CdmObjectType.EntityDef) {
                    Logger.debug(this.getCtx(), TAG, "finishDocumentResolve", def.getAtCorpusPath(), Logger.format("indexed: '{0}'", def.getAtCorpusPath()));
                }
            });
        }
    }

    private int prioritizeImports(LinkedHashSet<CdmDocumentDefinition> processedSet, ImportPriorities importPriorities, int sequence, boolean skipMonikered) {
        Map<CdmDocumentDefinition, ImportInfo> priorityMap = importPriorities.getImportPriority();
        Map<String, CdmDocumentDefinition> monikerMap = importPriorities.getMonikerPriorityMap();
        if (processedSet.contains(this)) {
            if (priorityMap.containsKey(this) && priorityMap.get(this).getPriority() == 0) {
                importPriorities.setHasCircularImport(true);
            }
            return sequence;
        }
        processedSet.add(this);
        if (this.getImports() != null) {
            boolean isMoniker;
            CdmDocumentDefinition impDoc;
            int i;
            int l = this.getImports().getCount();
            ArrayList<CdmDocumentDefinition> monikerImports = new ArrayList<CdmDocumentDefinition>();
            for (i = l - 1; i >= 0; --i) {
                CdmImport cdmImport = (CdmImport)this.getImports().get(i);
                impDoc = cdmImport.getDocument();
                boolean bl = isMoniker = !StringUtils.isNullOrTrimEmpty(cdmImport.getMoniker());
                if (impDoc != null) {
                    if (cdmImport.getDocument() != null && !isMoniker && !priorityMap.containsKey(impDoc)) {
                        priorityMap.put(impDoc, new ImportInfo(sequence, false));
                        ++sequence;
                        continue;
                    }
                    monikerImports.add(impDoc);
                    continue;
                }
                Logger.warning(this.getCtx(), TAG, "prioritizeImports", this.getAtCorpusPath(), CdmLogCode.WarnDocImportNotLoaded, cdmImport.getCorpusPath());
            }
            for (i = l - 1; i >= 0; --i) {
                CdmImport cdmImport = (CdmImport)this.getImports().get(i);
                impDoc = cdmImport.getDocument();
                boolean bl = isMoniker = !StringUtils.isNullOrTrimEmpty(cdmImport.getMoniker());
                if (impDoc == null) {
                    Logger.warning(this.getCtx(), TAG, "prioritizeImports", this.getAtCorpusPath(), CdmLogCode.WarnDocImportNotLoaded, cdmImport.getCorpusPath());
                }
                if (impDoc != null && impDoc.importPriorities != null && !impDoc.importPriorities.getHasCircularImport()) {
                    ImportPriorities impPriSub = impDoc.getImportPriorities();
                    impPriSub.getImportPriority().remove(impDoc);
                    for (Map.Entry ip : impPriSub.getImportPriority().entrySet().stream().sorted(Comparator.comparing(entry -> ((ImportInfo)entry.getValue()).getPriority())).collect(Collectors.toList())) {
                        if (priorityMap.containsKey(ip.getKey()) || ((ImportInfo)ip.getValue()).getIsMoniker()) continue;
                        priorityMap.put((CdmDocumentDefinition)ip.getKey(), new ImportInfo(sequence, false));
                        ++sequence;
                    }
                    if (isMoniker) continue;
                    impPriSub.getMonikerPriorityMap().entrySet().forEach(mp -> monikerMap.put((String)mp.getKey(), (CdmDocumentDefinition)mp.getValue()));
                    continue;
                }
                if (impDoc == null) continue;
                sequence = impDoc.prioritizeImports(processedSet, importPriorities, sequence, isMoniker);
            }
            if (!skipMonikered) {
                for (i = 0; i < l; ++i) {
                    boolean isMoniker2;
                    CdmImport cdmImport = (CdmImport)this.getImports().get(i);
                    boolean bl = isMoniker2 = !StringUtils.isNullOrTrimEmpty(cdmImport.getMoniker());
                    if (cdmImport.getDocument() == null || !isMoniker2) continue;
                    monikerMap.put(cdmImport.getMoniker(), cdmImport.getDocument());
                }
                if (priorityMap.containsKey(this) && priorityMap.get(this).getPriority() == 0) {
                    for (CdmDocumentDefinition cdmDocumentDefinition : monikerImports) {
                        if (priorityMap.containsKey(cdmDocumentDefinition)) continue;
                        priorityMap.put(cdmDocumentDefinition, new ImportInfo(sequence, true));
                        ++sequence;
                    }
                }
                if (priorityMap.containsKey(this) && priorityMap.get(this).getPriority() == 0) {
                    for (CdmDocumentDefinition cdmDocumentDefinition : monikerImports) {
                        if (priorityMap.containsKey(cdmDocumentDefinition)) continue;
                        priorityMap.put(cdmDocumentDefinition, new ImportInfo(sequence, true));
                        ++sequence;
                    }
                }
            }
        }
        return sequence;
    }

    @Deprecated
    public String importPathToDoc(CdmDocumentDefinition docDest) {
        return this.internalImportPathToDoc(this, "", docDest, new LinkedHashSet<CdmDocumentDefinition>());
    }

    @Deprecated
    public CompletableFuture<Boolean> saveLinkedDocumentsAsync() {
        return this.saveLinkedDocumentsAsync(null);
    }

    @Deprecated
    public CompletableFuture<Boolean> saveLinkedDocumentsAsync(CopyOptions options) {
        return CompletableFuture.supplyAsync(() -> {
            if (this.getImports() != null) {
                Iterator iterator = this.getImports().iterator();
                while (iterator.hasNext()) {
                    CdmImport anImport;
                    CdmImport imp = anImport = (CdmImport)iterator.next();
                    CdmDocumentDefinition docImp = null;
                    try {
                        docImp = (CdmDocumentDefinition)this.getCtx().getCorpus().fetchObjectAsync(imp.getCorpusPath(), this).join();
                    }
                    catch (ClassCastException e) {
                        Logger.error(this.getCtx(), TAG, "saveLinkedDocumentsAsync", this.getAtCorpusPath(), CdmLogCode.ErrInvalidCast, imp.getCorpusPath(), "CdmDocumentDefinition");
                    }
                    if (docImp == null || !docImp.isDirty || docImp.saveAsAsync(docImp.getName(), true, options).join().booleanValue()) continue;
                    Logger.error(this.getCtx(), TAG, "saveLinkedDocumentsAsync", this.getAtCorpusPath(), CdmLogCode.ErrDocImportSavingFailure, docImp.getName());
                    return false;
                }
            }
            return true;
        });
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    ImportPriorities getImportPriorities() {
        if (this.importPriorities == null) {
            ImportPriorities importPriorities = new ImportPriorities();
            importPriorities.getImportPriority().put(this, new ImportInfo(0, false));
            this.prioritizeImports(new LinkedHashSet<CdmDocumentDefinition>(), importPriorities, 1, false);
            this.importPriorities = importPriorities;
        }
        return this.importPriorities.copy();
    }

    void setImportPriorities(ImportPriorities importPriorities) {
        this.importPriorities = importPriorities;
    }

    @Deprecated
    public boolean isDirty() {
        return this.isDirty;
    }

    @Deprecated
    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    CompletableFuture<Void> reloadAsync() {
        return this.getCtx().getCorpus().fetchObjectAsync(this.getAtCorpusPath(), null, true).thenAccept(v -> {});
    }

    private String internalImportPathToDoc(CdmDocumentDefinition docCheck, String path, CdmDocumentDefinition docDest, HashSet<CdmDocumentDefinition> avoidLoop) {
        String pathFound;
        ImportInfo impInfo;
        if (docCheck == docDest) {
            return "";
        }
        if (avoidLoop.contains(docCheck)) {
            return null;
        }
        avoidLoop.add(docCheck);
        if (docCheck.getImportPriorities() != null && docCheck.getImportPriorities().getMonikerPriorityMap() != null && docCheck.getImportPriorities().getMonikerPriorityMap().size() > 0) {
            for (Map.Entry<String, CdmDocumentDefinition> monPair : docCheck.getImportPriorities().getMonikerPriorityMap().entrySet()) {
                if (monPair.getValue() != docDest) continue;
                return String.format("%s%s/", path, monPair.getKey());
            }
        }
        ImportInfo importInfo = impInfo = docCheck.getImportPriorities() != null && docCheck.getImportPriorities().getImportPriority() != null ? docCheck.getImportPriorities().getImportPriority().get(docDest) : null;
        if (impInfo != null && !impInfo.getIsMoniker()) {
            return path;
        }
        if (docCheck.getImportPriorities() != null && docCheck.getImportPriorities().getMonikerPriorityMap() != null && docCheck.getImportPriorities().getMonikerPriorityMap().size() > 0) {
            for (Map.Entry<Object, Object> entry : docCheck.getImportPriorities().getMonikerPriorityMap().entrySet()) {
                if (entry.getValue() != docDest || (pathFound = this.internalImportPathToDoc((CdmDocumentDefinition)entry.getValue(), String.format("%s%s/", path, entry.getKey()), docDest, avoidLoop)) == null) continue;
                return pathFound;
            }
        }
        if (docCheck.getImportPriorities() != null && docCheck.getImportPriorities().getImportPriority() != null && docCheck.getImportPriorities().getImportPriority().size() > 0) {
            for (Map.Entry<Object, Object> entry : docCheck.getImportPriorities().getImportPriority().entrySet()) {
                if (!((ImportInfo)entry.getValue()).getIsMoniker() || (pathFound = this.internalImportPathToDoc((CdmDocumentDefinition)entry.getKey(), path, docDest, avoidLoop)) == null) continue;
                return pathFound;
            }
        }
        return null;
    }
}

