/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectDefinitionBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmParameterDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReference;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ParameterCollection;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ParameterValueSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolveContext;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttributeSetBuilder;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTrait;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSetBuilder;
import com.microsoft.commondatamodel.objectmodel.utilities.CdmException;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.SymbolSet;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class CdmTraitDefinition
extends CdmObjectDefinitionBase {
    private static final String TAG = CdmTraitDefinition.class.getSimpleName();
    Boolean thisIsKnownToHaveParameters;
    private Boolean baseIsKnownToHaveParameters;
    private String traitName;
    private CdmTraitReference extendsTrait;
    private Boolean elevated;
    private Boolean ugly;
    private List<String> associatedProperties;
    private ParameterCollection allParameters;
    private boolean hasSetFlags = false;
    private CdmTraitReference defaultVerb;
    private CdmCollection<CdmParameterDefinition> parameters;

    public CdmTraitDefinition(CdmCorpusContext ctx, String name) {
        this(ctx, name, null);
    }

    public CdmTraitDefinition(CdmCorpusContext ctx, String name, CdmTraitReference extendsTrait) {
        super(ctx);
        this.setObjectType(CdmObjectType.TraitDef);
        this.traitName = name;
        this.extendsTrait = extendsTrait;
    }

    @Override
    public String getName() {
        return this.getTraitName();
    }

    @Override
    public long getMinimumSemanticVersion() {
        if (this.defaultVerb != null || this.getExhibitsTraits() != null && this.getExhibitsTraits().size() > 0) {
            return CdmObjectBase.semanticVersionStringToNumber(CdmObjectBase.getJsonSchemaSemanticVersionTraitsOnTraits());
        }
        return super.getMinimumSemanticVersion();
    }

    @Override
    @Deprecated
    public ResolvedTraitSet fetchResolvedTraits(ResolveOptions resOpt) {
        SymbolSet currSymbolRefSet;
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        String kind = "rtsb";
        ResolveContext ctx = (ResolveContext)this.getCtx();
        BaseInfo baseInfo = new BaseInfo(null, null, null);
        if (this.getBaseIsKnownToHaveParameters() == null) {
            this.updateBaseInfo(baseInfo, resOpt);
            this.setBaseIsKnownToHaveParameters(false);
            if (baseInfo.getValues() != null && baseInfo.getValues().size() > 0) {
                this.setBaseIsKnownToHaveParameters(true);
            }
        }
        String cacheTagExtra = "";
        if (this.getBaseIsKnownToHaveParameters().booleanValue()) {
            cacheTagExtra = String.valueOf(this.getExtendsTrait().getId());
        }
        String cacheTag = ctx.getCorpus().createDefinitionCacheTag(resOpt, this, "rtsb", cacheTagExtra);
        ResolvedTraitSet rtsResult = null;
        if (cacheTag != null) {
            rtsResult = ctx.getTraitCache().get(cacheTag);
        }
        if ((currSymbolRefSet = resOpt.getSymbolRefSet()) == null) {
            currSymbolRefSet = new SymbolSet();
        }
        resOpt.setSymbolRefSet(new SymbolSet());
        if (rtsResult == null) {
            this.updateBaseInfo(baseInfo, resOpt);
            if (baseInfo.getTrait() != null && !this.hasSetFlags) {
                if (this.getElevated() == null) {
                    this.setElevated(baseInfo.getTrait().getElevated());
                }
                if (this.getUgly() == null) {
                    this.setUgly(baseInfo.getTrait().getUgly());
                }
                if (this.getAssociatedProperties() == null) {
                    this.setAssociatedProperties(baseInfo.getTrait().getAssociatedProperties());
                }
            }
            this.hasSetFlags = true;
            ParameterCollection parameterCollection = this.fetchAllParameters(resOpt);
            if (parameterCollection != null) {
                ArrayList<Object> argumentValues = new ArrayList<Object>();
                ArrayList<Boolean> wasSet = new ArrayList<Boolean>();
                this.thisIsKnownToHaveParameters = parameterCollection.getSequence().size() > 0;
                for (int i = 0; i < parameterCollection.getSequence().size(); ++i) {
                    Object baseValue;
                    Object value = parameterCollection.getSequence().get(i).getDefaultValue();
                    if (baseInfo.getValues() != null && i < baseInfo.getValues().size() && (baseValue = baseInfo.getValues().get(i)) != null) {
                        value = baseValue;
                    }
                    argumentValues.add(value);
                    wasSet.add(false);
                }
                ResolvedTrait resTrait = new ResolvedTrait(this, parameterCollection, argumentValues, wasSet, null, null);
                rtsResult = new ResolvedTraitSet(resOpt);
                rtsResult.merge(resTrait, false);
            }
            ctx.getCorpus().registerDefinitionReferenceSymbols((CdmObject)this.fetchObjectDefinition(resOpt), "rtsb", resOpt.getSymbolRefSet());
            cacheTag = ctx.getCorpus().createDefinitionCacheTag(resOpt, this, "rtsb", cacheTagExtra);
            if (!StringUtils.isNullOrEmpty(cacheTag)) {
                ctx.getTraitCache().put(cacheTag, rtsResult);
            }
        } else {
            String key = CdmCorpusDefinition.createCacheKeyFromObject(this, "rtsb");
            SymbolSet tempSymbolRefSet = ctx.getCorpus().getDefinitionReferenceSymbols().get(key);
            resOpt.setSymbolRefSet(tempSymbolRefSet);
        }
        currSymbolRefSet.merge(resOpt.getSymbolRefSet());
        resOpt.setSymbolRefSet(currSymbolRefSet);
        return rtsResult;
    }

    @Override
    public boolean isDerivedFrom(String baseDef, ResolveOptions resOpt) {
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        if (baseDef.equalsIgnoreCase(this.traitName)) {
            return true;
        }
        return this.isDerivedFromDef(resOpt, this.getExtendsTrait(), this.getTraitName(), baseDef);
    }

    @Override
    public boolean visit(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        String path = this.fetchDeclaredPath(pathFrom);
        if (preChildren != null && preChildren.invoke(this, path)) {
            return false;
        }
        if (this.getExtendsTrait() != null && this.getExtendsTrait().visit(path + "/extendsTrait/", preChildren, postChildren)) {
            return true;
        }
        if (this.getParameters() != null && this.getParameters().visitList(path + "/hasParameters/", preChildren, postChildren)) {
            return true;
        }
        if (this.getDefaultVerb() != null) {
            this.getDefaultVerb().setOwner(this);
            if (this.getDefaultVerb().visit(path + "/defaultVerb/", preChildren, postChildren)) {
                return true;
            }
        }
        if (this.visitDef(path, preChildren, postChildren)) {
            return true;
        }
        return postChildren != null && postChildren.invoke(this, path);
    }

    public List<String> getAssociatedProperties() {
        return this.associatedProperties;
    }

    private Boolean getBaseIsKnownToHaveParameters() {
        return this.baseIsKnownToHaveParameters;
    }

    public void setAssociatedProperties(List<String> value) {
        this.associatedProperties = value;
    }

    private void setBaseIsKnownToHaveParameters(Boolean baseIsKnownToHaveParameters) {
        this.baseIsKnownToHaveParameters = baseIsKnownToHaveParameters;
    }

    public Boolean getElevated() {
        return this.elevated;
    }

    public void setElevated(Boolean value) {
        this.elevated = value;
    }

    public CdmTraitReference getExtendsTrait() {
        return this.extendsTrait;
    }

    public void setExtendsTrait(CdmTraitReference value) {
        this.extendsTrait = value;
    }

    public CdmCollection<CdmParameterDefinition> getParameters() {
        if (this.parameters == null) {
            this.parameters = new CdmCollection(this.getCtx(), this, CdmObjectType.ParameterDef);
        }
        return this.parameters;
    }

    public String getTraitName() {
        return this.traitName;
    }

    public void setTraitName(String value) {
        this.traitName = value;
    }

    public Boolean getUgly() {
        return this.ugly;
    }

    public void setUgly(Boolean value) {
        this.ugly = value;
    }

    public CdmTraitReference getDefaultVerb() {
        return this.defaultVerb;
    }

    public void setDefaultVerb(CdmTraitReference value) {
        this.defaultVerb = value;
    }

    ParameterCollection fetchAllParameters(ResolveOptions resOpt) {
        if (this.allParameters != null) {
            return this.allParameters;
        }
        ParameterCollection prior = null;
        if (this.extendsTrait != null) {
            CdmTraitDefinition extDef = (CdmTraitDefinition)this.extendsTrait.fetchObjectDefinition(resOpt);
            if (extDef == null) {
                Logger.error(this.getCtx(), TAG, "fetchAllParameters", this.getAtCorpusPath(), CdmLogCode.ErrResolveReferenceFailure, this.getAtCorpusPath(), "ExtendsTrait");
                return null;
            }
            prior = extDef.fetchAllParameters(resOpt);
        }
        this.allParameters = new ParameterCollection(prior);
        if (this.parameters != null) {
            for (CdmParameterDefinition parameter : this.parameters) {
                try {
                    this.allParameters.add(parameter);
                }
                catch (CdmException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return this.allParameters;
    }

    @Override
    public boolean validate() {
        if (StringUtils.isNullOrTrimEmpty(this.traitName)) {
            ArrayList<String> missingFields = new ArrayList<String>(Arrays.asList("traitName"));
            Logger.error(this.getCtx(), TAG, "validate", this.getAtCorpusPath(), CdmLogCode.ErrValdnIntegrityCheckFailure, this.getAtCorpusPath(), String.join((CharSequence)", ", missingFields.parallelStream().map(s -> String.format("'%s'", s)).collect(Collectors.toList())));
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public Object copyData(ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectBase.copyData(this, resOpt, options, CdmTraitDefinition.class);
    }

    @Override
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        CdmTraitDefinition copy;
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        if (host == null) {
            copy = new CdmTraitDefinition(this.getCtx(), this.traitName, null);
        } else {
            copy = (CdmTraitDefinition)host;
            copy.setTraitName(this.getTraitName());
        }
        copy.setExtendsTrait((CdmTraitReference)(this.extendsTrait == null ? null : this.extendsTrait.copy(resOpt)));
        copy.allParameters = null;
        copy.setUgly(this.ugly);
        copy.setAssociatedProperties((List<String>)(this.associatedProperties != null ? new ArrayList<String>(this.associatedProperties) : null));
        copy.setDefaultVerb((CdmTraitReference)(this.defaultVerb == null ? null : this.defaultVerb.copy(resOpt)));
        this.copyDef(resOpt, copy);
        return copy;
    }

    @Override
    @Deprecated
    public ResolvedAttributeSetBuilder constructResolvedAttributes(ResolveOptions resOpt, CdmAttributeContext under) {
        return null;
    }

    @Override
    @Deprecated
    public ResolvedAttributeSetBuilder constructResolvedAttributes(ResolveOptions resOpt) {
        return this.constructResolvedAttributes(resOpt, null);
    }

    @Override
    void constructResolvedTraits(ResolvedTraitSetBuilder rtsb, ResolveOptions resOpt) {
    }

    private void updateBaseInfo(BaseInfo baseInfo, ResolveOptions resOpt) {
        if (this.getExtendsTrait() != null) {
            baseInfo.setTrait((CdmTraitDefinition)this.getExtendsTrait().fetchObjectDefinition(resOpt));
            if (baseInfo.getTrait() != null) {
                baseInfo.setRts(this.getExtendsTrait().fetchResolvedTraits(resOpt));
                if (baseInfo.getRts() != null && baseInfo.getRts().getSize() == 1) {
                    ParameterValueSet basePv;
                    ParameterValueSet parameterValueSet = basePv = baseInfo.getRts().get(baseInfo.getTrait()) != null ? baseInfo.getRts().get(baseInfo.getTrait()).getParameterValues() : null;
                    if (basePv != null) {
                        baseInfo.setValues(basePv.getValues());
                    }
                }
            }
        }
    }

    private static class BaseInfo {
        CdmTraitDefinition trait;
        ResolvedTraitSet rts;
        List<Object> values;

        public BaseInfo(CdmTraitDefinition traits, ResolvedTraitSet rts, List<Object> values) {
            this.trait = traits;
            this.rts = rts;
            this.values = values;
        }

        public CdmTraitDefinition getTrait() {
            return this.trait;
        }

        public ResolvedTraitSet getRts() {
            return this.rts;
        }

        public List<Object> getValues() {
            return this.values;
        }

        public void setTrait(CdmTraitDefinition trait) {
            this.trait = trait;
        }

        public void setRts(ResolvedTraitSet rts) {
            this.rts = rts;
        }

        public void setValues(List<Object> values) {
            this.values = values;
        }
    }
}

