/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm.projections;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttribute;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReferenceBase;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationBase;
import com.microsoft.commondatamodel.objectmodel.enums.CdmAttributeContextType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmOperationType;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ParameterValueSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttribute;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttributeSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTrait;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.TraitProfile;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.TraitProfileCache;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionAttributeState;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionAttributeStateSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionContext;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionResolutionCommonUtil;
import com.microsoft.commondatamodel.objectmodel.utilities.AttributeContextParameters;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CdmOperationAlterTraits
extends CdmOperationBase {
    private static final String TAG = CdmOperationAlterTraits.class.getSimpleName();
    private CdmCollection<CdmTraitReferenceBase> traitsToAdd;
    private CdmCollection<CdmTraitReferenceBase> traitsToRemove;
    private Boolean argumentsContainWildcards;
    private List<String> applyTo;
    private List<String> applyToTraits;
    private TraitProfileCache profCache = new TraitProfileCache();

    public CdmOperationAlterTraits(CdmCorpusContext ctx) {
        super(ctx);
        this.setObjectType(CdmObjectType.OperationAlterTraitsDef);
        this.setType(CdmOperationType.AlterTraits);
    }

    public CdmCollection<CdmTraitReferenceBase> getTraitsToAdd() {
        return this.traitsToAdd;
    }

    public void setTraitsToAdd(CdmCollection<CdmTraitReferenceBase> traitsToAdd) {
        this.traitsToAdd = traitsToAdd;
    }

    public CdmCollection<CdmTraitReferenceBase> getTraitsToRemove() {
        return this.traitsToRemove;
    }

    public void setTraitsToRemove(CdmCollection<CdmTraitReferenceBase> traitsToRemove) {
        this.traitsToRemove = traitsToRemove;
    }

    public Boolean getArgumentsContainWildcards() {
        return this.argumentsContainWildcards;
    }

    public void setArgumentsContainWildcards(Boolean argumentsContainWildcards) {
        this.argumentsContainWildcards = argumentsContainWildcards;
    }

    public List<String> getApplyTo() {
        return this.applyTo;
    }

    public void setApplyTo(List<String> applyTo) {
        this.applyTo = applyTo;
    }

    public List<String> getApplyToTraits() {
        return this.applyToTraits;
    }

    public void setApplyToTraits(List<String> applyToTraits) {
        this.applyToTraits = applyToTraits;
    }

    @Override
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        CdmOperationAlterTraits copy;
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        CdmOperationAlterTraits cdmOperationAlterTraits = copy = host == null ? new CdmOperationAlterTraits(this.getCtx()) : (CdmOperationAlterTraits)host;
        if (this.getTraitsToAdd() != null && this.getTraitsToAdd().size() > 0) {
            for (CdmTraitReferenceBase trait : this.getTraitsToAdd()) {
                copy.getTraitsToAdd().add((CdmTraitReferenceBase)trait.copy());
            }
        }
        if (this.getTraitsToRemove() != null && this.getTraitsToRemove().size() > 0) {
            for (CdmTraitReferenceBase trait : this.getTraitsToRemove()) {
                copy.getTraitsToRemove().add((CdmTraitReferenceBase)trait.copy());
            }
        }
        if (this.applyTo != null) {
            copy.setApplyTo(new ArrayList<String>(this.applyTo));
        }
        if (this.applyToTraits != null) {
            copy.setApplyToTraits(new ArrayList<String>(this.applyToTraits));
        }
        copy.argumentsContainWildcards = this.argumentsContainWildcards;
        this.copyProj(resOpt, copy);
        return copy;
    }

    @Override
    @Deprecated
    public Object copyData(ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectBase.copyData(this, resOpt, options, CdmOperationAlterTraits.class);
    }

    @Override
    public String getName() {
        return "operationAlterTraits";
    }

    @Override
    @Deprecated
    public CdmObjectType getObjectType() {
        return CdmObjectType.OperationAlterTraitsDef;
    }

    @Override
    public boolean validate() {
        ArrayList<String> missingFields = new ArrayList<String>();
        if (this.traitsToAdd == null && this.traitsToRemove == null) {
            missingFields.add("traitsToAdd");
            missingFields.add("traitsToRemove");
        }
        if (missingFields.size() > 0) {
            Logger.error(this.getCtx(), TAG, "validate", this.getAtCorpusPath(), CdmLogCode.ErrValdnIntegrityCheckFailure, this.getAtCorpusPath(), String.join((CharSequence)", ", missingFields.parallelStream().map(s -> String.format("'%s'", s)).collect(Collectors.toList())));
            return false;
        }
        return true;
    }

    @Override
    public boolean visit(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        String path = this.fetchDeclaredPath(pathFrom);
        if (preChildren != null && preChildren.invoke(this, path)) {
            return false;
        }
        if (this.getTraitsToAdd() != null && this.getTraitsToAdd().visitList(path + "/traitsToAdd/", preChildren, postChildren)) {
            return true;
        }
        if (this.getTraitsToRemove() != null && this.getTraitsToRemove().visitList(path + "/traitsToRemove/", preChildren, postChildren)) {
            return true;
        }
        return postChildren != null && postChildren.invoke(this, path);
    }

    @Override
    @Deprecated
    public ProjectionAttributeStateSet appendProjectionAttributeState(ProjectionContext projCtx, ProjectionAttributeStateSet projOutputSet, CdmAttributeContext attrCtx) {
        AttributeContextParameters attrCtxOpAlterTraitsParam = new AttributeContextParameters();
        attrCtxOpAlterTraitsParam.setUnder(attrCtx);
        attrCtxOpAlterTraitsParam.setType(CdmAttributeContextType.OperationAlterTraits);
        attrCtxOpAlterTraitsParam.setName("operation/index" + this.getIndex() + "/" + this.getName());
        CdmAttributeContext attrCtxOpAlterTraits = CdmAttributeContext.createChildUnder(projCtx.getProjectionDirective().getResOpt(), attrCtxOpAlterTraitsParam);
        Map<String, String> topLevelSelectedAttributeNames = this.applyTo != null ? ProjectionResolutionCommonUtil.getTopList(projCtx, this.applyTo) : null;
        HashSet traitNamesToRemove = new HashSet();
        if (this.traitsToRemove != null) {
            for (CdmTraitReferenceBase traitRef : this.traitsToRemove) {
                ResolvedTraitSet resolvedTraitSet = traitRef.fetchResolvedTraits(projCtx.getProjectionDirective().getResOpt());
                resolvedTraitSet.getSet().forEach(rt -> traitNamesToRemove.add(rt.getTraitName()));
            }
        }
        HashSet<String> applyToTraitNames = null;
        if (this.applyToTraits != null) {
            applyToTraitNames = new HashSet<String>(this.applyToTraits);
        }
        for (ProjectionAttributeState currentPAS : projCtx.getCurrentAttributeStateSet().getStates()) {
            if (topLevelSelectedAttributeNames == null || topLevelSelectedAttributeNames.containsKey(currentPAS.getCurrentResolvedAttribute().getResolvedName())) {
                AttributeContextParameters attrCtxNewAttrParam = new AttributeContextParameters();
                attrCtxNewAttrParam.setUnder(attrCtxOpAlterTraits);
                attrCtxNewAttrParam.setType(CdmAttributeContextType.AttributeDefinition);
                attrCtxNewAttrParam.setName(currentPAS.getCurrentResolvedAttribute().getResolvedName());
                CdmAttributeContext attrCtxNewAttr = CdmAttributeContext.createChildUnder(projCtx.getProjectionDirective().getResOpt(), attrCtxNewAttrParam);
                ResolvedAttribute foundNewResAttr = null;
                if (currentPAS.getCurrentResolvedAttribute().getTarget() instanceof ResolvedAttributeSet) {
                    ResolvedAttributeSet resAttrNewCopy = ((ResolvedAttributeSet)currentPAS.getCurrentResolvedAttribute().getTarget()).copy();
                    foundNewResAttr = new ResolvedAttribute(projCtx.getProjectionDirective().getResOpt(), resAttrNewCopy, currentPAS.getCurrentResolvedAttribute().getResolvedName(), attrCtxNewAttr);
                    foundNewResAttr.setResolvedTraits(currentPAS.getCurrentResolvedAttribute().getResolvedTraits().deepCopy());
                } else if (currentPAS.getCurrentResolvedAttribute().getTarget() instanceof CdmAttribute) {
                    foundNewResAttr = CdmOperationAlterTraits.createNewResolvedAttribute(projCtx, attrCtxNewAttr, currentPAS.getCurrentResolvedAttribute(), currentPAS.getCurrentResolvedAttribute().getResolvedName(), null);
                } else {
                    Logger.error(this.getCtx(), TAG, "appendProjectionAttributeState", this.getAtCorpusPath(), CdmLogCode.ErrProjUnsupportedSource, ((CdmObject)currentPAS.getCurrentResolvedAttribute().getTarget()).getObjectType().toString(), this.getName());
                    projOutputSet.add(currentPAS);
                    break;
                }
                ResolvedAttribute newResAttr = foundNewResAttr;
                ResolvedTraitSet newTraits = this.resolvedNewTraits(projCtx, currentPAS);
                if (applyToTraitNames == null) {
                    newResAttr.setResolvedTraits(newResAttr.getResolvedTraits().mergeSet(newTraits));
                    if (traitNamesToRemove != null) {
                        traitNamesToRemove.forEach(traitName -> newResAttr.getResolvedTraits().remove(projCtx.getProjectionDirective().getResOpt(), (String)traitName));
                    }
                } else {
                    ArrayList<CdmTraitReference> newTraitRefs = new ArrayList<CdmTraitReference>();
                    for (ResolvedTrait nrt : newTraits.getSet()) {
                        newTraitRefs.add(CdmObjectBase.resolvedTraitToTraitRef(projCtx.getProjectionDirective().getResOpt(), nrt));
                    }
                    for (ResolvedTrait rt2 : newResAttr.getResolvedTraits().getSet()) {
                        HashSet<String> classifiers = new HashSet<String>();
                        TraitProfile profile = rt2.fetchTraitProfile(projCtx.getProjectionDirective().getResOpt(), this.profCache, null);
                        if (profile != null) {
                            if ((profile = profile.consolidate(this.profCache)).getClassifications() != null) {
                                profile.getClassifications().parallelStream().map(c -> c.getTraitName()).forEach(classifiers::add);
                            }
                            while (profile != null) {
                                classifiers.add(profile.getTraitName());
                                profile = profile.getIS_A();
                            }
                        }
                        HashSet classifiersCheck = new HashSet(classifiers);
                        classifiersCheck.retainAll(applyToTraitNames);
                        if (classifiersCheck.size() <= 0) continue;
                        if (newTraitRefs != null && newTraitRefs.size() > 0) {
                            if (rt2.getMetaTraits() == null) {
                                rt2.setMetaTraits(new ArrayList<CdmTraitReferenceBase>());
                            }
                            rt2.getMetaTraits().addAll(newTraitRefs);
                        }
                        if (traitNamesToRemove == null || traitNamesToRemove.size() <= 0 || rt2.getMetaTraits() == null) continue;
                        List toRemove = rt2.getMetaTraits().parallelStream().filter(mtr -> traitNamesToRemove.contains(mtr.fetchObjectDefinitionName())).collect(Collectors.toList());
                        rt2.getMetaTraits().removeAll(toRemove);
                        if (rt2.getMetaTraits().size() != 0) continue;
                        rt2.setMetaTraits(null);
                    }
                }
                ProjectionAttributeState newPAS = currentPAS.copy();
                newPAS.setCurrentResolvedAttribute(newResAttr);
                projOutputSet.add(newPAS);
                continue;
            }
            projOutputSet.add(currentPAS);
        }
        return projOutputSet;
    }

    private ResolvedTraitSet resolvedNewTraits(ProjectionContext projCtx, ProjectionAttributeState currentPAS) {
        String projectionOwnerName;
        ResolvedTraitSet resolvedTraitSet = new ResolvedTraitSet(projCtx.getProjectionDirective().getResOpt());
        String string = projectionOwnerName = projCtx.getProjectionDirective().getOriginalSourceAttributeName() != null ? projCtx.getProjectionDirective().getOriginalSourceAttributeName() : "";
        if (this.traitsToAdd != null) {
            for (CdmTraitReferenceBase traitRef : this.traitsToAdd) {
                ResolvedTraitSet traitRefCopy = traitRef.fetchResolvedTraits(projCtx.getProjectionDirective().getResOpt()).deepCopy();
                this.replaceWildcardCharacters(projCtx.getProjectionDirective().getResOpt(), traitRefCopy, projectionOwnerName, currentPAS);
                resolvedTraitSet = resolvedTraitSet.mergeSet(traitRefCopy);
            }
        }
        return resolvedTraitSet;
    }

    private void replaceWildcardCharacters(ResolveOptions resOpt, ResolvedTraitSet resolvedTraitSet, String projectionOwnerName, ProjectionAttributeState currentPAS) {
        if (this.argumentsContainWildcards != null && this.argumentsContainWildcards.booleanValue()) {
            for (ResolvedTrait resolvedTrait : resolvedTraitSet.getSet()) {
                ParameterValueSet parameterValueSet = resolvedTrait.getParameterValues();
                for (int i = 0; i < parameterValueSet.length(); ++i) {
                    String newVal;
                    Object value = parameterValueSet.fetchValue(i);
                    if (!(value instanceof String) || value.equals(newVal = CdmOperationAlterTraits.replaceWildcardCharacters((String)value, projectionOwnerName, currentPAS))) continue;
                    parameterValueSet.setParameterValue(resOpt, parameterValueSet.fetchParameter(i).getName(), newVal);
                }
            }
        }
    }

    private void removeTraitsInNewAttribute(ResolveOptions resOpt, ResolvedAttribute newResAttr) {
        HashSet<String> traitNamesToRemove = new HashSet<String>();
        if (this.traitsToRemove != null) {
            for (CdmTraitReferenceBase traitRef : this.traitsToRemove) {
                ResolvedTraitSet resolvedTraitSet = traitRef.fetchResolvedTraits(resOpt).deepCopy();
                for (ResolvedTrait rt : resolvedTraitSet.getSet()) {
                    traitNamesToRemove.add(rt.getTraitName());
                }
            }
            for (String traitName : traitNamesToRemove) {
                newResAttr.getResolvedTraits().remove(resOpt, traitName);
            }
        }
    }
}

