/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm.projections;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationBase;
import com.microsoft.commondatamodel.objectmodel.enums.CdmAttributeContextType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmOperationType;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionAttributeContextTreeBuilder;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionAttributeState;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionAttributeStateSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionContext;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionResolutionCommonUtil;
import com.microsoft.commondatamodel.objectmodel.utilities.AttributeContextParameters;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CdmOperationIncludeAttributes
extends CdmOperationBase {
    private static final String TAG = CdmOperationIncludeAttributes.class.getSimpleName();
    private List<String> includeAttributes;

    public CdmOperationIncludeAttributes(CdmCorpusContext ctx) {
        super(ctx);
        this.setObjectType(CdmObjectType.OperationIncludeAttributesDef);
        this.setType(CdmOperationType.IncludeAttributes);
    }

    @Override
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        CdmOperationIncludeAttributes copy;
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        CdmOperationIncludeAttributes cdmOperationIncludeAttributes = copy = host == null ? new CdmOperationIncludeAttributes(this.getCtx()) : (CdmOperationIncludeAttributes)host;
        if (this.includeAttributes != null) {
            copy.setIncludeAttributes(new ArrayList<String>(this.includeAttributes));
        }
        this.copyProj(resOpt, copy);
        return copy;
    }

    public List<String> getIncludeAttributes() {
        return this.includeAttributes;
    }

    public void setIncludeAttributes(List<String> includeAttributes) {
        this.includeAttributes = includeAttributes;
    }

    @Override
    @Deprecated
    public Object copyData(ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectBase.copyData(this, resOpt, options, CdmOperationIncludeAttributes.class);
    }

    @Override
    public String getName() {
        return "operationIncludeAttributes";
    }

    @Override
    @Deprecated
    public CdmObjectType getObjectType() {
        return CdmObjectType.OperationIncludeAttributesDef;
    }

    @Override
    public boolean validate() {
        ArrayList<String> missingFields = new ArrayList<String>();
        if (this.includeAttributes == null) {
            missingFields.add("includeAttributes");
        }
        if (missingFields.size() > 0) {
            Logger.error(this.getCtx(), TAG, "validate", this.getAtCorpusPath(), CdmLogCode.ErrValdnIntegrityCheckFailure, this.getAtCorpusPath(), String.join((CharSequence)", ", missingFields.parallelStream().map(s -> String.format("'%s'", s)).collect(Collectors.toList())));
            return false;
        }
        return true;
    }

    @Override
    public boolean visit(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        String path = this.fetchDeclaredPath(pathFrom);
        if (preChildren != null && preChildren.invoke(this, path)) {
            return false;
        }
        return postChildren != null && postChildren.invoke(this, path);
    }

    @Override
    @Deprecated
    public ProjectionAttributeStateSet appendProjectionAttributeState(ProjectionContext projCtx, ProjectionAttributeStateSet projAttrStateSet, CdmAttributeContext attrCtx) {
        AttributeContextParameters attrCtxOpIncludeAttrsParam = new AttributeContextParameters();
        attrCtxOpIncludeAttrsParam.setUnder(attrCtx);
        attrCtxOpIncludeAttrsParam.setType(CdmAttributeContextType.OperationIncludeAttributes);
        attrCtxOpIncludeAttrsParam.setName("operation/index" + this.getIndex() + "/operationIncludeAttributes");
        CdmAttributeContext attrCtxOpIncludeAttrs = CdmAttributeContext.createChildUnder(projCtx.getProjectionDirective().getResOpt(), attrCtxOpIncludeAttrsParam);
        Map<String, String> topLevelIncludeAttributeNames = ProjectionResolutionCommonUtil.getTopList(projCtx, this.includeAttributes);
        ProjectionAttributeContextTreeBuilder attrCtxTreeBuilder = new ProjectionAttributeContextTreeBuilder(attrCtxOpIncludeAttrs);
        HashMap<String, ProjectionAttributeState> topLevelIncludeAttribute = new HashMap<String, ProjectionAttributeState>();
        ArrayList<ProjectionAttributeState> removedAttributes = new ArrayList<ProjectionAttributeState>();
        for (ProjectionAttributeState projectionAttributeState : projCtx.getCurrentAttributeStateSet().getStates()) {
            if (topLevelIncludeAttributeNames.containsKey(projectionAttributeState.getCurrentResolvedAttribute().getResolvedName())) {
                topLevelIncludeAttribute.put(projectionAttributeState.getCurrentResolvedAttribute().getResolvedName(), projectionAttributeState);
                continue;
            }
            removedAttributes.add(projectionAttributeState);
        }
        for (Map.Entry entry : topLevelIncludeAttributeNames.entrySet()) {
            ProjectionAttributeState currentPAS = (ProjectionAttributeState)topLevelIncludeAttribute.get(entry.getKey());
            String includeAttributeName = (String)entry.getValue();
            attrCtxTreeBuilder.createAndStoreAttributeContextParameters(includeAttributeName, currentPAS, currentPAS.getCurrentResolvedAttribute(), CdmAttributeContextType.AttributeDefinition, currentPAS.getCurrentResolvedAttribute().getAttCtx(), null);
            ProjectionAttributeState newPAS = currentPAS.copy();
            projAttrStateSet.add(newPAS);
        }
        for (ProjectionAttributeState projectionAttributeState : removedAttributes) {
            attrCtxTreeBuilder.createAndStoreAttributeContextParameters(null, projectionAttributeState, projectionAttributeState.getCurrentResolvedAttribute(), CdmAttributeContextType.AttributeExcluded, projectionAttributeState.getCurrentResolvedAttribute().getAttCtx(), null);
        }
        attrCtxTreeBuilder.constructAttributeContextTree(projCtx);
        return projAttrStateSet;
    }
}

