/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.resolvedmodel;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmParameterDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReferenceBase;
import com.microsoft.commondatamodel.objectmodel.cdm.StringSpewCatcher;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ParameterCollection;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ParameterValueSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.TraitProfile;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.TraitProfileCache;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

@Deprecated
public class ResolvedTrait {
    private CdmTraitDefinition trait;
    private ParameterValueSet parameterValues;
    private CdmTraitReference explicitVerb;
    private List<CdmTraitReferenceBase> metaTraits;

    @Deprecated
    public ResolvedTrait(CdmTraitDefinition trait, ParameterCollection parameterCollection, List<Object> values, List<Boolean> wasSet, CdmTraitReference explicitVerb, List<CdmTraitReferenceBase> metaTraits) {
        if (parameterCollection != null && parameterCollection.sequence != null && parameterCollection.sequence.size() > 0) {
            this.parameterValues = new ParameterValueSet(trait.getCtx(), parameterCollection, values, wasSet);
        }
        this.trait = trait;
        this.explicitVerb = explicitVerb;
        if (metaTraits != null) {
            this.metaTraits = new ArrayList<CdmTraitReferenceBase>(metaTraits);
        }
    }

    public String getTraitName() {
        return this.trait != null ? this.trait.getDeclaredPath() : null;
    }

    public void setExplicitVerb(CdmTraitReference value) {
        this.explicitVerb = value;
    }

    public CdmTraitReference getExplicitVerb() {
        return this.explicitVerb;
    }

    public void setMetaTraits(List<CdmTraitReferenceBase> value) {
        this.metaTraits = value;
    }

    public List<CdmTraitReferenceBase> getMetaTraits() {
        return this.metaTraits;
    }

    public void spew(ResolveOptions resOpt, StringSpewCatcher to, String indent) throws IOException {
        to.spewLine(indent + "[" + this.getTraitName() + "]");
        if (this.parameterValues != null) {
            this.parameterValues.spew(resOpt, to, indent + "-");
        }
    }

    public ResolvedTrait copy() {
        ParameterCollection pc = null;
        List<Object> values = null;
        List<Boolean> wasSet = null;
        ArrayList<CdmTraitReferenceBase> metaTraits = null;
        if (this.parameterValues != null) {
            ParameterValueSet copyParamValues = this.parameterValues.copy();
            pc = copyParamValues.getPc();
            values = copyParamValues.getValues();
            wasSet = copyParamValues.getWasSet();
        }
        if (this.metaTraits != null) {
            metaTraits = new ArrayList<CdmTraitReferenceBase>(this.metaTraits);
        }
        return new ResolvedTrait(this.trait, pc, values, wasSet, this.explicitVerb, metaTraits);
    }

    public void addMetaTrait(CdmTraitReference trait, CdmTraitReference verb) {
        if (this.metaTraits == null) {
            this.metaTraits = new ArrayList<CdmTraitReferenceBase>();
        }
        trait.setVerb(verb);
        this.metaTraits.add(trait);
    }

    public void collectTraitNames(ResolveOptions resOpt, Set<String> into) {
        CdmTraitDefinition currentTrait = this.trait;
        while (currentTrait != null) {
            into.add(currentTrait.getName());
            CdmTraitReference baseRef = currentTrait.getExtendsTrait();
            currentTrait = baseRef != null ? (CdmTraitDefinition)baseRef.fetchObjectDefinition(resOpt) : null;
        }
    }

    public CdmTraitDefinition getTrait() {
        return this.trait;
    }

    public void setTrait(CdmTraitDefinition trait) {
        this.trait = trait;
    }

    @Deprecated
    public ParameterValueSet getParameterValues() {
        return this.parameterValues;
    }

    public TraitProfile fetchTraitProfile(ResolveOptions resOpt) {
        return this.fetchTraitProfile(resOpt, null, null);
    }

    public TraitProfile fetchTraitProfile(ResolveOptions resOpt, TraitProfileCache cache) {
        return this.fetchTraitProfile(resOpt, cache, null);
    }

    public TraitProfile fetchTraitProfile(ResolveOptions resOpt, TraitProfileCache cache, String forVerb) {
        if (cache == null) {
            cache = new TraitProfileCache();
        }
        TraitProfile definition = TraitProfile._traitDefToProfile(this.trait, resOpt, false, false, cache);
        TraitProfile result = new TraitProfile();
        result.setReferences(definition);
        result.setTraitName(definition.getTraitName());
        if (this.explicitVerb != null) {
            result.setVerb(TraitProfile._traitRefToProfile(this.explicitVerb, resOpt, true, true, true, cache));
        }
        if (result.getVerb() != null && forVerb != null && !result.getVerb().getTraitName().equals(forVerb)) {
            result = null;
        } else {
            if (this.metaTraits != null) {
                result.setMetaTraits(TraitProfile.traitCollectionToProfileList(this.metaTraits, resOpt, result.getMetaTraits(), true, cache));
                result.removeClassifiersFromMeta();
            }
            if (this.getParameterValues() != null && this.getParameterValues().length() > 0) {
                HashMap<String, Object> argMap = new HashMap<String, Object>();
                int l = this.getParameterValues().length();
                for (int i = 0; i < l; ++i) {
                    Object value;
                    CdmParameterDefinition p = this.getParameterValues().fetchParameter(i);
                    Object v = this.getParameterValues().fetchValue(i);
                    String name = p.getName();
                    if (name == null) {
                        name = Integer.toString(i);
                    }
                    if ((value = TraitProfile.fetchProfileArgumentFromTraitArgument(v, resOpt)) == null) continue;
                    argMap.put(name, value);
                }
                if (argMap.size() > 0) {
                    result.setArgumentValues(argMap);
                }
            }
        }
        return result;
    }
}

