/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.resolvedmodel;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitDefinition;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.TraitProfile;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.traitProfileKeyFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TraitProfileCache {
    Set<String> stack;
    Map<CdmTraitDefinition, TraitProfile> traitDefToProfile;
    Map<CdmTraitDefinition, TraitProfile> traitDefToProfileNoClassifiers;
    Map<CdmTraitDefinition, TraitProfile> traitDefToProfileNoMeta;
    Map<TraitProfile, TraitProfile> profToPromotedProfile = null;
    Map<TraitProfile, TraitProfile> profToCleanedProfile = null;
    Map<String, TraitProfile> referenceCache = null;

    public Boolean addContext(String level) {
        if (this.stack == null) {
            this.stack = new HashSet<String>();
        } else if (this.stack.contains(level)) {
            return false;
        }
        this.stack.add(level);
        return true;
    }

    public Boolean removeContext(String level) {
        if (this.stack != null) {
            return this.stack.remove(level);
        }
        return false;
    }

    public TraitProfile SaveDefinitionProfile(CdmTraitDefinition traitDef, TraitProfile defProf, Boolean noMeta, Boolean noClassifiers) {
        if (this.traitDefToProfile == null) {
            this.traitDefToProfile = new HashMap<CdmTraitDefinition, TraitProfile>();
            this.traitDefToProfileNoClassifiers = new HashMap<CdmTraitDefinition, TraitProfile>();
            this.traitDefToProfileNoMeta = new HashMap<CdmTraitDefinition, TraitProfile>();
        }
        if (!noClassifiers.booleanValue() && !noMeta.booleanValue()) {
            this.traitDefToProfile.put(traitDef, defProf);
        }
        if (noClassifiers.booleanValue() && !noMeta.booleanValue()) {
            this.traitDefToProfileNoClassifiers.put(traitDef, defProf);
        }
        if (noMeta.booleanValue()) {
            this.traitDefToProfileNoMeta.put(traitDef, defProf);
        }
        return defProf;
    }

    public TraitProfile getDefinitionProfile(CdmTraitDefinition traitDef, Boolean noMeta, Boolean noClassifiers) {
        if (this.traitDefToProfile == null) {
            return null;
        }
        TraitProfile found = null;
        if (!noClassifiers.booleanValue() && !noMeta.booleanValue() && (found = this.traitDefToProfile.get(traitDef)) == null) {
            return null;
        }
        if (noClassifiers.booleanValue() && !noMeta.booleanValue() && (found = this.traitDefToProfileNoClassifiers.get(traitDef)) == null) {
            return null;
        }
        if (noMeta.booleanValue() && (found = this.traitDefToProfileNoMeta.get(traitDef)) == null) {
            return null;
        }
        return found;
    }

    public TraitProfile savePromotedDefinitionProfile(TraitProfile promoted, TraitProfile defProf) {
        if (this.profToPromotedProfile == null) {
            this.profToPromotedProfile = new HashMap<TraitProfile, TraitProfile>();
        }
        this.profToPromotedProfile.put(defProf, promoted);
        return defProf;
    }

    public TraitProfile getPromotedDefinitionProfile(TraitProfile profToFind) {
        if (this.profToPromotedProfile == null) {
            return null;
        }
        TraitProfile found = this.profToPromotedProfile.get(profToFind);
        if (found != null) {
            return found;
        }
        return null;
    }

    public TraitProfile saveCleanedDefinitionProfile(TraitProfile cleaned, TraitProfile promoted) {
        if (this.profToCleanedProfile == null) {
            this.profToCleanedProfile = new HashMap<TraitProfile, TraitProfile>();
        }
        this.profToCleanedProfile.put(promoted, cleaned);
        return cleaned;
    }

    public TraitProfile getCleanedDefinitionProfile(TraitProfile promoted) {
        if (this.profToCleanedProfile == null) {
            return null;
        }
        TraitProfile found = this.profToCleanedProfile.get(promoted);
        if (found != null) {
            return found;
        }
        return null;
    }

    public TraitProfile getEquivalentReference(TraitProfile prof) {
        String testWith;
        TraitProfile equivalent;
        if (this.referenceCache == null) {
            this.referenceCache = new HashMap<String, TraitProfile>();
        }
        if ((equivalent = this.referenceCache.get(testWith = traitProfileKeyFactory.getKey(prof))) == null) {
            equivalent = prof;
            this.referenceCache.put(testWith, prof);
        }
        return equivalent;
    }
}

