/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDocumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.function.Predicate;

public class CdmCollection<T extends CdmObject>
implements Iterable<T> {
    public final List<T> allItems;
    private final CdmCorpusContext ctx;
    private final CdmObjectType defaultType;
    private final CdmObject owner;

    public CdmCollection(CdmCorpusContext ctx, CdmObject owner, CdmObjectType defaultType) {
        this.ctx = ctx;
        this.allItems = Collections.synchronizedList(new ArrayList());
        this.defaultType = defaultType;
        this.owner = owner;
    }

    public CdmCollection(T cdmObject) {
        this(cdmObject.getCtx(), cdmObject.getOwner(), cdmObject.getObjectType());
    }

    public CdmCollection(CdmCollection<T> original) {
        this(original.ctx, original.owner, original.defaultType);
        this.allItems.addAll(original.allItems);
    }

    public boolean visitList(String path, VisitCallback preChildren, VisitCallback postChildren) {
        boolean result = false;
        if (this.getAllItems() != null) {
            int lItem = this.getCount();
            for (int iItem = 0; iItem < lItem; ++iItem) {
                CdmObject element = (CdmObject)this.getAllItems().get(iItem);
                if (element == null || !element.visit(path, preChildren, postChildren)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    public int size() {
        return this.allItems.size();
    }

    public boolean isEmpty() {
        return this.allItems.isEmpty();
    }

    public boolean contains(Object o) {
        return this.allItems.contains(o);
    }

    @Override
    public Iterator<T> iterator() {
        return this.allItems.iterator();
    }

    public Object[] toArray() {
        return this.allItems.toArray();
    }

    public <T1> T1[] toArray(T1[] a) {
        return this.allItems.toArray(a);
    }

    public int getCount() {
        return this.allItems.size();
    }

    @Deprecated
    public List<T> getAllItems() {
        return this.allItems;
    }

    public CdmObject getOwner() {
        return this.owner;
    }

    public CdmCorpusContext getCtx() {
        return this.ctx;
    }

    public CdmObjectType getDefaultType() {
        return this.defaultType;
    }

    public T add(String name) {
        return this.add(name, false);
    }

    public T add(String name, boolean simpleRef) {
        Object newObj = this.ctx.getCorpus().makeObject(this.defaultType, name, simpleRef);
        return this.add(newObj);
    }

    public T add(T currObject) {
        this.makeDocumentDirty();
        currObject.setOwner(this.getOwner());
        this.propagateInDocument((CdmObject)currObject, this.getOwner() == null ? null : this.getOwner().getInDocument());
        this.allItems.add(currObject);
        return currObject;
    }

    public boolean remove(T currObject) {
        boolean wasRemoved = this.allItems.remove(currObject);
        this.propagateInDocument((CdmObject)currObject, null);
        if (wasRemoved) {
            currObject.setOwner(null);
            this.makeDocumentDirty();
        }
        return wasRemoved;
    }

    public void removeAt(int index) {
        if (index >= 0 && index < this.getCount()) {
            CdmObject currObject = (CdmObject)this.allItems.get(index);
            boolean wasRemoved = this.allItems.remove(currObject);
            this.propagateInDocument(currObject, null);
            if (wasRemoved) {
                currObject.setOwner(null);
                this.makeDocumentDirty();
            }
        }
    }

    public T item(String name) {
        return (T)((CdmObject)this.allItems.stream().filter(x -> x.fetchObjectDefinitionName().equals(name)).findFirst().orElse(null));
    }

    public boolean remove(Object o) {
        return this.allItems.remove(o);
    }

    public void addAll(CdmCollection<T> cdmCollection) {
        for (CdmObject t : cdmCollection) {
            this.add(t);
        }
    }

    public void addAll(Collection<? extends T> c) {
        for (CdmObject t : c) {
            this.add(t);
        }
    }

    public void addAll(int index, Collection<? extends T> c) {
        for (CdmObject t : c) {
            this.add(index, t);
        }
    }

    public void clear() {
        this.allItems.forEach(item -> {
            item.setOwner(null);
            this.propagateInDocument((CdmObject)item, null);
        });
        this.makeDocumentDirty();
        this.allItems.clear();
    }

    public T get(int index) {
        return (T)((CdmObject)this.allItems.get(index));
    }

    public T set(int index, T element) {
        return (T)((CdmObject)this.allItems.set(index, element));
    }

    public void add(int index, T element) {
        element.setOwner(this.owner);
        this.propagateInDocument((CdmObject)element, this.getOwner().getInDocument());
        this.makeDocumentDirty();
        this.allItems.add(index, element);
    }

    public CdmCollection<T> copy(ResolveOptions resOpt) {
        return this.copy(resOpt, null);
    }

    public CdmCollection<T> copy(ResolveOptions resOpt, CdmObject host) {
        CdmCollection copy = new CdmCollection(this.getCtx(), this.getOwner(), this.getDefaultType());
        this.allItems.forEach(element -> copy.add(element.copy(resOpt)));
        return copy;
    }

    public int indexOf(Object o) {
        return this.allItems.indexOf(o);
    }

    public ListIterator<T> listIterator() {
        return this.allItems.listIterator();
    }

    public ListIterator<T> listIterator(int index) {
        return this.allItems.listIterator(index);
    }

    public CdmCollection<T> shallowCloneAndFilter(Predicate<T> predicate) {
        CdmCollection<CdmObject> clone = new CdmCollection<CdmObject>(this.ctx, this.owner, this.defaultType);
        for (CdmObject item : this.allItems) {
            if (!predicate.test(item)) continue;
            clone.add(item);
        }
        return clone;
    }

    public void sort(Comparator<? super T> c) {
        Object[] a = this.toArray();
        Arrays.sort(a, c);
        ListIterator<T> i = this.listIterator();
        for (Object e : a) {
            i.next();
            i.set((CdmObject)e);
        }
    }

    void makeDocumentDirty() {
        if (!this.getCtx().getCorpus().isCurrentlyResolving) {
            CdmDocumentDefinition document = null;
            if (this.getOwner() != null && this.getOwner().getInDocument() != null) {
                document = this.getOwner().getInDocument();
            } else if (this.getOwner() instanceof CdmDocumentDefinition) {
                document = (CdmDocumentDefinition)this.getOwner();
            }
            if (document != null) {
                document.setDirty(true);
                document.setNeedsIndexing(true);
            }
        }
    }

    void propagateInDocument(CdmObject cdmObject, CdmDocumentDefinition document) {
        if (!this.getCtx().getCorpus().isCurrentlyResolving) {
            cdmObject.visit("", (obj, path) -> {
                if (Objects.equals(obj.getInDocument(), document)) {
                    return true;
                }
                obj.setInDocument(document);
                return false;
            }, null);
        }
    }
}

