/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDataTypeReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectDefinitionBase;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttributeSetBuilder;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSetBuilder;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;

public class CdmDataTypeDefinition
extends CdmObjectDefinitionBase {
    private static final String TAG = CdmDataTypeDefinition.class.getSimpleName();
    private String dataTypeName;
    private CdmDataTypeReference extendsDataType;

    public CdmDataTypeDefinition(CdmCorpusContext ctx, String dataTypeName) {
        this(ctx, dataTypeName, null);
    }

    public CdmDataTypeDefinition(CdmCorpusContext ctx, String dataTypeName, CdmDataTypeReference extendsDataType) {
        super(ctx);
        this.setObjectType(CdmObjectType.DataTypeDef);
        this.setDataTypeName(dataTypeName);
        this.setExtendsDataType(extendsDataType);
    }

    @Override
    public boolean validate() {
        if (StringUtils.isNullOrTrimEmpty(this.dataTypeName)) {
            ArrayList<String> missingFields = new ArrayList<String>(Arrays.asList("dataTypeName"));
            Logger.error(this.getCtx(), TAG, "validate", this.getAtCorpusPath(), CdmLogCode.ErrValdnIntegrityCheckFailure, this.getAtCorpusPath(), String.join((CharSequence)", ", missingFields.parallelStream().map(s -> String.format("'%s'", s)).collect(Collectors.toList())));
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public Object copyData(ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectBase.copyData(this, resOpt, options, CdmDataTypeDefinition.class);
    }

    @Override
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        CdmDataTypeDefinition copy;
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        if (host == null) {
            copy = new CdmDataTypeDefinition(this.getCtx(), this.getDataTypeName(), null);
        } else {
            copy = (CdmDataTypeDefinition)host;
            copy.setDataTypeName(this.getDataTypeName());
        }
        if (this.getExtendsDataType() != null) {
            copy.setExtendsDataType((CdmDataTypeReference)this.getExtendsDataType().copy(resOpt));
        }
        this.copyDef(resOpt, copy);
        return copy;
    }

    @Override
    public String getName() {
        return this.dataTypeName;
    }

    @Override
    public boolean isDerivedFrom(String baseDef, ResolveOptions resOpt) {
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        return this.isDerivedFromDef(resOpt, this.getExtendsDataType(), this.getName(), baseDef);
    }

    @Override
    public boolean visit(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        String path = this.fetchDeclaredPath(pathFrom);
        if (preChildren != null && preChildren.invoke(this, path)) {
            return false;
        }
        if (this.getExtendsDataType() != null) {
            this.getExtendsDataType().setOwner(this);
            if (this.getExtendsDataType().visit(path + "/extendsDataType/", preChildren, postChildren)) {
                return true;
            }
        }
        if (this.visitDef(path, preChildren, postChildren)) {
            return true;
        }
        return postChildren != null && postChildren.invoke(this, path);
    }

    @Override
    void constructResolvedTraits(ResolvedTraitSetBuilder rtsb, ResolveOptions resOpt) {
        this.constructResolvedTraitsDef(this.getExtendsDataType(), rtsb, resOpt);
    }

    @Override
    @Deprecated
    public ResolvedAttributeSetBuilder constructResolvedAttributes(ResolveOptions resOpt) {
        return this.constructResolvedAttributes(resOpt, null);
    }

    @Override
    @Deprecated
    public ResolvedAttributeSetBuilder constructResolvedAttributes(ResolveOptions resOpt, CdmAttributeContext under) {
        return null;
    }

    public String getDataTypeName() {
        return this.dataTypeName;
    }

    public void setDataTypeName(String value) {
        this.dataTypeName = value;
    }

    public CdmDataTypeReference getExtendsDataType() {
        return this.extendsDataType;
    }

    public void setExtendsDataType(CdmDataTypeReference value) {
        this.extendsDataType = value;
    }
}

