/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDocumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmImport;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import java.util.List;

public class CdmImportCollection
extends CdmCollection<CdmImport> {
    public CdmImportCollection(CdmCorpusContext ctx, CdmObject owner) {
        super(ctx, owner, CdmObjectType.Import);
    }

    public CdmImport item(String corpusPath, String moniker, boolean checkMoniker) {
        if (checkMoniker) {
            return this.allItems.stream().filter(x -> corpusPath.equals(x.getCorpusPath()) && (x.getMoniker() == null && moniker == null || x.getMoniker() != null && x.getMoniker().equals(moniker))).findFirst().orElse(null);
        }
        return this.allItems.stream().filter(x -> corpusPath.equals(x.getCorpusPath())).findFirst().orElse(null);
    }

    public CdmImport item(String corpusPath, String moniker) {
        return this.item(corpusPath, moniker, true);
    }

    @Override
    public CdmImport item(String corpusPath) {
        return this.item(corpusPath, null);
    }

    @Override
    public CdmDocumentDefinition getOwner() {
        return (CdmDocumentDefinition)super.getOwner();
    }

    @Override
    public CdmImport add(String corpusPath) {
        return (CdmImport)((Object)super.add(corpusPath));
    }

    @Override
    public CdmImport add(String corpusPath, boolean simpleRef) {
        CdmImport cdmImport = (CdmImport)this.getCtx().getCorpus().makeObject(this.getDefaultType(), corpusPath, simpleRef);
        this.add(cdmImport);
        return cdmImport;
    }

    public CdmImport add(String corpusPath, String moniker) {
        CdmImport cdmImport = this.add(corpusPath);
        cdmImport.setMoniker(moniker);
        return cdmImport;
    }

    @Override
    public CdmImport add(CdmImport currObject) {
        if (currObject.previousOwner != null) {
            String absolutePath = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(currObject.getCorpusPath(), currObject.previousOwner);
            currObject.setCorpusPath(this.getCtx().getCorpus().getStorage().createRelativeCorpusPath(absolutePath, this.getOwner()));
        }
        return super.add(currObject);
    }

    @Override
    public void addAll(List<CdmImport> importList) {
        importList.forEach(this::add);
    }
}

