/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder;

import com.fasterxml.jackson.databind.JsonNode;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReferenceBase;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.ArgumentPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.CdmObjectRefPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.TraitPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.Utils;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import java.util.ArrayList;

public class TraitReferencePersistence {
    public static CdmTraitReference fromData(CdmCorpusContext ctx, JsonNode obj) {
        Object trait;
        if (obj == null) {
            return null;
        }
        boolean simpleReference = true;
        Boolean optional = null;
        JsonNode args = null;
        CdmTraitReference trVerb = null;
        ArrayList<CdmTraitReferenceBase> appliedTraits = null;
        if (obj.isValueNode()) {
            trait = obj;
        } else {
            simpleReference = false;
            args = obj.get("arguments");
            optional = Utils.propertyFromDataToBoolean(obj.get("optional"));
            trait = obj.get("traitReference").isValueNode() ? obj.get("traitReference").asText() : TraitPersistence.fromData(ctx, obj.get("traitReference"));
            trVerb = TraitReferencePersistence.fromData(ctx, obj.get("verb"));
            appliedTraits = Utils.createTraitReferenceList(ctx, obj.get("appliedTraits"));
        }
        CdmTraitReference traitReference = (CdmTraitReference)ctx.getCorpus().makeRef(CdmObjectType.TraitRef, trait, simpleReference);
        if (optional != null) {
            traitReference.setOptional(optional);
        }
        if (args != null) {
            args.forEach(a -> traitReference.getArguments().add(ArgumentPersistence.fromData(ctx, a)));
        }
        traitReference.setVerb(trVerb);
        Utils.addListToCdmCollection(traitReference.getAppliedTraits(), appliedTraits);
        return traitReference;
    }

    public static Object toData(CdmTraitReference instance, ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectRefPersistence.toData(instance, resOpt, options);
    }
}

