/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.resolvedmodel;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusDefinition;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmStatusLevel;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttributeSetBuilder;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSet;
import com.microsoft.commondatamodel.objectmodel.utilities.EventCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.EventList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;

public class ResolveContext
implements CdmCorpusContext {
    protected final Map<String, ResolvedAttributeSetBuilder> attributeCache;
    protected final Map<String, ResolvedTraitSet> traitCache;
    String corpusPathRoot;
    private CdmCorpusDefinition corpus;
    private String relativePath;
    private CdmStatusLevel reportAtLevel;
    private EventCallback statusEvent;
    private EventList events;
    private HashSet<CdmLogCode> suppressedLogCodes;
    private String correlationId;
    private Map<String, Object> featureFlags;

    public ResolveContext(CdmCorpusDefinition corpus) {
        this(corpus, null);
    }

    public ResolveContext(CdmCorpusDefinition corpus, EventCallback statusEvent) {
        this(corpus, statusEvent, null);
    }

    public ResolveContext(CdmCorpusDefinition corpus, EventCallback statusEvent, CdmStatusLevel reportAtLevel) {
        this.reportAtLevel = reportAtLevel != null ? reportAtLevel : CdmStatusLevel.Warning;
        this.statusEvent = statusEvent;
        this.attributeCache = new LinkedHashMap<String, ResolvedAttributeSetBuilder>();
        this.traitCache = new LinkedHashMap<String, ResolvedTraitSet>();
        this.corpus = corpus;
        this.events = new EventList();
        this.suppressedLogCodes = new HashSet();
        this.featureFlags = new HashMap<String, Object>();
    }

    @Override
    public CdmCorpusDefinition getCorpus() {
        return this.corpus;
    }

    @Override
    public void setCorpus(CdmCorpusDefinition value) {
        this.corpus = value;
    }

    @Override
    public CdmStatusLevel getReportAtLevel() {
        return this.reportAtLevel;
    }

    @Override
    public void setReportAtLevel(CdmStatusLevel value) {
        this.reportAtLevel = value;
    }

    @Override
    public EventCallback getStatusEvent() {
        return this.statusEvent;
    }

    @Override
    public void setStatusEvent(EventCallback value) {
        this.statusEvent = value;
    }

    @Override
    public EventList getEvents() {
        return this.events;
    }

    @Override
    public HashSet<CdmLogCode> getSuppressedLogCodes() {
        return this.suppressedLogCodes;
    }

    @Override
    public String getCorrelationId() {
        return this.correlationId;
    }

    @Override
    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    @Override
    public Map<String, Object> getFeatureFlags() {
        return this.featureFlags;
    }

    @Override
    public void setFeatureFlags(Map<String, Object> featureFlags) {
        this.featureFlags = featureFlags;
    }

    @Deprecated
    public String getRelativePath() {
        return this.relativePath;
    }

    @Deprecated
    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
    }

    @Deprecated
    public String getCorpusPathRoot() {
        return this.corpusPathRoot;
    }

    @Deprecated
    public void setCorpusPathRoot(String corpusPathRoot) {
        this.corpusPathRoot = corpusPathRoot;
    }

    @Deprecated
    public Map<String, ResolvedAttributeSetBuilder> getAttributeCache() {
        return this.attributeCache;
    }

    @Deprecated
    public Map<String, ResolvedTraitSet> getTraitCache() {
        return this.traitCache;
    }
}

