/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.resolvedmodel;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.TraitProfile;
import com.microsoft.commondatamodel.objectmodel.utilities.JMapper;
import java.util.ArrayList;
import java.util.Map;

class traitProfileKeyFactory {
    traitProfileKeyFactory() {
    }

    public static String collectionGetKey(ArrayList<TraitProfile> col) {
        if (col == null || col.size() == 0) {
            return "[]";
        }
        Object key = "[";
        for (TraitProfile t : col) {
            key = (String)key + t.getTpId();
        }
        key = (String)key + "]";
        return key;
    }

    public static String getKey(TraitProfile prof) {
        String iKey = prof.getIS_A() == null ? "0" : prof.getIS_A().getTpId();
        String rKey = prof.getReferences() == null ? "0" : prof.getReferences().getTpId();
        String vKey = prof.getVerb() == null ? "0" : prof.getVerb().getTpId();
        Object aKey = "[]";
        if (prof.getArgumentValues() != null && prof.getArgumentValues().size() > 0) {
            aKey = "[";
            for (Map.Entry<String, Object> kv : prof.getArgumentValues().entrySet()) {
                aKey = (String)aKey + "{";
                aKey = (String)aKey + kv.getKey();
                aKey = (String)aKey + "=";
                try {
                    aKey = (String)aKey + JMapper.WRITER.writeValueAsString(kv.getValue());
                }
                catch (JsonProcessingException e) {
                    aKey = (String)aKey + "failed conversion";
                }
                aKey = (String)aKey + "}";
            }
            aKey = (String)aKey + "]";
        }
        String cKey = traitProfileKeyFactory.collectionGetKey(prof.getClassifications());
        String mKey = traitProfileKeyFactory.collectionGetKey(prof.getMetaTraits());
        return String.format("%s i:%s r:%s v:%s a:%s c:%s m:%s", prof.getTraitName(), iKey, rKey, vKey, aKey, cKey, mKey);
    }
}

