/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.utilities;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDocumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.enums.ImportsLoadStrategy;
import com.microsoft.commondatamodel.objectmodel.utilities.AttributeResolutionDirectiveSet;
import com.microsoft.commondatamodel.objectmodel.utilities.DepthInfo;
import com.microsoft.commondatamodel.objectmodel.utilities.SymbolSet;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public class ResolveOptions {
    private CdmDocumentDefinition wrtDoc;
    private AttributeResolutionDirectiveSet directives;
    private boolean shallowValidation;
    private ImportsLoadStrategy importsLoadStrategy = ImportsLoadStrategy.LazyLoad;
    private Integer resolvedAttributeLimit = 4000;
    private int maxOrdinalForArrayExpansion = 20;
    private int maxDepth = 2;
    private boolean saveResolutionsOnCopy;
    private SymbolSet symbolRefSet = new SymbolSet();
    private CdmDocumentDefinition localizeReferencesFor;
    private CdmDocumentDefinition indexingDoc;
    private String fromMoniker;
    @Deprecated
    public DepthInfo depthInfo = new DepthInfo();
    @Deprecated
    public boolean inCircularReference = false;
    private HashMap<CdmAttributeContext, CdmAttributeContext> mapOldCtxToNewCtx;
    public HashSet<CdmEntityDefinition> currentlyResolvingEntities = new HashSet();
    public boolean usedResolutionGuidance = false;

    public ResolveOptions(CdmDocumentDefinition cdmDocument) {
        this(cdmDocument, null);
    }

    public ResolveOptions(CdmDocumentDefinition cdmDocument, AttributeResolutionDirectiveSet directives) {
        this();
        this.setWrtDoc(cdmDocument);
        this.setDirectives(directives != null ? directives.copy() : new AttributeResolutionDirectiveSet(new HashSet<String>(Arrays.asList("referenceOnly", "normalized"))));
    }

    public ResolveOptions(CdmObject cdmObject) {
        this(cdmObject, null);
    }

    public ResolveOptions(CdmObject cdmObject, AttributeResolutionDirectiveSet directives) {
        this();
        this.setWrtDoc(ResolveOptions.fetchDocument(cdmObject));
        this.setDirectives(directives != null ? directives.copy() : new AttributeResolutionDirectiveSet(new HashSet<String>(Arrays.asList("referenceOnly", "normalized"))));
    }

    public ResolveOptions() {
    }

    @Deprecated
    public void setSymbolRefSet(SymbolSet symbolRefSet) {
        this.symbolRefSet = symbolRefSet;
    }

    public boolean getShallowValidation() {
        return this.shallowValidation;
    }

    public void setShallowValidation(boolean shallowValidation) {
        this.shallowValidation = shallowValidation;
    }

    public ImportsLoadStrategy getImportsLoadStrategy() {
        return this.importsLoadStrategy;
    }

    public void setImportsLoadStrategy(ImportsLoadStrategy importsLoadStrategy) {
        this.importsLoadStrategy = importsLoadStrategy;
    }

    @Deprecated
    public Boolean getStrictValidation() {
        if (this.importsLoadStrategy == ImportsLoadStrategy.LazyLoad) {
            return null;
        }
        return this.importsLoadStrategy == ImportsLoadStrategy.Load;
    }

    @Deprecated
    public void setStrictValidation(Boolean strictValidation) {
        this.importsLoadStrategy = strictValidation == null ? ImportsLoadStrategy.LazyLoad : (strictValidation != false ? ImportsLoadStrategy.Load : ImportsLoadStrategy.DoNotLoad);
    }

    @Deprecated
    public void setSaveResolutionsOnCopy(boolean saveResolutionsOnCopy) {
        this.saveResolutionsOnCopy = saveResolutionsOnCopy;
    }

    public void setDirectives(AttributeResolutionDirectiveSet directives) {
        this.directives = directives;
    }

    public CdmDocumentDefinition getWrtDoc() {
        return this.wrtDoc;
    }

    public void setWrtDoc(CdmDocumentDefinition wrtDoc) {
        this.wrtDoc = wrtDoc;
    }

    public Integer getResolvedAttributeLimit() {
        return this.resolvedAttributeLimit;
    }

    public void setResolvedAttributeLimit(Integer resolvedAttributeLimit) {
        this.resolvedAttributeLimit = resolvedAttributeLimit;
    }

    public int getMaxOrdinalForArrayExpansion() {
        return this.maxOrdinalForArrayExpansion;
    }

    public void setMaxOrdinalForArrayExpansion(int maxOrdinalForArrayExpansion) {
        this.maxOrdinalForArrayExpansion = maxOrdinalForArrayExpansion;
    }

    @Deprecated
    public CdmDocumentDefinition getIndexingDoc() {
        return this.indexingDoc;
    }

    @Deprecated
    public boolean isSaveResolutionsOnCopy() {
        return this.saveResolutionsOnCopy;
    }

    @Deprecated
    public SymbolSet getSymbolRefSet() {
        return this.symbolRefSet;
    }

    public AttributeResolutionDirectiveSet getDirectives() {
        return this.directives;
    }

    @Deprecated
    public void setIndexingDoc(CdmDocumentDefinition indexingDoc) {
        this.indexingDoc = indexingDoc;
    }

    @Deprecated
    public CdmDocumentDefinition getLocalizeReferencesFor() {
        return this.localizeReferencesFor;
    }

    @Deprecated
    public void setLocalizeReferencesFor(CdmDocumentDefinition localizeReferencesFor) {
        this.localizeReferencesFor = localizeReferencesFor;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public ResolveOptions copy() {
        ResolveOptions resOptCopy = new ResolveOptions();
        resOptCopy.wrtDoc = this.wrtDoc;
        resOptCopy.depthInfo = this.depthInfo.copy();
        resOptCopy.localizeReferencesFor = this.localizeReferencesFor;
        resOptCopy.indexingDoc = this.indexingDoc;
        resOptCopy.shallowValidation = this.shallowValidation;
        resOptCopy.resolvedAttributeLimit = this.resolvedAttributeLimit;
        resOptCopy.setMapOldCtxToNewCtx(this.mapOldCtxToNewCtx);
        resOptCopy.importsLoadStrategy = this.importsLoadStrategy;
        resOptCopy.saveResolutionsOnCopy = this.saveResolutionsOnCopy;
        resOptCopy.currentlyResolvingEntities = this.currentlyResolvingEntities;
        resOptCopy.usedResolutionGuidance = this.usedResolutionGuidance;
        if (this.directives != null) {
            resOptCopy.directives = this.directives.copy();
        }
        return resOptCopy;
    }

    @Deprecated
    public String getFromMoniker() {
        return this.fromMoniker;
    }

    @Deprecated
    public void setFromMoniker(String fromMoniker) {
        this.fromMoniker = fromMoniker;
    }

    @Deprecated
    public HashMap<CdmAttributeContext, CdmAttributeContext> getMapOldCtxToNewCtx() {
        return this.mapOldCtxToNewCtx;
    }

    @Deprecated
    public void setMapOldCtxToNewCtx(HashMap<CdmAttributeContext, CdmAttributeContext> mapOldCtxToNewCtx) {
        this.mapOldCtxToNewCtx = mapOldCtxToNewCtx;
    }

    private static CdmDocumentDefinition fetchDocument(CdmObject obj) {
        if (obj == null) {
            return null;
        }
        if (obj.getInDocument() != null) {
            return obj.getInDocument();
        }
        return obj.getOwner() != null ? obj.getOwner().getInDocument() : null;
    }

    @Deprecated
    public boolean checkAttributeCount(int amount) {
        return this.getResolvedAttributeLimit() == null || amount <= this.getResolvedAttributeLimit();
    }
}

