/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeItem;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeResolutionGuidance;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectDefinitionBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmPurposeReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReferenceBase;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CardinalitySettings;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSetBuilder;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;

public abstract class CdmAttribute
extends CdmObjectDefinitionBase
implements CdmAttributeItem {
    private String name;
    private CdmPurposeReference purpose;
    private CdmAttributeResolutionGuidance resolutionGuidance;
    private CdmTraitCollection appliedTraits;
    private int attributeCount;
    private CardinalitySettings cardinality;

    public CdmAttribute(CdmCorpusContext ctx, String name) {
        super(ctx);
        this.name = name;
        this.appliedTraits = new CdmTraitCollection(this.getCtx(), this);
        this.setAttributeCount(0);
    }

    CdmAttribute copyAtt(ResolveOptions resOpt, CdmAttribute copy) {
        copy.setPurpose(this.getPurpose() != null ? (CdmPurposeReference)this.getPurpose().copy(resOpt) : null);
        copy.setResolutionGuidance(this.getResolutionGuidance() != null ? (CdmAttributeResolutionGuidance)this.getResolutionGuidance().copy(resOpt) : null);
        copy.getAppliedTraits().clear();
        for (CdmTraitReferenceBase trait : this.getAppliedTraits()) {
            copy.getAppliedTraits().add((CdmTraitReferenceBase)trait.copy(resOpt));
        }
        this.copyDef(resOpt, copy);
        return copy;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        this.name = value;
    }

    public CdmPurposeReference getPurpose() {
        return this.purpose;
    }

    public void setPurpose(CdmPurposeReference value) {
        this.purpose = value;
    }

    public CdmAttributeResolutionGuidance getResolutionGuidance() {
        return this.resolutionGuidance;
    }

    public void setResolutionGuidance(CdmAttributeResolutionGuidance value) {
        this.resolutionGuidance = value;
    }

    @Override
    public CdmTraitCollection getAppliedTraits() {
        return this.appliedTraits;
    }

    public int getAttributeCount() {
        return this.attributeCount;
    }

    public void setAttributeCount(int attributeCount) {
        this.attributeCount = attributeCount;
    }

    public CardinalitySettings getCardinality() {
        return this.cardinality;
    }

    public void setCardinality(CardinalitySettings cardinality) {
        this.cardinality = cardinality;
    }

    boolean visitAtt(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        if (this.getPurpose() != null) {
            this.getPurpose().setOwner(this);
        }
        if (this.getPurpose() != null && this.getPurpose().visit(pathFrom + "/purpose/", preChildren, postChildren)) {
            return true;
        }
        if (this.getAppliedTraits() != null && this.getAppliedTraits().visitList(pathFrom + "/appliedTraits/", preChildren, postChildren)) {
            return true;
        }
        if (this.getResolutionGuidance() != null) {
            this.getResolutionGuidance().setOwner(this);
            if (this.getResolutionGuidance().visit(pathFrom + "/resolutionGuidance/", preChildren, postChildren)) {
                return true;
            }
        }
        return this.visitDef(pathFrom, preChildren, postChildren);
    }

    ResolvedTraitSet addResolvedTraitsApplied(ResolvedTraitSetBuilder rtsb, ResolveOptions resOpt) {
        this.getAppliedTraits().forEach(item -> rtsb.mergeTraits(item.fetchResolvedTraits(resOpt)));
        return rtsb.getResolvedTraitSet();
    }
}

