/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDataPartitionDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDataPartitionPatternDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityDeclarationDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmFileStatus;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectDefinitionBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReferenceBase;
import com.microsoft.commondatamodel.objectmodel.enums.CdmIncrementalPartitionType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.enums.PartitionFileStatusCheckType;
import com.microsoft.commondatamodel.objectmodel.storage.StorageAdapterBase;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.FileStatusCheckOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.TimeUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.exceptions.CdmReadPartitionFromPatternException;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

public class CdmLocalEntityDeclarationDefinition
extends CdmObjectDefinitionBase
implements CdmEntityDeclarationDefinition {
    private static final String TAG = CdmLocalEntityDeclarationDefinition.class.getSimpleName();
    public String entityName;
    public String entityPath;
    public OffsetDateTime lastFileStatusCheckTime;
    public OffsetDateTime lastFileModifiedTime;
    public OffsetDateTime lastFileModifiedOldTime;
    public OffsetDateTime lastChildFileModifiedTime;
    private CdmCollection<CdmDataPartitionDefinition> dataPartitions;
    private CdmCollection<CdmDataPartitionPatternDefinition> dataPartitionPatterns;
    private CdmCollection<CdmDataPartitionDefinition> incrementalPartitions;
    private CdmCollection<CdmDataPartitionPatternDefinition> incrementalPartitionPatterns;
    private String virtualLocation;

    public CdmLocalEntityDeclarationDefinition(CdmCorpusContext ctx, String entityName) {
        super(ctx);
        this.setObjectType(CdmObjectType.LocalEntityDeclarationDef);
        this.setEntityName(entityName);
        this.dataPartitions = new CdmCollection(this.getCtx(), this, CdmObjectType.DataPartitionDef);
        this.dataPartitionPatterns = new CdmCollection(this.getCtx(), this, CdmObjectType.DataPartitionPatternDef);
        this.incrementalPartitions = new CdmCollection(this.getCtx(), this, CdmObjectType.DataPartitionDef);
        this.incrementalPartitionPatterns = new CdmCollection(this.getCtx(), this, CdmObjectType.DataPartitionPatternDef);
        this.lastFileModifiedOldTime = null;
        this.lastFileModifiedTime = null;
    }

    @Override
    public String getName() {
        return this.getEntityName();
    }

    @Override
    public boolean isDerivedFrom(String baseDef, ResolveOptions resOpt) {
        return false;
    }

    @Override
    public boolean visit(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        String path = this.fetchDeclaredPath(pathFrom);
        if (preChildren != null && preChildren.invoke(this, path)) {
            return false;
        }
        if (this.dataPartitions != null && this.dataPartitions.visitList(path + "/dataPartitions/", preChildren, postChildren)) {
            return true;
        }
        if (this.dataPartitionPatterns != null && this.dataPartitionPatterns.visitList(path + "/dataPartitionPatterns/", preChildren, postChildren)) {
            return true;
        }
        if (this.incrementalPartitions != null && this.incrementalPartitions.visitList(path + "/incrementalPartitions/", preChildren, postChildren)) {
            return true;
        }
        if (this.incrementalPartitionPatterns != null && this.incrementalPartitionPatterns.visitList(path + "/incrementalPartitionPatterns/", preChildren, postChildren)) {
            return true;
        }
        if (this.visitDef(path, preChildren, postChildren)) {
            return true;
        }
        return postChildren != null && postChildren.invoke(this, path);
    }

    @Override
    public String getEntityPath() {
        return this.entityPath;
    }

    @Override
    public void setEntityPath(String value) {
        this.entityPath = value;
    }

    @Override
    public CdmCollection<CdmDataPartitionDefinition> getDataPartitions() {
        return this.dataPartitions;
    }

    @Override
    public CdmCollection<CdmDataPartitionPatternDefinition> getDataPartitionPatterns() {
        return this.dataPartitionPatterns;
    }

    @Override
    public CdmCollection<CdmDataPartitionDefinition> getIncrementalPartitions() {
        return this.incrementalPartitions;
    }

    @Override
    public CdmCollection<CdmDataPartitionPatternDefinition> getIncrementalPartitionPatterns() {
        return this.incrementalPartitionPatterns;
    }

    @Override
    public String getEntityName() {
        return this.entityName;
    }

    @Override
    public void setEntityName(String value) {
        this.entityName = value;
    }

    @Override
    public OffsetDateTime getLastChildFileModifiedTime() {
        return this.lastChildFileModifiedTime;
    }

    @Override
    public void setLastChildFileModifiedTime(OffsetDateTime value) {
        this.lastChildFileModifiedTime = value;
    }

    @Override
    public OffsetDateTime getLastFileStatusCheckTime() {
        return this.lastFileStatusCheckTime;
    }

    @Override
    public void setLastFileStatusCheckTime(OffsetDateTime value) {
        this.lastFileStatusCheckTime = value;
    }

    @Override
    public OffsetDateTime getLastFileModifiedTime() {
        return this.lastFileModifiedTime;
    }

    @Override
    public void setLastFileModifiedTime(OffsetDateTime value) {
        this.setlastFileModifiedOldTime(this.lastFileModifiedTime);
        this.lastFileModifiedTime = value;
    }

    public OffsetDateTime getlastFileModifiedOldTime() {
        return this.lastFileModifiedOldTime;
    }

    private void setlastFileModifiedOldTime(OffsetDateTime value) {
        this.lastFileModifiedOldTime = value;
    }

    @Deprecated
    public String getVirtualLocation() {
        return this.virtualLocation;
    }

    @Deprecated
    public void setVirtualLocation(String virtualLocation) {
        this.virtualLocation = virtualLocation;
    }

    public boolean isVirtual() {
        return !StringUtils.isNullOrTrimEmpty(this.virtualLocation);
    }

    @Override
    public CompletableFuture<Void> fileStatusCheckAsync() throws CdmReadPartitionFromPatternException {
        return this.fileStatusCheckAsync(PartitionFileStatusCheckType.Full);
    }

    public CompletableFuture<Void> fileStatusCheckAsync(PartitionFileStatusCheckType partitionFileStatusCheckType) throws CdmReadPartitionFromPatternException {
        return this.fileStatusCheckAsync(partitionFileStatusCheckType, CdmIncrementalPartitionType.None);
    }

    public CompletableFuture<Void> fileStatusCheckAsync(PartitionFileStatusCheckType partitionFileStatusCheckType, CdmIncrementalPartitionType incrementalType) throws CdmReadPartitionFromPatternException {
        return this.fileStatusCheckAsync(partitionFileStatusCheckType, incrementalType, null);
    }

    public CompletableFuture<Void> fileStatusCheckAsync(PartitionFileStatusCheckType partitionFileStatusCheckType, CdmIncrementalPartitionType incrementalType, FileStatusCheckOptions fileStatusCheckOptions) throws CdmReadPartitionFromPatternException {
        return CompletableFuture.runAsync(() -> {
            StorageAdapterBase adapter = this.getCtx().getCorpus().getStorage().fetchAdapter(this.getInDocument().getNamespace());
            StorageAdapterBase.CacheContext cacheContext = null;
            if (adapter != null) {
                cacheContext = adapter.createFileQueryCacheContext();
            }
            try {
                OffsetDateTime modifiedTime;
                String fullPath = this.getCtx().getCorpus().getStorage().createAbsoluteCorpusPath(this.getEntityPath(), this.getInDocument());
                OffsetDateTime offsetDateTime = modifiedTime = this.isVirtual() ? this.getCtx().getCorpus().getLastModifiedTimeFromObjectAsync(this).join() : this.getCtx().getCorpus().computeLastModifiedTimeAsync(fullPath, this).join();
                if (partitionFileStatusCheckType == PartitionFileStatusCheckType.Full || partitionFileStatusCheckType == PartitionFileStatusCheckType.FullAndIncremental) {
                    for (CdmDataPartitionPatternDefinition pattern : this.getDataPartitionPatterns()) {
                        if (pattern.isIncremental()) {
                            Logger.error(pattern.getCtx(), TAG, "fileStatusCheckAsync", pattern.getAtCorpusPath(), CdmLogCode.ErrUnexpectedIncrementalPartitionTrait, pattern.getClass().getSimpleName(), pattern.fetchObjectDefinitionName(), "is.partition.incremental", "dataPartitionPatterns");
                            continue;
                        }
                        pattern.fileStatusCheckAsync(fileStatusCheckOptions).join();
                    }
                    for (CdmDataPartitionDefinition partition : this.getDataPartitions()) {
                        if (partition.isIncremental()) {
                            Logger.error(partition.getCtx(), TAG, "fileStatusCheckAsync", partition.getAtCorpusPath(), CdmLogCode.ErrUnexpectedIncrementalPartitionTrait, partition.getClass().getSimpleName(), partition.fetchObjectDefinitionName(), "is.partition.incremental", "dataPartitions");
                            continue;
                        }
                        partition.fileStatusCheckAsync(fileStatusCheckOptions).join();
                    }
                }
                if (partitionFileStatusCheckType == PartitionFileStatusCheckType.Incremental || partitionFileStatusCheckType == PartitionFileStatusCheckType.FullAndIncremental) {
                    for (CdmDataPartitionPatternDefinition pattern : this.getIncrementalPartitionPatterns()) {
                        if (!this.shouldCallFileStatusCheck(incrementalType, true, pattern)) continue;
                        pattern.fileStatusCheckAsync().join();
                    }
                    for (CdmDataPartitionDefinition partition : this.getIncrementalPartitions()) {
                        if (!this.shouldCallFileStatusCheck(incrementalType, false, partition)) continue;
                        partition.fileStatusCheckAsync().join();
                    }
                }
                this.setLastFileStatusCheckTime(OffsetDateTime.now(ZoneOffset.UTC));
                this.setLastFileModifiedTime(TimeUtils.maxTime(modifiedTime, this.getLastFileModifiedTime()));
                this.reportMostRecentTimeAsync(this.getLastFileModifiedTime()).join();
            }
            finally {
                if (cacheContext != null) {
                    cacheContext.dispose();
                }
            }
        });
    }

    private boolean shouldCallFileStatusCheck(CdmIncrementalPartitionType incrementalType, boolean isPattern, CdmObjectDefinitionBase patternOrPartitionObj) {
        boolean update = true;
        CdmTraitReference traitRef = (CdmTraitReference)patternOrPartitionObj.getExhibitsTraits().item("is.partition.incremental");
        if (traitRef == null) {
            Logger.error(patternOrPartitionObj.getCtx(), TAG, "shouldCallFileStatusCheck", patternOrPartitionObj.getAtCorpusPath(), CdmLogCode.ErrMissingIncrementalPartitionTrait, patternOrPartitionObj.getClass().getSimpleName(), patternOrPartitionObj.fetchObjectDefinitionName(), "is.partition.incremental", isPattern ? "incrementalPartitionPatterns" : "incrementalPartitions");
        } else {
            Object traitRefIncrementalTypeValue;
            if (incrementalType == CdmIncrementalPartitionType.None) {
                return update;
            }
            Object object = traitRefIncrementalTypeValue = traitRef.getArguments() != null ? traitRef.getArguments().fetchValue("type") : null;
            if (traitRefIncrementalTypeValue == null) {
                update = false;
                Logger.error(patternOrPartitionObj.getCtx(), TAG, "shouldCallFileStatusCheck", patternOrPartitionObj.getAtCorpusPath(), CdmLogCode.ErrTraitArgumentMissing, "type", "is.partition.incremental", patternOrPartitionObj.fetchObjectDefinitionName());
            } else if (!(traitRefIncrementalTypeValue instanceof String)) {
                update = false;
                Logger.error(patternOrPartitionObj.getCtx(), TAG, "shouldCallFileStatusCheck", patternOrPartitionObj.getAtCorpusPath(), CdmLogCode.ErrTraitInvalidArgumentValueType, "type", "is.partition.incremental", patternOrPartitionObj.fetchObjectDefinitionName());
            } else {
                String endpointStr = traitRefIncrementalTypeValue.toString();
                try {
                    CdmIncrementalPartitionType traitRefIncrementalType = CdmIncrementalPartitionType.valueOf(traitRefIncrementalTypeValue.toString());
                    update = traitRefIncrementalType == incrementalType;
                }
                catch (IllegalArgumentException ex) {
                    update = false;
                    Logger.error(patternOrPartitionObj.getCtx(), TAG, "shouldCallFileStatusCheck", patternOrPartitionObj.getAtCorpusPath(), CdmLogCode.ErrEnumConversionFailure, (String)traitRefIncrementalTypeValue, "CdmIncrementalPartitionType", "parameter 'type' of trait 'is.partition.incremental' from '" + patternOrPartitionObj.fetchObjectDefinitionName() + "'");
                }
            }
        }
        return update;
    }

    @Override
    public CompletableFuture<Void> reportMostRecentTimeAsync(OffsetDateTime childTime) {
        this.setLastChildFileModifiedTime(childTime);
        OffsetDateTime mostRecentAtThisLevel = TimeUtils.maxTime(childTime, this.getLastFileModifiedTime());
        if (this.getOwner() instanceof CdmFileStatus && mostRecentAtThisLevel != null) {
            return ((CdmFileStatus)this.getOwner()).reportMostRecentTimeAsync(mostRecentAtThisLevel);
        }
        return CompletableFuture.completedFuture(null);
    }

    @Override
    public boolean validate() {
        if (StringUtils.isNullOrTrimEmpty(this.entityName)) {
            ArrayList<String> missingFields = new ArrayList<String>(Arrays.asList("entityName"));
            Logger.error(this.getCtx(), TAG, "validate", this.getAtCorpusPath(), CdmLogCode.ErrValdnIntegrityCheckFailure, this.getAtCorpusPath(), String.join((CharSequence)", ", missingFields.parallelStream().map(s -> String.format("'%s'", s)).collect(Collectors.toList())));
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public Object copyData(ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectBase.copyData(this, resOpt, options, CdmLocalEntityDeclarationDefinition.class);
    }

    @Override
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        CdmLocalEntityDeclarationDefinition copy;
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        if (host == null) {
            copy = new CdmLocalEntityDeclarationDefinition(this.getCtx(), this.getEntityName());
        } else {
            copy = (CdmLocalEntityDeclarationDefinition)host;
            copy.setCtx(this.getCtx());
            copy.setEntityName(this.getEntityName());
            copy.getDataPartitions().clear();
            copy.getDataPartitionPatterns().clear();
            copy.getIncrementalPartitions().clear();
            copy.getIncrementalPartitionPatterns().clear();
        }
        copy.setEntityPath(this.getEntityPath());
        copy.setLastFileStatusCheckTime(this.getLastFileStatusCheckTime());
        copy.setLastFileModifiedTime(this.getLastFileModifiedTime());
        copy.setLastChildFileModifiedTime(this.getLastChildFileModifiedTime());
        copy.setVirtualLocation(this.getVirtualLocation());
        for (CdmDataPartitionDefinition dataPartition : this.getDataPartitions()) {
            copy.getDataPartitions().add((CdmDataPartitionDefinition)dataPartition.copy(resOpt));
        }
        for (CdmDataPartitionPatternDefinition dataPartitionPattern : this.getDataPartitionPatterns()) {
            copy.getDataPartitionPatterns().add((CdmDataPartitionPatternDefinition)dataPartitionPattern.copy(resOpt));
        }
        for (CdmDataPartitionDefinition incrementalPartition : this.getIncrementalPartitions()) {
            copy.getIncrementalPartitions().add((CdmDataPartitionDefinition)incrementalPartition.copy(resOpt));
        }
        for (CdmDataPartitionPatternDefinition incrementalPartitionPattern : this.getIncrementalPartitionPatterns()) {
            copy.getIncrementalPartitionPatterns().add((CdmDataPartitionPatternDefinition)incrementalPartitionPattern.copy(resOpt));
        }
        this.copyDef(resOpt, copy);
        return copy;
    }

    @Deprecated
    void createDataPartitionFromPattern(String filePath, CdmTraitCollection exhibitsTraits, Map<String, List<String>> args, String schema, OffsetDateTime modifiedTime) {
        this.createDataPartitionFromPattern(filePath, exhibitsTraits, args, schema, modifiedTime, false, null);
    }

    @Deprecated
    void createDataPartitionFromPattern(String filePath, CdmTraitCollection exhibitsTraits, Map<String, List<String>> args, String schema, OffsetDateTime modifiedTime, boolean isIncrementalPartition) {
        this.createDataPartitionFromPattern(filePath, exhibitsTraits, args, schema, modifiedTime, isIncrementalPartition, null);
    }

    @Deprecated
    void createDataPartitionFromPattern(String filePath, CdmTraitCollection exhibitsTraits, Map<String, List<String>> args, String schema, OffsetDateTime modifiedTime, boolean isIncrementalPartition, String incrementPartitionPatternName) {
        CdmDataPartitionDefinition newPartition = (CdmDataPartitionDefinition)this.getCtx().getCorpus().makeObject(CdmObjectType.DataPartitionDef);
        newPartition.setLocation(filePath);
        newPartition.setSpecializedSchema(schema);
        newPartition.setLastFileModifiedTime(modifiedTime);
        newPartition.setLastFileStatusCheckTime(OffsetDateTime.now(ZoneOffset.UTC));
        for (CdmTraitReferenceBase cdmTraitReferenceBase : exhibitsTraits) {
            newPartition.getExhibitsTraits().add((CdmTraitReferenceBase)cdmTraitReferenceBase.copy());
        }
        for (Map.Entry entry : args.entrySet()) {
            newPartition.getArguments().put((String)entry.getKey(), (List)entry.getValue());
        }
        if (!isIncrementalPartition) {
            this.dataPartitions.add(newPartition);
        } else {
            if (!StringUtils.isNullOrTrimEmpty(incrementPartitionPatternName)) {
                ((CdmTraitReference)newPartition.getExhibitsTraits().item("is.partition.incremental")).getArguments().add("incrementPartitionPatternName", incrementPartitionPatternName);
            }
            this.incrementalPartitions.add(newPartition);
        }
    }

    public void resetLastFileModifiedOldTime() {
        this.setlastFileModifiedOldTime(null);
    }
}

