/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeItem;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmConstantEntityDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDocumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityAttributeDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectDefinitionBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmParameterDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitCollection;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitGroupReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReferenceBase;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.persistence.PersistenceLayer;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolveContext;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttributeSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttributeSetBuilder;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTrait;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedTraitSetBuilder;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.TraitProfile;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.TraitProfileCache;
import com.microsoft.commondatamodel.objectmodel.utilities.AttributeContextParameters;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.SymbolSet;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class CdmObjectBase
implements CdmObject {
    private static final String TAG = CdmEntityAttributeDefinition.class.getSimpleName();
    private int id;
    private CdmCorpusContext ctx;
    private CdmDocumentDefinition inDocument;
    private String atCorpusPath;
    private CdmObjectType objectType;
    private CdmObject owner;
    private boolean resolvingTraits = false;
    private String declaredPath;
    private Map<String, ResolvedTraitSetBuilder> traitCache;
    static long DefaultJsonSchemaSemanticVersionNumber = CdmObjectBase.semanticVersionStringToNumber(CdmObjectBase.getJsonSchemaSemanticVersionMinimumSave());

    public static String getJsonSchemaSemanticVersionMinimumLoad() {
        return "1.0.0";
    }

    public static String getJsonSchemaSemanticVersionMinimumSave() {
        return "1.1.0";
    }

    public static String getJsonSchemaSemanticVersionMaximumSaveLoad() {
        return "1.5.0";
    }

    public static String getJsonSchemaSemanticVersionProjections() {
        return "1.4.0";
    }

    public static String getJsonSchemaSemanticVersionTraitsOnTraits() {
        return "1.5.0";
    }

    public CdmObjectBase() {
    }

    public CdmObjectBase(CdmCorpusContext ctx) {
        this.id = CdmCorpusDefinition.getNextId();
        this.ctx = ctx;
    }

    @Deprecated
    public static <T extends CdmObject> Object copyData(T instance, ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectBase.copyData(instance, resOpt, options, CdmObject.class);
    }

    @Deprecated
    public static <T extends CdmObject> Object copyData(T instance, ResolveOptions resOpt, CopyOptions options, Class<T> classInterface) {
        if (resOpt == null) {
            resOpt = new ResolveOptions(instance, instance.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        if (options == null) {
            options = new CopyOptions();
        }
        String persistenceTypeName = "CdmFolder";
        return PersistenceLayer.toData(instance, resOpt, options, "CdmFolder", classInterface);
    }

    @Deprecated
    public static CdmTraitReference resolvedTraitToTraitRef(ResolveOptions resOpt, ResolvedTrait rt) {
        CdmTraitReference traitRef = (CdmTraitReference)rt.getTrait().getCtx().getCorpus().makeObject(CdmObjectType.TraitRef, rt.getTraitName(), (rt.getParameterValues() == null || rt.getParameterValues().length() <= 0) && rt.getExplicitVerb() == null && rt.getMetaTraits() == null);
        if (rt.getParameterValues() != null && rt.getParameterValues().length() > 0) {
            int l = rt.getParameterValues().length();
            if (l == 1) {
                Object val = CdmObjectBase.ProtectParameterValues(resOpt, rt.getParameterValues().getValues().get(0));
                if (val != null) {
                    traitRef.getArguments().add(null, val);
                }
            } else {
                for (int i = 0; i < l; ++i) {
                    CdmParameterDefinition param = rt.getParameterValues().fetchParameter(i);
                    Object val = CdmObjectBase.ProtectParameterValues(resOpt, rt.getParameterValues().getValues().get(i));
                    if (val == null) continue;
                    traitRef.getArguments().add(param.getName(), val);
                }
            }
        }
        if (rt.getExplicitVerb() != null) {
            traitRef.setVerb((CdmTraitReference)rt.getExplicitVerb().copy(resOpt));
            traitRef.getVerb().setOwner(traitRef);
        }
        if (rt.getMetaTraits() != null) {
            for (CdmTraitReferenceBase trMeta : rt.getMetaTraits()) {
                CdmTraitReference trMetaCopy = (CdmTraitReference)trMeta.copy(resOpt);
                traitRef.getAppliedTraits().add(trMetaCopy);
            }
        }
        if (resOpt.isSaveResolutionsOnCopy()) {
            traitRef.setExplicitReference(rt.getTrait());
            traitRef.setInDocument(rt.getTrait().getInDocument());
        }
        if (rt.getTrait().getAssociatedProperties() != null && rt.getTrait().getAssociatedProperties().size() > 0 && !rt.getTrait().isDerivedFrom("is.dataFormat", resOpt) && !rt.getTrait().getTraitName().equals("is.constrainedList.wellKnown")) {
            traitRef.setFromProperty(true);
        }
        return traitRef;
    }

    @Deprecated
    public long getMinimumSemanticVersion() {
        return DefaultJsonSchemaSemanticVersionNumber;
    }

    public static long semanticVersionStringToNumber(String version) {
        if (version == null) {
            return -1L;
        }
        String[] semanticVersionSplit = version.split("\\.");
        if (semanticVersionSplit.length != 3) {
            return -1L;
        }
        long numVer = 0L;
        for (int i = 0; i < 3; ++i) {
            int verPart = 0;
            try {
                verPart = Integer.parseInt(semanticVersionSplit[i]);
            }
            catch (NumberFormatException e) {
                return -1L;
            }
            if (verPart > 100000) {
                return -1L;
            }
            numVer *= 100000L;
            numVer += (long)verPart;
        }
        return numVer;
    }

    public static String semanticVersionNumberToString(long version) {
        int verPartM = (int)(version / 10000000000L);
        int verPartm = (int)((version -= (long)verPartM * 10000000000L) / 100000L);
        int verPartP = (int)(version - (long)verPartm * 100000L);
        return String.valueOf(verPartM) + "." + String.valueOf(verPartm) + "." + String.valueOf(verPartP);
    }

    @Deprecated
    public static boolean visitList(Iterable<?> items, String path, VisitCallback preChildren, VisitCallback postChildren) {
        boolean result = false;
        if (items != null) {
            for (Object element : items) {
                if (element == null || !((CdmObjectBase)element).visit(path, preChildren, postChildren)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    void clearTraitCache() {
        this.traitCache = null;
    }

    @Deprecated
    public String getDeclaredPath() {
        return this.declaredPath;
    }

    @Deprecated
    public void setDeclaredPath(String declaredPath) {
        this.declaredPath = declaredPath;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setId(int value) {
        this.id = value;
    }

    @Override
    public CdmCorpusContext getCtx() {
        return this.ctx;
    }

    @Override
    public void setCtx(CdmCorpusContext value) {
        this.ctx = value;
    }

    @Override
    public CdmDocumentDefinition getInDocument() {
        return this.inDocument;
    }

    @Override
    public void setInDocument(CdmDocumentDefinition value) {
        this.inDocument = value;
    }

    @Override
    public String getAtCorpusPath() {
        if (this.getInDocument() == null) {
            return "NULL:/NULL/" + this.declaredPath;
        }
        return this.getInDocument().getAtCorpusPath() + "/" + (this.declaredPath != null ? this.declaredPath : "");
    }

    @Override
    public CdmObjectType getObjectType() {
        return this.objectType;
    }

    @Override
    public void setObjectType(CdmObjectType value) {
        this.objectType = value;
    }

    @Override
    public CdmObject getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(CdmObject value) {
        this.owner = value;
    }

    public List<TraitProfile> fetchTraitProfiles() {
        return this.fetchTraitProfiles(null, null, null);
    }

    public List<TraitProfile> fetchTraitProfiles(ResolveOptions resOpt) {
        return this.fetchTraitProfiles(resOpt, null, null);
    }

    public List<TraitProfile> fetchTraitProfiles(ResolveOptions resOpt, TraitProfileCache cache) {
        return this.fetchTraitProfiles(resOpt, cache, null);
    }

    @Override
    public List<TraitProfile> fetchTraitProfiles(ResolveOptions resOpt, TraitProfileCache cache, String forVerb) {
        if (cache == null) {
            cache = new TraitProfileCache();
        }
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.ctx.getCorpus().getDefaultResolutionDirectives());
        }
        ArrayList<TraitProfile> result = new ArrayList<TraitProfile>();
        CdmTraitCollection traits = null;
        TraitProfile prof = null;
        if (this instanceof CdmAttributeItem) {
            traits = ((CdmAttributeItem)((Object)this)).getAppliedTraits();
        } else if (this instanceof CdmTraitDefinition) {
            prof = TraitProfile._traitDefToProfile((CdmTraitDefinition)this, resOpt, false, false, cache);
        } else if (this instanceof CdmObjectDefinition) {
            traits = ((CdmObjectDefinition)((Object)this)).getExhibitsTraits();
        }
        if (this instanceof CdmTraitReference) {
            prof = TraitProfile._traitRefToProfile((CdmTraitReference)this, resOpt, false, false, true, cache);
        } else if (this instanceof CdmTraitGroupReference) {
            prof = TraitProfile._traitRefToProfile((CdmTraitGroupReference)this, resOpt, false, false, true, cache);
        } else if (this instanceof CdmObjectReference) {
            traits = ((CdmObjectReference)((Object)this)).getAppliedTraits();
        }
        if (prof != null && (prof.getVerb() == null || forVerb == null || prof.getVerb().getTraitName().equals(forVerb))) {
            result.add(prof);
        }
        if (traits != null) {
            for (CdmTraitReferenceBase tr : traits) {
                prof = TraitProfile._traitRefToProfile(tr, resOpt, false, false, true, cache);
                if (prof == null || prof.getVerb() != null && forVerb != null && !prof.getVerb().getTraitName().equals(forVerb)) continue;
                result.add(prof);
            }
        }
        if (result.size() == 0) {
            result = null;
        }
        return result;
    }

    void constructResolvedTraits(ResolvedTraitSetBuilder rtsb, ResolveOptions resOpt) {
    }

    @Deprecated
    public ResolvedAttributeSetBuilder constructResolvedAttributes(ResolveOptions resOptl) {
        return this.constructResolvedAttributes(resOptl, null);
    }

    @Deprecated
    public ResolvedAttributeSetBuilder constructResolvedAttributes(ResolveOptions resOpt, CdmAttributeContext under) {
        return null;
    }

    @Override
    @Deprecated
    public ResolvedTraitSet fetchResolvedTraits(ResolveOptions resOpt) {
        boolean wasPreviouslyResolving = this.getCtx().getCorpus().isCurrentlyResolving;
        this.getCtx().getCorpus().isCurrentlyResolving = true;
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        String kind = "rtsb";
        ResolveContext ctx = (ResolveContext)this.getCtx();
        String cacheTagA = ctx.getCorpus().createDefinitionCacheTag(resOpt, this, "rtsb");
        ResolvedTraitSetBuilder rtsbAll = null;
        if (this.getTraitCache() == null) {
            this.setTraitCache(new LinkedHashMap<String, ResolvedTraitSetBuilder>());
        } else if (!StringUtils.isNullOrTrimEmpty(cacheTagA)) {
            rtsbAll = this.getTraitCache().get(cacheTagA);
        }
        SymbolSet currDocRefSet = resOpt.getSymbolRefSet();
        if (currDocRefSet == null) {
            currDocRefSet = new SymbolSet();
        }
        resOpt.setSymbolRefSet(new SymbolSet());
        if (rtsbAll == null) {
            CdmObjectDefinitionBase objDef;
            rtsbAll = new ResolvedTraitSetBuilder();
            if (!this.resolvingTraits) {
                this.resolvingTraits = true;
                this.constructResolvedTraits(rtsbAll, resOpt);
                this.resolvingTraits = false;
            }
            if ((objDef = (CdmObjectDefinitionBase)this.fetchObjectDefinition(resOpt)) != null) {
                ctx.getCorpus().registerDefinitionReferenceSymbols(objDef, "rtsb", resOpt.getSymbolRefSet());
                if (rtsbAll.getResolvedTraitSet() == null) {
                    rtsbAll.setResolvedTraitSet(new ResolvedTraitSet(resOpt));
                }
                if (!StringUtils.isNullOrTrimEmpty(cacheTagA = ctx.getCorpus().createDefinitionCacheTag(resOpt, this, "rtsb"))) {
                    this.getTraitCache().put(cacheTagA, rtsbAll);
                }
            }
        } else {
            String key = CdmCorpusDefinition.createCacheKeyFromObject(this, "rtsb");
            SymbolSet tempDocRefSet = ctx.getCorpus().getDefinitionReferenceSymbols().get(key);
            resOpt.setSymbolRefSet(tempDocRefSet);
        }
        currDocRefSet.merge(resOpt.getSymbolRefSet());
        resOpt.setSymbolRefSet(currDocRefSet);
        this.getCtx().getCorpus().isCurrentlyResolving = wasPreviouslyResolving;
        return rtsbAll.getResolvedTraitSet();
    }

    @Deprecated
    public ResolvedAttributeSetBuilder fetchObjectFromCache(ResolveOptions resOpt, AttributeContextParameters acpInContext) {
        String kind = "rasb";
        ResolveContext ctx = (ResolveContext)this.getCtx();
        String cacheTag = ctx.getCorpus().createDefinitionCacheTag(resOpt, this, kind, acpInContext != null ? "ctx" : "");
        ResolvedAttributeSetBuilder rasbCache = null;
        if (cacheTag != null) {
            rasbCache = ctx.getAttributeCache().get(cacheTag);
        }
        return rasbCache;
    }

    @Override
    @Deprecated
    public ResolvedAttributeSet fetchResolvedAttributes(ResolveOptions resOpt) {
        return this.fetchResolvedAttributes(resOpt, null);
    }

    @Override
    @Deprecated
    public ResolvedAttributeSet fetchResolvedAttributes(ResolveOptions resOpt, AttributeContextParameters acpInContext) {
        boolean wasPreviouslyResolving = this.getCtx().getCorpus().isCurrentlyResolving;
        this.getCtx().getCorpus().isCurrentlyResolving = true;
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        boolean inCircularReference = false;
        boolean wasInCircularReference = resOpt.inCircularReference;
        if (this.objectType == CdmObjectType.EntityDef) {
            CdmEntityDefinition entity = (CdmEntityDefinition)this;
            inCircularReference = resOpt.currentlyResolvingEntities.contains(entity);
            resOpt.currentlyResolvingEntities.add(entity);
            resOpt.inCircularReference = inCircularReference;
        }
        int currentDepth = resOpt.depthInfo.getCurrentDepth();
        String kind = "rasb";
        ResolveContext ctx = (ResolveContext)this.getCtx();
        ResolvedAttributeSetBuilder rasbResult = null;
        ResolvedAttributeSetBuilder rasbCache = this.fetchObjectFromCache(resOpt, acpInContext);
        CdmAttributeContext underCtx = null;
        SymbolSet currDocRefSet = resOpt.getSymbolRefSet();
        if (currDocRefSet == null) {
            currDocRefSet = new SymbolSet();
        }
        resOpt.setSymbolRefSet(new SymbolSet());
        if (rasbCache != null && resOpt.depthInfo.getMaxDepth() != null && resOpt.depthInfo.getCurrentDepth() + rasbCache.getResolvedAttributeSet().getDepthTraveled() > resOpt.depthInfo.getMaxDepth()) {
            Logger.warning(this.getCtx(), TAG, "fetchResolvedAttributes", this.getAtCorpusPath(), CdmLogCode.WarnMaxDepthExceeded, resOpt.depthInfo.getMaxDepth() != null ? resOpt.depthInfo.getMaxDepth().toString() : "", this.fetchObjectDefinitionName());
            rasbCache = null;
        }
        if (rasbCache == null) {
            underCtx = CdmAttributeContext.getUnderContextForCacheContext(resOpt, this.getCtx(), acpInContext);
            rasbCache = this.constructResolvedAttributes(resOpt, underCtx);
            if (rasbCache != null) {
                Object oDef = this.fetchObjectDefinition(resOpt);
                if (oDef != null) {
                    String cacheTag;
                    ctx.getCorpus().registerDefinitionReferenceSymbols((CdmObject)oDef, "rasb", resOpt.getSymbolRefSet());
                    if (this.objectType == CdmObjectType.EntityDef && underCtx != null) {
                        HashSet<CdmAttributeContext> scopesForAttributes = new HashSet<CdmAttributeContext>();
                        underCtx.collectContextFromAtts(rasbCache.getResolvedAttributeSet(), scopesForAttributes);
                        if (!underCtx.pruneToScope(scopesForAttributes)) {
                            return null;
                        }
                    }
                    if (!StringUtils.isNullOrTrimEmpty(cacheTag = ctx.getCorpus().createDefinitionCacheTag(resOpt, this, "rasb", acpInContext != null ? "ctx" : null)) && rasbCache != null) {
                        ctx.getAttributeCache().put(cacheTag, rasbCache);
                    }
                }
                underCtx = rasbCache.getResolvedAttributeSet().getAttributeContext() != null ? rasbCache.getResolvedAttributeSet().getAttributeContext().getUnderContextFromCacheContext(resOpt, acpInContext) : null;
            }
        } else {
            CdmAttributeContext cdmAttributeContext = underCtx = rasbCache.getResolvedAttributeSet().getAttributeContext() != null ? rasbCache.getResolvedAttributeSet().getAttributeContext().getUnderContextFromCacheContext(resOpt, acpInContext) : null;
        }
        if (rasbCache != null) {
            rasbResult = new ResolvedAttributeSetBuilder();
            rasbResult.setResolvedAttributeSet(rasbCache.getResolvedAttributeSet().copy());
            if (underCtx != null && !underCtx.associateTreeCopyWithAttributes(resOpt, rasbResult.getResolvedAttributeSet())) {
                return null;
            }
        }
        if (this instanceof CdmEntityAttributeDefinition) {
            resOpt.depthInfo.setCurrentDepth(currentDepth);
            if (resOpt.depthInfo.getCurrentDepth() == 0) {
                resOpt.depthInfo.setMaxDepthExceeded(false);
            }
        }
        if (!inCircularReference && this.objectType == CdmObjectType.EntityDef) {
            resOpt.currentlyResolvingEntities.remove(this);
        }
        resOpt.inCircularReference = wasInCircularReference;
        currDocRefSet.merge(resOpt.getSymbolRefSet());
        resOpt.setSymbolRefSet(currDocRefSet);
        this.getCtx().getCorpus().isCurrentlyResolving = wasPreviouslyResolving;
        return rasbResult != null ? rasbResult.getResolvedAttributeSet() : null;
    }

    private static Object ProtectParameterValues(ResolveOptions resOpt, Object val) {
        if (val != null) {
            CdmConstantEntityDefinition cEnt = null;
            if (val instanceof CdmEntityReference) {
                cEnt = (CdmConstantEntityDefinition)((CdmEntityReference)val).getExplicitReference();
            }
            if (cEnt != null) {
                cEnt = (CdmConstantEntityDefinition)cEnt.copy(resOpt);
                val = ((CdmEntityReference)val).copy(resOpt);
                ((CdmEntityReference)val).setExplicitReference(cEnt);
            }
        }
        return val;
    }

    @Deprecated
    public Map<String, ResolvedTraitSetBuilder> getTraitCache() {
        return this.traitCache;
    }

    @Deprecated
    public void setTraitCache(Map<String, ResolvedTraitSetBuilder> traitCache) {
        this.traitCache = traitCache;
    }
}

