/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmContainerDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDocumentDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmFolderDefinition;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.storage.StorageAdapterBase;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.StorageUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.concurrent.ConcurrentSemaphore;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

@Deprecated
public class DocumentLibrary {
    private static String TAG = DocumentLibrary.class.getSimpleName();
    List<Pair<CdmFolderDefinition, CdmDocumentDefinition>> allDocuments = new ArrayList<Pair<CdmFolderDefinition, CdmDocumentDefinition>>();
    public ConcurrentSemaphore concurrentReadLock = new ConcurrentSemaphore();
    CdmCorpusDefinition corpus;
    Set<String> docsCurrentlyLoading;
    Set<CdmDocumentDefinition> docsCurrentlyIndexing;
    Set<String> docsNotFound;
    Lock documentLibraryLock;
    Map<String, Pair<CdmFolderDefinition, CdmDocumentDefinition>> pathLookup;

    DocumentLibrary(CdmCorpusDefinition corpus) {
        this.corpus = corpus;
        this.docsCurrentlyLoading = new HashSet<String>();
        this.docsCurrentlyIndexing = new HashSet<CdmDocumentDefinition>();
        this.docsNotFound = new HashSet<String>();
        this.documentLibraryLock = new ReentrantLock();
        this.pathLookup = new LinkedHashMap<String, Pair<CdmFolderDefinition, CdmDocumentDefinition>>();
    }

    void addDocumentPath(String path, CdmFolderDefinition folder, CdmDocumentDefinition doc) {
        this.documentLibraryLock.lock();
        if (!this.pathLookup.containsKey(path)) {
            this.allDocuments.add((Pair<CdmFolderDefinition, CdmDocumentDefinition>)new ImmutablePair((Object)folder, (Object)doc));
            this.pathLookup.put(path, (Pair<CdmFolderDefinition, CdmDocumentDefinition>)new ImmutablePair((Object)folder, (Object)doc));
            folder.getDocumentLookup().put(doc.getName(), doc);
        }
        this.documentLibraryLock.unlock();
    }

    void removeDocumentPath(String path, CdmFolderDefinition folder, CdmDocumentDefinition doc) {
        this.documentLibraryLock.lock();
        if (this.pathLookup.containsKey(path)) {
            this.pathLookup.remove(path);
            int index = this.allDocuments.indexOf(ImmutablePair.of((Object)folder, (Object)doc));
            this.allDocuments.remove(index);
        }
        this.documentLibraryLock.unlock();
    }

    List<CdmDocumentDefinition> listDocsNotIndexed(CdmDocumentDefinition rootDoc, Set<String> docsLoaded) {
        this.documentLibraryLock.lock();
        ArrayList<CdmDocumentDefinition> docsNotIndexed = new ArrayList<CdmDocumentDefinition>();
        for (String docPath : docsLoaded) {
            CdmDocumentDefinition doc = this.fetchDocument(docPath);
            if (doc == null) continue;
            if (doc != rootDoc) {
                if (!this.markDocumentForIndexing(doc)) continue;
                docsNotIndexed.add(doc);
                continue;
            }
            docsNotIndexed.add(rootDoc);
        }
        this.documentLibraryLock.unlock();
        return docsNotIndexed;
    }

    @Deprecated
    public List<CdmDocumentDefinition> listAllDocuments() {
        this.documentLibraryLock.lock();
        ArrayList<CdmDocumentDefinition> list = new ArrayList<CdmDocumentDefinition>();
        for (Pair<CdmFolderDefinition, CdmDocumentDefinition> pair : this.allDocuments) {
            list.add((CdmDocumentDefinition)pair.getRight());
        }
        this.documentLibraryLock.unlock();
        return list;
    }

    CdmDocumentDefinition fetchDocument(String path) {
        Pair<CdmFolderDefinition, CdmDocumentDefinition> lookup;
        this.documentLibraryLock.lock();
        CdmDocumentDefinition doc = null;
        if (!this.docsNotFound.contains(path) && (lookup = this.pathLookup.get(path)) != null) {
            doc = (CdmDocumentDefinition)lookup.getRight();
        }
        this.documentLibraryLock.unlock();
        return doc;
    }

    boolean needToLoadDocument(String docPath, Set<String> docsLoaded) {
        boolean needToLoad;
        this.documentLibraryLock.lock();
        CdmDocumentDefinition document = this.pathLookup.containsKey(docPath) ? (CdmDocumentDefinition)this.pathLookup.get(docPath).getValue() : null;
        boolean bl = needToLoad = !this.docsNotFound.contains(docPath) && !docsLoaded.contains(docPath) && (document == null || !document.isImportsIndexed() && !document.isCurrentlyIndexing());
        if (needToLoad) {
            docsLoaded.add(docPath);
        }
        this.documentLibraryLock.unlock();
        return needToLoad;
    }

    void markAsLoadedOrFailed(String docPath, CdmContainerDefinition doc) {
        this.documentLibraryLock.lock();
        this.docsCurrentlyLoading.remove(docPath);
        if (doc == null) {
            this.docsNotFound.add(docPath);
        }
        this.documentLibraryLock.unlock();
    }

    void markDocumentAsIndexed(CdmDocumentDefinition doc) {
        this.documentLibraryLock.lock();
        doc.setCurrentlyIndexing(false);
        this.docsCurrentlyIndexing.remove(doc);
        this.documentLibraryLock.unlock();
    }

    boolean markDocumentForIndexing(CdmDocumentDefinition doc) {
        this.documentLibraryLock.lock();
        if (doc.getNeedsIndexing() && !doc.isCurrentlyIndexing()) {
            this.docsCurrentlyIndexing.add(doc);
            doc.setCurrentlyIndexing(true);
        }
        this.documentLibraryLock.unlock();
        return doc.getNeedsIndexing();
    }

    @Deprecated
    public boolean contains(Pair<CdmFolderDefinition, CdmDocumentDefinition> fd) {
        return this.allDocuments.contains(fd);
    }

    CompletableFuture<? extends CdmContainerDefinition> loadFolderOrDocumentAsync(String objectPath) {
        return this.loadFolderOrDocumentAsync(objectPath, false);
    }

    CompletableFuture<? extends CdmContainerDefinition> loadFolderOrDocumentAsync(String objectPath, boolean forceReload) {
        return this.loadFolderOrDocumentAsync(objectPath, forceReload, null);
    }

    CompletableFuture<? extends CdmContainerDefinition> loadFolderOrDocumentAsync(String objectPath, boolean forceReload, ResolveOptions resOpt) {
        this.documentLibraryLock.lock();
        if (!forceReload && this.pathLookup.containsKey(objectPath)) {
            CdmContainerDefinition doc = (CdmContainerDefinition)this.pathLookup.get(objectPath).getRight();
            this.documentLibraryLock.unlock();
            return CompletableFuture.completedFuture(doc);
        }
        this.docsCurrentlyLoading.add(objectPath);
        this.documentLibraryLock.unlock();
        return CompletableFuture.supplyAsync(() -> {
            CdmContainerDefinition result = this._loadFolderOrDocumentAsync(objectPath, forceReload, resOpt);
            this.markAsLoadedOrFailed(objectPath, result);
            return result;
        });
    }

    private CdmContainerDefinition _loadFolderOrDocumentAsync(String objectPath, boolean forceReload, ResolveOptions resOpt) {
        if (StringUtils.isNullOrTrimEmpty(objectPath)) {
            return null;
        }
        ImmutablePair<String, String> pathTuple = StorageUtils.splitNamespacePath(objectPath);
        if (pathTuple == null) {
            Logger.error(this.corpus.getCtx(), TAG, "loadFolderOrDocumentAsync", objectPath, CdmLogCode.ErrPathNullObjectPath, new String[0]);
            return null;
        }
        String nameSpace = !StringUtils.isNullOrTrimEmpty((String)pathTuple.getKey()) ? (String)pathTuple.getKey() : this.corpus.getStorage().getDefaultNamespace();
        objectPath = (String)pathTuple.getValue();
        if (objectPath.startsWith("/")) {
            CdmFolderDefinition namespaceFolder = this.corpus.getStorage().fetchRootFolder(nameSpace);
            StorageAdapterBase namespaceAdapter = this.corpus.getStorage().fetchAdapter(nameSpace);
            if (namespaceFolder == null || namespaceAdapter == null) {
                Logger.error(this.corpus.getCtx(), TAG, "loadFolderOrDocumentAsync", objectPath, CdmLogCode.ErrStorageNamespaceNotRegistered, nameSpace);
                return null;
            }
            CdmFolderDefinition lastFolder = namespaceFolder.fetchChildFolderFromPath(objectPath, false);
            if (lastFolder != null) {
                String lastPath = lastFolder.getFolderPath();
                if (lastPath.equals(objectPath)) {
                    return lastFolder;
                }
                String newObjectPath = StringUtils.slice(objectPath, lastPath.length());
                this.concurrentReadLock.acquire().join();
                CdmDocumentDefinition doc = lastFolder.fetchDocumentFromFolderPathAsync(newObjectPath, forceReload, resOpt).join();
                this.concurrentReadLock.release();
                return doc;
            }
        }
        return null;
    }
}

