/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.cdm.projections;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObjectBase;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTypeAttributeDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.projections.CdmOperationBase;
import com.microsoft.commondatamodel.objectmodel.enums.CdmAttributeContextType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.enums.CdmOperationType;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedAttribute;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionAttributeContextTreeBuilder;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionAttributeState;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionAttributeStateSet;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionContext;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.projections.ProjectionResolutionCommonUtil;
import com.microsoft.commondatamodel.objectmodel.utilities.AttributeContextParameters;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.VisitCallback;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;

public class CdmOperationCombineAttributes
extends CdmOperationBase {
    private static final String TAG = CdmOperationCombineAttributes.class.getSimpleName();
    private List<String> select;
    private CdmTypeAttributeDefinition mergeInto;

    public CdmOperationCombineAttributes(CdmCorpusContext ctx) {
        super(ctx);
        this.setObjectType(CdmObjectType.OperationCombineAttributesDef);
        this.setType(CdmOperationType.CombineAttributes);
        this.select = new ArrayList<String>();
    }

    @Override
    public CdmObject copy(ResolveOptions resOpt, CdmObject host) {
        CdmOperationCombineAttributes copy;
        if (resOpt == null) {
            resOpt = new ResolveOptions(this, this.getCtx().getCorpus().getDefaultResolutionDirectives());
        }
        CdmOperationCombineAttributes cdmOperationCombineAttributes = copy = host == null ? new CdmOperationCombineAttributes(this.getCtx()) : (CdmOperationCombineAttributes)host;
        if (this.select != null) {
            copy.setSelect(new ArrayList<String>(this.select));
        }
        copy.setMergeInto((CdmTypeAttributeDefinition)this.getMergeInto().copy(resOpt));
        this.copyProj(resOpt, copy);
        return copy;
    }

    public List<String> getSelect() {
        return this.select;
    }

    public void setSelect(List<String> select) {
        this.select = select;
    }

    public CdmTypeAttributeDefinition getMergeInto() {
        return this.mergeInto;
    }

    public void setMergeInto(CdmTypeAttributeDefinition mergeInto) {
        this.mergeInto = mergeInto;
    }

    @Override
    @Deprecated
    public Object copyData(ResolveOptions resOpt, CopyOptions options) {
        return CdmObjectBase.copyData(this, resOpt, options, CdmOperationCombineAttributes.class);
    }

    @Override
    public String getName() {
        return "operationCombineAttributes";
    }

    @Override
    @Deprecated
    public CdmObjectType getObjectType() {
        return CdmObjectType.OperationCombineAttributesDef;
    }

    @Override
    public boolean validate() {
        ArrayList<String> missingFields = new ArrayList<String>();
        if (this.select == null) {
            missingFields.add("select");
        }
        if (this.mergeInto == null) {
            missingFields.add("mergeInto");
        }
        if (missingFields.size() > 0) {
            Logger.error(this.getCtx(), TAG, "validate", this.getAtCorpusPath(), CdmLogCode.ErrValdnIntegrityCheckFailure, this.getAtCorpusPath(), String.join((CharSequence)", ", missingFields.parallelStream().map(s -> String.format("'%s'", s)).collect(Collectors.toList())));
            return false;
        }
        return true;
    }

    @Override
    public boolean visit(String pathFrom, VisitCallback preChildren, VisitCallback postChildren) {
        String path = this.fetchDeclaredPath(pathFrom);
        if (preChildren != null && preChildren.invoke(this, path)) {
            return false;
        }
        if (this.getMergeInto() != null && this.getMergeInto().visit(path + "/mergeInto/", preChildren, postChildren)) {
            return true;
        }
        return postChildren != null && postChildren.invoke(this, path);
    }

    @Override
    @Deprecated
    public ProjectionAttributeStateSet appendProjectionAttributeState(ProjectionContext projCtx, ProjectionAttributeStateSet projAttrStateSet, CdmAttributeContext attrCtx) {
        AttributeContextParameters attrCtxOpCombineAttrsParam = new AttributeContextParameters();
        attrCtxOpCombineAttrsParam.setUnder(attrCtx);
        attrCtxOpCombineAttrsParam.setType(CdmAttributeContextType.OperationCombineAttributes);
        attrCtxOpCombineAttrsParam.setName("operation/index" + this.getIndex() + "/operationCombineAttributes");
        CdmAttributeContext attrCtxOpCombineAttrs = CdmAttributeContext.createChildUnder(projCtx.getProjectionDirective().getResOpt(), attrCtxOpCombineAttrsParam);
        ProjectionAttributeContextTreeBuilder attrCtxTreeBuilder = new ProjectionAttributeContextTreeBuilder(attrCtxOpCombineAttrs);
        LinkedHashMap<String, List<ProjectionAttributeState>> leafLevelCombineAttributeNames = new LinkedHashMap<String, List<ProjectionAttributeState>>();
        ArrayList<ProjectionAttributeState> leafLevelMergePASList = new ArrayList<ProjectionAttributeState>();
        for (String string : this.select) {
            List<ProjectionAttributeState> leafLevelListForCurrentSelect = ProjectionResolutionCommonUtil.getLeafList(projCtx, string);
            if (leafLevelListForCurrentSelect == null || leafLevelListForCurrentSelect.size() <= 0 || leafLevelCombineAttributeNames.containsKey(string)) continue;
            leafLevelCombineAttributeNames.put(string, leafLevelListForCurrentSelect);
            leafLevelMergePASList.addAll(leafLevelListForCurrentSelect);
        }
        ArrayList<ProjectionAttributeState> pasMergeList = new ArrayList<ProjectionAttributeState>();
        for (ProjectionAttributeState currentPAS : projCtx.getCurrentAttributeStateSet().getStates()) {
            if (leafLevelCombineAttributeNames.containsKey(currentPAS.getCurrentResolvedAttribute().getResolvedName())) {
                if (pasMergeList.contains(currentPAS)) continue;
                pasMergeList.add(currentPAS);
                continue;
            }
            ProjectionAttributeState newPAS = currentPAS.copy();
            projAttrStateSet.add(newPAS);
        }
        if (pasMergeList.size() > 0) {
            CdmTypeAttributeDefinition cdmTypeAttributeDefinition = this.mergeInto;
            AttributeContextParameters mergedAttrCtxParam = new AttributeContextParameters();
            mergedAttrCtxParam.setUnder(attrCtxOpCombineAttrs);
            mergedAttrCtxParam.setType(CdmAttributeContextType.AttributeDefinition);
            mergedAttrCtxParam.setName(cdmTypeAttributeDefinition.getName());
            CdmAttributeContext mergedAttrCtx = CdmAttributeContext.createChildUnder(projCtx.getProjectionDirective().getResOpt(), mergedAttrCtxParam);
            ResolvedAttribute raNewMergeInto = CdmOperationCombineAttributes.createNewResolvedAttribute(projCtx, mergedAttrCtx, cdmTypeAttributeDefinition, null);
            ProjectionAttributeState newMergeIntoPAS = new ProjectionAttributeState(projAttrStateSet.getCtx());
            newMergeIntoPAS.setCurrentResolvedAttribute(raNewMergeInto);
            newMergeIntoPAS.setPreviousStateList(pasMergeList);
            LinkedHashSet<String> attributesAddedToContext = new LinkedHashSet<String>();
            for (String select : leafLevelCombineAttributeNames.keySet()) {
                if (!leafLevelCombineAttributeNames.containsKey(select) || leafLevelCombineAttributeNames.get(select) == null || ((List)leafLevelCombineAttributeNames.get(select)).size() <= 0) continue;
                for (ProjectionAttributeState leafLevelForSelect : (List)leafLevelCombineAttributeNames.get(select)) {
                    if (attributesAddedToContext.contains(leafLevelForSelect.getCurrentResolvedAttribute().getResolvedName())) continue;
                    attributesAddedToContext.add(leafLevelForSelect.getCurrentResolvedAttribute().getResolvedName());
                    attrCtxTreeBuilder.createAndStoreAttributeContextParameters(select, leafLevelForSelect, newMergeIntoPAS.getCurrentResolvedAttribute(), CdmAttributeContextType.AttributeDefinition, leafLevelForSelect.getCurrentResolvedAttribute().getAttCtx(), newMergeIntoPAS.getCurrentResolvedAttribute().getAttCtx());
                }
            }
            projAttrStateSet.add(newMergeIntoPAS);
        }
        attrCtxTreeBuilder.constructAttributeContextTree(projCtx);
        return projAttrStateSet;
    }
}

