/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.enums;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public enum CdmDataFormat {
    Int16,
    Int32,
    Int64,
    Float,
    Char,
    Double,
    String,
    Byte,
    Binary,
    DateTime,
    Date,
    Time,
    DateTimeOffset,
    Boolean,
    Decimal,
    Guid,
    Json,
    Unknown;

    private static final Map<String, CdmDataFormat> LOWERCASE_ENUM_MAP;

    public static CdmDataFormat fromString(String baseType) {
        return LOWERCASE_ENUM_MAP.getOrDefault(baseType.toLowerCase(), Unknown);
    }

    static {
        ConcurrentHashMap<String, CdmDataFormat> map = new ConcurrentHashMap<String, CdmDataFormat>();
        for (CdmDataFormat value : CdmDataFormat.values()) {
            map.put(value.toString().toLowerCase(), value);
        }
        LOWERCASE_ENUM_MAP = Collections.unmodifiableMap(map);
    }
}

