/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDataPartitionDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDataPartitionPatternDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityDeclarationDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmLocalEntityDeclarationDefinition;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmObjectType;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.DataPartitionPatternPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.DataPartitionPersistence;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.Utils;
import com.microsoft.commondatamodel.objectmodel.persistence.cdmfolder.types.LocalEntityDeclaration;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.util.function.Function;

public class LocalEntityDeclarationPersistence {
    private static final String TAG = LocalEntityDeclarationPersistence.class.getSimpleName();

    public static CdmEntityDeclarationDefinition fromData(CdmCorpusContext ctx, String prefixPath, LocalEntityDeclaration obj) {
        CdmEntityDeclarationDefinition localDec = (CdmEntityDeclarationDefinition)ctx.getCorpus().makeObject(CdmObjectType.LocalEntityDeclarationDef, obj.getEntityName());
        localDec.setEntityPath(obj.getEntityPath());
        if (obj.getLastChildFileModifiedTime() != null) {
            localDec.setLastChildFileModifiedTime(obj.getLastChildFileModifiedTime());
        }
        if (obj.getLastFileModifiedTime() != null) {
            localDec.setLastFileModifiedTime(obj.getLastFileModifiedTime());
        }
        if (obj.getLastFileStatusCheckTime() != null) {
            localDec.setLastFileStatusCheckTime(obj.getLastFileStatusCheckTime());
        }
        if (obj.getExplanation() != null) {
            localDec.setExplanation(obj.getExplanation());
        }
        Utils.addListToCdmCollection(localDec.getExhibitsTraits(), Utils.createTraitReferenceList(ctx, obj.getExhibitsTraits()));
        if (obj.getDataPartitions() != null) {
            obj.getDataPartitions().forEach(dataPartition -> {
                CdmDataPartitionDefinition dataPartitionDef = DataPartitionPersistence.fromData(ctx, dataPartition);
                if (dataPartitionDef.isIncremental()) {
                    LocalEntityDeclarationPersistence.errorMessage(ctx, "fromData", null, dataPartitionDef, true);
                } else {
                    localDec.getDataPartitions().add(dataPartitionDef);
                }
            });
        }
        if (obj.getDataPartitionPatterns() != null) {
            obj.getDataPartitionPatterns().forEach(pattern -> {
                CdmDataPartitionPatternDefinition dataPartitionPatternDef = DataPartitionPatternPersistence.fromData(ctx, pattern);
                if (dataPartitionPatternDef.isIncremental()) {
                    LocalEntityDeclarationPersistence.errorMessage(ctx, "fromData", null, dataPartitionPatternDef, true);
                } else {
                    localDec.getDataPartitionPatterns().add(dataPartitionPatternDef);
                }
            });
        }
        if (obj.getIncrementalPartitions() != null) {
            obj.getIncrementalPartitions().forEach(incrementalPartition -> {
                CdmDataPartitionDefinition incrementalPartitionDef = DataPartitionPersistence.fromData(ctx, incrementalPartition);
                if (!incrementalPartitionDef.isIncremental()) {
                    LocalEntityDeclarationPersistence.errorMessage(ctx, "fromData", null, incrementalPartitionDef, false);
                } else {
                    localDec.getIncrementalPartitions().add(incrementalPartitionDef);
                }
            });
        }
        if (obj.getIncrementalPartitionPatterns() != null) {
            obj.getIncrementalPartitionPatterns().forEach(incrementalPattern -> {
                CdmDataPartitionPatternDefinition incrementalPartitionPatternDef = DataPartitionPatternPersistence.fromData(ctx, incrementalPattern);
                if (!incrementalPartitionPatternDef.isIncremental()) {
                    LocalEntityDeclarationPersistence.errorMessage(ctx, "fromData", null, incrementalPartitionPatternDef, false);
                } else {
                    localDec.getIncrementalPartitionPatterns().add(incrementalPartitionPatternDef);
                }
            });
        }
        return localDec;
    }

    public static LocalEntityDeclaration toData(CdmLocalEntityDeclarationDefinition instance, ResolveOptions resOpt, CopyOptions options) {
        LocalEntityDeclaration result = new LocalEntityDeclaration();
        result.setType("LocalEntity");
        result.setEntityName(instance.getEntityName());
        result.setExplanation(instance.getExplanation());
        result.setLastFileStatusCheckTime(instance.getLastFileStatusCheckTime());
        result.setLastFileModifiedTime(instance.getLastFileModifiedTime());
        result.setLastChildFileModifiedTime(instance.getLastChildFileModifiedTime());
        result.setEntityPath(instance.getEntityPath());
        result.setExhibitsTraits(Utils.listCopyDataAsArrayNode(instance.getExhibitsTraits(), resOpt, options));
        result.setDataPartitions(Utils.listCopyDataAsCdmObject(instance.getDataPartitions(), resOpt, options, LocalEntityDeclarationPersistence.ensureNonIncremental(instance)));
        result.setDataPartitionPatterns(Utils.listCopyDataAsCdmObject(instance.getDataPartitionPatterns(), resOpt, options, LocalEntityDeclarationPersistence.ensureNonIncremental(instance)));
        result.setIncrementalPartitions(Utils.listCopyDataAsCdmObject(instance.getIncrementalPartitions(), resOpt, options, LocalEntityDeclarationPersistence.ensureIncremental(instance)));
        result.setIncrementalPartitionPatterns(Utils.listCopyDataAsCdmObject(instance.getIncrementalPartitionPatterns(), resOpt, options, LocalEntityDeclarationPersistence.ensureIncremental(instance)));
        return result;
    }

    private static void errorMessage(CdmCorpusContext ctx, String methodName, String corpusPath, CdmDataPartitionDefinition obj, boolean isIncremental) {
        if (isIncremental) {
            Logger.error(ctx, TAG, methodName, corpusPath, CdmLogCode.ErrPersistIncrementalConversionError, obj.getName(), "is.partition.incremental", "dataPartitions");
        } else {
            Logger.error(ctx, TAG, methodName, corpusPath, CdmLogCode.ErrPersistNonIncrementalConversionError, obj.getName(), "is.partition.incremental", "incrementalPartitions");
        }
    }

    private static void errorMessage(CdmCorpusContext ctx, String methodName, String corpusPath, CdmDataPartitionPatternDefinition obj, boolean isIncremental) {
        if (isIncremental) {
            Logger.error(ctx, TAG, methodName, corpusPath, CdmLogCode.ErrPersistIncrementalConversionError, obj.getName(), "is.partition.incremental", "dataPartitionPatterns");
        } else {
            Logger.error(ctx, TAG, methodName, corpusPath, CdmLogCode.ErrPersistNonIncrementalConversionError, obj.getName(), "is.partition.incremental", "incrementalPartitionPatterns");
        }
    }

    private static Function<Object, Boolean> ensureNonIncremental(CdmLocalEntityDeclarationDefinition instance) {
        Function<Object, Boolean> compare = obj -> {
            if (obj instanceof CdmDataPartitionDefinition && ((CdmDataPartitionDefinition)obj).isIncremental()) {
                LocalEntityDeclarationPersistence.errorMessage(instance.getCtx(), "toData", instance.getAtCorpusPath(), (CdmDataPartitionDefinition)obj, true);
                return false;
            }
            if (obj instanceof CdmDataPartitionPatternDefinition && ((CdmDataPartitionPatternDefinition)obj).isIncremental()) {
                LocalEntityDeclarationPersistence.errorMessage(instance.getCtx(), "toData", instance.getAtCorpusPath(), (CdmDataPartitionPatternDefinition)obj, true);
                return false;
            }
            return true;
        };
        return compare;
    }

    private static Function<Object, Boolean> ensureIncremental(CdmLocalEntityDeclarationDefinition instance) {
        Function<Object, Boolean> compare = obj -> {
            if (obj instanceof CdmDataPartitionDefinition && !((CdmDataPartitionDefinition)obj).isIncremental()) {
                LocalEntityDeclarationPersistence.errorMessage(instance.getCtx(), "toData", instance.getAtCorpusPath(), (CdmDataPartitionDefinition)obj, false);
                return false;
            }
            if (obj instanceof CdmDataPartitionPatternDefinition && !((CdmDataPartitionPatternDefinition)obj).isIncremental()) {
                LocalEntityDeclarationPersistence.errorMessage(instance.getCtx(), "toData", instance.getAtCorpusPath(), (CdmDataPartitionPatternDefinition)obj, false);
                return false;
            }
            return true;
        };
        return compare;
    }
}

