/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.resolvedmodel;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.StringSpewCatcher;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.ResolvedEntityReference;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;

public class ResolvedEntityReferenceSet {
    List<ResolvedEntityReference> set;
    ResolveOptions resOpt;

    public ResolvedEntityReferenceSet(ResolveOptions resOpt) {
        this.resOpt = resOpt;
        this.set = new ArrayList<ResolvedEntityReference>();
    }

    private ResolvedEntityReferenceSet(ResolveOptions resOpt, List<ResolvedEntityReference> set) {
        this.resOpt = resOpt;
        this.set = set;
    }

    public void add(ResolvedEntityReferenceSet toAdd) {
        if (toAdd != null && toAdd.getSet() != null && toAdd.getSet().size() > 0) {
            this.set.addAll(toAdd.getSet());
        }
    }

    public ResolvedEntityReferenceSet copy() {
        ArrayList<ResolvedEntityReference> newSet = new ArrayList<ResolvedEntityReference>(this.set);
        for (int i = 0; i < newSet.size(); ++i) {
            newSet.set(i, ((ResolvedEntityReference)newSet.get(i)).copy());
        }
        return new ResolvedEntityReferenceSet(this.resOpt, newSet);
    }

    public ResolvedEntityReferenceSet findEntity(CdmEntityDefinition entOther) {
        ArrayList<ResolvedEntityReference> filter = new ArrayList<ResolvedEntityReference>();
        for (ResolvedEntityReference rer : this.set) {
            if (rer.getReferenced().stream().filter(rers -> rers.getEntity() == entOther).count() > 0L) {
                // empty if block
            }
            filter.add(rer);
        }
        if (filter.size() == 0) {
            return null;
        }
        return new ResolvedEntityReferenceSet(this.resOpt, filter);
    }

    @Deprecated
    public void spew(ResolveOptions resOpt, StringSpewCatcher to, String indent, boolean nameSort) throws IOException {
        ArrayList<ResolvedEntityReference> list = new ArrayList<ResolvedEntityReference>(this.set);
        if (nameSort) {
            list.sort(new CaseAgnosticEntityRefNameComparator());
        }
        for (int i = 0; i < this.set.size(); ++i) {
            ((ResolvedEntityReference)list.get(i)).spew(resOpt, to, indent + "(rer[" + i + "])", nameSort);
        }
    }

    public List<ResolvedEntityReference> getSet() {
        return this.set;
    }

    void setSet(List<ResolvedEntityReference> set) {
        this.set = set;
    }

    ResolveOptions getResOpt() {
        return this.resOpt;
    }

    void setResOpt(ResolveOptions resOpt) {
        this.resOpt = resOpt;
    }

    private class CaseAgnosticEntityRefNameComparator
    implements Comparator<ResolvedEntityReference> {
        private CaseAgnosticEntityRefNameComparator() {
        }

        @Override
        public int compare(ResolvedEntityReference l, ResolvedEntityReference r) {
            if (l.getReferenced() != null && l.getReferenced().size() > 0) {
                if (r.getReferenced() != null && r.getReferenced().size() > 0) {
                    String lEntityName = l.getReferenced().get(0).getEntity() != null ? l.getReferenced().get(0).getEntity().getName().toLowerCase() : null;
                    String rEntityName = r.getReferenced().get(0).getEntity() != null ? r.getReferenced().get(0).getEntity().getName().toLowerCase() : null;
                    return ObjectUtils.compare((Comparable)((Object)lEntityName), rEntityName);
                }
                return 1;
            }
            return -1;
        }
    }
}

