/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.resolvedmodel;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmAttributeReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmConstantEntityDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitGroupDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitGroupReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReference;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReferenceBase;
import com.microsoft.commondatamodel.objectmodel.persistence.PersistenceLayer;
import com.microsoft.commondatamodel.objectmodel.resolvedmodel.TraitProfileCache;
import com.microsoft.commondatamodel.objectmodel.utilities.CopyOptions;
import com.microsoft.commondatamodel.objectmodel.utilities.ResolveOptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class TraitProfile {
    private String traitName;
    private String explanation;
    private TraitProfile IS_A;
    private TraitProfile references;
    private TraitProfile verb;
    private Map<String, Object> argumentValues;
    private ArrayList<TraitProfile> classifications;
    private ArrayList<TraitProfile> metaTraits;
    private static AtomicInteger nextId = new AtomicInteger();
    private String tpId = nextId.incrementAndGet() + "_";

    public void setTraitName(String traitName) {
        this.traitName = traitName;
    }

    public String getTraitName() {
        return this.traitName;
    }

    public void setExplanation(String value) {
        this.explanation = value;
    }

    public String getExplanation() {
        return this.explanation;
    }

    @JsonProperty(value="IS_A")
    public void setIS_A(TraitProfile value) {
        this.IS_A = value;
    }

    @JsonProperty(value="IS_A")
    public TraitProfile getIS_A() {
        return this.IS_A;
    }

    public void setReferences(TraitProfile value) {
        this.references = value;
    }

    public TraitProfile getReferences() {
        return this.references;
    }

    public void setVerb(TraitProfile value) {
        this.verb = value;
    }

    public TraitProfile getVerb() {
        return this.verb;
    }

    public void setArgumentValues(Map<String, Object> value) {
        this.argumentValues = value;
    }

    public Map<String, Object> getArgumentValues() {
        return this.argumentValues;
    }

    public void setClassifications(ArrayList<TraitProfile> value) {
        this.classifications = value;
    }

    public ArrayList<TraitProfile> getClassifications() {
        return this.classifications;
    }

    public void setMetaTraits(ArrayList<TraitProfile> value) {
        this.metaTraits = value;
    }

    public ArrayList<TraitProfile> getMetaTraits() {
        return this.metaTraits;
    }

    @JsonIgnore
    public String getTpId() {
        return this.tpId;
    }

    public boolean IsA(String extendedName) {
        TraitProfile seek = this;
        while (seek != null) {
            if (seek.getTraitName().equals(extendedName)) {
                return true;
            }
            if (seek.IS_A != null) {
                seek = seek.IS_A;
                continue;
            }
            if (seek.getReferences() != null) {
                seek = seek.getReferences();
                continue;
            }
            seek = null;
        }
        return false;
    }

    public TraitProfile AppliedVerb() {
        TraitProfile seek = this;
        while (seek != null) {
            if (seek.getVerb() != null) {
                return seek.getVerb();
            }
            if (seek.IS_A != null) {
                seek = seek.IS_A;
                continue;
            }
            if (seek.getReferences() != null) {
                seek = seek.getReferences();
                continue;
            }
            seek = null;
        }
        return null;
    }

    @JsonIgnore
    public boolean isClassification() {
        TraitProfile seek = this;
        while (seek != null) {
            if (seek.getVerb() != null) {
                return seek.getVerb().getTraitName().equals("classifiedAs");
            }
            if (seek.IS_A != null) {
                seek = seek.IS_A;
                continue;
            }
            if (seek.getReferences() != null) {
                seek = seek.getReferences();
                continue;
            }
            seek = null;
        }
        return false;
    }

    public TraitProfile copy() {
        TraitProfile copy = new TraitProfile();
        copy.setTraitName(this.traitName);
        copy.setExplanation(this.explanation);
        copy.setIS_A(this.IS_A);
        copy.setReferences(this.references);
        copy.setVerb(this.verb);
        if (this.argumentValues != null) {
            HashMap<String, Object> copyArgs = new HashMap<String, Object>();
            copyArgs.putAll(this.argumentValues);
            copy.setArgumentValues(copyArgs);
        }
        if (this.classifications != null) {
            copy.setClassifications(new ArrayList<TraitProfile>(this.classifications));
        }
        if (this.metaTraits != null) {
            copy.setMetaTraits(new ArrayList<TraitProfile>(this.metaTraits));
        }
        return copy;
    }

    public static Object fetchProfileArgumentFromTraitArgument(Object value, ResolveOptions resOpt) {
        if (value == null) {
            return null;
        }
        if (value instanceof CdmEntityReference) {
            return PersistenceLayer.toData((CdmEntityReference)value, resOpt, new CopyOptions(), "CdmFolder", CdmEntityReference.class);
        }
        if (value instanceof CdmAttributeReference) {
            return PersistenceLayer.toData((CdmAttributeReference)value, resOpt, new CopyOptions(), "CdmFolder", CdmAttributeReference.class);
        }
        String strVal = value.toString();
        if (strVal != null && strVal != "") {
            return strVal;
        }
        return null;
    }

    public static CdmConstantEntityDefinition fetchConstantEntityFromProfileArgument(Object argValue, ResolveOptions resOpt) {
        if (argValue == null) {
            return null;
        }
        CdmEntityReference entRefArg = (CdmEntityReference)PersistenceLayer.fromData(resOpt.getWrtDoc().getCtx(), argValue, "CdmFolder", CdmEntityReference.class);
        if (entRefArg == null) {
            return null;
        }
        CdmConstantEntityDefinition constEntDef = (CdmConstantEntityDefinition)entRefArg.fetchObjectDefinition(resOpt);
        return constEntDef;
    }

    public static ArrayList<TraitProfile> consolidateList(List<TraitProfile> toConsolidate) {
        return TraitProfile.consolidateList(toConsolidate, null);
    }

    public static ArrayList<TraitProfile> consolidateList(List<TraitProfile> toConsolidate, TraitProfileCache cache) {
        if (cache == null) {
            cache = new TraitProfileCache();
        }
        return TraitProfile._consolidateList(toConsolidate, cache);
    }

    public TraitProfile consolidate() {
        return this.consolidate(null);
    }

    public TraitProfile consolidate(TraitProfileCache cache) {
        if (cache == null) {
            cache = new TraitProfileCache();
        }
        TraitProfile consProf = this.promoteFromBase(cache);
        return consProf.removeNakedReferences(cache);
    }

    private static ArrayList<TraitProfile> _consolidateList(List<TraitProfile> toConsolidate, TraitProfileCache cache) {
        TraitProfile consProf;
        ArrayList<TraitProfile> result = new ArrayList<TraitProfile>();
        for (TraitProfile prof : toConsolidate) {
            consProf = prof.promoteFromBase(cache);
            result.add(consProf);
        }
        toConsolidate = result;
        result = new ArrayList();
        for (TraitProfile prof : toConsolidate) {
            consProf = prof.removeNakedReferences(cache);
            result.add(consProf);
        }
        return result;
    }

    private void takePromoValues(TraitProfile source) {
        if (this.explanation == null) {
            this.explanation = source.getExplanation();
        }
        if (this.verb == null) {
            this.verb = source.getVerb();
        }
        if (source.classifications != null && source.classifications.size() > 0) {
            if (this.classifications == null) {
                this.classifications = new ArrayList<TraitProfile>(source.getClassifications());
            } else {
                this.classifications.addAll(source.getClassifications());
            }
        }
    }

    private TraitProfile promoteFromBase(TraitProfileCache cache) {
        TraitProfile result = this;
        if (this.references == null) {
            TraitProfile cached = cache.getPromotedDefinitionProfile(this);
            if (cached != null) {
                return cached;
            }
            result = this.copy();
            if (result.IS_A != null) {
                TraitProfile isaRef;
                result.IS_A = isaRef = result.IS_A.promoteFromBase(cache);
                result.takePromoValues(isaRef);
                isaRef.setClassifications(null);
                isaRef.setVerb(null);
            }
            cache.savePromotedDefinitionProfile(result, this);
            TraitProfile cleaned = result.copy();
            cleaned.setClassifications(null);
            cleaned.setVerb(null);
            cache.saveCleanedDefinitionProfile(cleaned, result);
        } else {
            TraitProfile isaDef = this.references.promoteFromBase(cache);
            result = this.copy();
            result.takePromoValues(isaDef);
            result.setReferences(cache.getCleanedDefinitionProfile(isaDef));
        }
        if (result.metaTraits != null) {
            result.setMetaTraits(TraitProfile.promoteFromBaseList(result.metaTraits, cache));
        }
        return result;
    }

    private static ArrayList<TraitProfile> promoteFromBaseList(ArrayList<TraitProfile> toConsolidate, TraitProfileCache cache) {
        ArrayList<TraitProfile> result = new ArrayList<TraitProfile>();
        for (TraitProfile prof : toConsolidate) {
            TraitProfile consProf = prof.promoteFromBase(cache);
            result.add(consProf);
        }
        return result;
    }

    private TraitProfile removeNakedReferences(TraitProfileCache cache) {
        TraitProfile result = this.copy();
        if (result.IS_A != null) {
            result.IS_A = result.IS_A.removeNakedReferences(cache);
        }
        if (result.references != null) {
            result.setReferences(result.references.removeNakedReferences(cache));
        }
        if (result.verb != null) {
            result.setVerb(result.verb.removeNakedReferences(cache));
        }
        if (result.metaTraits != null) {
            result.setMetaTraits(TraitProfile.removeNakedReferencesList(result.metaTraits, cache));
        }
        if (result.references != null) {
            if (result.metaTraits == null || result.metaTraits.size() == 0) {
                TraitProfile newResult = result.references.copy();
                newResult.setVerb(result.verb);
                newResult.setClassifications(result.classifications);
                newResult.setArgumentValues(result.argumentValues);
                newResult = cache.getEquivalentReference(newResult);
                return newResult;
            }
            if (result.references.metaTraits == null || result.references.metaTraits.size() == 0) {
                TraitProfile newResult = result.copy();
                newResult.setIS_A(result.references.IS_A);
                newResult.setReferences(null);
                newResult = cache.getEquivalentReference(newResult);
                return newResult;
            }
        }
        return cache.getEquivalentReference(result);
    }

    private static ArrayList<TraitProfile> removeNakedReferencesList(ArrayList<TraitProfile> toConsolidate, TraitProfileCache cache) {
        ArrayList<TraitProfile> result = new ArrayList<TraitProfile>();
        for (TraitProfile prof : toConsolidate) {
            TraitProfile consProf = prof.removeNakedReferences(cache);
            result.add(consProf);
        }
        return result;
    }

    @Deprecated
    public static TraitProfile _traitDefToProfile(CdmTraitDefinition traitDef, ResolveOptions resOpt, boolean isVerb, boolean isMeta, TraitProfileCache cache) {
        if (cache == null) {
            cache = new TraitProfileCache();
        }
        TraitProfile result = new TraitProfile();
        String traitName = traitDef.getTraitName();
        result.setTraitName(traitName);
        result.setExplanation(traitDef.getExplanation());
        TraitProfile extTrait = null;
        if (cache.addContext(traitName).booleanValue()) {
            TraitProfile tpCache = cache.getDefinitionProfile(traitDef, isVerb, isMeta);
            if (tpCache != null) {
                cache.removeContext(traitName);
                return tpCache;
            }
            if (!isVerb) {
                ArrayList<TraitProfile> subTraits;
                if (traitDef.getExtendsTrait() != null) {
                    extTrait = TraitProfile._traitRefToProfile(traitDef.getExtendsTrait(), resOpt, false, isMeta, false, cache);
                    result.setIS_A(extTrait);
                }
                if (traitDef.getDefaultVerb() != null) {
                    result.setVerb(TraitProfile._traitRefToProfile(traitDef.getDefaultVerb(), resOpt, true, true, true, cache));
                }
                if (traitDef.getExhibitsTraits() != null && traitDef.getExhibitsTraits().size() > 0 && (subTraits = TraitProfile.traitCollectionToProfileList(traitDef.getExhibitsTraits().getAllItems(), resOpt, result.metaTraits, isMeta, cache)) != null) {
                    result.setMetaTraits(subTraits);
                    result.removeClassifiersFromMeta();
                }
            }
            cache.removeContext(traitName);
            cache.SaveDefinitionProfile(traitDef, result, isVerb, isMeta);
        }
        return result;
    }

    @Deprecated
    public static TraitProfile _traitRefToProfile(CdmTraitReferenceBase trb, ResolveOptions resOpt, boolean isVerb, boolean isMeta, boolean includeArgs, TraitProfileCache cache) {
        if (cache == null) {
            cache = new TraitProfileCache();
        }
        TraitProfile result = new TraitProfile();
        String traitName = trb.fetchObjectDefinitionName();
        result.setTraitName(traitName);
        if (cache.addContext(traitName).booleanValue()) {
            cache.removeContext(traitName);
            if (trb instanceof CdmTraitReference) {
                Map<String, Object> args;
                ArrayList<TraitProfile> subTraits;
                CdmTraitReference tr = (CdmTraitReference)trb;
                CdmTraitDefinition traitDef = (CdmTraitDefinition)tr.fetchObjectDefinition(resOpt);
                if (traitDef != null) {
                    result.setReferences(TraitProfile._traitDefToProfile(traitDef, resOpt, isVerb, isMeta, cache));
                }
                if (tr.getVerb() != null) {
                    result.setVerb(TraitProfile._traitRefToProfile(tr.getVerb(), resOpt, true, true, true, cache));
                }
                if (tr.getAppliedTraits() != null && tr.getAppliedTraits().size() > 0 && (subTraits = TraitProfile.traitCollectionToProfileList(tr.getAppliedTraits().getAllItems(), resOpt, result.metaTraits, true, cache)) != null) {
                    result.setMetaTraits(subTraits);
                    result.removeClassifiersFromMeta();
                }
                if (includeArgs && (args = tr.fetchFinalArgumentValues(resOpt)) != null && args.size() > 0) {
                    HashMap<String, Object> argMap = new HashMap<String, Object>();
                    for (Map.Entry<String, Object> av : args.entrySet()) {
                        Object value = TraitProfile.fetchProfileArgumentFromTraitArgument(av.getValue(), resOpt);
                        if (value == null) continue;
                        argMap.put(av.getKey(), value);
                    }
                    if (argMap.size() > 0) {
                        result.setArgumentValues(argMap);
                    }
                }
                result = cache.getEquivalentReference(result);
            } else {
                CdmTraitGroupDefinition tg = (CdmTraitGroupDefinition)((CdmTraitGroupReference)trb).fetchObjectDefinition(resOpt);
                if (tg != null) {
                    result.setMetaTraits(TraitProfile.traitCollectionToProfileList(tg.getExhibitsTraits().getAllItems(), resOpt, null, true, cache));
                }
            }
        }
        return result;
    }

    static ArrayList<TraitProfile> traitCollectionToProfileList(List<CdmTraitReferenceBase> trCol, ResolveOptions resOpt, ArrayList<TraitProfile> accumulateInList, boolean isMeta, TraitProfileCache cache) {
        if (cache == null) {
            cache = new TraitProfileCache();
        }
        ArrayList<TraitProfile> result = new ArrayList<TraitProfile>();
        if (accumulateInList != null) {
            for (TraitProfile oldProf : accumulateInList) {
                if (isMeta && oldProf.isClassification()) continue;
                result.add(oldProf);
            }
        }
        for (CdmTraitReferenceBase tr : trCol) {
            TraitProfile current = TraitProfile._traitRefToProfile(tr, resOpt, false, isMeta, true, cache);
            if (isMeta && current.isClassification()) continue;
            result.add(current);
        }
        if (result.size() == 0) {
            return null;
        }
        return result;
    }

    void removeClassifiersFromMeta() {
        if (this.metaTraits != null && this.metaTraits.size() > 0) {
            ArrayList<TraitProfile> newExtTraits = new ArrayList<TraitProfile>();
            ArrayList<TraitProfile> classifierTraits = new ArrayList<TraitProfile>();
            for (TraitProfile extr : this.metaTraits) {
                if (extr.isClassification()) {
                    classifierTraits.add(extr);
                    continue;
                }
                newExtTraits.add(extr);
            }
            this.metaTraits = null;
            if (newExtTraits.size() > 0) {
                this.metaTraits = newExtTraits;
            }
            if (classifierTraits.size() > 0) {
                if (this.classifications == null) {
                    this.classifications = new ArrayList();
                }
                this.classifications.addAll(classifierTraits);
            }
        }
    }
}

