/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.storage;

import com.microsoft.commondatamodel.objectmodel.storage.StorageAdapterBase;
import com.microsoft.commondatamodel.objectmodel.storage.StorageAdapterException;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.CompletableFuture;

public class CdmCustomPackageAdapter
extends StorageAdapterBase {
    final Class packageObject;
    final Method packageReadAsync;

    public CdmCustomPackageAdapter(String packageName) throws ClassNotFoundException {
        if (StringUtils.isNullOrTrimEmpty(packageName)) {
            throw new ClassNotFoundException("No package name passed in, please pass in a package name or package when constructing the CdmCustomPackageAdapter.");
        }
        try {
            this.packageObject = Class.forName(packageName);
            this.packageReadAsync = this.packageObject.getMethod("readAsync", String.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new ClassNotFoundException(String.format("Couldn't find package '%s', please install the package, and add it as dependency of the project.", packageName));
        }
    }

    public CdmCustomPackageAdapter(Class packageObject) throws ClassNotFoundException {
        if (packageObject == null) {
            throw new ClassNotFoundException("No package passed in, please pass in a package name or package when constructing the CdmCustomPackageAdapter.");
        }
        this.packageObject = packageObject;
        try {
            this.packageReadAsync = packageObject.getMethod("readAsync", String.class);
        }
        catch (NoSuchMethodException e) {
            throw new ClassNotFoundException(String.format("Couldn't find package '%s', please install the package, and add it as dependency of the project.", packageObject.getName()));
        }
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public CompletableFuture<String> readAsync(String corpusPath) throws StorageAdapterException {
        return CompletableFuture.supplyAsync(() -> {
            String adapterPath = this.createAdapterPath(corpusPath);
            try {
                return (String)this.packageReadAsync.invoke(null, adapterPath);
            }
            catch (IllegalAccessException e) {
                throw new StorageAdapterException(e.getMessage());
            }
            catch (InvocationTargetException e) {
                throw new StorageAdapterException(e.getCause().getMessage());
            }
        });
    }

    @Override
    public String createAdapterPath(String corpusPath) {
        return corpusPath;
    }

    @Override
    public String createCorpusPath(String adapterPath) {
        return adapterPath;
    }
}

