/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.storage;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.microsoft.commondatamodel.objectmodel.storage.NetworkAdapter;
import com.microsoft.commondatamodel.objectmodel.storage.StorageAdapterException;
import com.microsoft.commondatamodel.objectmodel.utilities.JMapper;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.network.CdmHttpClient;
import com.microsoft.commondatamodel.objectmodel.utilities.network.CdmHttpRequest;
import com.microsoft.commondatamodel.objectmodel.utilities.network.CdmHttpResponse;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@Deprecated
public class GithubAdapter
extends NetworkAdapter {
    private static final String ghHost = "raw.githubusercontent.com";
    private static final String ghPath = "/Microsoft/CDM/master/schemaDocuments";
    private static final String ghRawRoot = "https://raw.githubusercontent.com/Microsoft/CDM/master/schemaDocuments";
    static final String TYPE = "github";

    public GithubAdapter() {
        this.httpClient = new CdmHttpClient(ghRawRoot);
    }

    @Override
    public String fetchConfig() {
        ObjectNode resultConfig = JsonNodeFactory.instance.objectNode();
        resultConfig.put("type", TYPE);
        ObjectNode configObject = JsonNodeFactory.instance.objectNode();
        for (Map.Entry<String, JsonNode> stringJsonNodeEntry : this.fetchNetworkConfig().entrySet()) {
            configObject.set(stringJsonNodeEntry.getKey(), stringJsonNodeEntry.getValue());
        }
        String locationHint = this.getLocationHint();
        if (locationHint != null) {
            configObject.put("locationHint", locationHint);
        }
        resultConfig.set("config", (JsonNode)configObject);
        try {
            return JMapper.WRITER.writeValueAsString((Object)resultConfig);
        }
        catch (JsonProcessingException e) {
            throw new StorageAdapterException("Failed to construct config string.", (Exception)((Object)e));
        }
    }

    @Override
    public boolean canRead() {
        return true;
    }

    @Override
    public CompletableFuture<String> readAsync(String corpusPath) {
        return CompletableFuture.supplyAsync(() -> {
            LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
            headers.put("User-Agent", "CDM");
            CdmHttpRequest cdmHttpRequest = this.setUpCdmRequest(corpusPath, headers, "GET");
            try {
                CdmHttpResponse res = this.executeRequest(cdmHttpRequest).get();
                return res != null ? res.getContent() : null;
            }
            catch (Exception e) {
                throw new StorageAdapterException("Could not read GitHub content at path: " + corpusPath, e);
            }
        });
    }

    @Override
    public String createAdapterPath(String corpusPath) {
        return ghRawRoot + corpusPath;
    }

    @Override
    public String createCorpusPath(String adapterPath) {
        String ghRoot = ghRawRoot;
        if (!StringUtils.isNullOrEmpty(adapterPath) && adapterPath.startsWith(ghRawRoot)) {
            return StringUtils.slice(adapterPath, ghRawRoot.length());
        }
        return null;
    }

    @Override
    public void updateConfig(String config) throws IOException {
        if (config == null) {
            return;
        }
        this.updateNetworkConfig(config);
        JsonNode configsJson = JMapper.MAP.readTree(config);
        this.setLocationHint(configsJson.has("locationHint") ? configsJson.get("locationHint").asText() : null);
    }
}

