/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.storage;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.storage.StorageAdapterException;
import com.microsoft.commondatamodel.objectmodel.utilities.CdmFileMetadata;
import com.microsoft.commondatamodel.objectmodel.utilities.exceptions.CdmReadPartitionFromPatternException;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public abstract class StorageAdapterBase {
    private CdmCorpusContext ctx;
    private String locationHint = "";
    private HashSet<CacheContext> activeCacheContexts = new HashSet();

    protected CdmCorpusContext getCtx() {
        return this.ctx;
    }

    protected void setCtx(CdmCorpusContext ctx) {
        this.ctx = ctx;
    }

    public String getLocationHint() {
        return this.locationHint;
    }

    public void setLocationHint(String locationHint) {
        this.locationHint = locationHint;
    }

    public boolean canRead() {
        return false;
    }

    public boolean canWrite() {
        return false;
    }

    public CompletableFuture<String> readAsync(String corpusPath) {
        throw new UnsupportedOperationException("This adapter does not support the readAsync method.");
    }

    public CompletableFuture<Void> writeAsync(String corpusPath, String data) {
        throw new UnsupportedOperationException("This adapter does not support the writeAsync method.");
    }

    public String createAdapterPath(String corpusPath) throws StorageAdapterException {
        return corpusPath;
    }

    public String createCorpusPath(String adapterPath) {
        return adapterPath;
    }

    public CompletableFuture<OffsetDateTime> computeLastModifiedTimeAsync(String corpusPath) throws StorageAdapterException {
        return CompletableFuture.completedFuture(OffsetDateTime.now());
    }

    public CompletableFuture<CdmFileMetadata> fetchFileMetadataAsync(String corpusPath) {
        return CompletableFuture.completedFuture(null);
    }

    @Deprecated
    public CompletableFuture<List<String>> fetchAllFilesAsync(String folderCorpusPath) {
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<HashMap<String, CdmFileMetadata>> fetchAllFilesMetadataAsync(String folderCorpusPath) throws CdmReadPartitionFromPatternException {
        List<String> allFiles = this.fetchAllFilesAsync(folderCorpusPath).join();
        HashMap<String, Object> filesMetadata = new HashMap<String, Object>();
        if (allFiles != null) {
            for (String file : allFiles) {
                filesMetadata.put(file, null);
            }
        }
        return CompletableFuture.completedFuture(filesMetadata);
    }

    public String fetchConfig() {
        return "{}";
    }

    public void updateConfig(String config) throws IOException {
    }

    public void clearCache() {
    }

    protected boolean getIsCacheEnabled() {
        return !this.activeCacheContexts.isEmpty();
    }

    public CacheContext createFileQueryCacheContext() {
        return new CacheContext(this);
    }

    public class CacheContext {
        private StorageAdapterBase adapter;

        protected CacheContext(StorageAdapterBase adapter) {
            this.adapter = adapter;
            this.adapter.activeCacheContexts.add(this);
        }

        public void dispose() {
            this.adapter.activeCacheContexts.remove(this);
            if (!this.adapter.getIsCacheEnabled()) {
                this.adapter.clearCache();
            }
        }
    }
}

