/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.storage;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmContainerDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmFolderDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmObject;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.storage.AdlsAdapter;
import com.microsoft.commondatamodel.objectmodel.storage.CdmStandardsAdapter;
import com.microsoft.commondatamodel.objectmodel.storage.GithubAdapter;
import com.microsoft.commondatamodel.objectmodel.storage.LocalAdapter;
import com.microsoft.commondatamodel.objectmodel.storage.RemoteAdapter;
import com.microsoft.commondatamodel.objectmodel.storage.ResourceAdapter;
import com.microsoft.commondatamodel.objectmodel.storage.StorageAdapterBase;
import com.microsoft.commondatamodel.objectmodel.storage.StorageAdapterException;
import com.microsoft.commondatamodel.objectmodel.utilities.JMapper;
import com.microsoft.commondatamodel.objectmodel.utilities.StorageUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.logger.Logger;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class StorageManager {
    private static final String TAG = StorageManager.class.getSimpleName();
    private final CdmCorpusDefinition corpus;
    private Map<String, CdmFolderDefinition> namespaceFolders = new LinkedHashMap<String, CdmFolderDefinition>();
    private String defaultNamespace;
    private Map<String, StorageAdapterBase> namespaceAdapters = new LinkedHashMap<String, StorageAdapterBase>();
    private Set<String> systemDefinedNamespaces;

    public StorageManager(CdmCorpusDefinition corpus) {
        this.corpus = corpus;
        this.systemDefinedNamespaces = new HashSet<String>();
        this.mount("local", new LocalAdapter(System.getProperty("user.dir") + "\\objectmodel"));
        this.systemDefinedNamespaces.add("local");
        try {
            this.mount("cdm", new CdmStandardsAdapter());
            this.systemDefinedNamespaces.add("cdm");
        }
        catch (ClassNotFoundException e) {
            Logger.error(this.corpus.getCtx(), TAG, "constructor", null, CdmLogCode.ErrStorageCdmStandardsMissing, "com.microsoft.commondatamodel.cdmStandards");
        }
    }

    public void mount(String nameSpace, StorageAdapterBase adapter) {
        try (Logger.LoggerScope logScope = Logger.enterScope(StorageManager.class.getSimpleName(), this.getCtx(), "mount");){
            if (StringUtils.isNullOrTrimEmpty(nameSpace)) {
                Logger.error(this.corpus.getCtx(), TAG, "mount", null, CdmLogCode.ErrStorageNullNamespace, new String[0]);
                return;
            }
            if (adapter != null) {
                adapter.setCtx(this.corpus.getCtx());
                this.namespaceAdapters.put(nameSpace, adapter);
                CdmFolderDefinition fd = new CdmFolderDefinition(this.corpus.getCtx(), "");
                fd.setCorpus(this.corpus);
                fd.setNamespace(nameSpace);
                fd.setFolderPath("/");
                this.namespaceFolders.put(nameSpace, fd);
                this.systemDefinedNamespaces.remove(nameSpace);
            } else {
                Logger.error(this.corpus.getCtx(), TAG, "mount", null, CdmLogCode.ErrStorageNullAdapter, new String[0]);
            }
        }
    }

    public List<String> mountFromConfig(String adapterConfig) {
        return this.mountFromConfig(adapterConfig, false);
    }

    public List<String> mountFromConfig(String adapterConfig, boolean doesReturnErrorList) {
        JsonNode adapterConfigJson;
        if (StringUtils.isNullOrEmpty(adapterConfig)) {
            Logger.error(this.corpus.getCtx(), TAG, "mountFromConfig", null, CdmLogCode.ErrStorageNullAdapterConfig, new String[0]);
            return null;
        }
        try {
            adapterConfigJson = JMapper.MAP.readTree(adapterConfig);
        }
        catch (IOException e) {
            throw new StorageAdapterException("Failed to convert config jsonNode", e);
        }
        if (adapterConfigJson.has("appId")) {
            this.corpus.setAppId(adapterConfigJson.get("appId").asText());
        }
        if (adapterConfigJson.has("defaultNamespace")) {
            this.defaultNamespace = adapterConfigJson.get("defaultNamespace").asText();
        }
        ArrayList<String> unrecognizedAdapters = new ArrayList<String>();
        for (JsonNode item : adapterConfigJson.get("adapters")) {
            if (!item.has("namespace")) {
                Logger.error(this.corpus.getCtx(), TAG, "mountFromConfig", null, CdmLogCode.ErrStorageMissingNamespace, new String[0]);
                continue;
            }
            String nameSpace = item.get("namespace").asText();
            if (!item.has("config")) {
                Logger.error(this.corpus.getCtx(), TAG, "mountFromConfig", null, CdmLogCode.ErrStorageMissingJsonConfig, nameSpace);
                continue;
            }
            JsonNode configs = item.get("config");
            if (!item.has("type")) {
                Logger.error(this.corpus.getCtx(), TAG, "mountFromConfig", null, CdmLogCode.ErrStorageNullNamespace, nameSpace);
                continue;
            }
            try {
                String itemType = item.get("type").asText();
                StorageAdapterBase adapter = null;
                switch (itemType) {
                    case "cdm-standards": {
                        try {
                            adapter = new CdmStandardsAdapter();
                        }
                        catch (ClassNotFoundException e) {
                            Logger.error(this.corpus.getCtx(), TAG, "constructor", null, CdmLogCode.ErrStorageCdmStandardsMissing, "com.microsoft.commondatamodel.cdmStandards");
                        }
                        break;
                    }
                    case "local": {
                        adapter = new LocalAdapter();
                        break;
                    }
                    case "github": {
                        adapter = new GithubAdapter();
                        break;
                    }
                    case "remote": {
                        adapter = new RemoteAdapter();
                        break;
                    }
                    case "adls": {
                        adapter = new AdlsAdapter();
                        break;
                    }
                    default: {
                        unrecognizedAdapters.add(JMapper.WRITER.writeValueAsString((Object)item));
                    }
                }
                if (adapter == null) continue;
                adapter.updateConfig(JMapper.WRITER.writeValueAsString((Object)configs));
                this.mount(nameSpace, adapter);
            }
            catch (JsonProcessingException e) {
                throw new StorageAdapterException("Failed to process config as String", (Exception)((Object)e));
            }
            catch (MalformedURLException e) {
                throw new StorageAdapterException("Config contains malformed URL.", e);
            }
            catch (IOException e) {
                throw new StorageAdapterException("Failed to construct adapter. AdapterType: " + item.get("type").asText(), e);
            }
        }
        return doesReturnErrorList ? unrecognizedAdapters : null;
    }

    public boolean unmount(String nameSpace) {
        try (Logger.LoggerScope logScope = Logger.enterScope(StorageManager.class.getSimpleName(), this.getCtx(), "unmount");){
            if (StringUtils.isNullOrTrimEmpty(nameSpace)) {
                Logger.error(this.corpus.getCtx(), TAG, "unmount", null, CdmLogCode.ErrStorageNullNamespace, new String[0]);
                boolean bl = false;
                return bl;
            }
            if (this.namespaceAdapters.containsKey(nameSpace)) {
                this.namespaceAdapters.remove(nameSpace);
                this.namespaceFolders.remove(nameSpace);
                this.systemDefinedNamespaces.remove(nameSpace);
                if (nameSpace.equals("cdm")) {
                    this.mount(nameSpace, new ResourceAdapter());
                }
                boolean bl = true;
                return bl;
            }
            Logger.warning(this.corpus.getCtx(), TAG, "unmount", null, CdmLogCode.WarnStorageRemoveAdapterFailed, nameSpace);
            boolean bl = false;
            return bl;
        }
    }

    @Deprecated
    public void setAdapter(String nameSpace, StorageAdapterBase adapter) {
        if (StringUtils.isNullOrTrimEmpty(nameSpace)) {
            Logger.error(this.corpus.getCtx(), TAG, "setAdapter", null, CdmLogCode.ErrStorageNullNamespace, new String[0]);
            return;
        }
        if (adapter != null) {
            this.namespaceAdapters.put(nameSpace, adapter);
        } else {
            Logger.error(this.corpus.getCtx(), TAG, "setAdapter", null, CdmLogCode.ErrStorageNullAdapter, new String[0]);
        }
    }

    public StorageAdapterBase fetchAdapter(String nameSpace) {
        if (StringUtils.isNullOrTrimEmpty(nameSpace)) {
            Logger.error(this.corpus.getCtx(), TAG, "fetchAdapter", null, CdmLogCode.ErrStorageNullNamespace, new String[0]);
            return null;
        }
        if (this.namespaceFolders.containsKey(nameSpace)) {
            return this.namespaceAdapters.get(nameSpace);
        }
        Logger.error(this.corpus.getCtx(), TAG, "fetchAdapter", null, CdmLogCode.ErrStorageAdapterNotFound, nameSpace);
        return null;
    }

    public CdmFolderDefinition fetchRootFolder(String nameSpace) {
        try (Logger.LoggerScope logScope = Logger.enterScope(StorageManager.class.getSimpleName(), this.getCtx(), "fetchRootFolder");){
            if (StringUtils.isNullOrTrimEmpty(nameSpace)) {
                Logger.error(this.corpus.getCtx(), TAG, "fetchRootFolder", null, CdmLogCode.ErrStorageNullNamespace, new String[0]);
                CdmFolderDefinition cdmFolderDefinition = null;
                return cdmFolderDefinition;
            }
            if (this.namespaceFolders.containsKey(nameSpace)) {
                CdmFolderDefinition cdmFolderDefinition = this.namespaceFolders.get(nameSpace);
                return cdmFolderDefinition;
            }
            if (this.namespaceFolders.containsKey(this.defaultNamespace)) {
                CdmFolderDefinition cdmFolderDefinition = this.namespaceFolders.get(this.defaultNamespace);
                return cdmFolderDefinition;
            }
            Logger.error(this.corpus.getCtx(), TAG, "fetchRootFolder", null, CdmLogCode.ErrStorageFolderNotFound, nameSpace);
            CdmFolderDefinition cdmFolderDefinition = null;
            return cdmFolderDefinition;
        }
    }

    public String adapterPathToCorpusPath(String adapterPath) {
        try (Logger.LoggerScope logScope = Logger.enterScope(StorageManager.class.getSimpleName(), this.getCtx(), "adapterPathToCorpusPath");){
            for (Map.Entry<String, StorageAdapterBase> kv : this.namespaceAdapters.entrySet()) {
                String corpusPath = kv.getValue().createCorpusPath(adapterPath);
                if (corpusPath == null) continue;
                String string = kv.getKey() + ":" + corpusPath;
                return string;
            }
            Logger.error(this.corpus.getCtx(), TAG, "adapterPathToCorpusPath", null, CdmLogCode.ErrStorageInvalidAdapterPath, adapterPath);
            Iterator<Map.Entry<String, StorageAdapterBase>> iterator = null;
            return iterator;
        }
    }

    public String corpusPathToAdapterPath(String corpusPath) {
        try (Logger.LoggerScope logScope = Logger.enterScope(StorageManager.class.getSimpleName(), this.getCtx(), "corpusPathToAdapterPath");){
            String nameSpace;
            if (StringUtils.isNullOrTrimEmpty(corpusPath)) {
                Logger.error(this.corpus.getCtx(), TAG, "corpusPathToAdapterPath", null, CdmLogCode.ErrStorageNullCorpusPath, new String[0]);
                String string = null;
                return string;
            }
            ImmutablePair<String, String> pathTuple = StorageUtils.splitNamespacePath(corpusPath);
            if (pathTuple == null) {
                Logger.error(this.corpus.getCtx(), TAG, "corpusPathToAdapterPath", null, CdmLogCode.ErrStorageNullCorpusPath, new String[0]);
                String string = null;
                return string;
            }
            String string = nameSpace = !StringUtils.isNullOrTrimEmpty((String)pathTuple.getLeft()) ? (String)pathTuple.getLeft() : this.defaultNamespace;
            if (this.fetchAdapter(nameSpace) == null) {
                Logger.error(this.corpus.getCtx(), TAG, "corpusPathToAdapterPath", null, CdmLogCode.ErrStorageNamespaceNotRegistered, new String[0]);
                String string2 = "";
                return string2;
            }
            String string3 = this.fetchAdapter(nameSpace).createAdapterPath((String)pathTuple.getRight());
            return string3;
        }
    }

    public String createAbsoluteCorpusPath(String objectPath) {
        return this.createAbsoluteCorpusPath(objectPath, null);
    }

    public String createAbsoluteCorpusPath(String objectPath, CdmObject obj) {
        try (Logger.LoggerScope logScope = Logger.enterScope(StorageManager.class.getSimpleName(), this.getCtx(), "createAbsoluteCorpusPath");){
            String finalNamespace;
            if (StringUtils.isNullOrTrimEmpty(objectPath)) {
                Logger.error(this.corpus.getCtx(), TAG, "createAbsoluteCorpusPath", null, CdmLogCode.ErrPathNullObjectPath, new String[0]);
                String string = null;
                return string;
            }
            if (this.containsUnsupportedPathFormat(objectPath)) {
                String string = null;
                return string;
            }
            ImmutablePair<String, String> pathTuple = StorageUtils.splitNamespacePath(objectPath);
            if (pathTuple == null) {
                Logger.error(this.corpus.getCtx(), TAG, "createAbsoluteCorpusPath", null, CdmLogCode.ErrPathNullObjectPath, new String[0]);
                String string = null;
                return string;
            }
            String nameSpace = (String)pathTuple.getLeft();
            Object newObjectPath = (String)pathTuple.getRight();
            Object prefix = "";
            String namespaceFromObj = "";
            if (obj instanceof CdmContainerDefinition) {
                prefix = ((CdmContainerDefinition)obj).getFolderPath();
                namespaceFromObj = ((CdmContainerDefinition)obj).getNamespace();
            } else if (obj != null) {
                prefix = obj.getInDocument().getFolderPath();
                namespaceFromObj = obj.getInDocument().getNamespace();
            }
            if (prefix != null && this.containsUnsupportedPathFormat((String)prefix)) {
                String string = null;
                return string;
            }
            if (!StringUtils.isNullOrEmpty((String)prefix) && ((String)prefix).charAt(((String)prefix).length() - 1) != '/') {
                Logger.warning(this.corpus.getCtx(), TAG, "createAbsoluteCorpusPath", null, CdmLogCode.WarnStorageExpectedPathPrefix, new String[]{prefix});
                prefix = (String)prefix + "/";
            }
            if (!StringUtils.isNullOrEmpty((String)newObjectPath) && !((String)newObjectPath).startsWith("/")) {
                if (obj == null) {
                    prefix = "/";
                }
                if (!StringUtils.isNullOrEmpty(nameSpace) && !Objects.equals(nameSpace, namespaceFromObj)) {
                    Logger.error(this.corpus.getCtx(), TAG, "createAbsoluteCorpusPath", null, CdmLogCode.ErrStorageNamespaceMismatch, new String[]{newObjectPath, prefix, namespaceFromObj});
                    String string = null;
                    return string;
                }
                newObjectPath = (String)prefix + (String)newObjectPath;
                finalNamespace = StringUtils.isNullOrEmpty(namespaceFromObj) ? (StringUtils.isNullOrTrimEmpty(nameSpace) ? this.defaultNamespace : nameSpace) : namespaceFromObj;
            } else {
                finalNamespace = StringUtils.isNullOrEmpty(nameSpace) ? (StringUtils.isNullOrTrimEmpty(namespaceFromObj) ? this.defaultNamespace : namespaceFromObj) : nameSpace;
            }
            String string = (String)(!StringUtils.isNullOrTrimEmpty(finalNamespace) ? finalNamespace + ":" : "") + (String)newObjectPath;
            return string;
        }
    }

    public String fetchConfig() {
        ArrayNode adaptersArray = JsonNodeFactory.instance.arrayNode();
        for (Map.Entry<String, StorageAdapterBase> namespaceAdapterTuple : this.namespaceAdapters.entrySet()) {
            if (this.systemDefinedNamespaces.contains(namespaceAdapterTuple.getKey()) || namespaceAdapterTuple.getValue() instanceof ResourceAdapter) continue;
            String config = namespaceAdapterTuple.getValue().fetchConfig();
            if (StringUtils.isNullOrEmpty(config)) {
                Logger.error(this.corpus.getCtx(), TAG, "fetchConfig", null, CdmLogCode.ErrStorageNullAdapter, new String[0]);
                continue;
            }
            try {
                ObjectNode jsonConfig = (ObjectNode)JMapper.MAP.readTree(config);
                jsonConfig.put("namespace", namespaceAdapterTuple.getKey());
                adaptersArray.add((JsonNode)jsonConfig);
            }
            catch (IOException e) {
                Logger.error(this.corpus.getCtx(), TAG, "fetchConfig", null, CdmLogCode.ErrStorageObjectNodeCastFailed, config, e.getMessage());
            }
        }
        ObjectNode resultConfig = JsonNodeFactory.instance.objectNode();
        if (this.corpus.getAppId() != null) {
            resultConfig.put("appId", this.corpus.getAppId());
        }
        resultConfig.put("defaultNamespace", this.defaultNamespace);
        resultConfig.set("adapters", (JsonNode)adaptersArray);
        try {
            return JMapper.WRITER.writeValueAsString((Object)resultConfig);
        }
        catch (JsonProcessingException e) {
            throw new StorageAdapterException("Cannot generate adapters config", (Exception)((Object)e));
        }
    }

    public CompletableFuture<Void> saveAdapterConfigAsync(String name, StorageAdapterBase adapter) {
        return adapter.writeAsync(name, this.fetchConfig());
    }

    public String createRelativeCorpusPath(String objectPath) {
        return this.createRelativeCorpusPath(objectPath, null);
    }

    public String createRelativeCorpusPath(String objectPath, CdmContainerDefinition relativeTo) {
        try (Logger.LoggerScope logScope = Logger.enterScope(StorageManager.class.getSimpleName(), this.getCtx(), "createRelativeCorpusPath");){
            String namespaceString;
            String newPath = this.createAbsoluteCorpusPath(objectPath, relativeTo);
            String string = namespaceString = relativeTo != null ? relativeTo.getNamespace() + ":" : "";
            if (!StringUtils.isNullOrTrimEmpty(namespaceString) && !StringUtils.isNullOrTrimEmpty(newPath) && newPath.startsWith(namespaceString)) {
                newPath = newPath.substring(namespaceString.length());
                if (relativeTo != null && newPath.startsWith(relativeTo.getFolderPath())) {
                    newPath = newPath.substring(relativeTo.getFolderPath().length());
                }
            }
            String string2 = newPath;
            return string2;
        }
    }

    public Integer getMaxConcurrentReads() {
        return this.corpus.getDocumentLibrary().concurrentReadLock.getPermits();
    }

    public void setMaxConcurrentReads(Integer maxConcurrentReads) {
        this.corpus.getDocumentLibrary().concurrentReadLock.setPermits(maxConcurrentReads);
    }

    private boolean containsUnsupportedPathFormat(String path) {
        if (!(path.startsWith("./") || path.startsWith(".\\") || path.contains("../") || path.contains("..\\") || path.contains("/./") || path.contains("\\.\\"))) {
            return false;
        }
        Logger.error(this.corpus.getCtx(), TAG, "containsUnsupportedPathFormat", null, CdmLogCode.ErrStorageInvalidPathFormat, new String[0]);
        return true;
    }

    public Map<String, StorageAdapterBase> getNamespaceAdapters() {
        return this.namespaceAdapters;
    }

    public void setNamespaceAdapters(Map<String, StorageAdapterBase> namespaceAdapters) {
        this.namespaceAdapters = namespaceAdapters;
    }

    public Map<String, CdmFolderDefinition> getNamespaceFolders() {
        return this.namespaceFolders;
    }

    public void setNamespaceFolders(Map<String, CdmFolderDefinition> namespaceFolders) {
        this.namespaceFolders = namespaceFolders;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public void setDefaultNamespace(String defaultNamespace) {
        this.defaultNamespace = defaultNamespace;
    }

    private CdmCorpusContext getCtx() {
        return this.corpus.getCtx();
    }
}

