/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.utilities.logger;

import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class EventList
extends ArrayList<Map<String, String>> {
    private boolean isRecording = false;
    private int nestingLevel = 0;
    private UUID apiCorrelationId;
    Lock lock = new ReentrantLock();

    public void enable() {
        this.lock.lock();
        if (this.nestingLevel == 0) {
            this.clear();
            this.isRecording = true;
            this.apiCorrelationId = UUID.randomUUID();
        }
        ++this.nestingLevel;
        this.lock.unlock();
    }

    public void disable() {
        this.lock.lock();
        --this.nestingLevel;
        if (this.nestingLevel == 0) {
            this.isRecording = false;
            this.apiCorrelationId = UUID.randomUUID();
        }
        this.lock.unlock();
    }

    @Override
    public boolean add(Map<String, String> theEvent) {
        if (this.isRecording) {
            return super.add(theEvent);
        }
        return false;
    }

    public boolean isRecording() {
        return this.isRecording;
    }

    public UUID getApiCorrelationId() {
        return this.apiCorrelationId;
    }

    public int getNestingLevel() {
        return this.nestingLevel;
    }
}

