/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.utilities.logger;

import com.microsoft.commondatamodel.objectmodel.cdm.CdmCorpusContext;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmDataPartitionPatternDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityDeclarationDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmEntityDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmManifestDefinition;
import com.microsoft.commondatamodel.objectmodel.cdm.CdmTraitReferenceBase;
import com.microsoft.commondatamodel.objectmodel.enums.CdmLogCode;
import com.microsoft.commondatamodel.objectmodel.enums.CdmStatusLevel;
import com.microsoft.commondatamodel.objectmodel.storage.StorageAdapterBase;
import com.microsoft.commondatamodel.objectmodel.utilities.StorageUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.StringUtils;
import com.microsoft.commondatamodel.objectmodel.utilities.TimeUtils;
import java.text.MessageFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.Consumer;

public class Logger {
    private static final ResourceBundle resource = ResourceBundle.getBundle("LogMessages");

    public static void debug(CdmCorpusContext ctx, String classname, String method, String corpuspath, String message, boolean ingestTelemetry) {
        Logger.log(CdmStatusLevel.Progress, ctx, classname, message, method, System.out::println, corpuspath, CdmLogCode.None, ingestTelemetry);
    }

    public static void debug(CdmCorpusContext ctx, String classname, String method, String corpuspath, String message) {
        Logger.debug(ctx, classname, method, corpuspath, message, false);
    }

    public static void info(CdmCorpusContext ctx, String classname, String method, String corpuspath, String message) {
        Logger.log(CdmStatusLevel.Info, ctx, classname, message, method, System.out::println, corpuspath, CdmLogCode.None);
    }

    public static void warning(CdmCorpusContext ctx, String classname, String method, String corpuspath, CdmLogCode code, String ... args) {
        String message = Logger.getMessageFromResourceFile(code, args);
        Logger.log(CdmStatusLevel.Warning, ctx, classname, message, method, System.out::println, corpuspath, code);
    }

    public static void error(CdmCorpusContext ctx, String classname, String method, String corpuspath, CdmLogCode code, String ... args) {
        String message = Logger.getMessageFromResourceFile(code, args);
        Logger.log(CdmStatusLevel.Error, ctx, classname, message, method, System.err::println, corpuspath, code);
    }

    private static String formatMessage(String classname, String message) {
        return Logger.formatMessage(classname, message, null, null, null);
    }

    private static String formatMessage(String classname, String message, String method) {
        return Logger.formatMessage(classname, message, method, null, null);
    }

    private static String formatMessage(String classname, String message, String method, String correlationId, String corpuspath) {
        StringBuilder strBuf = new StringBuilder();
        strBuf.append(classname).append(" | ").append(message);
        if (method != null) {
            strBuf.append(" | ").append(method);
        }
        if (correlationId != null) {
            strBuf.append(" | ").append(correlationId);
        }
        if (corpuspath != null) {
            strBuf.append(" | ").append(corpuspath);
        }
        return strBuf.toString();
    }

    private static void log(CdmStatusLevel level, CdmCorpusContext ctx, String classname, String message, String method, Consumer<String> defaultStatusEvent, String corpuspath, CdmLogCode code, boolean ingestTelemetry) {
        if (ctx.getSuppressedLogCodes().contains((Object)code)) {
            return;
        }
        if (level.compareTo(ctx.getReportAtLevel()) >= 0) {
            String timestamp = TimeUtils.formatDateStringIfNotNull(OffsetDateTime.now(ZoneOffset.UTC));
            if (ctx.getEvents().isRecording()) {
                HashMap<String, String> theEvent = new HashMap<String, String>();
                theEvent.put("timestamp", timestamp);
                theEvent.put("level", level.name());
                theEvent.put("class", classname);
                theEvent.put("message", message);
                theEvent.put("method", method);
                if (level == CdmStatusLevel.Error || level == CdmStatusLevel.Warning) {
                    theEvent.put("code", code.name());
                }
                if (ctx.getCorrelationId() != null) {
                    theEvent.put("cid", ctx.getCorrelationId());
                }
                if (corpuspath != null) {
                    theEvent.put("path", corpuspath);
                }
                ctx.getEvents().add((Map<String, String>)theEvent);
            }
            String formattedMessage = Logger.formatMessage(classname, message, method, ctx.getCorrelationId(), corpuspath);
            if (ctx.getStatusEvent() != null) {
                ctx.getStatusEvent().apply(level, formattedMessage);
            } else {
                defaultStatusEvent.accept(message);
            }
            if (ctx.getCorpus().getTelemetryClient() != null) {
                ctx.getCorpus().getTelemetryClient().addToIngestionQueue(timestamp, level, classname, method, corpuspath, message, ingestTelemetry, code);
            }
        }
    }

    private static void log(CdmStatusLevel level, CdmCorpusContext ctx, String classname, String message, String method, Consumer<String> defaultStatusEvent, String corpuspath, CdmLogCode code) {
        Logger.log(level, ctx, classname, message, method, defaultStatusEvent, corpuspath, code, false);
    }

    private static String getMessageFromResourceFile(CdmLogCode code, String ... args) {
        StringBuilder builder = new StringBuilder(resource.getString(code.toString()));
        int i = 0;
        for (String x : args) {
            String from = "{" + i + "}";
            int index = builder.indexOf(from);
            if (index > -1) {
                builder = builder.replace(index, index + from.length(), x == null ? "" : x);
            }
            ++i;
        }
        return builder.toString();
    }

    @Deprecated
    public static String format(String str, Object ... arguments) {
        if (str == null) {
            return null;
        }
        return MessageFormat.format(str.replace("'", "''"), arguments);
    }

    public static LoggerScope enterScope(String classname, CdmCorpusContext ctx, String path) {
        return new LoggerScope(new TState(classname, ctx, path));
    }

    public static void ingestManifestTelemetry(CdmManifestDefinition manifest, CdmCorpusContext ctx, String className, String method, String corpusPath) {
        if (ctx.getCorpus().getTelemetryClient() == null) {
            return;
        }
        String storageNamespace = manifest.getNamespace();
        if (StringUtils.isNullOrEmpty(storageNamespace)) {
            storageNamespace = manifest.getCtx().getCorpus().getStorage().getDefaultNamespace();
        }
        StorageAdapterBase adapter = manifest.getCtx().getCorpus().getStorage().fetchAdapter(storageNamespace);
        String adapterType = adapter.getClass().getSimpleName();
        Object message = Logger.format("ManifestStorage:{0};", adapterType);
        HashMap<String, Integer> manifestInfo = new HashMap<String, Integer>();
        manifestInfo.put("RelationshipNum", manifest.getRelationships().getCount());
        int entityNum = manifest.getEntities().getCount();
        manifestInfo.put("EntityNum", entityNum);
        int partitionNum = 0;
        int partitionGlobPatternNum = 0;
        int partitionRegExPatternNum = 0;
        int standardEntityNum = 0;
        for (CdmEntityDeclarationDefinition entityDec : manifest.getEntities()) {
            String entityNamespace;
            if (entityDec.getDataPartitions() != null) {
                partitionNum += entityDec.getDataPartitions().getCount();
                for (CdmDataPartitionPatternDefinition pattern : entityDec.getDataPartitionPatterns()) {
                    if (pattern.getGlobPattern() != null) {
                        ++partitionGlobPatternNum;
                        continue;
                    }
                    if (pattern.getRegularExpression() == null) continue;
                    ++partitionRegExPatternNum;
                }
            }
            if (!"cdm".equals(entityNamespace = (String)StorageUtils.splitNamespacePath((String)entityDec.getEntityPath()).left)) continue;
            ++standardEntityNum;
        }
        manifestInfo.put("PartitionNum", partitionNum);
        manifestInfo.put("PartitionGlobPatternNum", partitionGlobPatternNum);
        manifestInfo.put("PartitionRegExPatternNum", partitionRegExPatternNum);
        manifestInfo.put("StandardEntityNum", standardEntityNum);
        manifestInfo.put("CustomEntityNum", entityNum - standardEntityNum);
        message = (String)message + Logger.serializeMap(manifestInfo);
        Logger.debug(ctx, className, method, corpusPath, MessageFormat.format("Manifest Info: '{'{0}'}'", message), true);
    }

    public static void ingestEntityTelemetry(CdmEntityDefinition entity, CdmCorpusContext ctx, String className, String method, String corpusPath) {
        if (ctx.getCorpus().getTelemetryClient() == null) {
            return;
        }
        String entityNamespace = entity.getInDocument().getNamespace();
        if (StringUtils.isNullOrEmpty(entityNamespace)) {
            entityNamespace = entity.getCtx().getCorpus().getStorage().getDefaultNamespace();
        }
        StorageAdapterBase adapter = entity.getCtx().getCorpus().getStorage().fetchAdapter(entityNamespace);
        String adapterType = adapter.getClass().getSimpleName();
        Object message = Logger.format("EntityStorage:{0};EntityNamespace:{1};", adapterType, entityNamespace);
        Map<String, Integer> entityInfo = Logger.formEntityInfoDict(entity);
        message = (String)message + Logger.serializeMap(entityInfo);
        Logger.debug(ctx, className, method, corpusPath, MessageFormat.format("Entity Info: '{'{0}'}'", message), true);
    }

    private static Map<String, Integer> formEntityInfoDict(CdmEntityDefinition entity) {
        HashMap<String, Integer> entityInfo = new HashMap<String, Integer>();
        int isResolved = 0;
        if (entity.getAttributeContext() != null) {
            isResolved = 1;
        }
        entityInfo.put("ResolvedEntity", isResolved);
        entityInfo.put("ExhibitsTraitNum", entity.getExhibitsTraits().getCount());
        entityInfo.put("AttributeNum", entity.getAttributes().getCount());
        int semanticsTraitNum = 0;
        for (CdmTraitReferenceBase trait : entity.getExhibitsTraits()) {
            if (!trait.fetchObjectDefinitionName().startsWith("means.")) continue;
            ++semanticsTraitNum;
        }
        entityInfo.put("SemanticsTraitNum", semanticsTraitNum);
        return entityInfo;
    }

    private static String serializeMap(Map<String, Integer> map) {
        StringBuilder mapAsString = new StringBuilder();
        for (String key : map.keySet()) {
            mapAsString.append(key + ":" + map.get(key) + ";");
        }
        return mapAsString.toString();
    }

    public static class LoggerScope
    implements AutoCloseable {
        private final TState state;
        private Instant time = Instant.now();
        private boolean isTopLevelMethod = false;

        public LoggerScope(TState state) {
            this.state = state;
            state.ctx.getEvents().enable();
            if (state.ctx.getEvents().getNestingLevel() == 1) {
                this.isTopLevelMethod = true;
            }
            Logger.debug(state.ctx, state.classname, state.path, null, "Entering scope");
        }

        @Override
        public void close() {
            String message = Logger.format("Leaving scope. Time Elapsed: {0} ms.", String.valueOf(Duration.between(this.time, Instant.now()).toMillis()));
            Logger.debug(this.state.ctx, this.state.classname, this.state.path, null, message, this.isTopLevelMethod);
            this.state.ctx.getEvents().disable();
        }
    }

    private static class TState {
        public String classname;
        public CdmCorpusContext ctx;
        public String path;

        public TState(String classname, CdmCorpusContext ctx, String path) {
            this.classname = classname;
            this.ctx = ctx;
            this.path = path;
        }
    }
}

