/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.commondatamodel.objectmodel.utilities.network;

import java.time.Duration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;

public class CdmHttpRequest {
    private Map<String, String> headers = new LinkedHashMap<String, String>();
    private String content;
    private String contentType;
    private String method;
    private String requestedUrl;
    private UUID requestId;
    private Duration timeout;
    private Duration maximumTimeout;
    private int numberOfRetries;

    public CdmHttpRequest(String url) {
        this(url, 0, null);
    }

    public CdmHttpRequest(String url, int numberOfRetries) {
        this(url, numberOfRetries, null);
    }

    public CdmHttpRequest(String url, int numberOfRetries, String method) {
        this.requestedUrl = url;
        this.requestId = UUID.randomUUID();
        this.numberOfRetries = numberOfRetries;
        this.method = method == null ? "GET" : method;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getRequestedUrl() {
        return this.requestedUrl;
    }

    public void setRequestedUrl(String requestedUrl) {
        this.requestedUrl = requestedUrl;
    }

    public UUID getRequestId() {
        return this.requestId;
    }

    public void setRequestId(UUID requestId) {
        this.requestId = requestId;
    }

    public Duration getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Duration timeout) {
        this.timeout = timeout;
    }

    public Duration getMaximumTimeout() {
        return this.maximumTimeout;
    }

    public void setMaximumTimeout(Duration maximumTimeout) {
        this.maximumTimeout = maximumTimeout;
    }

    public int getNumberOfRetries() {
        return this.numberOfRetries;
    }

    public void setNumberOfRetries(int numberOfRetries) {
        this.numberOfRetries = numberOfRetries;
    }

    @Deprecated
    public String stripSasSig() {
        int sigStartIndex = this.requestedUrl.indexOf("sig=");
        if (sigStartIndex == -1) {
            return this.requestedUrl;
        }
        int sigEndIndex = this.requestedUrl.indexOf("&", sigStartIndex + 1);
        sigEndIndex = sigEndIndex == -1 ? this.requestedUrl.length() : sigEndIndex;
        return this.requestedUrl.substring(0, sigStartIndex + 4) + "REMOVED" + this.requestedUrl.substring(sigEndIndex);
    }
}

