/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.gen.proc;

import com.mockrunner.gen.proc.JavaLineParser;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;

public class JavaLineProcessor {
    private JavaLineParser parser = new JavaLineParser();

    public void addLine(String line) {
        this.parser.addLine(line);
    }

    public void addBlock(String block) {
        this.parser.addBlock(block);
    }

    public void addLines(List<String> lines) {
        this.parser.addLines(lines);
    }

    public void addBlocks(List<String> blocks) {
        this.parser.addBlocks(blocks);
    }

    public String process(String source) {
        List<JavaLineParser.Line> result = this.parser.parse(source);
        LineNumberReader input = new LineNumberReader(new StringReader(source));
        StringWriter resultStringWriter = new StringWriter(source.length() + 100);
        PrintWriter output = new PrintWriter(resultStringWriter);
        Iterator<JavaLineParser.Line> iterator = result.iterator();
        while (iterator.hasNext()) {
            JavaLineParser.Line aResult;
            JavaLineParser.Line nextLine = aResult = iterator.next();
            int processUntil = nextLine.getLineNumber();
            this.dumpToOutputUntil(input, output, processUntil);
            this.handleLine(nextLine, input, output);
        }
        this.dumpToOutputUntilEnd(input, output);
        output.flush();
        return resultStringWriter.toString();
    }

    private void handleLine(JavaLineParser.Line line, LineNumberReader input, PrintWriter output) {
        try {
            int firstNonWhitespace;
            StringBuffer nextLine = new StringBuffer(input.readLine());
            for (firstNonWhitespace = 0; firstNonWhitespace < nextLine.length() && Character.isWhitespace(nextLine.charAt(firstNonWhitespace)); ++firstNonWhitespace) {
            }
            if (firstNonWhitespace < nextLine.length()) {
                if (line instanceof JavaLineParser.Block) {
                    int lastNonWhitespace;
                    nextLine.insert(firstNonWhitespace, "/*");
                    output.println(nextLine);
                    int processUntil = ((JavaLineParser.Block)line).getEndLineNumber();
                    this.dumpToOutputUntil(input, output, processUntil);
                    nextLine = new StringBuffer(input.readLine());
                    for (lastNonWhitespace = nextLine.length() - 1; lastNonWhitespace > 0 && Character.isWhitespace(nextLine.charAt(lastNonWhitespace)); --lastNonWhitespace) {
                    }
                    nextLine.insert(lastNonWhitespace + 1, "*/");
                    output.println(nextLine);
                } else {
                    nextLine.insert(firstNonWhitespace, "//");
                    output.println(nextLine);
                }
            }
        }
        catch (IOException exc) {
            throw new RuntimeException(exc.getMessage());
        }
    }

    private void dumpToOutputUntil(LineNumberReader input, PrintWriter output, int processUntil) {
        while (input.getLineNumber() < processUntil - 1) {
            try {
                output.println(input.readLine());
            }
            catch (IOException exc) {
                throw new RuntimeException(exc.getMessage());
            }
        }
    }

    private void dumpToOutputUntilEnd(LineNumberReader input, PrintWriter output) {
        String line = null;
        try {
            while (null != (line = input.readLine())) {
                output.println(line);
            }
        }
        catch (IOException exc) {
            throw new RuntimeException(exc.getMessage());
        }
    }
}

