/*
 * Decompiled with CFR 0.152.
 */
package com.mycila.junit.rule;

import com.mycila.junit.concurrent.ConcurrentException;
import com.mycila.junit.concurrent.ConcurrentRunnerScheduler;
import com.mycila.junit.rule.Times;
import java.util.concurrent.CountDownLatch;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class TestRepeater
implements TestRule {
    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                block7: {
                    Times annotation;
                    block6: {
                        annotation = (Times)description.getAnnotation(Times.class);
                        if (annotation != null) break block6;
                        base.evaluate();
                        break block7;
                    }
                    int times = Math.max(0, annotation.value());
                    if (times <= 0) break block7;
                    if (!annotation.concurrent()) {
                        while (times-- > 0) {
                            base.evaluate();
                        }
                    } else {
                        ConcurrentRunnerScheduler scheduler = new ConcurrentRunnerScheduler(description.getTestClass().getSimpleName() + (description.isTest() ? "#" + description.getMethodName() : ""), times);
                        final CountDownLatch go = new CountDownLatch(1);
                        Runnable runnable = new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    go.await();
                                    base.evaluate();
                                }
                                catch (InterruptedException e) {
                                    Thread.currentThread().interrupt();
                                }
                                catch (Throwable throwable) {
                                    throw ConcurrentException.wrap(throwable);
                                }
                            }
                        };
                        while (times-- > 0) {
                            scheduler.schedule(runnable);
                        }
                        go.countDown();
                        try {
                            scheduler.finished();
                        }
                        catch (ConcurrentException e) {
                            throw e.unwrap();
                        }
                    }
                }
            }
        };
    }
}

