/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.types;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.mysema.query.types.Converters;
import com.mysema.query.types.Template;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TemplateFactory {
    private static final Pattern elementPattern = Pattern.compile("\\{%?%?\\d+[slu%]?%?\\}");
    public static final TemplateFactory DEFAULT = new TemplateFactory('\\');
    private final Map<String, Template> cache = new ConcurrentHashMap<String, Template>();
    private final Converters converters;

    public TemplateFactory(char escape) {
        this.converters = new Converters(escape);
    }

    public Template create(String template) {
        if (this.cache.containsKey(template)) {
            return this.cache.get(template);
        }
        Matcher m = elementPattern.matcher(template);
        ImmutableList.Builder elements = ImmutableList.builder();
        int end = 0;
        while (m.find()) {
            if (m.start() > end) {
                elements.add((Object)new Template.StaticText(template.substring(end, m.start())));
            }
            String str = template.substring(m.start() + 1, m.end() - 1).toLowerCase(Locale.ENGLISH);
            boolean asString = false;
            Function<Object, Object> transformer = null;
            if (str.charAt(0) == '%') {
                if (str.charAt(1) == '%') {
                    transformer = this.converters.toEndsWithViaLikeLower;
                    str = str.substring(2);
                } else {
                    transformer = this.converters.toEndsWithViaLike;
                    str = str.substring(1);
                }
            }
            int strip = 0;
            switch (str.charAt(str.length() - 1)) {
                case 'l': {
                    transformer = this.converters.toLowerCase;
                    strip = 1;
                    break;
                }
                case 'u': {
                    transformer = this.converters.toUpperCase;
                    strip = 1;
                    break;
                }
                case '%': {
                    if (transformer == null) {
                        if (str.charAt(str.length() - 2) == '%') {
                            transformer = this.converters.toStartsWithViaLikeLower;
                            strip = 2;
                            break;
                        }
                        transformer = this.converters.toStartsWithViaLike;
                        strip = 1;
                        break;
                    }
                    if (str.charAt(str.length() - 2) == '%') {
                        transformer = this.converters.toContainsViaLikeLower;
                        strip = 2;
                        break;
                    }
                    transformer = this.converters.toContainsViaLike;
                    strip = 1;
                    break;
                }
                case 's': {
                    asString = true;
                    strip = 1;
                }
            }
            if (strip > 0) {
                str = str.substring(0, str.length() - strip);
            }
            int index = Integer.parseInt(str);
            if (asString) {
                elements.add((Object)new Template.AsString(index));
            } else if (transformer != null) {
                elements.add((Object)new Template.Transformed(index, transformer));
            } else {
                elements.add((Object)new Template.ByIndex(index));
            }
            end = m.end();
        }
        if (end < template.length()) {
            elements.add((Object)new Template.StaticText(template.substring(end)));
        }
        Template rv = new Template(template, (ImmutableList<Template.Element>)elements.build());
        this.cache.put(template, rv);
        return rv;
    }
}

